/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.jvm;

import com.google.common.collect.ImmutableList;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.protobuf.jvm.PbJavaGotoDeclarationContext;
import com.intellij.protobuf.jvm.PbJavaGotoReferenceMatch;
import com.intellij.protobuf.jvm.PbJavaOuterClassIndex;
import com.intellij.protobuf.jvm.names.NameGeneratorSelector;
import com.intellij.protobuf.jvm.names.NameMatcher;
import com.intellij.protobuf.lang.psi.PbEnumDefinition;
import com.intellij.protobuf.lang.psi.PbEnumValue;
import com.intellij.protobuf.lang.psi.PbField;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbMessageType;
import com.intellij.protobuf.lang.psi.PbOneofDefinition;
import com.intellij.protobuf.lang.psi.PbStatement;
import com.intellij.protobuf.lang.psi.PbSymbol;
import com.intellij.protobuf.lang.psi.util.PbPsiUtil;
import com.intellij.protobuf.shared.gencode.ProtoFromSourceComments;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PbJavaGotoDeclarationHandler
implements GotoDeclarationHandler {
    @Nullable
    public String getActionText(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PbJavaGotoDeclarationHandler.$$$reportNull$$$0(0);
        }
        return null;
    }

    public PsiElement @Nullable [] getGotoDeclarationTargets(@Nullable PsiElement sourceElement, int i, Editor editor) {
        if (!(sourceElement instanceof PsiIdentifier)) {
            return null;
        }
        PsiJavaCodeReferenceElement javaRef = (PsiJavaCodeReferenceElement)PsiTreeUtil.getParentOfType((PsiElement)sourceElement, PsiJavaCodeReferenceElement.class);
        if (javaRef == null) {
            return null;
        }
        PsiElement resolved = javaRef.resolve();
        if (resolved == null) {
            return null;
        }
        PbJavaGotoDeclarationContext context = PbJavaGotoReferenceMatch.isFromProto(resolved);
        if (context == null) {
            return null;
        }
        Project project = javaRef.getProject();
        ImmutableList matchedFiles = PbJavaOuterClassIndex.getFilesWithOuterClass(project, context.outerClass.getQualifiedName(), GlobalSearchScope.allScope((Project)project));
        if (matchedFiles.isEmpty()) {
            PbFile matchingFile = PbJavaGotoDeclarationHandler.matchingProtoFileFromSource(resolved);
            if (matchingFile == null) {
                return null;
            }
            matchedFiles = ImmutableList.of((Object)matchingFile);
        }
        ArrayList<PsiElement> results = new ArrayList<PsiElement>();
        for (PbFile file : matchedFiles) {
            results.addAll(PbJavaGotoDeclarationHandler.findMatchingElements(file, context));
        }
        return results.toArray(PsiElement.EMPTY_ARRAY);
    }

    @Nullable
    private static PbFile matchingProtoFileFromSource(PsiElement resolvedReference) {
        if (!(resolvedReference.getContainingFile() instanceof PsiCompiledFile)) {
            return null;
        }
        PsiElement possibleSourceElement = resolvedReference.getNavigationElement();
        PsiFile possibleSourceFile = possibleSourceElement.getContainingFile();
        if (possibleSourceFile == null) {
            return null;
        }
        return ProtoFromSourceComments.findProtoOfGeneratedCode("//", possibleSourceFile);
    }

    private static List<PsiElement> findMatchingElements(PbFile file, PbJavaGotoDeclarationContext context) {
        PsiClass contextClass = context.javaClass;
        String classContextName = contextClass.getQualifiedName();
        String elementName = context.resolvedElement.getName();
        if (classContextName == null || elementName == null) {
            return Collections.emptyList();
        }
        ArrayList<PsiElement> results = new ArrayList<PsiElement>();
        ArrayList<PsiElement> matchedTypeElements = new ArrayList<PsiElement>();
        List nameMatchers = ContainerUtil.map(NameGeneratorSelector.selectForFile(file), generator -> generator.toNameMatcher(context));
        if (context.javaClass.isEnum()) {
            PbJavaGotoDeclarationHandler.findMatchingEnumElement(file, context, nameMatchers, results, matchedTypeElements);
        } else {
            PbJavaGotoDeclarationHandler.findMatchingClassElement(file, context, nameMatchers, results, matchedTypeElements);
        }
        if (results.isEmpty()) {
            return matchedTypeElements;
        }
        return results;
    }

    private static void findMatchingEnumElement(PbFile file, PbJavaGotoDeclarationContext context, List<NameMatcher> nameMatchers, List<PsiElement> results, List<PsiElement> matchedTypeElements) {
        boolean searchEnumValues = context.resolvedElement instanceof PsiEnumConstant;
        for (PbSymbol symbol : file.getLocalQualifiedSymbolMap().values()) {
            if (PbPsiUtil.isEnumElement(symbol)) {
                PbEnumDefinition enumDefinition = (PbEnumDefinition)symbol;
                for (NameMatcher matcher : nameMatchers) {
                    if (!matcher.matchesEnum(enumDefinition)) continue;
                    if (!searchEnumValues) {
                        results.add(enumDefinition);
                        continue;
                    }
                    matchedTypeElements.add(enumDefinition);
                    for (PbEnumValue enumValue : enumDefinition.getEnumValues()) {
                        if (!matcher.matchesEnumValue(enumValue)) continue;
                        results.add(enumValue);
                    }
                }
                continue;
            }
            if (!PbPsiUtil.isOneofElement(symbol)) continue;
            PbOneofDefinition oneof = (PbOneofDefinition)symbol;
            for (NameMatcher matcher : nameMatchers) {
                if (!matcher.matchesOneofEnum(oneof)) continue;
                if (!searchEnumValues) {
                    results.add(oneof);
                    continue;
                }
                matchedTypeElements.add(oneof);
                if (matcher.matchesOneofNotSetEnumValue(oneof)) {
                    results.add(oneof);
                    continue;
                }
                for (PbStatement statement : oneof.getStatements()) {
                    PbField oneofField;
                    if (!(statement instanceof PbField) || !matcher.matchesOneofEnumValue(oneofField = (PbField)statement)) continue;
                    results.add(oneofField);
                }
            }
        }
    }

    private static void findMatchingClassElement(PbFile file, PbJavaGotoDeclarationContext context, List<NameMatcher> nameMatchers, List<PsiElement> results, List<PsiElement> matchedTypeElements) {
        boolean searchFields = context.resolvedElement instanceof PsiMember;
        for (PbSymbol symbol : file.getLocalQualifiedSymbolMap().values()) {
            if (!PbPsiUtil.isMessageElement(symbol)) continue;
            PbMessageType message = (PbMessageType)symbol;
            for (NameMatcher matcher : nameMatchers) {
                if (!matcher.matchesMessage(message)) continue;
                if (!searchFields) {
                    results.add(message);
                    continue;
                }
                matchedTypeElements.add(message);
                for (PbField field : message.getSymbols(PbField.class)) {
                    if (!matcher.matchesField(field)) continue;
                    results.add(field);
                }
                for (PbOneofDefinition oneof : message.getSymbols(PbOneofDefinition.class)) {
                    if (!matcher.matchesOneofMember(oneof)) continue;
                    results.add(oneof);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/protobuf/jvm/PbJavaGotoDeclarationHandler", "getActionText"));
    }
}

