/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.jvm;

import com.google.common.collect.ImmutableSet;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.protobuf.jvm.names.NameGenerator;
import com.intellij.protobuf.jvm.names.NameGeneratorSelector;
import com.intellij.protobuf.lang.psi.PbEnumDefinition;
import com.intellij.protobuf.lang.psi.PbEnumValue;
import com.intellij.protobuf.lang.psi.PbField;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbGroupDefinition;
import com.intellij.protobuf.lang.psi.PbMessageDefinition;
import com.intellij.protobuf.lang.psi.PbMessageType;
import com.intellij.protobuf.lang.psi.PbNamedElement;
import com.intellij.protobuf.lang.psi.PbOneofDefinition;
import com.intellij.protobuf.lang.psi.PbStatementOwner;
import com.intellij.protobuf.lang.psi.PbSymbol;
import com.intellij.protobuf.lang.psi.PbSymbolOwner;
import com.intellij.protobuf.lang.psi.PbVisitor;
import com.intellij.protobuf.lang.psi.util.PbPsiUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PbJavaFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    public boolean canFindUsages(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            PbJavaFindUsagesHandlerFactory.$$$reportNull$$$0(0);
        }
        return psiElement instanceof PbSymbol;
    }

    @Nullable
    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement psiElement, boolean forHighlightUsages) {
        if (psiElement == null) {
            PbJavaFindUsagesHandlerFactory.$$$reportNull$$$0(1);
        }
        if (forHighlightUsages) {
            return null;
        }
        if (!(psiElement instanceof PbSymbol)) {
            return null;
        }
        PbSymbol symbol = (PbSymbol)psiElement;
        PbFile file = symbol.getPbFile();
        ProtoToJavaConverter dispatcher = new ProtoToJavaConverter(file);
        symbol.accept(dispatcher);
        if (dispatcher.results == null) {
            return null;
        }
        return new AdditionalUsagesHandler(symbol, dispatcher.results);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "psiElement";
        objectArray2[1] = "com/intellij/protobuf/jvm/PbJavaFindUsagesHandlerFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canFindUsages";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createFindUsagesHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ProtoToJavaConverter
    extends PbVisitor {
        PsiElement[] results;
        private final PbFile file;
        private static final boolean CHECK_BASES = false;
        private final NotNullLazyValue<List<NameGenerator>> nameGenerators = new NotNullLazyValue<List<NameGenerator>>(){

            @NotNull
            protected List<NameGenerator> compute() {
                List<NameGenerator> list = NameGeneratorSelector.selectForFile(file);
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/protobuf/jvm/PbJavaFindUsagesHandlerFactory$ProtoToJavaConverter$1", "compute"));
            }
        };

        ProtoToJavaConverter(PbFile file) {
            this.file = file;
        }

        private void setResults(Collection<? extends PsiElement> javaElements) {
            if (!javaElements.isEmpty()) {
                this.results = (PsiElement[])javaElements.stream().distinct().toArray(PsiElement[]::new);
            }
        }

        @Override
        public void visitMessageDefinition(@NotNull PbMessageDefinition message) {
            if (message == null) {
                ProtoToJavaConverter.$$$reportNull$$$0(0);
            }
            this.setResults(this.messageTypeClasses(message));
        }

        @Override
        public void visitField(@NotNull PbField field) {
            if (field == null) {
                ProtoToJavaConverter.$$$reportNull$$$0(1);
            }
            Collection<PsiMember> javaElements = this.fieldMembers(field);
            PbStatementOwner owner = field.getStatementOwner();
            if (PbPsiUtil.isOneofElement(owner)) {
                Collection<PsiClass> enumParents = this.oneofEnumClasses((PbOneofDefinition)owner);
                javaElements.addAll(this.oneofFieldEnumConstants(field, enumParents));
            }
            this.setResults(javaElements);
        }

        @Override
        public void visitGroupDefinition(@NotNull PbGroupDefinition group) {
            if (group == null) {
                ProtoToJavaConverter.$$$reportNull$$$0(2);
            }
            ArrayList<PsiClass> javaElements = new ArrayList<PsiClass>(this.messageTypeClasses(group));
            for (PbSymbol sibling : group.getAdditionalSiblings()) {
                ProtoToJavaConverter siblingVisitor = new ProtoToJavaConverter(this.file);
                sibling.accept(siblingVisitor);
                if (siblingVisitor.results == null) continue;
                Collections.addAll(javaElements, siblingVisitor.results);
            }
            this.setResults(javaElements);
        }

        @Override
        public void visitEnumDefinition(@NotNull PbEnumDefinition enumDefinition) {
            if (enumDefinition == null) {
                ProtoToJavaConverter.$$$reportNull$$$0(3);
            }
            this.setResults(this.enumDefinitionClasses(enumDefinition));
        }

        @Override
        public void visitEnumValue(@NotNull PbEnumValue enumValue) {
            if (enumValue == null) {
                ProtoToJavaConverter.$$$reportNull$$$0(4);
            }
            this.setResults(this.enumValueEnumConstants(enumValue));
        }

        @Override
        public void visitOneofDefinition(@NotNull PbOneofDefinition oneof) {
            if (oneof == null) {
                ProtoToJavaConverter.$$$reportNull$$$0(5);
            }
            ArrayList<PsiMember> javaElements = new ArrayList<PsiMember>(this.oneofMessageMembers(oneof));
            Collection<PsiClass> oneofEnums = this.oneofEnumClasses(oneof);
            javaElements.addAll(oneofEnums);
            javaElements.addAll(this.protoToEnumConstants(oneof, NameGenerator::oneofNotSetEnumValueName, oneofEnums));
            this.setResults(javaElements);
        }

        private Collection<PsiClass> messageTypeClasses(PbMessageType messageType) {
            return this.protoToClasses(messageType, NameGenerator::messageClassNames, cls -> !cls.isEnum());
        }

        private Collection<PsiClass> enumDefinitionClasses(PbEnumDefinition enumDefinition) {
            return this.protoToClasses(enumDefinition, (nameGen, enumDef) -> {
                String name = nameGen.enumClassName((PbEnumDefinition)enumDef);
                return name != null ? ImmutableSet.of((Object)name) : ImmutableSet.of();
            }, PsiClass::isEnum);
        }

        private Collection<PsiClass> oneofEnumClasses(PbOneofDefinition oneof) {
            return this.protoToClasses(oneof, (nameGen, oneofDef) -> {
                String name = nameGen.oneofEnumClassName((PbOneofDefinition)oneofDef);
                return name != null ? ImmutableSet.of((Object)name) : ImmutableSet.of();
            }, PsiClass::isEnum);
        }

        private <ProtoT extends PbNamedElement> Collection<PsiClass> protoToClasses(ProtoT protoNamedType, BiFunction<NameGenerator, ProtoT, Set<String>> toClassNames, Predicate<PsiClass> classPredicate) {
            ArrayList<PsiClass> javaElements = new ArrayList<PsiClass>();
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)this.file.getProject());
            GlobalSearchScope scope = this.getScope(this.file);
            for (NameGenerator generator : (List)this.nameGenerators.getValue()) {
                Set<String> classNames = toClassNames.apply(generator, protoNamedType);
                for (String className : classNames) {
                    PsiClass[] classes = javaPsiFacade.findClasses(className, scope);
                    Arrays.stream(classes).filter(classPredicate).forEach(javaElements::add);
                }
            }
            return javaElements;
        }

        private Collection<PsiMember> fieldMembers(PbField field) {
            return this.protoToMembers(field, NameGenerator::fieldMemberNames);
        }

        private Collection<PsiMember> oneofMessageMembers(PbOneofDefinition oneof) {
            return this.protoToMembers(oneof, NameGenerator::oneofMemberNames);
        }

        private <ProtoT extends PbNamedElement> Collection<PsiMember> protoToMembers(ProtoT protoElement, BiFunction<NameGenerator, ProtoT, Set<String>> toMemberNames) {
            PbSymbolOwner owner = protoElement.getSymbolOwner();
            if (!PbPsiUtil.isMessageElement(owner)) {
                return Collections.emptyList();
            }
            PbMessageType message = (PbMessageType)owner;
            Collection<PsiClass> parentClasses = this.messageTypeClasses(message);
            if (parentClasses.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<PsiMember> javaElements = new ArrayList<PsiMember>();
            for (NameGenerator generator : (List)this.nameGenerators.getValue()) {
                Collection fieldMembers = toMemberNames.apply(generator, protoElement);
                for (PsiClass psiClass : parentClasses) {
                    for (String qualifiedMember : fieldMembers) {
                        String innerClass;
                        PsiClass parentClass;
                        String[] components = qualifiedMember.split("\\.");
                        int componentIndex = 0;
                        for (parentClass = psiClass; componentIndex < components.length - 1 && parentClass != null; parentClass = parentClass.findInnerClassByName(innerClass, false), ++componentIndex) {
                            innerClass = components[componentIndex];
                        }
                        if (parentClass == null) continue;
                        String fieldOrMethod = components[componentIndex];
                        PsiField javaField = parentClass.findFieldByName(fieldOrMethod, false);
                        if (javaField != null) {
                            javaElements.add((PsiMember)javaField);
                            continue;
                        }
                        PsiMethod[] methods = parentClass.findMethodsByName(fieldOrMethod, false);
                        Collections.addAll(javaElements, methods);
                    }
                }
            }
            return javaElements;
        }

        private Collection<PsiField> enumValueEnumConstants(PbEnumValue enumValue) {
            PbEnumDefinition enumDefinition = (PbEnumDefinition)PsiTreeUtil.getParentOfType((PsiElement)enumValue, PbEnumDefinition.class);
            if (enumDefinition == null) {
                return Collections.emptyList();
            }
            Collection<PsiClass> enumParents = this.enumDefinitionClasses(enumDefinition);
            if (enumParents.isEmpty()) {
                return Collections.emptyList();
            }
            return this.protoToEnumConstants(enumValue, NameGenerator::enumValueName, enumParents);
        }

        private Collection<PsiField> oneofFieldEnumConstants(PbField oneofField, Collection<PsiClass> enumParents) {
            return new ArrayList<PsiField>(this.protoToEnumConstants(oneofField, NameGenerator::oneofEnumValueName, enumParents));
        }

        private <ProtoT extends PbNamedElement> Collection<PsiField> protoToEnumConstants(ProtoT protoElement, BiFunction<NameGenerator, ProtoT, String> toEnumName, Collection<PsiClass> enumParents) {
            ArrayList<PsiField> javaElements = new ArrayList<PsiField>();
            for (NameGenerator generator : (List)this.nameGenerators.getValue()) {
                String enumValueName = toEnumName.apply(generator, protoElement);
                if (enumValueName == null) continue;
                for (PsiClass enumParent : enumParents) {
                    PsiField javaEnumValue = enumParent.findFieldByName(enumValueName, false);
                    if (!(javaEnumValue instanceof PsiEnumConstant)) continue;
                    javaElements.add(javaEnumValue);
                }
            }
            return javaElements;
        }

        private GlobalSearchScope getScope(PsiElement element) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            if (module != null) {
                return GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            }
            return GlobalSearchScope.allScope((Project)element.getProject());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enumDefinition";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enumValue";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oneof";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/protobuf/jvm/PbJavaFindUsagesHandlerFactory$ProtoToJavaConverter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMessageDefinition";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitGroupDefinition";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitEnumDefinition";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitEnumValue";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitOneofDefinition";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AdditionalUsagesHandler
    extends FindUsagesHandler {
        private final PsiElement[] additionalElements;

        AdditionalUsagesHandler(@NotNull PbSymbol element, PsiElement ... additionalElements) {
            if (element == null) {
                AdditionalUsagesHandler.$$$reportNull$$$0(0);
            }
            super((PsiElement)element);
            this.additionalElements = additionalElements;
        }

        @NotNull
        public PsiElement[] getSecondaryElements() {
            if (this.additionalElements == null) {
                AdditionalUsagesHandler.$$$reportNull$$$0(1);
            }
            return this.additionalElements;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/protobuf/jvm/PbJavaFindUsagesHandlerFactory$AdditionalUsagesHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/protobuf/jvm/PbJavaFindUsagesHandlerFactory$AdditionalUsagesHandler";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSecondaryElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

