/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.ide.style;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.protobuf.ide.util.ResourceUtil;
import com.intellij.protobuf.lang.PbLanguage;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class PbLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public Language getLanguage() {
        PbLanguage pbLanguage = PbLanguage.INSTANCE;
        if (pbLanguage == null) {
            PbLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        return pbLanguage;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            PbLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        if (settingsType == null) {
            PbLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            consumer.showStandardOptions(new String[]{"SPACE_WITHIN_BRACES", "SPACE_WITHIN_BRACKETS", "SPACE_WITHIN_PARENTHESIS", "SPACE_BEFORE_COMMA", "SPACE_AFTER_COMMA", "SPACE_AROUND_ASSIGNMENT_OPERATORS"});
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"KEEP_BLANK_LINES_IN_CODE"});
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"RIGHT_MARGIN", "KEEP_LINE_BREAKS"});
        }
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new SmartIndentOptionsEditor();
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            PbLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        try {
            return ResourceUtil.readUrlAsString(((Object)((Object)this)).getClass().getResource("/example.proto"));
        }
        catch (IOException e) {
            return "Error loading example.";
        }
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (commonSettings == null) {
            PbLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(4);
        }
        if (indentOptions == null) {
            PbLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(5);
        }
        commonSettings.SPACE_BEFORE_COLON = false;
        commonSettings.SPACE_AFTER_COLON = true;
        indentOptions.USE_TAB_CHARACTER = false;
        indentOptions.TAB_SIZE = 2;
        indentOptions.INDENT_SIZE = 2;
        indentOptions.CONTINUATION_INDENT_SIZE = 4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/protobuf/ide/style/PbLanguageCodeStyleSettingsProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/protobuf/ide/style/PbLanguageCodeStyleSettingsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "customizeDefaults";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

