/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.ide.settings;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.protobuf.ide.settings.PbProjectSettings;
import com.intellij.protobuf.lang.resolve.FileResolveProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SettingsFileResolveProvider
implements FileResolveProvider {
    private final PbProjectSettings staticSettings;

    public SettingsFileResolveProvider() {
        this.staticSettings = null;
    }

    public SettingsFileResolveProvider(PbProjectSettings staticSettings) {
        this.staticSettings = staticSettings;
    }

    @Override
    @Nullable
    public VirtualFile findFile(@NotNull String path, @NotNull Project project) {
        if (path == null) {
            SettingsFileResolveProvider.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SettingsFileResolveProvider.$$$reportNull$$$0(1);
        }
        PbProjectSettings settings = this.getSettings(project);
        for (PbProjectSettings.ImportPathEntry entry : settings.getImportPathEntries()) {
            String unprefixedPath;
            VirtualFile imported;
            VirtualFile location;
            String prefix = this.normalizePath(entry.getPrefix());
            if (!path.startsWith(prefix) || (location = VirtualFileManager.getInstance().findFileByUrl(entry.getLocation())) == null || !PROTO_FILTER.accept(imported = location.findFileByRelativePath(unprefixedPath = path.substring(prefix.length())))) continue;
            return imported;
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<FileResolveProvider.ChildEntry> getChildEntries(@NotNull String path, @NotNull Project project) {
        if (path == null) {
            SettingsFileResolveProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            SettingsFileResolveProvider.$$$reportNull$$$0(3);
        }
        PbProjectSettings settings = this.getSettings(project);
        HashSet<FileResolveProvider.ChildEntry> results = new HashSet<FileResolveProvider.ChildEntry>();
        for (PbProjectSettings.ImportPathEntry entry : settings.getImportPathEntries()) {
            VirtualFile[] children;
            String unprefixedPath;
            VirtualFile pathFile;
            VirtualFile location;
            String prefix = this.normalizePath(entry.getPrefix());
            if (prefix.startsWith(path = this.normalizePath(path)) && !prefix.equals(path)) {
                String nextPrefixComponent = prefix.substring(path.length()).split("/")[0];
                results.add(FileResolveProvider.ChildEntry.directory(nextPrefixComponent));
                continue;
            }
            if (!path.startsWith(prefix) || (location = VirtualFileManager.getInstance().findFileByUrl(entry.getLocation())) == null || (pathFile = location.findFileByRelativePath(unprefixedPath = path.substring(prefix.length()))) == null || (children = pathFile.getChildren()) == null) continue;
            for (VirtualFile child : children) {
                if (!PROTO_AND_DIRECTORY_FILTER.accept(child)) continue;
                results.add(new FileResolveProvider.ChildEntry(child.getName(), child.isDirectory()));
            }
        }
        HashSet<FileResolveProvider.ChildEntry> hashSet = results;
        if (hashSet == null) {
            SettingsFileResolveProvider.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    @Override
    @Nullable
    public VirtualFile getDescriptorFile(@NotNull Project project) {
        PbProjectSettings settings;
        String descriptorPath;
        if (project == null) {
            SettingsFileResolveProvider.$$$reportNull$$$0(5);
        }
        if ((descriptorPath = (settings = this.getSettings(project)).getDescriptorPath()) != null) {
            return this.findFile(descriptorPath, project);
        }
        return null;
    }

    @Override
    @NotNull
    public GlobalSearchScope getSearchScope(@NotNull Project project) {
        if (project == null) {
            SettingsFileResolveProvider.$$$reportNull$$$0(6);
        }
        PbProjectSettings settings = this.getSettings(project);
        VirtualFile[] roots = (VirtualFile[])settings.getImportPathEntries().stream().map(PbProjectSettings.ImportPathEntry::getLocation).map(arg_0 -> ((VirtualFileManager)VirtualFileManager.getInstance()).findFileByUrl(arg_0)).filter(Objects::nonNull).toArray(VirtualFile[]::new);
        GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.directoriesScope((Project)project, (boolean)true, (VirtualFile[])roots);
        if (globalSearchScope == null) {
            SettingsFileResolveProvider.$$$reportNull$$$0(7);
        }
        return globalSearchScope;
    }

    @NotNull
    private PbProjectSettings getSettings(Project project) {
        if (this.staticSettings != null) {
            PbProjectSettings pbProjectSettings = this.staticSettings;
            if (pbProjectSettings == null) {
                SettingsFileResolveProvider.$$$reportNull$$$0(8);
            }
            return pbProjectSettings;
        }
        PbProjectSettings pbProjectSettings = PbProjectSettings.getInstance(project);
        if (pbProjectSettings == null) {
            SettingsFileResolveProvider.$$$reportNull$$$0(9);
        }
        return pbProjectSettings;
    }

    private String normalizePath(@Nullable String path) {
        if (path == null) {
            return "";
        }
        if (!path.isEmpty() && !path.endsWith("/")) {
            return path + "/";
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/protobuf/ide/settings/SettingsFileResolveProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/protobuf/ide/settings/SettingsFileResolveProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildEntries";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getChildEntries";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptorFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSearchScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

