/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.ide.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.protobuf.ide.settings.PbProjectSettings;
import com.intellij.protobuf.ide.settings.ProjectSettingsConfigurator;
import java.util.Collection;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class ProjectSettingsConfiguratorManager
implements Disposable {
    private final Project project;

    public ProjectSettingsConfiguratorManager(Project project) {
        this.project = project;
    }

    public static ProjectSettingsConfiguratorManager getInstance(Project project) {
        return (ProjectSettingsConfiguratorManager)ServiceManager.getService((Project)project, ProjectSettingsConfiguratorManager.class);
    }

    @Nullable
    public PbProjectSettings configure(PbProjectSettings settings) {
        for (ProjectSettingsConfigurator configurator : this.getConfigurators()) {
            PbProjectSettings configured = configurator.configure(this.project, settings.copy());
            if (configured == null) continue;
            return configured;
        }
        return null;
    }

    @NotNull
    public Collection<String> getDescriptorPathSuggestions() {
        TreeSet<String> suggestions = new TreeSet<String>();
        for (ProjectSettingsConfigurator configurator : this.getConfigurators()) {
            suggestions.addAll(configurator.getDescriptorPathSuggestions(this.project));
        }
        TreeSet<String> treeSet = suggestions;
        if (treeSet == null) {
            ProjectSettingsConfiguratorManager.$$$reportNull$$$0(0);
        }
        return treeSet;
    }

    private ProjectSettingsConfigurator[] getConfigurators() {
        return (ProjectSettingsConfigurator[])ProjectSettingsConfigurator.EP_NAME.getExtensions((AreaInstance)this.project);
    }

    private void configureSettingsIfNecessary() {
        PbProjectSettings settings = PbProjectSettings.getInstance(this.project);
        if (!settings.isAutoConfigEnabled()) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (this.project.isDisposed()) {
                return;
            }
            PbProjectSettings newSettings = this.configure(settings);
            if (newSettings != null && !settings.equals(newSettings)) {
                settings.copyState(newSettings);
                ApplicationManager.getApplication().invokeLater(() -> PbProjectSettings.notifyUpdated(this.project), ModalityState.NON_MODAL);
            }
        });
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/protobuf/ide/settings/ProjectSettingsConfiguratorManager", "getDescriptorPathSuggestions"));
    }

    static final class ProjectOpenedActivity
    implements StartupActivity {
        ProjectOpenedActivity() {
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                ProjectOpenedActivity.$$$reportNull$$$0(0);
            }
            ProjectSettingsConfiguratorManager instance = ProjectSettingsConfiguratorManager.getInstance(project);
            project.getExtensionArea().getExtensionPoint(ProjectSettingsConfigurator.EP_NAME).addChangeListener(() -> instance.configureSettingsIfNecessary(), (Disposable)instance);
            instance.configureSettingsIfNecessary();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/protobuf/ide/settings/ProjectSettingsConfiguratorManager$ProjectOpenedActivity", "runActivity"));
        }
    }

    static final class ProjectRootsListener
    implements ModuleRootListener {
        ProjectRootsListener() {
        }

        public void rootsChanged(@NotNull ModuleRootEvent event) {
            if (event == null) {
                ProjectRootsListener.$$$reportNull$$$0(0);
            }
            ProjectSettingsConfiguratorManager.getInstance(event.getProject()).configureSettingsIfNecessary();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/protobuf/ide/settings/ProjectSettingsConfiguratorManager$ProjectRootsListener", "rootsChanged"));
        }
    }
}

