/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.ide.settings;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.protobuf.ide.PbIdeBundle;
import com.intellij.protobuf.ide.settings.PbProjectSettings;
import com.intellij.protobuf.ide.settings.ProjectSettingsConfiguratorManager;
import com.intellij.protobuf.ide.settings.SettingsFileResolveProvider;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.table.TableView;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.CellEditorComponentWithBrowseButton;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.table.IconTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PbLanguageSettingsForm
implements ConfigurableUi<PbProjectSettings> {
    private static final Pattern LEADING_TRAILING_SLASHES = Pattern.compile("(^/+)|(/+$)");
    private final Project project;
    private PbProjectSettings originalSettings;
    private JPanel panel;
    private ListTableModel<ImportPath> importPathModel;
    private ComboBox<String> descriptorPathField;
    private JCheckBox autoConfigCheckbox;
    private final List<JComponent> manualConfigComponents = new ArrayList<JComponent>();

    PbLanguageSettingsForm(Project project) {
        this.project = project;
        this.initComponent();
    }

    public void reset(@NotNull PbProjectSettings settings) {
        if (settings == null) {
            PbLanguageSettingsForm.$$$reportNull$$$0(0);
        }
        this.originalSettings = settings;
        this.loadSettings(settings);
    }

    public boolean isModified(@NotNull PbProjectSettings settings) {
        if (settings == null) {
            PbLanguageSettingsForm.$$$reportNull$$$0(1);
        }
        return !this.getImportPathEntries().equals(settings.getImportPathEntries()) || !this.getDescriptorPath().equals(settings.getDescriptorPath()) || this.isAutoConfigEnabled() != settings.isAutoConfigEnabled();
    }

    public void apply(@NotNull PbProjectSettings settings) {
        if (settings == null) {
            PbLanguageSettingsForm.$$$reportNull$$$0(2);
        }
        this.applyNoNotify(settings);
        PbProjectSettings.notifyUpdated(this.project);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.panel;
        if (jPanel == null) {
            PbLanguageSettingsForm.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private void loadSettings(@NotNull PbProjectSettings settings) {
        if (settings == null) {
            PbLanguageSettingsForm.$$$reportNull$$$0(4);
        }
        this.autoConfigCheckbox.setSelected(settings.isAutoConfigEnabled());
        this.descriptorPathField.setSelectedItem((Object)settings.getDescriptorPath());
        this.importPathModel.setItems(new ArrayList());
        this.importPathModel.addRows((Collection)ContainerUtil.map(settings.getImportPathEntries(), ImportPath::new));
    }

    private void applyNoNotify(@NotNull PbProjectSettings settings) {
        if (settings == null) {
            PbLanguageSettingsForm.$$$reportNull$$$0(5);
        }
        settings.setAutoConfigEnabled(this.isAutoConfigEnabled());
        settings.setDescriptorPath(this.getDescriptorPath());
        settings.setImportPathEntries(this.getImportPathEntries());
    }

    private void initComponent() {
        JPanel pathsPanel = this.buildImportPathsPanel();
        this.manualConfigComponents.add(pathsPanel);
        JPanel descriptorPanel = this.buildDescriptorPathPanel();
        this.manualConfigComponents.add(descriptorPanel);
        BorderLayoutPanel manualConfigurationPanel = new BorderLayoutPanel();
        manualConfigurationPanel.add((Component)pathsPanel, "Center");
        manualConfigurationPanel.add((Component)descriptorPanel, "South");
        this.autoConfigCheckbox = new JBCheckBox(PbIdeBundle.message("settings.language.autoconfig", new Object[0]));
        this.panel = new BorderLayoutPanel();
        this.panel.add((Component)this.autoConfigCheckbox, "North");
        this.panel.add((Component)manualConfigurationPanel, "Center");
        this.autoConfigCheckbox.addItemListener(event -> {
            boolean autoConfig = ((JCheckBox)event.getSource()).isSelected();
            this.manualConfigComponents.forEach(component -> component.setEnabled(!autoConfig));
        });
        this.autoConfigCheckbox.addActionListener(event -> {
            boolean autoConfig = ((JCheckBox)event.getSource()).isSelected();
            if (autoConfig) {
                this.applyAutomaticConfiguration();
            }
        });
    }

    private JPanel buildDescriptorPathPanel() {
        ArrayList<String> descriptorOptions = new ArrayList<String>(ProjectSettingsConfiguratorManager.getInstance(this.project).getDescriptorPathSuggestions());
        this.descriptorPathField = new ComboBox((ComboBoxModel)new CollectionComboBoxModel(descriptorOptions));
        this.descriptorPathField.setEditable(true);
        JTextField editorComponent = (JTextField)this.descriptorPathField.getEditor().getEditorComponent();
        editorComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                PbLanguageSettingsForm.this.updateDescriptorPathColor();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/protobuf/ide/settings/PbLanguageSettingsForm$1", "textChanged"));
            }
        });
        this.importPathModel.addTableModelListener(event -> this.updateDescriptorPathColor());
        return LabeledComponent.create(this.descriptorPathField, (String)PbIdeBundle.message("settings.language.descriptor.path", new Object[0]), (String)"West");
    }

    private JPanel buildImportPathsPanel() {
        BorderLayoutPanel panel = new BorderLayoutPanel();
        UIUtil.addBorder((JComponent)panel, (Border)IdeBorderFactory.createTitledBorder((String)PbIdeBundle.message("settings.language.import.paths", new Object[0]), (boolean)false));
        this.importPathModel = new ListTableModel(new ColumnInfo[]{new LocationColumn(PbIdeBundle.message("location", new Object[0])), new PrefixColumn(PbIdeBundle.message("prefix", new Object[0]))});
        TableView importPathTable = new TableView(this.importPathModel);
        importPathTable.setStriped(true);
        this.manualConfigComponents.add((JComponent)importPathTable);
        importPathTable.setMinRowHeight(25);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((TableView)importPathTable, null);
        decorator.setAddAction(button -> {
            VirtualFile selectedFile = FileChooser.chooseFile((FileChooserDescriptor)PbLanguageSettingsForm.getFileChooserDescriptor(null), (Project)this.project, null);
            if (selectedFile != null) {
                this.importPathModel.addRow((Object)new ImportPath(selectedFile.getUrl()));
            }
        });
        decorator.setEditAction(button -> importPathTable.editCellAt(importPathTable.getSelectedRow(), importPathTable.getSelectedColumn()));
        panel.add((Component)decorator.createPanel(), "Center");
        return panel;
    }

    private List<PbProjectSettings.ImportPathEntry> getImportPathEntries() {
        return this.importPathModel.getItems().stream().map(ImportPath::toEntry).collect(Collectors.toList());
    }

    private String getDescriptorPath() {
        return (String)this.descriptorPathField.getEditor().getItem();
    }

    private boolean isAutoConfigEnabled() {
        return this.autoConfigCheckbox.isSelected();
    }

    private boolean isDescriptorPathValid() {
        PbProjectSettings tempSettings = new PbProjectSettings();
        this.applyNoNotify(tempSettings);
        SettingsFileResolveProvider provider = new SettingsFileResolveProvider(tempSettings);
        return provider.getDescriptorFile(this.project) != null;
    }

    private void updateDescriptorPathColor() {
        if (this.isDescriptorPathValid()) {
            this.descriptorPathField.getEditor().getEditorComponent().setForeground(UIUtil.getTextFieldForeground());
        } else {
            this.descriptorPathField.getEditor().getEditorComponent().setForeground((Color)JBColor.RED);
        }
    }

    private void applyAutomaticConfiguration() {
        PbProjectSettings currentSettings = this.originalSettings.copy();
        this.applyNoNotify(currentSettings);
        PbProjectSettings newSettings = ProjectSettingsConfiguratorManager.getInstance(this.project).configure(currentSettings.copy());
        this.loadSettings(newSettings != null ? newSettings : currentSettings);
    }

    private static FileChooserDescriptor getFileChooserDescriptor(@NlsContexts.DialogTitle String title) {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, true, false).withShowFileSystemRoots(true).withShowHiddenFiles(true);
        if (title != null) {
            descriptor.setTitle(title);
        }
        return descriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/protobuf/ide/settings/PbLanguageSettingsForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/protobuf/ide/settings/PbLanguageSettingsForm";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyNoNotify";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LocationCellEditor
    extends AbstractTableCellEditor {
        @NlsContexts.DialogTitle
        private final String title;
        private final Project project;
        private CellEditorComponentWithBrowseButton<JTextField> component = null;

        LocationCellEditor(@Nullable @NlsContexts.DialogTitle String title, @Nullable Project project) {
            this.title = title;
            this.project = project;
        }

        LocationCellEditor(@Nullable Project project) {
            this(null, project);
        }

        public Object getCellEditorValue() {
            return this.component != null ? ((JTextField)this.component.getChildComponent()).getText() : "";
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.component = new CellEditorComponentWithBrowseButton((ComponentWithBrowseButton)new TextFieldWithBrowseButton(this.createActionListener(table)), (TableCellEditor)((Object)this));
            ((JTextField)this.component.getChildComponent()).setText((String)value);
            this.component.setFocusable(false);
            return this.component;
        }

        public boolean isCellEditable(EventObject e) {
            return !(e instanceof MouseEvent) || ((MouseEvent)e).getClickCount() >= 2;
        }

        private ActionListener createActionListener(JTable table) {
            return e -> {
                String initialValue = (String)this.getCellEditorValue();
                VirtualFile initialFile = !StringUtil.isEmpty((String)initialValue) ? VirtualFileManager.getInstance().findFileByUrl(initialValue) : null;
                FileChooser.chooseFile((FileChooserDescriptor)PbLanguageSettingsForm.getFileChooserDescriptor(this.title), (Project)this.project, (Component)table, (VirtualFile)initialFile, file -> ((JTextField)this.component.getChildComponent()).setText(file.getUrl()));
            };
        }
    }

    private static class ImportPath {
        @NlsSafe
        String location;
        @NlsSafe
        String prefix;

        ImportPath(PbProjectSettings.ImportPathEntry entry) {
            this.location = entry.getLocation();
            this.prefix = entry.getPrefix();
        }

        ImportPath(String location) {
            this.location = location;
            this.prefix = null;
        }

        PbProjectSettings.ImportPathEntry toEntry() {
            return new PbProjectSettings.ImportPathEntry(this.location, this.prefix);
        }
    }

    private static class PrefixColumn
    extends ColumnInfo<ImportPath, String> {
        PrefixColumn(@NlsContexts.ColumnName String name) {
            super(name);
        }

        @Nullable
        public String valueOf(ImportPath o) {
            return o.prefix;
        }

        public void setValue(ImportPath o, String value) {
            o.prefix = LEADING_TRAILING_SLASHES.matcher(value.trim()).replaceAll("");
        }

        public boolean isCellEditable(ImportPath item) {
            return true;
        }

        public TableCellEditor getEditor(ImportPath path) {
            DefaultCellEditor editor = new DefaultCellEditor((JTextField)new JBTextField(path.prefix));
            editor.setClickCountToStart(2);
            return editor;
        }
    }

    private class LocationColumn
    extends ColumnInfo<ImportPath, String> {
        LocationColumn(String name) {
            super(name);
        }

        @Nullable
        public String valueOf(ImportPath o) {
            return o.location;
        }

        public void setValue(ImportPath o, String value) {
            o.location = value;
        }

        public boolean isCellEditable(ImportPath path) {
            return true;
        }

        public TableCellRenderer getRenderer(ImportPath path) {
            return new IconTableCellRenderer<String>(){

                @Nullable
                protected Icon getIcon(@NotNull String value, JTable table, int row) {
                    VirtualFile file;
                    if (value == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((file = VirtualFileManager.getInstance().findFileByUrl(value)) != null && file.isDirectory()) {
                        return PlatformIcons.FOLDER_ICON;
                    }
                    return AllIcons.General.Error;
                }

                protected void setValue(Object value) {
                    String url = (String)value;
                    VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
                    if (file == null || !file.isDirectory()) {
                        this.setForeground((Color)JBColor.RED);
                    }
                    this.setText(file != null ? file.getPresentableUrl() : url);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/protobuf/ide/settings/PbLanguageSettingsForm$LocationColumn$1", "getIcon"));
                }
            };
        }

        public TableCellEditor getEditor(ImportPath path) {
            return new LocationCellEditor(PbLanguageSettingsForm.this.project);
        }
    }
}

