/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.ide.settings;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.protobuf.ide.settings.PbProjectSettings;
import com.intellij.protobuf.ide.settings.ProjectSettingsConfigurator;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultConfigurator
implements ProjectSettingsConfigurator {
    private static final String DESCRIPTOR = "google/protobuf/descriptor.proto";

    @Override
    @NotNull
    public PbProjectSettings configure(Project project, PbProjectSettings settings) {
        VirtualFile[] roots;
        settings.setDescriptorPath(DESCRIPTOR);
        settings.getImportPathEntries().clear();
        for (VirtualFile root : roots = ProjectRootManager.getInstance((Project)project).getContentSourceRoots()) {
            settings.getImportPathEntries().add(new PbProjectSettings.ImportPathEntry(root.getUrl(), ""));
        }
        PbProjectSettings.ImportPathEntry includeEntry = DefaultConfigurator.getBuiltInIncludeEntry();
        if (includeEntry != null) {
            settings.getImportPathEntries().add(includeEntry);
        }
        PbProjectSettings pbProjectSettings = settings;
        if (pbProjectSettings == null) {
            DefaultConfigurator.$$$reportNull$$$0(0);
        }
        return pbProjectSettings;
    }

    @Override
    @NotNull
    public Collection<String> getDescriptorPathSuggestions(Project project) {
        List<String> list = Collections.singletonList(DESCRIPTOR);
        if (list == null) {
            DefaultConfigurator.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    static PbProjectSettings.ImportPathEntry getBuiltInIncludeEntry() {
        URL includedDescriptorsDirectoryUrl = DefaultConfigurator.class.getClassLoader().getResource("include");
        if (includedDescriptorsDirectoryUrl == null) {
            return null;
        }
        VirtualFile descriptorsDirectory = VfsUtil.findFileByURL((URL)includedDescriptorsDirectoryUrl);
        if (descriptorsDirectory == null || !descriptorsDirectory.isDirectory()) {
            return null;
        }
        return new PbProjectSettings.ImportPathEntry(descriptorsDirectory.getUrl(), null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/protobuf/ide/settings/DefaultConfigurator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "configure";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptorPathSuggestions";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

