/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.ide.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.protobuf.ide.formatter.PbTextBlock;
import com.intellij.protobuf.lang.psi.PbStatement;
import com.intellij.protobuf.lang.psi.PbTextElementType;
import com.intellij.protobuf.lang.psi.ProtoBlockBody;
import com.intellij.protobuf.lang.psi.ProtoTokenTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.common.AbstractBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PbBlock
extends AbstractBlock {
    private final SpacingBuilder spacingBuilder;

    PbBlock(@NotNull ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment, SpacingBuilder spacingBuilder) {
        if (node == null) {
            PbBlock.$$$reportNull$$$0(0);
        }
        super(node, wrap, alignment);
        this.spacingBuilder = spacingBuilder;
    }

    protected List<Block> buildChildren() {
        if (this.isLeaf()) {
            return Collections.emptyList();
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (ASTNode child : this.myNode.getChildren(null)) {
            if (this.isEmpty(child)) continue;
            if (child.getElementType() instanceof PbTextElementType) {
                blocks.add((Block)new PbTextBlock(child, this.myWrap, this.myAlignment, this.spacingBuilder));
                continue;
            }
            child = this.deepestLeaf(child);
            blocks.add((Block)new PbBlock(child, this.myWrap, this.myAlignment, this.spacingBuilder));
        }
        return blocks;
    }

    public Indent getIndent() {
        if (this.isEmpty(this.myNode)) {
            return null;
        }
        PsiElement psi = this.myNode.getPsi();
        PsiElement parent = psi.getParent();
        if (parent instanceof ProtoBlockBody) {
            ProtoBlockBody block = (ProtoBlockBody)parent;
            if (psi.equals(block.getStart()) || psi.equals(block.getEnd())) {
                return Indent.getNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        if (psi instanceof ProtoBlockBody) {
            return Indent.getNoneIndent();
        }
        if (ProtoTokenTypes.SEMI.equals(this.myNode.getElementType())) {
            return Indent.getNoneIndent();
        }
        if (ProtoTokenTypes.BLOCK_COMMENT.equals(this.myNode.getElementType()) || ProtoTokenTypes.LINE_COMMENT.equals(this.myNode.getElementType())) {
            return Indent.getNoneIndent();
        }
        if (this.isLeaf() || parent instanceof PbStatement) {
            return Indent.getContinuationWithoutFirstIndent();
        }
        return Indent.getNoneIndent();
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            PbBlock.$$$reportNull$$$0(1);
        }
        return this.spacingBuilder.getSpacing((Block)this, child1, child2);
    }

    public boolean isLeaf() {
        return this.myNode.getFirstChildNode() == null;
    }

    public Indent getChildIndent() {
        PsiElement psi = this.myNode.getPsi();
        if (psi instanceof PbStatement) {
            return Indent.getContinuationWithoutFirstIndent();
        }
        if (psi instanceof ProtoBlockBody) {
            return Indent.getNormalIndent();
        }
        return Indent.getNoneIndent();
    }

    private boolean isEmpty(ASTNode node) {
        return node.getElementType() == TokenType.WHITE_SPACE || node.getTextLength() == 0;
    }

    private ASTNode deepestLeaf(ASTNode node) {
        while (node.getFirstChildNode() != null && node.getTextRange().equals((Object)node.getFirstChildNode().getTextRange())) {
            node = node.getFirstChildNode();
        }
        return node;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/protobuf/ide/formatter/PbBlock";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpacing";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

