/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.ide.editing;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.protobuf.ide.PbIdeBundle;
import com.intellij.protobuf.ide.settings.PbTextLanguageSettings;
import com.intellij.protobuf.ide.settings.PbTextLanguageSettingsConfigurable;
import com.intellij.protobuf.lang.psi.PbTextFile;
import com.intellij.protobuf.lang.resolve.directive.SchemaDirective;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.containers.WeakList;
import java.util.Collection;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingSchemaNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"prototext.missing.schema.notification");
    private final Collection<VirtualFile> ignoredFiles = new WeakList();

    public static void update(PbTextFile file) {
        if (file == null) {
            return;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        EditorNotifications.getInstance((Project)file.getProject()).updateNotifications(virtualFile);
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            MissingSchemaNotificationProvider.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile virtualFile, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (virtualFile == null) {
            MissingSchemaNotificationProvider.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            MissingSchemaNotificationProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            MissingSchemaNotificationProvider.$$$reportNull$$$0(3);
        }
        if (this.ignoredFiles.contains(virtualFile)) {
            return null;
        }
        if (!(fileEditor instanceof TextEditor)) {
            return null;
        }
        TextEditor textEditor = (TextEditor)fileEditor;
        Editor editor = textEditor.getEditor();
        PbTextLanguageSettings settings = PbTextLanguageSettings.getInstance(project);
        if (settings == null || !settings.isMissingSchemaWarningEnabled()) {
            return null;
        }
        Document document = editor.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        PsiFile file = documentManager.getPsiFile(document);
        if (!(file instanceof PbTextFile)) {
            return null;
        }
        PbTextFile textFile = (PbTextFile)file;
        SchemaDirective existingDirective = SchemaDirective.find((PsiFile)textFile);
        if (existingDirective != null) {
            return null;
        }
        return this.createPanelForTextFormatFile(textFile);
    }

    private EditorNotificationPanel createPanelForTextFormatFile(PbTextFile file) {
        PbTextLanguageSettings settings;
        if (file.isBound()) {
            return null;
        }
        EditorNotificationPanel panel = new EditorNotificationPanel();
        panel.setText(PbIdeBundle.message("prototext.missing.schema.message", new Object[0]));
        HyperlinkListener closingListener = event -> EditorNotifications.getInstance((Project)file.getProject()).updateNotifications(file.getVirtualFile());
        if (file.isWritable()) {
            panel.createActionLabel(PbIdeBundle.message("prototext.missing.schema.insert.annotation", new Object[0]), "prototext.InsertSchemaDirective").addHyperlinkListener(closingListener);
        }
        if ((settings = PbTextLanguageSettings.getInstance(file.getProject())) != null) {
            panel.createActionLabel(PbIdeBundle.message("prototext.missing.schema.settings", new Object[0]), () -> ShowSettingsUtil.getInstance().showSettingsDialog(file.getProject(), PbTextLanguageSettingsConfigurable.class)).addHyperlinkListener(closingListener);
        }
        panel.createActionLabel(PbIdeBundle.message("prototext.missing.schema.ignore", new Object[0]), () -> this.ignoredFiles.add(file.getVirtualFile())).addHyperlinkListener(closingListener);
        return panel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/protobuf/ide/editing/MissingSchemaNotificationProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/protobuf/ide/editing/MissingSchemaNotificationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

