/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class PsiPrecedenceUtil {
    public static final int PARENTHESIZED_PRECEDENCE = 0;
    public static final int LITERAL_PRECEDENCE = 0;
    public static final int METHOD_CALL_PRECEDENCE = 1;
    public static final int POSTFIX_PRECEDENCE = 2;
    public static final int PREFIX_PRECEDENCE = 3;
    public static final int TYPE_CAST_PRECEDENCE = 4;
    public static final int MULTIPLICATIVE_PRECEDENCE = 5;
    public static final int ADDITIVE_PRECEDENCE = 6;
    public static final int SHIFT_PRECEDENCE = 7;
    public static final int RELATIONAL_PRECEDENCE = 8;
    public static final int EQUALITY_PRECEDENCE = 9;
    public static final int BINARY_AND_PRECEDENCE = 10;
    public static final int BINARY_XOR_PRECEDENCE = 11;
    public static final int BINARY_OR_PRECEDENCE = 12;
    public static final int AND_PRECEDENCE = 13;
    public static final int OR_PRECEDENCE = 14;
    public static final int CONDITIONAL_PRECEDENCE = 15;
    public static final int ASSIGNMENT_PRECEDENCE = 16;
    public static final int LAMBDA_PRECEDENCE = 17;
    public static final int NUM_PRECEDENCES = 18;
    private static final Map<IElementType, Integer> s_binaryOperatorPrecedence = new HashMap<IElementType, Integer>(18);

    public static boolean isCommutativeOperator(@NotNull IElementType token) {
        if (token == null) {
            PsiPrecedenceUtil.$$$reportNull$$$0(0);
        }
        return token == JavaTokenType.PLUS || token == JavaTokenType.ASTERISK || token == JavaTokenType.EQEQ || token == JavaTokenType.NE || token == JavaTokenType.AND || token == JavaTokenType.OR || token == JavaTokenType.XOR;
    }

    public static boolean isCommutativeOperation(PsiPolyadicExpression expression) {
        IElementType tokenType = expression.getOperationTokenType();
        if (!PsiPrecedenceUtil.isCommutativeOperator(tokenType)) {
            return false;
        }
        PsiType type = expression.getType();
        return type != null && !type.equalsToText("java.lang.String");
    }

    public static boolean isAssociativeOperation(PsiPolyadicExpression expression) {
        PsiPrimitiveType primitiveType;
        IElementType tokenType = expression.getOperationTokenType();
        PsiType type = expression.getType();
        if (type instanceof PsiClassType) {
            primitiveType = PsiPrimitiveType.getUnboxedType(type);
            if (primitiveType == null) {
                return false;
            }
        } else if (type instanceof PsiPrimitiveType) {
            primitiveType = (PsiPrimitiveType)type;
        } else {
            return false;
        }
        if (JavaTokenType.PLUS == tokenType || JavaTokenType.ASTERISK == tokenType) {
            return !PsiType.FLOAT.equals(primitiveType) && !PsiType.DOUBLE.equals(primitiveType);
        }
        if (JavaTokenType.EQEQ == tokenType || JavaTokenType.NE == tokenType) {
            return PsiType.BOOLEAN.equals(primitiveType);
        }
        if (JavaTokenType.AND == tokenType || JavaTokenType.OR == tokenType || JavaTokenType.XOR == tokenType) {
            return true;
        }
        return JavaTokenType.OROR == tokenType || JavaTokenType.ANDAND == tokenType;
    }

    public static int getPrecedence(PsiExpression expression) {
        if (expression instanceof PsiThisExpression || expression instanceof PsiLiteralExpression || expression instanceof PsiSuperExpression || expression instanceof PsiClassObjectAccessExpression || expression instanceof PsiArrayAccessExpression || expression instanceof PsiArrayInitializerExpression) {
            return 0;
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            if (referenceExpression.getQualifier() != null) {
                return 1;
            }
            return 0;
        }
        if (expression instanceof PsiMethodCallExpression || expression instanceof PsiNewExpression) {
            return 1;
        }
        if (expression instanceof PsiTypeCastExpression) {
            return 4;
        }
        if (expression instanceof PsiPrefixExpression) {
            return 3;
        }
        if (expression instanceof PsiPostfixExpression || expression instanceof PsiSwitchExpression) {
            return 2;
        }
        if (expression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            return PsiPrecedenceUtil.getPrecedenceForOperator(polyadicExpression.getOperationTokenType());
        }
        if (expression instanceof PsiInstanceOfExpression) {
            return 8;
        }
        if (expression instanceof PsiConditionalExpression) {
            return 15;
        }
        if (expression instanceof PsiAssignmentExpression) {
            return 16;
        }
        if (expression instanceof PsiParenthesizedExpression) {
            return 0;
        }
        if (expression instanceof PsiLambdaExpression) {
            return 17;
        }
        return -1;
    }

    public static int getPrecedenceForOperator(@NotNull IElementType operator) {
        Integer precedence;
        if (operator == null) {
            PsiPrecedenceUtil.$$$reportNull$$$0(1);
        }
        if ((precedence = s_binaryOperatorPrecedence.get(operator)) == null) {
            throw new IllegalArgumentException("unknown operator: " + operator);
        }
        return precedence;
    }

    public static boolean areParenthesesNeeded(PsiParenthesizedExpression expression, boolean ignoreClarifyingParentheses) {
        PsiElement parent = expression.getParent();
        if (!(parent instanceof PsiExpression)) {
            return false;
        }
        PsiExpression child = expression.getExpression();
        return child == null || PsiPrecedenceUtil.areParenthesesNeeded(child, (PsiExpression)parent, ignoreClarifyingParentheses);
    }

    public static boolean areParenthesesNeeded(PsiExpression expression, PsiExpression parentExpression, boolean ignoreClarifyingParentheses) {
        int childPrecedence;
        if (parentExpression instanceof PsiParenthesizedExpression || parentExpression instanceof PsiArrayInitializerExpression) {
            return false;
        }
        if (parentExpression instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)parentExpression;
            return PsiTreeUtil.isAncestor((PsiElement)arrayAccessExpression.getArrayExpression(), (PsiElement)expression, (boolean)false);
        }
        int parentPrecedence = PsiPrecedenceUtil.getPrecedence(parentExpression);
        if (parentPrecedence > (childPrecedence = PsiPrecedenceUtil.getPrecedence(expression))) {
            return ignoreClarifyingParentheses && (expression instanceof PsiPolyadicExpression ? parentExpression instanceof PsiPolyadicExpression || parentExpression instanceof PsiConditionalExpression || parentExpression instanceof PsiInstanceOfExpression : expression instanceof PsiInstanceOfExpression);
        }
        if (parentExpression instanceof PsiPolyadicExpression && expression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression parentPolyadicExpression = (PsiPolyadicExpression)parentExpression;
            PsiType parentType = parentPolyadicExpression.getType();
            if (parentType == null) {
                return true;
            }
            PsiPolyadicExpression childPolyadicExpression = (PsiPolyadicExpression)expression;
            PsiType childType = childPolyadicExpression.getType();
            if (!parentType.equals(childType)) {
                return true;
            }
            if (childType.equalsToText("java.lang.String") && !PsiTreeUtil.isAncestor((PsiElement)parentPolyadicExpression.getOperands()[0], (PsiElement)childPolyadicExpression, (boolean)true)) {
                PsiExpression[] operands = childPolyadicExpression.getOperands();
                return !childType.equals(operands[0].getType()) && !childType.equals(operands[1].getType());
            }
            if (childType.equals(PsiType.BOOLEAN)) {
                PsiExpression[] operands;
                for (PsiExpression operand : operands = childPolyadicExpression.getOperands()) {
                    PsiType operandType = operand.getType();
                    if (operandType == null || PsiType.BOOLEAN.equals(operandType)) continue;
                    return true;
                }
            }
            IElementType parentOperator = parentPolyadicExpression.getOperationTokenType();
            IElementType childOperator = childPolyadicExpression.getOperationTokenType();
            if (ignoreClarifyingParentheses && !childOperator.equals(parentOperator)) {
                return true;
            }
            PsiExpression[] parentOperands = parentPolyadicExpression.getOperands();
            if (!(PsiTreeUtil.isAncestor((PsiElement)parentOperands[0], (PsiElement)expression, (boolean)false) || PsiPrecedenceUtil.isAssociativeOperation(parentPolyadicExpression) && JavaTokenType.DIV != childOperator && JavaTokenType.PERC != childOperator)) {
                return true;
            }
        } else {
            if (parentExpression instanceof PsiConditionalExpression && expression instanceof PsiConditionalExpression) {
                PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)parentExpression;
                PsiExpression condition2 = conditionalExpression.getCondition();
                return PsiTreeUtil.isAncestor((PsiElement)condition2, (PsiElement)expression, (boolean)true);
            }
            if (expression instanceof PsiLambdaExpression) {
                if (parentExpression instanceof PsiTypeCastExpression) {
                    return false;
                }
                if (parentExpression instanceof PsiConditionalExpression) {
                    PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)parentExpression;
                    return PsiTreeUtil.isAncestor((PsiElement)conditionalExpression.getCondition(), (PsiElement)expression, (boolean)true);
                }
            }
        }
        return parentPrecedence < childPrecedence;
    }

    public static boolean areParenthesesNeeded(PsiJavaToken compoundAssignmentToken, PsiExpression rhs) {
        if (rhs instanceof PsiPolyadicExpression) {
            IElementType signTokenType;
            IElementType newOperatorToken;
            int precedence2;
            PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)rhs;
            int precedence1 = PsiPrecedenceUtil.getPrecedenceForOperator(binaryExpression.getOperationTokenType());
            return precedence1 >= (precedence2 = PsiPrecedenceUtil.getPrecedenceForOperator(newOperatorToken = TypeConversionUtil.convertEQtoOperation(signTokenType = compoundAssignmentToken.getTokenType()))) || !PsiPrecedenceUtil.isCommutativeOperator(newOperatorToken);
        }
        return rhs instanceof PsiConditionalExpression || rhs instanceof PsiAssignmentExpression || rhs instanceof PsiInstanceOfExpression;
    }

    static {
        s_binaryOperatorPrecedence.put(JavaTokenType.PLUS, 6);
        s_binaryOperatorPrecedence.put(JavaTokenType.MINUS, 6);
        s_binaryOperatorPrecedence.put(JavaTokenType.ASTERISK, 5);
        s_binaryOperatorPrecedence.put(JavaTokenType.DIV, 5);
        s_binaryOperatorPrecedence.put(JavaTokenType.PERC, 5);
        s_binaryOperatorPrecedence.put(JavaTokenType.ANDAND, 13);
        s_binaryOperatorPrecedence.put(JavaTokenType.OROR, 14);
        s_binaryOperatorPrecedence.put(JavaTokenType.AND, 10);
        s_binaryOperatorPrecedence.put(JavaTokenType.OR, 12);
        s_binaryOperatorPrecedence.put(JavaTokenType.XOR, 11);
        s_binaryOperatorPrecedence.put(JavaTokenType.LTLT, 7);
        s_binaryOperatorPrecedence.put(JavaTokenType.GTGT, 7);
        s_binaryOperatorPrecedence.put(JavaTokenType.GTGTGT, 7);
        s_binaryOperatorPrecedence.put(JavaTokenType.GT, 8);
        s_binaryOperatorPrecedence.put(JavaTokenType.GE, 8);
        s_binaryOperatorPrecedence.put(JavaTokenType.LT, 8);
        s_binaryOperatorPrecedence.put(JavaTokenType.LE, 8);
        s_binaryOperatorPrecedence.put(JavaTokenType.EQEQ, 9);
        s_binaryOperatorPrecedence.put(JavaTokenType.NE, 9);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/util/PsiPrecedenceUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isCommutativeOperator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPrecedenceForOperator";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

