/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Query;
import org.jetbrains.annotations.NotNull;

public final class FunctionalExpressionSearch
extends ExtensibleQueryFactory<PsiFunctionalExpression, SearchParameters> {
    private static final FunctionalExpressionSearch INSTANCE = new FunctionalExpressionSearch();

    @NotNull
    public static Query<PsiFunctionalExpression> search(@NotNull PsiClass aClass, @NotNull SearchScope scope) {
        if (aClass == null) {
            FunctionalExpressionSearch.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            FunctionalExpressionSearch.$$$reportNull$$$0(1);
        }
        SearchParameters parameters = (SearchParameters)ReadAction.compute(() -> new SearchParameters(aClass, scope));
        Query query = INSTANCE.createUniqueResultsQuery(parameters, element -> (SmartPsiElementPointer)ReadAction.compute(() -> SmartPointerManager.getInstance((Project)parameters.myProject).createSmartPsiElementPointer((PsiElement)element)));
        if (query == null) {
            FunctionalExpressionSearch.$$$reportNull$$$0(2);
        }
        return query;
    }

    @NotNull
    public static Query<PsiFunctionalExpression> search(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            FunctionalExpressionSearch.$$$reportNull$$$0(3);
        }
        return FunctionalExpressionSearch.search(psiMethod, (SearchScope)GlobalSearchScope.allScope((Project)PsiUtilCore.getProjectInReadAction((PsiElement)psiMethod)));
    }

    @NotNull
    public static Query<PsiFunctionalExpression> search(@NotNull PsiMethod psiMethod, @NotNull SearchScope scope) {
        if (psiMethod == null) {
            FunctionalExpressionSearch.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            FunctionalExpressionSearch.$$$reportNull$$$0(5);
        }
        Query query = (Query)ReadAction.compute(() -> {
            PsiClass containingClass;
            if (!psiMethod.hasModifierProperty("static") && !psiMethod.hasModifierProperty("default") && (containingClass = psiMethod.getContainingClass()) != null) {
                return INSTANCE.createUniqueResultsQuery(new SearchParameters(containingClass, scope));
            }
            return EmptyQuery.getEmptyQuery();
        });
        if (query == null) {
            FunctionalExpressionSearch.$$$reportNull$$$0(6);
        }
        return query;
    }

    @NotNull
    public static Query<PsiFunctionalExpression> search(@NotNull PsiClass aClass) {
        if (aClass == null) {
            FunctionalExpressionSearch.$$$reportNull$$$0(7);
        }
        return FunctionalExpressionSearch.search(aClass, (SearchScope)GlobalSearchScope.allScope((Project)PsiUtilCore.getProjectInReadAction((PsiElement)aClass)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/searches/FunctionalExpressionSearch";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/searches/FunctionalExpressionSearch";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "search";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "search";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SearchParameters {
        private final PsiClass myElementToSearch;
        private final SearchScope myScope;
        @NotNull
        private final Project myProject;

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope) {
            if (aClass == null) {
                SearchParameters.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                SearchParameters.$$$reportNull$$$0(1);
            }
            this.myProject = aClass.getProject();
            this.myElementToSearch = aClass;
            this.myScope = scope;
        }

        @NotNull
        public PsiClass getElementToSearch() {
            PsiClass psiClass = this.myElementToSearch;
            if (psiClass == null) {
                SearchParameters.$$$reportNull$$$0(2);
            }
            return psiClass;
        }

        @NotNull
        public SearchScope getEffectiveSearchScope() {
            SearchScope searchScope = this.myScope.intersectWith(PsiSearchHelper.getInstance((Project)this.myProject).getUseScope((PsiElement)this.myElementToSearch));
            if (searchScope == null) {
                SearchParameters.$$$reportNull$$$0(3);
            }
            return searchScope;
        }

        @NotNull
        public Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                SearchParameters.$$$reportNull$$$0(4);
            }
            return project;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/searches/FunctionalExpressionSearch$SearchParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/searches/FunctionalExpressionSearch$SearchParameters";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementToSearch";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEffectiveSearchScope";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

