/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.jvm.types.JvmPrimitiveType;
import com.intellij.lang.jvm.types.JvmPrimitiveTypeKind;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiPrimitiveType
extends PsiType.Stub
implements JvmPrimitiveType {
    private static final Map<String, PsiPrimitiveType> ourQNameToUnboxed = new HashMap<String, PsiPrimitiveType>();
    private final JvmPrimitiveTypeKind myKind;
    private final String myName;

    PsiPrimitiveType(@Nullable(value="for NULL type") @Nullable(value="for NULL type") JvmPrimitiveTypeKind kind) {
        super(PsiAnnotation.EMPTY_ARRAY);
        this.myKind = kind;
        if (kind != null) {
            ourQNameToUnboxed.put(kind.getBoxedFqn(), this);
        }
        this.myName = PsiPrimitiveType.getName(kind);
    }

    public PsiPrimitiveType(@Nullable(value="for NULL type") @Nullable(value="for NULL type") JvmPrimitiveTypeKind kind, PsiAnnotation @NotNull [] annotations) {
        if (annotations == null) {
            PsiPrimitiveType.$$$reportNull$$$0(0);
        }
        super(annotations);
        this.myKind = kind;
        this.myName = PsiPrimitiveType.getName(kind);
    }

    public PsiPrimitiveType(@Nullable(value="for NULL type") @Nullable(value="for NULL type") JvmPrimitiveTypeKind kind, @NotNull TypeAnnotationProvider provider) {
        if (provider == null) {
            PsiPrimitiveType.$$$reportNull$$$0(1);
        }
        super(provider);
        this.myKind = kind;
        this.myName = PsiPrimitiveType.getName(kind);
    }

    public PsiPrimitiveType(@NotNull String name, @NotNull TypeAnnotationProvider provider) {
        if (name == null) {
            PsiPrimitiveType.$$$reportNull$$$0(2);
        }
        if (provider == null) {
            PsiPrimitiveType.$$$reportNull$$$0(3);
        }
        super(provider);
        JvmPrimitiveTypeKind kind = JvmPrimitiveTypeKind.getKindByName(name);
        if (kind == null) {
            throw new NoSuchElementException("Cannot find primitive type: " + name);
        }
        this.myKind = kind;
        this.myName = name;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public PsiPrimitiveType(@NotNull String name, PsiAnnotation @NotNull [] annotations) {
        if (name == null) {
            PsiPrimitiveType.$$$reportNull$$$0(4);
        }
        if (annotations == null) {
            PsiPrimitiveType.$$$reportNull$$$0(5);
        }
        super(annotations);
        this.myKind = null;
        this.myName = name;
    }

    @NotNull
    @Contract(pure=true)
    private static String getName(@Nullable JvmPrimitiveTypeKind kind) {
        String string = kind == null ? "null" : kind.getName();
        if (string == null) {
            PsiPrimitiveType.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public JvmPrimitiveTypeKind getKind() {
        JvmPrimitiveTypeKind jvmPrimitiveTypeKind = Objects.requireNonNull(this.myKind, "getKind() called on PsiType.NULL\nIf your code works with JvmElement API then this should not happen unless some implementation improperly returns PsiType.NULL from JvmMethod.getReturnType() (or any other available methods).\nIf your code works with PsiType-s then you must check if this type is PsiType.NULL type before calling this method");
        if (jvmPrimitiveTypeKind == null) {
            PsiPrimitiveType.$$$reportNull$$$0(7);
        }
        return jvmPrimitiveTypeKind;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            PsiPrimitiveType.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public PsiPrimitiveType annotate(@NotNull TypeAnnotationProvider provider) {
        if (provider == null) {
            PsiPrimitiveType.$$$reportNull$$$0(9);
        }
        PsiPrimitiveType psiPrimitiveType = (PsiPrimitiveType)super.annotate(provider);
        if (psiPrimitiveType == null) {
            PsiPrimitiveType.$$$reportNull$$$0(10);
        }
        return psiPrimitiveType;
    }

    @Override
    @NotNull
    public String getPresentableText(boolean annotated) {
        String string = this.getText(false, annotated);
        if (string == null) {
            PsiPrimitiveType.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string = this.getText(true, annotated);
        if (string == null) {
            PsiPrimitiveType.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string = this.getCanonicalText(true);
        if (string == null) {
            PsiPrimitiveType.$$$reportNull$$$0(13);
        }
        return string;
    }

    private String getText(boolean qualified, boolean annotated) {
        PsiAnnotation[] annotations;
        PsiAnnotation[] psiAnnotationArray = annotations = annotated ? this.getAnnotations() : PsiAnnotation.EMPTY_ARRAY;
        if (annotations.length == 0) {
            return this.myName;
        }
        StringBuilder sb = new StringBuilder();
        PsiNameHelper.appendAnnotations(sb, annotations, qualified);
        sb.append(this.myName);
        return sb.toString();
    }

    @Override
    public boolean isValid() {
        for (PsiAnnotation annotation : this.getAnnotations()) {
            if (annotation.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsToText(@NotNull String text) {
        if (text == null) {
            PsiPrimitiveType.$$$reportNull$$$0(14);
        }
        return this.myName.equals(text);
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor) {
        if (visitor == null) {
            PsiPrimitiveType.$$$reportNull$$$0(15);
        }
        return visitor.visitPrimitiveType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return null;
    }

    @Override
    public PsiType @NotNull [] getSuperTypes() {
        if (EMPTY_ARRAY == null) {
            PsiPrimitiveType.$$$reportNull$$$0(16);
        }
        return EMPTY_ARRAY;
    }

    @Nullable
    public static PsiPrimitiveType getUnboxedType(PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        PsiUtil.ensureValidType(type);
        LanguageLevel languageLevel = ((PsiClassType)type).getLanguageLevel();
        if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
            return null;
        }
        PsiClass psiClass = ((PsiClassType)type).resolve();
        if (psiClass == null) {
            return null;
        }
        PsiPrimitiveType unboxed = ourQNameToUnboxed.get(psiClass.getQualifiedName());
        if (unboxed == null) {
            return null;
        }
        return unboxed.annotate(type.getAnnotationProvider());
    }

    @Nullable
    public static PsiPrimitiveType getOptionallyUnboxedType(PsiType type) {
        return type instanceof PsiPrimitiveType ? (PsiPrimitiveType)type : PsiPrimitiveType.getUnboxedType(type);
    }

    @Contract(pure=true)
    @Nullable
    public static PsiPrimitiveType fromJvmTypeDescriptor(char descriptor) {
        switch (descriptor) {
            case 'B': {
                return PsiType.BYTE;
            }
            case 'C': {
                return PsiType.CHAR;
            }
            case 'D': {
                return PsiType.DOUBLE;
            }
            case 'F': {
                return PsiType.FLOAT;
            }
            case 'Z': {
                return PsiType.BOOLEAN;
            }
            case 'I': {
                return PsiType.INT;
            }
            case 'J': {
                return PsiType.LONG;
            }
            case 'S': {
                return PsiType.SHORT;
            }
        }
        return null;
    }

    @Nullable
    public String getBoxedTypeName() {
        return this.myKind == null ? null : this.myKind.getBoxedFqn();
    }

    @Nullable
    public PsiClassType getBoxedType(@NotNull PsiElement context) {
        PsiFile file;
        if (context == null) {
            PsiPrimitiveType.$$$reportNull$$$0(17);
        }
        if ((file = context.getContainingFile()) == null) {
            return null;
        }
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)file);
        if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
            return null;
        }
        String boxedQName = this.getBoxedTypeName();
        if (boxedQName == null) {
            return null;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance(file.getProject());
        PsiClass aClass = facade.findClass(boxedQName, file.getResolveScope());
        if (aClass == null) {
            return null;
        }
        PsiElementFactory factory = facade.getElementFactory();
        return factory.createType(aClass, PsiSubstitutor.EMPTY, languageLevel).annotate(this.getAnnotationProvider());
    }

    @Nullable
    public PsiClassType getBoxedType(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        String boxedQName;
        if (manager == null) {
            PsiPrimitiveType.$$$reportNull$$$0(18);
        }
        if (resolveScope == null) {
            PsiPrimitiveType.$$$reportNull$$$0(19);
        }
        if ((boxedQName = this.getBoxedTypeName()) == null) {
            return null;
        }
        PsiClass aClass = JavaPsiFacade.getInstance(manager.getProject()).findClass(boxedQName, resolveScope);
        if (aClass == null) {
            return null;
        }
        return JavaPsiFacade.getElementFactory(manager.getProject()).createType(aClass);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static Collection<String> getAllBoxedTypeNames() {
        return JvmPrimitiveTypeKind.getBoxedFqns();
    }

    public int hashCode() {
        return this.myKind == null ? 0 : this.myKind.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof PsiPrimitiveType && this.myKind == ((PsiPrimitiveType)obj).myKind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/PsiPrimitiveType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/PsiPrimitiveType";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "annotate";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalCanonicalText";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "equalsToText";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getBoxedType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

