/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.NativeLibraryOrderRootType;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.jrt.JrtFileSystem;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.PathsList;
import com.intellij.util.text.VersionComparatorUtil;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaParameters
extends SimpleJavaParameters {
    private static final Logger LOG = Logger.getInstance(JavaParameters.class);
    private static final String JAVA_LIBRARY_PATH_PROPERTY = "java.library.path";
    public static final String JAVA_ENABLE_PREVIEW_PROPERTY = "--enable-preview";
    public static final DataKey<JavaParameters> JAVA_PARAMETERS = DataKey.create((String)"javaParameters");
    public static final int JDK_ONLY = 1;
    public static final int CLASSES_ONLY = 2;
    public static final int TESTS_ONLY = 4;
    public static final int INCLUDE_PROVIDED = 8;
    public static final int JDK_AND_CLASSES = 3;
    public static final int JDK_AND_CLASSES_AND_TESTS = 7;
    public static final int CLASSES_AND_TESTS = 6;
    public static final int JDK_AND_CLASSES_AND_PROVIDED = 11;

    public String getJdkPath() throws CantRunException {
        Sdk jdk = this.getJdk();
        if (jdk == null) {
            throw new CantRunException(ExecutionBundle.message((String)"no.jdk.specified..error.message", (Object[])new Object[0]));
        }
        VirtualFile jdkHome = jdk.getHomeDirectory();
        if (jdkHome == null) {
            throw new CantRunException(ExecutionBundle.message((String)"home.directory.not.specified.for.jdk.error.message", (Object[])new Object[0]));
        }
        return jdkHome.getPresentableUrl();
    }

    public void configureByModule(Module module, int classPathType, Sdk jdk) throws CantRunException {
        if ((classPathType & 1) != 0) {
            if (jdk == null) {
                throw CantRunException.noJdkConfigured();
            }
            this.setJdk(jdk);
        }
        if ((classPathType & 2) == 0) {
            return;
        }
        this.setDefaultCharset(module.getProject());
        JavaParameters.configureEnumerator(OrderEnumerator.orderEntries((Module)module).recursively(), classPathType, jdk).collectPaths(this.getClassPath());
        this.configureJavaLibraryPath(OrderEnumerator.orderEntries((Module)module).recursively());
        this.configureJavaEnablePreviewProperty(OrderEnumerator.orderEntries((Module)module).recursively(), jdk);
    }

    private void configureJavaEnablePreviewProperty(OrderEnumerator orderEnumerator, Sdk jdk) {
        ParametersList vmParameters = this.getVMParametersList();
        if (vmParameters.hasParameter(JAVA_ENABLE_PREVIEW_PROPERTY) || !JavaSdkVersionUtil.isAtLeast(jdk, JavaSdkVersion.JDK_11)) {
            return;
        }
        orderEnumerator.forEachModule(module -> {
            LanguageLevel languageLevel = LanguageLevelUtil.getEffectiveLanguageLevel(module);
            if (languageLevel.isPreview()) {
                vmParameters.add(JAVA_ENABLE_PREVIEW_PROPERTY);
                return false;
            }
            return true;
        });
    }

    private void configureJavaLibraryPath(OrderEnumerator enumerator) {
        PathsList pathsList = new PathsList();
        enumerator.runtimeOnly().withoutSdk().roots(NativeLibraryOrderRootType.getInstance()).collectPaths(pathsList);
        if (!pathsList.getPathList().isEmpty()) {
            ParametersList vmParameters = this.getVMParametersList();
            if (vmParameters.hasProperty(JAVA_LIBRARY_PATH_PROPERTY)) {
                LOG.info("java.library.path property is already specified, native library paths from dependencies (" + pathsList.getPathsString() + ") won't be added");
            } else {
                vmParameters.addProperty(JAVA_LIBRARY_PATH_PROPERTY, pathsList.getPathsString());
            }
        }
    }

    public void setDefaultCharset(Project project) {
        Charset encoding = EncodingProjectManager.getInstance((Project)project).getDefaultCharset();
        this.setCharset(encoding);
    }

    public void configureByModule(Module module, int classPathType) throws CantRunException {
        this.configureByModule(module, classPathType, JavaParameters.getValidJdkToRunModule(module, (classPathType & 4) == 0));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static Sdk getModuleJdk(Module module) throws CantRunException {
        return JavaParameters.getValidJdkToRunModule(module, false);
    }

    @NotNull
    public static Sdk getValidJdkToRunModule(Module module, boolean productionOnly) throws CantRunException {
        Sdk jdk = JavaParameters.getJdkToRunModule(module, productionOnly);
        if (jdk == null) {
            throw CantRunException.noJdkForModule((Module)module);
        }
        VirtualFile homeDirectory = jdk.getHomeDirectory();
        if (homeDirectory == null || !homeDirectory.isValid()) {
            throw CantRunException.jdkMisconfigured((Sdk)jdk);
        }
        Sdk sdk = jdk;
        if (sdk == null) {
            JavaParameters.$$$reportNull$$$0(0);
        }
        return sdk;
    }

    @Nullable
    public static Sdk getJdkToRunModule(Module module, boolean productionOnly) {
        Sdk moduleSdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (moduleSdk == null) {
            return null;
        }
        LinkedHashSet sdksFromDependencies = new LinkedHashSet();
        OrderEnumerator enumerator = OrderEnumerator.orderEntries((Module)module).runtimeOnly().recursively();
        if (productionOnly) {
            enumerator = enumerator.productionOnly();
        }
        enumerator.forEachModule(module1 -> {
            Sdk sdk = ModuleRootManager.getInstance((Module)module1).getSdk();
            if (sdk != null && sdk.getSdkType().equals(moduleSdk.getSdkType())) {
                sdksFromDependencies.add(sdk);
            }
            return true;
        });
        return JavaParameters.findLatestVersion(moduleSdk, sdksFromDependencies);
    }

    @NotNull
    private static Sdk findLatestVersion(@NotNull Sdk mainSdk, @NotNull Set<? extends Sdk> sdks) {
        if (mainSdk == null) {
            JavaParameters.$$$reportNull$$$0(1);
        }
        if (sdks == null) {
            JavaParameters.$$$reportNull$$$0(2);
        }
        Sdk result = mainSdk;
        for (Sdk sdk : sdks) {
            if (VersionComparatorUtil.compare((String)result.getVersionString(), (String)sdk.getVersionString()) >= 0) continue;
            result = sdk;
        }
        Sdk sdk = result;
        if (sdk == null) {
            JavaParameters.$$$reportNull$$$0(3);
        }
        return sdk;
    }

    public void configureByProject(Project project, int classPathType, Sdk jdk) throws CantRunException {
        if ((classPathType & 1) != 0) {
            if (jdk == null) {
                throw CantRunException.noJdkConfigured();
            }
            this.setJdk(jdk);
        }
        if ((classPathType & 2) == 0) {
            return;
        }
        this.setDefaultCharset(project);
        JavaParameters.configureEnumerator(OrderEnumerator.orderEntries((Project)project).runtimeOnly(), classPathType, jdk).collectPaths(this.getClassPath());
        this.configureJavaLibraryPath(OrderEnumerator.orderEntries((Project)project));
        this.configureJavaEnablePreviewProperty(OrderEnumerator.orderEntries((Project)project), jdk);
    }

    private static OrderRootsEnumerator configureEnumerator(OrderEnumerator enumerator, int classPathType, Sdk jdk) {
        if ((classPathType & 8) == 0) {
            enumerator = enumerator.runtimeOnly();
        }
        if ((classPathType & 1) == 0) {
            enumerator = enumerator.withoutSdk();
        }
        if ((classPathType & 4) == 0) {
            enumerator = enumerator.productionOnly();
        }
        OrderRootsEnumerator rootsEnumerator = enumerator.classes();
        if ((classPathType & 1) != 0) {
            rootsEnumerator = rootsEnumerator.usingCustomRootProvider(e -> e instanceof JdkOrderEntry ? JavaParameters.jdkRoots(jdk) : e.getFiles(OrderRootType.CLASSES));
        }
        return rootsEnumerator;
    }

    private static VirtualFile[] jdkRoots(Sdk jdk) {
        return (VirtualFile[])Arrays.stream(jdk.getRootProvider().getFiles(OrderRootType.CLASSES)).filter(f -> !JrtFileSystem.isModuleRoot(f)).toArray(VirtualFile[]::new);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/JavaParameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainSdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidJdkToRunModule";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/JavaParameters";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findLatestVersion";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findLatestVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

