/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.Language;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.AnnotationAttributeRequest;
import com.intellij.lang.jvm.actions.AnnotationRequestsKt;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MemberRequestsKt;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastVisibility;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003\u001a\u0010\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0005\u00a8\u0006\u0006"}, d2={"createMakePublicActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lorg/jetbrains/uast/UField;", "createMakeStaticActions", "Lorg/jetbrains/uast/UMethod;", "intellij.jvm.analysis"})
public final class AnalysisUastUtilKt {
    @NotNull
    public static final List<IntentionAction> createMakePublicActions(@NotNull UField $this$createMakePublicActions) {
        Intrinsics.checkNotNullParameter((Object)$this$createMakePublicActions, (String)"$this$createMakePublicActions");
        PsiElement jPsi = $this$createMakePublicActions.getJavaPsi();
        boolean isPublic = $this$createMakePublicActions.getVisibility() == UastVisibility.PUBLIC;
        SmartList actions = new SmartList();
        if (!isPublic) {
            actions.addAll((Collection)JvmElementActionFactories.createModifierActions($this$createMakePublicActions, MemberRequestsKt.modifierRequest(JvmModifier.PUBLIC, true)));
        }
        PsiElement psiElement = $this$createMakePublicActions.getSourcePsi();
        if (Intrinsics.areEqual((Object)(psiElement != null ? psiElement.getLanguage() : null), (Object)Language.findLanguageByID((String)"kotlin")) && jPsi instanceof JvmModifiersOwner && !((JvmModifiersOwner)jPsi).hasAnnotation("kotlin.jvm.JvmField")) {
            actions.addAll((Collection)JvmElementActionFactories.createAddAnnotationActions((JvmModifiersOwner)jPsi, AnnotationRequestsKt.annotationRequest("kotlin.jvm.JvmField", new AnnotationAttributeRequest[0])));
        }
        return (List)actions;
    }

    @NotNull
    public static final List<IntentionAction> createMakeStaticActions(@NotNull UMethod $this$createMakeStaticActions) {
        Intrinsics.checkNotNullParameter((Object)$this$createMakeStaticActions, (String)"$this$createMakeStaticActions");
        PsiMethod jPsi = $this$createMakeStaticActions.getJavaPsi();
        boolean isStatic = $this$createMakeStaticActions.isStatic();
        SmartList actions = new SmartList();
        if (!isStatic) {
            actions.addAll((Collection)JvmElementActionFactories.createModifierActions($this$createMakeStaticActions, MemberRequestsKt.modifierRequest(JvmModifier.STATIC, true)));
        }
        PsiClass containingClass = jPsi.getContainingClass();
        PsiElement psiElement = $this$createMakeStaticActions.getSourcePsi();
        if (Intrinsics.areEqual((Object)(psiElement != null ? psiElement.getLanguage() : null), (Object)Language.findLanguageByID((String)"kotlin")) && !jPsi.hasAnnotation("kotlin.jvm.JvmStatic")) {
            PsiClass psiClass = containingClass;
            if (Intrinsics.areEqual((Object)"Companion", (Object)(psiClass != null ? psiClass.getName() : null))) {
                actions.addAll((Collection)JvmElementActionFactories.createAddAnnotationActions(jPsi, AnnotationRequestsKt.annotationRequest("kotlin.jvm.JvmStatic", new AnnotationAttributeRequest[0])));
            }
        }
        return (List)actions;
    }
}

