/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NullableNotNullManager {
    protected static final Logger LOG = Logger.getInstance(NullableNotNullManager.class);
    protected final Project myProject;

    protected NullableNotNullManager(Project project) {
        this.myProject = project;
    }

    @NotNull
    abstract List<String> getDefaultNullables();

    @NotNull
    abstract List<String> getDefaultNotNulls();

    @NotNull
    public abstract Optional<Nullability> getAnnotationNullability(String var1);

    public abstract boolean isTypeUseAnnotationLocationRestricted(String var1);

    public abstract boolean canAnnotateLocals(String var1);

    public static NullableNotNullManager getInstance(Project project) {
        return (NullableNotNullManager)project.getService(NullableNotNullManager.class);
    }

    public abstract void setNotNulls(String ... var1);

    public abstract void setNullables(String ... var1);

    @NotNull
    public abstract String getDefaultNullable();

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Nullable
    public PsiAnnotation getNullableAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        NullabilityAnnotationInfo info;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(0);
        }
        if ((info = this.findEffectiveNullabilityInfo(owner)) == null || info.getNullability() != Nullability.NULLABLE) {
            return null;
        }
        if (!checkBases && info.getInheritedFrom() != null) {
            return null;
        }
        return info.getAnnotation();
    }

    public abstract void setDefaultNullable(@NotNull String var1);

    @NotNull
    public abstract String getDefaultNotNull();

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Nullable
    public PsiAnnotation getNotNullAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        NullabilityAnnotationInfo info;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(1);
        }
        if ((info = this.findEffectiveNullabilityInfo(owner)) == null || info.getNullability() != Nullability.NOT_NULL) {
            return null;
        }
        if (!checkBases && info.getInheritedFrom() != null) {
            return null;
        }
        return info.getAnnotation();
    }

    @Nullable
    public PsiAnnotation copyNotNullAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        NullabilityAnnotationInfo info;
        if (original == null) {
            NullableNotNullManager.$$$reportNull$$$0(2);
        }
        if (generated == null) {
            NullableNotNullManager.$$$reportNull$$$0(3);
        }
        if ((info = this.findOwnNullabilityInfo(original)) == null || info.getNullability() != Nullability.NOT_NULL) {
            return null;
        }
        return NullableNotNullManager.copyAnnotation(info.getAnnotation(), generated);
    }

    @Nullable
    public PsiAnnotation copyNullableAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        NullabilityAnnotationInfo info;
        if (original == null) {
            NullableNotNullManager.$$$reportNull$$$0(4);
        }
        if (generated == null) {
            NullableNotNullManager.$$$reportNull$$$0(5);
        }
        if ((info = this.findOwnNullabilityInfo(original)) == null || info.getNullability() != Nullability.NULLABLE) {
            return null;
        }
        return NullableNotNullManager.copyAnnotation(info.getAnnotation(), generated);
    }

    @Nullable
    public PsiAnnotation copyNullableOrNotNullAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        NullabilityAnnotationInfo src;
        if (original == null) {
            NullableNotNullManager.$$$reportNull$$$0(6);
        }
        if (generated == null) {
            NullableNotNullManager.$$$reportNull$$$0(7);
        }
        if ((src = this.findOwnNullabilityInfo(original)) == null) {
            return null;
        }
        NullabilityAnnotationInfo effective = this.findEffectiveNullabilityInfo(generated);
        if (effective != null && effective.getNullability() == src.getNullability()) {
            return null;
        }
        return NullableNotNullManager.copyAnnotation(src.getAnnotation(), generated);
    }

    @Nullable
    private static PsiAnnotation copyAnnotation(@NotNull PsiAnnotation annotation, @NotNull PsiModifierListOwner target) {
        String qualifiedName;
        if (annotation == null) {
            NullableNotNullManager.$$$reportNull$$$0(8);
        }
        if (target == null) {
            NullableNotNullManager.$$$reportNull$$$0(9);
        }
        if ((qualifiedName = annotation.getQualifiedName()) != null) {
            if (JavaPsiFacade.getInstance(annotation.getProject()).findClass(qualifiedName, target.getResolveScope()) == null) {
                return null;
            }
            PsiModifierList modifierList = target.getModifierList();
            if (modifierList != null && !AnnotationTargetUtil.isStrictlyTypeUseAnnotation(modifierList, annotation) && !modifierList.hasAnnotation(qualifiedName)) {
                return modifierList.addAnnotation(qualifiedName);
            }
        }
        return null;
    }

    public abstract void setDefaultNotNull(@NotNull String var1);

    @Nullable
    public NullabilityAnnotationInfo findOwnNullabilityInfo(@NotNull PsiModifierListOwner owner) {
        NullabilityAnnotationInfo info;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(10);
        }
        if ((info = this.findEffectiveNullabilityInfo(owner)) == null || info.isContainer() || info.getInheritedFrom() != null) {
            return null;
        }
        return info;
    }

    @Nullable
    public NullabilityAnnotationInfo findExplicitNullability(PsiModifierListOwner owner) {
        NullabilityAnnotationInfo result = this.findPlainAnnotation(owner, false, true, this.getAllNullabilityAnnotationsWithNickNames());
        if (result != null) {
            return result;
        }
        return this.findNullityDefaultInHierarchy(owner);
    }

    @Nullable
    public NullabilityAnnotationInfo findEffectiveNullabilityInfo(@NotNull PsiModifierListOwner owner) {
        PsiType type;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(11);
        }
        if ((type = NullableNotNullManager.getOwnerType(owner)) == null || TypeConversionUtil.isPrimitiveAndNotNull(type)) {
            return null;
        }
        return (NullabilityAnnotationInfo)CachedValuesManager.getCachedValue((PsiElement)owner, () -> CachedValueProvider.Result.create((Object)this.doFindEffectiveNullabilityAnnotation(owner), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private NullabilityAnnotationInfo doFindEffectiveNullabilityAnnotation(@NotNull PsiModifierListOwner owner) {
        List<PsiParameter> superParameters;
        NullabilityAnnotationInfo defaultInfo;
        boolean lambdaParameter;
        NullabilityAnnotationInfo result;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(12);
        }
        if ((result = this.findPlainAnnotation(owner, true, false, this.getAllNullabilityAnnotationsWithNickNames())) != null) {
            return result;
        }
        boolean bl = lambdaParameter = owner instanceof PsiParameter && owner.getParent() instanceof PsiParameterList && owner.getParent().getParent() instanceof PsiLambdaExpression;
        if (!lambdaParameter && (defaultInfo = this.findNullityDefaultFiltered(owner)) != null) {
            return defaultInfo;
        }
        if (owner instanceof PsiParameter && !(superParameters = AnnotationUtil.getSuperAnnotationOwners((PsiParameter)owner)).isEmpty()) {
            for (PsiParameter parameter : superParameters) {
                NullabilityAnnotationInfo plain = this.findPlainAnnotation(parameter, false, false, this.getAllNullabilityAnnotationsWithNickNames());
                if (plain != null) {
                    return null;
                }
                NullabilityAnnotationInfo defaultInfo2 = this.findNullityDefaultInHierarchy(parameter);
                if (defaultInfo2 == null) continue;
                return defaultInfo2.getNullability() == Nullability.NOT_NULL ? defaultInfo2.withInheritedFrom(parameter) : null;
            }
            return null;
        }
        if (lambdaParameter) {
            return this.findNullityDefaultFiltered(owner);
        }
        return null;
    }

    @Nullable
    private NullabilityAnnotationInfo findNullityDefaultFiltered(@NotNull PsiModifierListOwner owner) {
        NullabilityAnnotationInfo defaultInfo;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(13);
        }
        if (!((defaultInfo = this.findNullityDefaultInHierarchy(owner)) == null || defaultInfo.getNullability() != Nullability.NULLABLE && this.hasHardcodedContracts(owner))) {
            return defaultInfo;
        }
        return null;
    }

    @Nullable
    public PsiAnnotation findExplicitNullabilityAnnotation(@NotNull PsiModifierListOwner owner, @NotNull Collection<Nullability> nullabilities) {
        NullabilityAnnotationDataHolder holder;
        Set filteredSet;
        NullabilityAnnotationDataHolder filtered;
        NullabilityAnnotationInfo result;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(14);
        }
        if (nullabilities == null) {
            NullableNotNullManager.$$$reportNull$$$0(15);
        }
        return (result = this.findPlainAnnotation(owner, false, false, filtered = new NullabilityAnnotationDataHolder(filteredSet = (holder = this.getAllNullabilityAnnotationsWithNickNames()).qualifiedNames().stream().filter(qName -> nullabilities.contains((Object)holder.getNullability((String)qName))).collect(Collectors.toSet()), holder, nullabilities){
            final /* synthetic */ Set val$filteredSet;
            final /* synthetic */ NullabilityAnnotationDataHolder val$holder;
            final /* synthetic */ Collection val$nullabilities;
            {
                this.val$filteredSet = set;
                this.val$holder = nullabilityAnnotationDataHolder;
                this.val$nullabilities = collection;
            }

            @Override
            public Set<String> qualifiedNames() {
                return this.val$filteredSet;
            }

            @Override
            @Nullable
            public Nullability getNullability(String annotation) {
                Nullability origNullability = this.val$holder.getNullability(annotation);
                return this.val$nullabilities.contains((Object)origNullability) ? origNullability : null;
            }
        })) == null ? null : result.getAnnotation();
    }

    @Nullable
    private NullabilityAnnotationInfo findPlainAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases, boolean skipExternal, NullabilityAnnotationDataHolder annotations) {
        PsiAnnotation annotation;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(16);
        }
        AnnotationUtil.AnnotationAndOwner memberAnno = checkBases && owner instanceof PsiMethod ? AnnotationUtil.findAnnotationAndOwnerInHierarchy(owner, annotations.qualifiedNames(), skipExternal) : ((annotation = AnnotationUtil.findAnnotation(owner, annotations.qualifiedNames(), skipExternal)) == null ? null : new AnnotationUtil.AnnotationAndOwner(owner, annotation));
        PsiType type = NullableNotNullManager.getOwnerType(owner);
        if (memberAnno != null && type instanceof PsiArrayType && !AnnotationUtil.isInferredAnnotation(memberAnno.annotation) && !AnnotationUtil.isExternalAnnotation(memberAnno.annotation) && AnnotationTargetUtil.isTypeAnnotation(memberAnno.annotation)) {
            memberAnno = null;
        }
        if (memberAnno != null) {
            Nullability nullability = annotations.getNullability(memberAnno.annotation.getQualifiedName());
            if (nullability == null) {
                return null;
            }
            if (type != null) {
                for (PsiAnnotation typeAnno : type.getApplicableAnnotations()) {
                    Nullability typeNullability;
                    if (typeAnno == memberAnno.annotation || (typeNullability = annotations.getNullability(typeAnno.getQualifiedName())) == null) continue;
                    if (typeNullability != nullability) {
                        return null;
                    }
                    memberAnno = new AnnotationUtil.AnnotationAndOwner(owner, typeAnno);
                    break;
                }
            }
            return new NullabilityAnnotationInfo(memberAnno.annotation, nullability, memberAnno.owner == owner ? null : memberAnno.owner, false);
        }
        if (type instanceof PsiPrimitiveType) {
            return null;
        }
        return this.findAnnotationInTypeHierarchy(type, annotations);
    }

    private static boolean areDifferentNullityAnnotations(@NotNull PsiAnnotation memberAnno, @NotNull PsiAnnotation typeAnno) {
        if (memberAnno == null) {
            NullableNotNullManager.$$$reportNull$$$0(17);
        }
        if (typeAnno == null) {
            NullableNotNullManager.$$$reportNull$$$0(18);
        }
        NullableNotNullManager manager = NullableNotNullManager.getInstance(memberAnno.getProject());
        List<String> notNulls = manager.getNotNullsWithNickNames();
        List<String> nullables = manager.getNullablesWithNickNames();
        return nullables.contains(typeAnno.getQualifiedName()) && notNulls.contains(memberAnno.getQualifiedName()) || nullables.contains(memberAnno.getQualifiedName()) && notNulls.contains(typeAnno.getQualifiedName());
    }

    @NotNull
    protected List<String> getNullablesWithNickNames() {
        List<String> list = this.getNullables();
        if (list == null) {
            NullableNotNullManager.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    protected List<String> getNotNullsWithNickNames() {
        List<String> list = this.getNotNulls();
        if (list == null) {
            NullableNotNullManager.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    protected abstract NullabilityAnnotationDataHolder getAllNullabilityAnnotationsWithNickNames();

    protected boolean hasHardcodedContracts(@NotNull PsiElement element) {
        if (element == null) {
            NullableNotNullManager.$$$reportNull$$$0(21);
        }
        return false;
    }

    @Nullable
    private static PsiType getOwnerType(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(22);
        }
        if (owner instanceof PsiVariable) {
            return ((PsiVariable)owner).getType();
        }
        if (owner instanceof PsiMethod) {
            return ((PsiMethod)owner).getReturnType();
        }
        return null;
    }

    public boolean isNullable(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        NullabilityAnnotationInfo info;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(23);
        }
        return (info = this.findEffectiveNullabilityInfo(owner)) != null && info.getNullability() == Nullability.NULLABLE && (checkBases || info.getInheritedFrom() == null);
    }

    public boolean isNotNull(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        NullabilityAnnotationInfo info;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(24);
        }
        return (info = this.findEffectiveNullabilityInfo(owner)) != null && info.getNullability() == Nullability.NOT_NULL && (checkBases || info.getInheritedFrom() == null);
    }

    @Nullable
    public NullabilityAnnotationInfo findDefaultTypeUseNullability(@Nullable PsiElement context) {
        if (context == null) {
            return null;
        }
        if (context.getParent() instanceof PsiTypeElement && context.getParent().getParent() instanceof PsiLocalVariable) {
            return null;
        }
        return this.findNullabilityDefault(context, PsiAnnotation.TargetType.TYPE_USE);
    }

    @Nullable
    NullabilityAnnotationInfo findNullityDefaultInHierarchy(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(25);
        }
        return this.findNullabilityDefault(owner, AnnotationTargetUtil.getTargetsForLocation(owner.getModifierList()));
    }

    @Nullable
    private NullabilityAnnotationInfo findNullabilityDefault(@NotNull PsiElement place, PsiAnnotation.TargetType ... placeTargetTypes) {
        if (place == null) {
            NullableNotNullManager.$$$reportNull$$$0(26);
        }
        if (placeTargetTypes == null) {
            NullableNotNullManager.$$$reportNull$$$0(27);
        }
        for (PsiElement element = place.getContext(); element != null; element = element.getContext()) {
            NullabilityAnnotationInfo result;
            if (element instanceof PsiModifierListOwner && (result = this.getNullityDefault((PsiModifierListOwner)element, placeTargetTypes, place, false)) != null) {
                return result;
            }
            if (!(element instanceof PsiClassOwner)) continue;
            String packageName = ((PsiClassOwner)element).getPackageName();
            return this.findNullityDefaultOnPackage(placeTargetTypes, JavaPsiFacade.getInstance(element.getProject()).findPackage(packageName), place);
        }
        return null;
    }

    @Nullable
    private NullabilityAnnotationInfo findNullityDefaultOnPackage(PsiAnnotation.TargetType @NotNull [] placeTargetTypes, @Nullable PsiPackage psiPackage, PsiElement context) {
        if (placeTargetTypes == null) {
            NullableNotNullManager.$$$reportNull$$$0(28);
        }
        boolean superPackage = false;
        while (psiPackage != null) {
            NullabilityAnnotationInfo onPkg = this.getNullityDefault(psiPackage, placeTargetTypes, context, superPackage);
            if (onPkg != null) {
                return onPkg;
            }
            superPackage = true;
            psiPackage = psiPackage.getParentPackage();
        }
        return null;
    }

    @Nullable
    abstract NullabilityAnnotationInfo getNullityDefault(@NotNull PsiModifierListOwner var1, PsiAnnotation.TargetType @NotNull [] var2, @NotNull PsiElement var3, boolean var4);

    @NotNull
    public abstract List<String> getNullables();

    @NotNull
    public abstract List<String> getNotNulls();

    public static boolean isNullable(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(29);
        }
        return NullableNotNullManager.getNullability(owner) == Nullability.NULLABLE;
    }

    public static boolean isNotNull(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(30);
        }
        return NullableNotNullManager.getNullability(owner) == Nullability.NOT_NULL;
    }

    @NotNull
    public static Nullability getNullability(@NotNull PsiModifierListOwner owner) {
        NullabilityAnnotationInfo info;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(31);
        }
        Nullability nullability = (info = NullableNotNullManager.getInstance(owner.getProject()).findEffectiveNullabilityInfo(owner)) == null ? Nullability.UNKNOWN : info.getNullability();
        if (nullability == null) {
            NullableNotNullManager.$$$reportNull$$$0(32);
        }
        return nullability;
    }

    @NotNull
    public abstract List<String> getInstrumentedNotNulls();

    public abstract void setInstrumentedNotNulls(@NotNull List<String> var1);

    public static boolean isNullabilityAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            NullableNotNullManager.$$$reportNull$$$0(33);
        }
        return NullableNotNullManager.getInstance(annotation.getProject()).getAllNullabilityAnnotationsWithNickNames().getNullability(annotation.getQualifiedName()) != null;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    private NullabilityAnnotationInfo findAnnotationInTypeHierarchy(@Nullable PsiType type, @NotNull NullabilityAnnotationDataHolder qualifiedNames) {
        if (qualifiedNames == null) {
            NullableNotNullManager.$$$reportNull$$$0(34);
        }
        if (type == null) {
            return null;
        }
        Ref result = Ref.create(null);
        InheritanceUtil.processSuperTypes(type, true, (Processor<? super PsiType>)((Processor)eachType -> {
            NullabilityAnnotationInfo info;
            for (PsiAnnotation annotation : eachType.getAnnotations()) {
                String qualifiedName = annotation.getQualifiedName();
                if (!qualifiedNames.qualifiedNames().contains(qualifiedName)) continue;
                Nullability nullability = qualifiedNames.getNullability(qualifiedName);
                if (nullability != null) {
                    result.set((Object)new NullabilityAnnotationInfo(annotation, nullability, false));
                }
                return false;
            }
            if (!(eachType instanceof PsiClassType)) {
                return true;
            }
            PsiClass targetClass = PsiUtil.resolveClassInClassTypeOnly(eachType);
            if (!(targetClass instanceof PsiTypeParameter)) {
                return false;
            }
            if (targetClass.getExtendsListTypes().length == 0 && (info = this.findNullabilityDefault(targetClass, PsiAnnotation.TargetType.TYPE_PARAMETER)) != null) {
                result.set((Object)info);
                return false;
            }
            return true;
        }));
        return (NullabilityAnnotationInfo)result.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 20: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: 
            case 20: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generated";
                break;
            }
            case 8: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullabilities";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberAnno";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAnno";
                break;
            }
            case 19: 
            case 20: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/NullableNotNullManager";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeTargetTypes";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/NullableNotNullManager";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullablesWithNickNames";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullsWithNickNames";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullability";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNullableAnnotation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNotNullAnnotation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copyNotNullAnnotation";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "copyNullableAnnotation";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyNullableOrNotNullAnnotation";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copyAnnotation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findOwnNullabilityInfo";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findEffectiveNullabilityInfo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doFindEffectiveNullabilityAnnotation";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findNullityDefaultFiltered";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findExplicitNullabilityAnnotation";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findPlainAnnotation";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "areDifferentNullityAnnotations";
                break;
            }
            case 19: 
            case 20: 
            case 32: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "hasHardcodedContracts";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getOwnerType";
                break;
            }
            case 23: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isNullable";
                break;
            }
            case 24: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isNotNull";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findNullityDefaultInHierarchy";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findNullabilityDefault";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findNullityDefaultOnPackage";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getNullability";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isNullabilityAnnotation";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotationInTypeHierarchy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: 
            case 20: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface NullabilityAnnotationDataHolder {
        public Set<String> qualifiedNames();

        @Nullable
        public Nullability getNullability(String var1);
    }
}

