/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.uast.UastModificationTracker;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MetaAnnotationUtil {
    private static final Hash.Strategy<PsiClass> HASHING_STRATEGY = new Hash.Strategy<PsiClass>(){

        public int hashCode(PsiClass object) {
            String qualifiedName = object == null ? null : object.getQualifiedName();
            return qualifiedName == null ? 0 : qualifiedName.hashCode();
        }

        public boolean equals(PsiClass o1, PsiClass o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            return Objects.equals(o1.getQualifiedName(), o2.getQualifiedName());
        }
    };

    public static Collection<PsiClass> getAnnotationTypesWithChildren(@NotNull Module module, String annotationName, boolean includeTests) {
        if (module == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(0);
        }
        Project project = module.getProject();
        Map map = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> {
            ConcurrentMap factoryMap = ConcurrentFactoryMap.createMap(key -> {
                GlobalSearchScope moduleScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)((Boolean)key.getSecond()));
                PsiClass annotationClass = JavaPsiFacade.getInstance(project).findClass((String)key.getFirst(), moduleScope);
                if (annotationClass == null || !annotationClass.isAnnotationType()) {
                    return Collections.emptyList();
                }
                GlobalSearchScope effectiveSearchScope = MetaAnnotationUtil.getAllAnnotationFilesScope(project).intersectWith(moduleScope);
                return MetaAnnotationUtil.getAnnotationTypesWithChildren(annotationClass, effectiveSearchScope);
            });
            return CachedValueProvider.Result.create((Object)factoryMap, (Object[])new Object[]{UastModificationTracker.getInstance(project)});
        });
        return (Collection)map.get(Pair.pair((Object)annotationName, (Object)includeTests));
    }

    public static Set<PsiClass> getChildren(@NotNull PsiClass psiClass, @NotNull GlobalSearchScope scope) {
        if (psiClass == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(2);
        }
        if (AnnotationTargetUtil.findAnnotationTarget(psiClass, PsiAnnotation.TargetType.ANNOTATION_TYPE, PsiAnnotation.TargetType.TYPE) == null) {
            return Collections.emptySet();
        }
        String name = psiClass.getQualifiedName();
        if (name == null) {
            return Collections.emptySet();
        }
        ObjectOpenCustomHashSet result = new ObjectOpenCustomHashSet(HASHING_STRATEGY);
        AnnotatedElementsSearch.searchPsiClasses(psiClass, (SearchScope)scope).forEach(arg_0 -> MetaAnnotationUtil.lambda$getChildren$2((Set)result, arg_0));
        if (result.isEmpty()) {
            return Collections.emptySet();
        }
        return result;
    }

    public static Collection<PsiClass> getAnnotatedTypes(@NotNull Module module, @NotNull String annotationName) {
        if (module == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(3);
        }
        if (annotationName == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(4);
        }
        Map map = (Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            ConcurrentMap factoryMap = ConcurrentFactoryMap.createMap(key -> MetaAnnotationUtil.findAnnotatedTypes(module, key));
            return new CachedValueProvider.Result((Object)factoryMap, new Object[]{UastModificationTracker.getInstance(module.getProject())});
        });
        return (Collection)map.get(annotationName);
    }

    @NotNull
    private static Collection<PsiClass> findAnnotatedTypes(@NotNull Module module, @NotNull String annotationName) {
        if (module == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(5);
        }
        if (annotationName == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(6);
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
        PsiClass psiClass = JavaPsiFacade.getInstance(module.getProject()).findClass(annotationName, scope);
        if (psiClass == null || !psiClass.isAnnotationType()) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                MetaAnnotationUtil.$$$reportNull$$$0(7);
            }
            return list;
        }
        Set<PsiClass> set = MetaAnnotationUtil.getChildren(psiClass, scope);
        if (set == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    private static Collection<PsiClass> getAnnotationTypesWithChildren(PsiClass annotationClass, GlobalSearchScope scope) {
        ObjectOpenCustomHashSet classes = new ObjectOpenCustomHashSet(HASHING_STRATEGY);
        MetaAnnotationUtil.collectClassWithChildren(annotationClass, (Set<? super PsiClass>)classes, scope);
        if (classes.isEmpty()) {
            Set<PsiClass> set = Collections.emptySet();
            if (set == null) {
                MetaAnnotationUtil.$$$reportNull$$$0(9);
            }
            return set;
        }
        ObjectOpenCustomHashSet objectOpenCustomHashSet = classes;
        if (objectOpenCustomHashSet == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(10);
        }
        return objectOpenCustomHashSet;
    }

    private static GlobalSearchScope getAllAnnotationFilesScope(Project project) {
        return (GlobalSearchScope)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            GlobalSearchScope javaScope = GlobalSearchScope.filesScope((Project)project, MetaAnnotationUtil.getJavaAnnotationInheritorIds(project));
            GlobalSearchScope otherScope = MetaAnnotationUtil.searchForAnnotationInheritorsInOtherLanguages(project);
            return CachedValueProvider.Result.createSingleDependency((Object)javaScope.uniteWith(otherScope), (Object)UastModificationTracker.getInstance(project));
        });
    }

    @NotNull
    private static GlobalSearchScope searchForAnnotationInheritorsInOtherLanguages(Project project) {
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)project);
        HashSet allAnnotationFiles = new HashSet();
        for (PsiClass javaLangAnnotation : JavaPsiFacade.getInstance(project).findClasses("java.lang.annotation.Annotation", allScope)) {
            DirectClassInheritorsSearch.SearchParameters parameters = new DirectClassInheritorsSearch.SearchParameters(javaLangAnnotation, (SearchScope)allScope, false, true){

                @Override
                public boolean shouldSearchInLanguage(@NotNull Language language2) {
                    if (language2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return language2 != JavaLanguage.INSTANCE;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/codeInsight/MetaAnnotationUtil$2", "shouldSearchInLanguage"));
                }
            };
            DirectClassInheritorsSearch.search(parameters).forEach(annotationClass -> {
                ProgressManager.checkCanceled();
                ContainerUtil.addIfNotNull((Collection)allAnnotationFiles, (Object)PsiUtilCore.getVirtualFile((PsiElement)annotationClass));
                return true;
            });
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesWithLibrariesScope((Project)project, allAnnotationFiles);
        if (globalSearchScope == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(11);
        }
        return globalSearchScope;
    }

    @NotNull
    private static Set<VirtualFile> getJavaAnnotationInheritorIds(Project project) {
        Set set = StubIndex.getInstance().getContainingFiles(JavaStubIndexKeys.SUPER_CLASSES, (Object)"Annotation", project, GlobalSearchScope.allScope((Project)project));
        if (set == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(12);
        }
        return set;
    }

    private static void collectClassWithChildren(PsiClass psiClass, Set<? super PsiClass> classes, GlobalSearchScope scope) {
        classes.add(psiClass);
        for (PsiClass aClass : MetaAnnotationUtil.getChildren(psiClass, scope)) {
            if (classes.contains(aClass)) continue;
            MetaAnnotationUtil.collectClassWithChildren(aClass, classes, scope);
        }
    }

    public static boolean isMetaAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations) {
        if (listOwner == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(13);
        }
        if (annotations == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(14);
        }
        if (AnnotationUtil.isAnnotated(listOwner, annotations, 0)) {
            return true;
        }
        List<PsiClass> resolvedAnnotations = MetaAnnotationUtil.getResolvedClassesInAnnotationsList(listOwner);
        for (String annotationFQN : annotations) {
            for (PsiClass resolvedAnnotation : resolvedAnnotations) {
                if (MetaAnnotationUtil.metaAnnotationCached(resolvedAnnotation, annotationFQN) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isMetaAnnotatedInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations) {
        if (listOwner == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(15);
        }
        if (annotations == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(16);
        }
        return MetaAnnotationUtil.isMetaAnnotatedInHierarchy(listOwner, annotations, new HashSet());
    }

    public static boolean hasMetaAnnotatedMethods(@NotNull PsiClass psiClass, @NotNull Collection<String> annotations) {
        if (psiClass == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(17);
        }
        if (annotations == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(18);
        }
        return ContainerUtil.or((Object[])psiClass.getMethods(), psiMethod -> MetaAnnotationUtil.isMetaAnnotated(psiMethod, annotations));
    }

    private static boolean isMetaAnnotatedInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations, Set<? super PsiMember> visited) {
        block6: {
            block5: {
                if (listOwner == null) {
                    MetaAnnotationUtil.$$$reportNull$$$0(19);
                }
                if (annotations == null) {
                    MetaAnnotationUtil.$$$reportNull$$$0(20);
                }
                if (MetaAnnotationUtil.isMetaAnnotated(listOwner, annotations)) {
                    return true;
                }
                if (!(listOwner instanceof PsiClass)) break block5;
                for (PsiClass superClass : ((PsiClass)listOwner).getSupers()) {
                    if (!visited.add(superClass) || !MetaAnnotationUtil.isMetaAnnotatedInHierarchy(superClass, annotations, visited)) continue;
                    return true;
                }
                break block6;
            }
            if (!(listOwner instanceof PsiMethod)) break block6;
            for (PsiMethod method : ((PsiMethod)listOwner).findSuperMethods()) {
                if (!visited.add(method) || !MetaAnnotationUtil.isMetaAnnotatedInHierarchy(method, annotations, visited)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PsiAnnotation metaAnnotationCached(PsiClass subjectAnnotation, String annotationToFind) {
        return (PsiAnnotation)((ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)subjectAnnotation, () -> {
            ConcurrentMap metaAnnotationsMap = ConcurrentFactoryMap.createMap(anno -> MetaAnnotationUtil.findMetaAnnotation(subjectAnnotation, anno, new HashSet()));
            return CachedValueProvider.Result.create((Object)metaAnnotationsMap, (Object[])new Object[]{UastModificationTracker.getInstance(subjectAnnotation.getProject())});
        })).get(annotationToFind);
    }

    @Nullable
    private static PsiAnnotation findMetaAnnotation(PsiClass aClass, String annotation, Set<? super PsiClass> visited) {
        PsiAnnotation directAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aClass, true, annotation);
        if (directAnnotation != null) {
            return directAnnotation;
        }
        List<PsiClass> resolvedAnnotations = MetaAnnotationUtil.getResolvedClassesInAnnotationsList(aClass);
        for (PsiClass resolvedAnnotation : resolvedAnnotations) {
            PsiAnnotation annotated;
            if (!visited.add(resolvedAnnotation) || (annotated = MetaAnnotationUtil.findMetaAnnotation(resolvedAnnotation, annotation, visited)) == null) continue;
            return annotated;
        }
        return null;
    }

    @NotNull
    public static Stream<PsiAnnotation> findMetaAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations) {
        if (listOwner == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(21);
        }
        if (annotations == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(22);
        }
        Stream<PsiAnnotation> directAnnotations = Stream.of(AnnotationUtil.findAnnotations(listOwner, annotations));
        Stream lazyResolvedAnnotations = Stream.generate(() -> MetaAnnotationUtil.getResolvedClassesInAnnotationsList(listOwner)).limit(1L).flatMap(it -> it.stream());
        Stream<PsiAnnotation> metaAnnotations = lazyResolvedAnnotations.flatMap(psiClass -> annotations.stream().map(annotationFQN -> MetaAnnotationUtil.metaAnnotationCached(psiClass, annotationFQN))).filter(Objects::nonNull);
        Stream<PsiAnnotation> stream = Stream.concat(directAnnotations, metaAnnotations);
        if (stream == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(23);
        }
        return stream;
    }

    private static List<PsiClass> getResolvedClassesInAnnotationsList(PsiModifierListOwner owner) {
        PsiModifierList modifierList = owner.getModifierList();
        if (modifierList != null) {
            return ContainerUtil.mapNotNull((Object[])modifierList.getApplicableAnnotations(), annotation -> annotation.resolveAnnotationType());
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ boolean lambda$getChildren$2(Set result, PsiClass processorResult) {
        ProgressManager.checkCanceled();
        if (processorResult.isAnnotationType()) {
            result.add(processorResult);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/MetaAnnotationUtil";
                break;
            }
            case 13: 
            case 15: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/MetaAnnotationUtil";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findAnnotatedTypes";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationTypesWithChildren";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "searchForAnnotationInheritorsInOtherLanguages";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaAnnotationInheritorIds";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findMetaAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationTypesWithChildren";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotatedTypes";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotatedTypes";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 23: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isMetaAnnotated";
                break;
            }
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isMetaAnnotatedInHierarchy";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "hasMetaAnnotatedMethods";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findMetaAnnotations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

