/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.client;

import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.intellij.j2ee.webSphere.client.AdminClientWrapper;
import com.intellij.j2ee.webSphere.client.AdminClientWrapperImpl;
import com.intellij.j2ee.webSphere.client.WebSphereClientException;
import com.intellij.j2ee.webSphere.client.WebSphereClientExceptionSeverity;
import com.intellij.j2ee.webSphere.client.WebSphereClientFactory;
import java.security.Security;
import java.util.Properties;

public class WebSphereClientFactoryImpl
implements WebSphereClientFactory {
    public AdminClientWrapper createAdminClient(String host, int port, boolean clientHasAutoUpload, String username, String password, boolean secured, String trustStorePath, String trustStorePassword, String keyStorePath, String keyStorePassword, boolean useIbmAlgorithm) throws WebSphereClientException {
        try {
            Properties properties = new Properties();
            properties.setProperty("type", "SOAP");
            properties.setProperty("host", host);
            properties.setProperty("port", String.valueOf(port));
            properties.setProperty("username", username);
            properties.setProperty("password", password);
            if (secured) {
                properties.setProperty("securityEnabled", Boolean.TRUE.toString());
                properties.setProperty("javax.net.ssl.trustStore", trustStorePath);
                properties.setProperty("javax.net.ssl.keyStore", keyStorePath);
                properties.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
                properties.setProperty("javax.net.ssl.keyStorePassword", keyStorePassword);
                properties.setProperty("autoAcceptSignerForThisConnectionOnly", Boolean.TRUE.toString());
                if (useIbmAlgorithm) {
                    Security.setProperty("ssl.KeyManagerFactory.algorithm", "IbmX509");
                }
            }
            AdminClient ac = AdminClientFactory.createAdminClient((Properties)properties);
            return new AdminClientWrapperImpl(ac, clientHasAutoUpload);
        }
        catch (ConnectorException e) {
            throw new WebSphereClientException((Throwable)e, WebSphereClientExceptionSeverity.SEVERITY_CONNECTOR);
        }
    }
}

