/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.client;

import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.exception.ConnectorException;
import com.intellij.j2ee.webSphere.client.AdminClientWrapper;
import com.intellij.j2ee.webSphere.client.AppManagementNotificationListener;
import com.intellij.j2ee.webSphere.client.AppManagementWrapper;
import com.intellij.j2ee.webSphere.client.AppManagementWrapperImpl;
import com.intellij.j2ee.webSphere.client.ApplicationWrapper;
import com.intellij.j2ee.webSphere.client.ApplicationWrapperImpl;
import com.intellij.j2ee.webSphere.client.ServerWrapper;
import com.intellij.j2ee.webSphere.client.ServerWrapperImpl;
import com.intellij.j2ee.webSphere.client.WebSphereClientException;
import com.intellij.j2ee.webSphere.client.WebSphereClientExceptionSeverity;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class AdminClientWrapperImpl
implements AdminClientWrapper {
    private final AdminClient myAdminClient;
    private final boolean myHasAutoUpload;

    public AdminClientWrapperImpl(AdminClient adminClient, boolean clientHasAutoUpload) {
        this.myAdminClient = adminClient;
        this.myHasAutoUpload = clientHasAutoUpload;
    }

    public AppManagementWrapper createAppManagement() throws Exception {
        return new AppManagementWrapperImpl(this.myAdminClient, AppManagementProxy.getJMXProxyForClient((AdminClient)this.myAdminClient), this.myHasAutoUpload);
    }

    public ServerWrapper createServer(String cellName, String nodeName, String serverName) throws WebSphereClientException {
        try {
            Set set = this.myAdminClient.queryNames(new ObjectName("*:type=Server,cell=" + cellName + ",node=" + nodeName + ",name=" + serverName + ",*"), null);
            if (set.isEmpty()) {
                throw new WebSphereClientException("Server instance cannot be found by " + cellName + "/" + nodeName + "/" + serverName, WebSphereClientExceptionSeverity.SEVERITY_ERROR);
            }
            ObjectName serverObjectName = (ObjectName)set.iterator().next();
            return new ServerWrapperImpl(this.myAdminClient, serverObjectName);
        }
        catch (ConnectorException e) {
            throw new WebSphereClientException((Throwable)e, WebSphereClientExceptionSeverity.SEVERITY_CONNECTOR);
        }
        catch (MalformedObjectNameException e) {
            throw new WebSphereClientException((Throwable)e, WebSphereClientExceptionSeverity.SEVERITY_ERROR);
        }
    }

    public ApplicationWrapper findApplication(String appName) throws WebSphereClientException {
        try {
            Set set = this.myAdminClient.queryNames(new ObjectName("*:type=Application,name=" + appName + ",*"), null);
            if (set.isEmpty()) {
                return null;
            }
            ObjectName objectName = (ObjectName)set.iterator().next();
            return new ApplicationWrapperImpl(this.myAdminClient, objectName);
        }
        catch (ConnectorException e) {
            throw new WebSphereClientException((Throwable)e, WebSphereClientExceptionSeverity.SEVERITY_CONNECTOR);
        }
        catch (MalformedObjectNameException e) {
            throw new WebSphereClientException((Throwable)e, WebSphereClientExceptionSeverity.SEVERITY_ERROR);
        }
    }

    public void registerNotificationListener(final AppManagementNotificationListener listener) throws WebSphereClientException {
        try {
            Set set = this.myAdminClient.queryNames(new ObjectName("*:type=AppManagement,*"), null);
            if (set.isEmpty()) {
                return;
            }
            ObjectName appManagement = (ObjectName)set.iterator().next();
            NotificationFilterSupport filter = new NotificationFilterSupport();
            filter.enableType("websphere.admin.appmgmt");
            this.myAdminClient.addNotificationListener(appManagement, new NotificationListener(){

                @Override
                public void handleNotification(Notification notification, Object handback) {
                    AppNotification appNotification = (AppNotification)notification.getUserData();
                    listener.handleNotification(appNotification.taskName, appNotification.taskStatus, appNotification.message, appNotification.props);
                }
            }, (NotificationFilter)filter, null);
        }
        catch (ConnectorException e) {
            throw new WebSphereClientException((Throwable)e, WebSphereClientExceptionSeverity.SEVERITY_CONNECTOR);
        }
        catch (JMException e) {
            throw new WebSphereClientException((Throwable)e, WebSphereClientExceptionSeverity.SEVERITY_ERROR);
        }
    }

    public void close() {
    }

    public List<ServerWrapper> getAllServers() throws WebSphereClientException {
        try {
            ArrayList<ServerWrapper> result = new ArrayList<ServerWrapper>();
            for (Object serverObject : this.myAdminClient.queryNames(new ObjectName("*:type=Server,*"), null)) {
                ObjectName serverObjectName = (ObjectName)serverObject;
                ServerWrapperImpl serverWrapper = new ServerWrapperImpl(this.myAdminClient, serverObjectName);
                result.add(serverWrapper);
            }
            return result;
        }
        catch (ConnectorException e) {
            throw new WebSphereClientException((Throwable)e, WebSphereClientExceptionSeverity.SEVERITY_CONNECTOR);
        }
        catch (MalformedObjectNameException e) {
            throw new WebSphereClientException((Throwable)e, WebSphereClientExceptionSeverity.SEVERITY_ERROR);
        }
    }
}

