/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.impl;

import com.intellij.execution.rmi.RemoteObject;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcRemoteObject
extends RemoteObject {
    protected Throwable wrapException(Throwable ex, int exDepth) {
        if (ex instanceof SQLException) {
            return this.wrapSqlException((SQLException)ex, exDepth);
        }
        return super.wrapException(ex, exDepth);
    }

    @Nullable
    protected SQLException wrapSqlException(@Nullable SQLException target, int exDepth) {
        SQLException result = null;
        SQLException prev = null;
        for (SQLException ex = target; ex != null; ex = ex.getNextException()) {
            SQLException w = this.createSqlExceptionWrapper(ex, this.wrapExceptionCause(ex, exDepth));
            if (prev == null) {
                result = prev = w;
                continue;
            }
            prev.setNextException(w);
        }
        return result;
    }

    @NotNull
    protected SQLException createSqlExceptionWrapper(@NotNull SQLException ex, @Nullable Throwable wCause) {
        if (ex == null) {
            JdbcRemoteObject.$$$reportNull$$$0(0);
        }
        SQLException w = new SQLException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), wCause);
        w.setStackTrace(ex.getStackTrace());
        SQLException sQLException = w;
        if (sQLException == null) {
            JdbcRemoteObject.$$$reportNull$$$0(1);
        }
        return sQLException;
    }

    @Nullable
    public SQLWarning wrapSqlWarning(@Nullable SQLWarning target) {
        SQLWarning result = null;
        SQLWarning prev = null;
        for (SQLWarning ex = target; ex != null; ex = ex.getNextWarning()) {
            SQLWarning w = JdbcRemoteObject.createSqlWarningWrapper(ex, this.wrapExceptionCause(ex, 0));
            if (prev == null) {
                result = prev = w;
                continue;
            }
            prev.setNextWarning(w);
        }
        return result;
    }

    @NotNull
    public List<SQLWarning> getAllWarnings(@Nullable SQLWarning target) {
        ArrayList<SQLWarning> warnings = new ArrayList<SQLWarning>();
        while (target != null) {
            SQLWarning warning = JdbcRemoteObject.createSqlWarningWrapper(target, this.wrapExceptionCause(target, 0));
            warnings.add(warning);
            target = target.getNextWarning();
        }
        ArrayList<SQLWarning> arrayList = warnings;
        if (arrayList == null) {
            JdbcRemoteObject.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    private static SQLWarning createSqlWarningWrapper(@NotNull SQLWarning ex, @Nullable Throwable wCause) {
        if (ex == null) {
            JdbcRemoteObject.$$$reportNull$$$0(3);
        }
        SQLWarning w = new SQLWarning(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), wCause);
        w.setStackTrace(ex.getStackTrace());
        SQLWarning sQLWarning = w;
        if (sQLWarning == null) {
            JdbcRemoteObject.$$$reportNull$$$0(4);
        }
        return sQLWarning;
    }

    @Contract(value="_ -> fail")
    public RuntimeException rethrowException(Throwable e) throws SQLException, RemoteException {
        Throwable wrap = this.wrapException(e);
        if (wrap instanceof SQLException) {
            throw (SQLException)wrap;
        }
        throw wrap instanceof RuntimeException ? (RuntimeException)wrap : new RuntimeException(wrap);
    }

    @Contract(value="_ -> fail")
    public RuntimeException rethrowRuntimeException(Throwable e) throws RemoteException {
        Throwable wrap = this.wrapException(e);
        throw wrap instanceof RuntimeException ? (RuntimeException)wrap : new RuntimeException(wrap);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/impl/JdbcRemoteObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/impl/JdbcRemoteObject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createSqlExceptionWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllWarnings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createSqlWarningWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSqlExceptionWrapper";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createSqlWarningWrapper";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

