/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.execution.rmi.ssl.SslUtil;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SFlakeJdbcHelper
extends JdbcHelperImpl {
    private static final Set<String> SFLAKE_UNLIMITED_TYPES = new HashSet<String>(Arrays.asList("DOUBLE", "ARRAY", "OBJECT", "VARIANT", "BOOLEAN", "DATE", "BINARY"));
    private static final Set<String> SFLAKE_TIME_TYPES = new HashSet<String>(Arrays.asList("TIME", "TIMESTAMPTZ", "TIMESTAMPLTZ", "TIMESTAMPNTZ"));

    public SFlakeJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super("SNOWFLAKE", version, connection);
    }

    public SFlakeJdbcHelper() {
        this(null, null);
    }

    @Override
    public void setStatementParameter(@NotNull RemotePreparedStatement statement, @Nullable Object value, @NotNull ColumnInfo columnInfo, boolean needsEscaping, int idx) throws Exception {
        if (statement == null) {
            SFlakeJdbcHelper.$$$reportNull$$$0(0);
        }
        if (columnInfo == null) {
            SFlakeJdbcHelper.$$$reportNull$$$0(1);
        }
        if (columnInfo.getType() == 93 && value instanceof Timestamp && "TIMESTAMPNTZ".equals(columnInfo.getTypeName())) {
            statement.setString(idx, value.toString());
        } else {
            super.setStatementParameter(statement, value, columnInfo, needsEscaping, idx);
        }
    }

    @Override
    public boolean isZonedTimestampColumn(@Nullable String typeName, int jdbcType) {
        if ("TIMESTAMPTZ".equals(typeName) || "TIMESTAMPLTZ".equals(typeName)) {
            return true;
        }
        return super.isZonedTimestampColumn(typeName, jdbcType);
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            SFlakeJdbcHelper.$$$reportNull$$$0(2);
        }
        if (e.typeName != null && SFLAKE_UNLIMITED_TYPES.contains(e.typeName)) {
            e.length = -1;
        } else if (e.typeName != null && SFLAKE_TIME_TYPES.contains(e.typeName)) {
            e.length = e.scale;
            e.scale = 0;
        }
    }

    @Override
    @Nullable
    public JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer) {
        if (!JdbcNativeUtil.detectString(product, "snowflake")) {
            return null;
        }
        return SFlakeJdbcHelper.create(delegate, productVer);
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            SFlakeJdbcHelper.$$$reportNull$$$0(3);
        }
        return SFlakeJdbcHelper.classNameContains(driver, "snowflake");
    }

    @Override
    protected void useSslKey(Properties properties, String sslCert, String sslKey, char[] sslPwd) throws SQLException {
        if (sslKey != null) {
            try {
                properties.put("privateKey", SslUtil.readPrivateKey((String)sslKey, (char[])sslPwd));
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        } else {
            super.useSslKey(properties, sslCert, sslKey, sslPwd);
        }
    }

    @Override
    @Nullable(value="no support at all")
    public JdbcSettings.SslMode[] supportedSslModes() {
        return new JdbcSettings.SslMode[]{JdbcSettings.SslMode.REQUIRE};
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return SFlakeJdbcHelper.extractVersion(version);
    }

    @NotNull
    protected static SFlakeJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer) {
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + productVer);
        return new SFlakeJdbcHelper(SFlakeJdbcHelper.extractVersion(productVer), delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    public boolean supportsIlike() {
        return true;
    }

    @Override
    @Nullable
    protected JdbcHelperImpl.TemporalGetter getTemporalGetter(int type) {
        return type == 91 ? SFlakeTemporalGetter.INSTANCE : super.getTemporalGetter(type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/SFlakeJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setStatementParameter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "detect";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SFlakeTemporalGetter
    implements JdbcHelperImpl.TemporalGetter {
        static final JdbcHelperImpl.TemporalGetter INSTANCE = new SFlakeTemporalGetter();

        private SFlakeTemporalGetter() {
        }

        @Override
        public Object get(@NotNull ResultSet set, @NotNull RemoteResultSet.DataRetrievingOptions options, int idx) throws SQLException {
            if (set == null) {
                SFlakeTemporalGetter.$$$reportNull$$$0(0);
            }
            if (options == null) {
                SFlakeTemporalGetter.$$$reportNull$$$0(1);
            }
            return set.getString(idx);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "set";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "options";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/remote/jdbc/helpers/SFlakeJdbcHelper$SFlakeTemporalGetter";
            objectArray[2] = "get";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

