/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.exceptions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsBaseSQLException
extends SQLException {
    static String EXCEPTION_CLASS_NAME = "com.microsoft.sqlserver.jdbc.SQLServerException";
    private static Method myGetError;
    static String ERROR_CLASS_NAME;
    private static Method myGetLineNumber;
    private final String detailMessageWithLine;

    public MsBaseSQLException(@NotNull SQLException ex, @Nullable Throwable cause) {
        String msg;
        if (ex == null) {
            MsBaseSQLException.$$$reportNull$$$0(0);
        }
        super(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), cause);
        if (myGetError == null) {
            try {
                Class<?> exceptionClass = Class.forName(EXCEPTION_CLASS_NAME, true, ex.getClass().getClassLoader());
                myGetError = exceptionClass.getMethod("getSQLServerError", new Class[0]);
                Class<?> errorClass = Class.forName(ERROR_CLASS_NAME, true, ex.getClass().getClassLoader());
                myGetLineNumber = errorClass.getMethod("getLineNumber", new Class[0]);
            }
            catch (ClassNotFoundException exceptionClass) {
            }
            catch (NoSuchMethodException exceptionClass) {
                // empty catch block
            }
        }
        Long lineNumber = null;
        if (myGetError != null && myGetLineNumber != null) {
            try {
                Object lineNumberObject;
                Object errorObject = myGetError.invoke((Object)ex, new Object[0]);
                Object object = lineNumberObject = errorObject == null ? null : myGetLineNumber.invoke(errorObject, new Object[0]);
                if (lineNumberObject instanceof Long) {
                    lineNumber = (Long)lineNumberObject;
                }
            }
            catch (IllegalArgumentException errorObject) {
            }
            catch (IllegalAccessException errorObject) {
            }
            catch (InvocationTargetException errorObject) {
                // empty catch block
            }
        }
        this.detailMessageWithLine = (msg = this.getMessage()) == null || lineNumber == null ? null : String.format("Line %d: %s", lineNumber, msg);
    }

    @Override
    public String getMessage() {
        return this.detailMessageWithLine != null ? this.detailMessageWithLine : super.getMessage();
    }

    static {
        ERROR_CLASS_NAME = "com.microsoft.sqlserver.jdbc.SQLServerError";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ex", "com/intellij/database/remote/jdbc/exceptions/MsBaseSQLException", "<init>"));
    }
}

