/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry;

import com.newrelic.telemetry.Backoff;
import com.newrelic.telemetry.BaseConfig;
import com.newrelic.telemetry.Telemetry;
import com.newrelic.telemetry.TelemetryBatch;
import com.newrelic.telemetry.events.EventBatch;
import com.newrelic.telemetry.events.EventBatchSender;
import com.newrelic.telemetry.exceptions.ResponseException;
import com.newrelic.telemetry.exceptions.RetryWithBackoffException;
import com.newrelic.telemetry.exceptions.RetryWithRequestedWaitException;
import com.newrelic.telemetry.exceptions.RetryWithSplitException;
import com.newrelic.telemetry.http.HttpPoster;
import com.newrelic.telemetry.logs.LogBatch;
import com.newrelic.telemetry.logs.LogBatchSender;
import com.newrelic.telemetry.metrics.MetricBatch;
import com.newrelic.telemetry.metrics.MetricBatchSender;
import com.newrelic.telemetry.spans.SpanBatch;
import com.newrelic.telemetry.spans.SpanBatchSender;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelemetryClient {
    private static final Logger LOG = LoggerFactory.getLogger(TelemetryClient.class);
    private static final int DEFAULT_SHUTDOWN_SECONDS = 3;
    private static final boolean DEFAULT_IS_DAEMON = true;
    private final EventBatchSender eventBatchSender;
    private final MetricBatchSender metricBatchSender;
    private final SpanBatchSender spanBatchSender;
    private final ScheduledExecutorService executor;
    private final int shutdownSeconds;
    private final LogBatchSender logBatchSender;

    public TelemetryClient(MetricBatchSender metricBatchSender, SpanBatchSender spanBatchSender, EventBatchSender eventBatchSender, LogBatchSender logBatchSender) {
        this(metricBatchSender, spanBatchSender, eventBatchSender, logBatchSender, 3, true);
    }

    public TelemetryClient(MetricBatchSender metricBatchSender, SpanBatchSender spanBatchSender, EventBatchSender eventBatchSender, LogBatchSender logBatchSender, int shutdownSeconds, boolean useDaemonThread) {
        this.metricBatchSender = metricBatchSender;
        this.spanBatchSender = spanBatchSender;
        this.eventBatchSender = eventBatchSender;
        this.logBatchSender = logBatchSender;
        this.shutdownSeconds = shutdownSeconds;
        this.executor = TelemetryClient.buildExecutorService(useDaemonThread);
    }

    @Deprecated
    public TelemetryClient(MetricBatchSender metricBatchSender, SpanBatchSender spanBatchSender) {
        this(metricBatchSender, spanBatchSender, null, null);
    }

    public void sendBatch(MetricBatch batch) {
        this.scheduleBatchSend(b -> this.metricBatchSender.sendBatch((MetricBatch)b), (TelemetryBatch<? extends Telemetry>)batch, 0L, TimeUnit.SECONDS);
    }

    public void sendBatch(SpanBatch batch) {
        this.scheduleBatchSend(b -> this.spanBatchSender.sendBatch((SpanBatch)b), (TelemetryBatch<? extends Telemetry>)batch, 0L, TimeUnit.SECONDS);
    }

    public void sendBatch(EventBatch batch) {
        this.scheduleBatchSend(b -> this.eventBatchSender.sendBatch((EventBatch)b), (TelemetryBatch<? extends Telemetry>)batch, 0L, TimeUnit.SECONDS);
    }

    public void sendBatch(LogBatch batch) {
        this.scheduleBatchSend(b -> this.logBatchSender.sendBatch((LogBatch)b), (TelemetryBatch<? extends Telemetry>)batch, 0L, TimeUnit.SECONDS);
    }

    private void scheduleBatchSend(BatchSender sender, TelemetryBatch<? extends Telemetry> batch, long waitTime, TimeUnit timeUnit) {
        this.scheduleBatchSend(sender, batch, waitTime, timeUnit, Backoff.defaultBackoff());
    }

    private void scheduleBatchSend(BatchSender sender, TelemetryBatch<? extends Telemetry> batch, long waitTime, TimeUnit timeUnit, Backoff backoff) {
        if (this.executor.isTerminated()) {
            return;
        }
        try {
            this.executor.schedule(() -> this.sendWithErrorHandling(sender, batch, backoff), waitTime, timeUnit);
        }
        catch (RejectedExecutionException e) {
            LOG.error("Problem scheduling batch : " + e.getMessage());
        }
    }

    private void sendWithErrorHandling(BatchSender batchSender, TelemetryBatch<? extends Telemetry> batch, Backoff backoff) {
        try {
            batchSender.sendBatch(batch);
            LOG.debug("Telemetry batch sent");
        }
        catch (RetryWithBackoffException e) {
            this.backoff(batchSender, batch, backoff);
        }
        catch (RetryWithRequestedWaitException e) {
            this.retry(batchSender, batch, e);
        }
        catch (RetryWithSplitException e) {
            this.splitAndSend(batchSender, batch, e);
        }
        catch (ResponseException e) {
            LOG.error("Received a fatal exception from the New Relic API. Aborting metric batch send.", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("Unexpected failure when sending data.", (Throwable)e);
        }
    }

    private <T extends Telemetry> void splitAndSend(BatchSender sender, TelemetryBatch<T> batch, RetryWithSplitException e) {
        LOG.info("Metric batch size too large, splitting and retrying.", (Throwable)e);
        List splitBatches = batch.split();
        splitBatches.forEach(metricBatch -> this.scheduleBatchSend(sender, (TelemetryBatch<? extends Telemetry>)metricBatch, 0L, TimeUnit.SECONDS));
    }

    private void retry(BatchSender sender, TelemetryBatch<? extends Telemetry> batch, RetryWithRequestedWaitException e) {
        LOG.info("Metric batch sending failed. Retrying failed batch after {} {}", (Object)e.getWaitTime(), (Object)e.getTimeUnit());
        this.scheduleBatchSend(sender, batch, e.getWaitTime(), e.getTimeUnit());
    }

    private void backoff(BatchSender sender, TelemetryBatch<? extends Telemetry> batch, Backoff backoff) {
        long newWaitTime = backoff.nextWaitMs();
        if (newWaitTime == -1L) {
            LOG.error("Max retries exceeded.  Dropping {} pieces of telemetry data!", (Object)batch.size());
            return;
        }
        LOG.info("Metric batch sending failed. Backing off {} {}", (Object)newWaitTime, (Object)TimeUnit.MILLISECONDS);
        this.scheduleBatchSend(sender, batch, newWaitTime, TimeUnit.MILLISECONDS, backoff);
    }

    public void shutdown() {
        LOG.info("Shutting down the TelemetryClient background Executor");
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(this.shutdownSeconds, TimeUnit.SECONDS)) {
                LOG.warn("couldn't shutdown within timeout");
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOG.error("interrupted graceful shutdown", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public static TelemetryClient create(Supplier<HttpPoster> httpPosterCreator, String insertApiKey) {
        return TelemetryClient.create(httpPosterCreator, new BaseConfig(insertApiKey));
    }

    public static TelemetryClient create(Supplier<HttpPoster> httpPosterCreator, BaseConfig baseConfig) {
        MetricBatchSender metricBatchSender = MetricBatchSender.create(httpPosterCreator, (BaseConfig)baseConfig);
        SpanBatchSender spanBatchSender = SpanBatchSender.create(httpPosterCreator, (BaseConfig)baseConfig);
        EventBatchSender eventBatchSender = EventBatchSender.create(httpPosterCreator, (BaseConfig)baseConfig);
        LogBatchSender logBatchSender = LogBatchSender.create(httpPosterCreator, (BaseConfig)baseConfig);
        return new TelemetryClient(metricBatchSender, spanBatchSender, eventBatchSender, logBatchSender);
    }

    private static ScheduledExecutorService buildExecutorService(boolean useDaemonThread) {
        return Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(useDaemonThread);
            return thread;
        });
    }

    private static interface BatchSender {
        public void sendBatch(TelemetryBatch<?> var1) throws ResponseException;
    }
}

