/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.io.IOUtil;
import com.intellij.xml.util.XmlUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertToBasicLatinInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final TokenSet LITERALS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.CHARACTER_LITERAL, JavaTokenType.STRING_LITERAL});

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            ConvertToBasicLatinInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            @Nullable
            private ProblemDescriptor getProblem(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (IOUtil.isAscii((String)element.getText())) {
                    return null;
                }
                return holder.getManager().createProblemDescriptor(element, (TextRange)null, JavaI18nBundle.message("inspection.convert.to.basic.latin", new Object[0]), ProblemHighlightType.INFORMATION, isOnTheFly, new LocalQuickFix[]{new MyLocalQuickFix()});
            }

            public void visitComment(@NotNull PsiComment comment) {
                if (comment == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitComment(comment);
                ProblemDescriptor descriptor = this.getProblem((PsiElement)comment);
                if (descriptor != null) {
                    holder.registerProblem(descriptor);
                }
            }

            public void visitLiteralExpression(PsiLiteralExpression expression) {
                super.visitLiteralExpression(expression);
                if (!(expression instanceof PsiLiteralExpressionImpl)) {
                    return;
                }
                if (!LITERALS.contains(((PsiLiteralExpressionImpl)expression).getLiteralElementType())) {
                    return;
                }
                ProblemDescriptor descriptor = this.getProblem((PsiElement)expression);
                if (descriptor != null) {
                    holder.registerProblem(descriptor);
                }
            }

            public void visitDocComment(PsiDocComment comment) {
                super.visitDocComment(comment);
                ProblemDescriptor descriptor = this.getProblem((PsiElement)comment);
                if (descriptor != null) {
                    holder.registerProblem(descriptor);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "comment";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/i18n/ConvertToBasicLatinInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getProblem";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitComment";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/i18n/ConvertToBasicLatinInspection", "buildVisitor"));
    }

    private static class MyLocalQuickFix
    implements LocalQuickFix {
        private MyLocalQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaI18nBundle.message("inspection.convert.to.basic.latin", new Object[0]);
            if (string == null) {
                MyLocalQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            Handler handler;
            if (project == null) {
                MyLocalQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MyLocalQuickFix.$$$reportNull$$$0(2);
            }
            if ((handler = (element = descriptor.getPsiElement()) instanceof PsiLiteralExpression ? new LiteralHandler() : (element instanceof PsiDocComment ? new DocCommentHandler() : (element instanceof PsiComment ? new CommentHandler() : null))) == null) {
                return;
            }
            PsiElement newElement = handler.getSubstitution(project, element);
            element.replace(newElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/i18n/ConvertToBasicLatinInspection$MyLocalQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/i18n/ConvertToBasicLatinInspection$MyLocalQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CommentHandler
    extends DocCommentHandler {
        private CommentHandler() {
        }
    }

    private static class DocCommentHandler
    extends Handler {
        private static Int2ObjectMap<String> ourEntities;

        private DocCommentHandler() {
        }

        @Override
        @NotNull
        PsiElement getSubstitution(@NotNull Project project, @NotNull PsiElement element) {
            if (project == null) {
                DocCommentHandler.$$$reportNull$$$0(0);
            }
            if (element == null) {
                DocCommentHandler.$$$reportNull$$$0(1);
            }
            DocCommentHandler.loadEntities(project);
            PsiElement psiElement = ourEntities != null ? super.getSubstitution(project, element) : element;
            if (psiElement == null) {
                DocCommentHandler.$$$reportNull$$$0(2);
            }
            return psiElement;
        }

        @Override
        protected void convert(@NotNull StringBuilder sb, char ch) {
            String entity;
            if (sb == null) {
                DocCommentHandler.$$$reportNull$$$0(3);
            }
            if ((entity = (String)ourEntities.get((int)ch)) != null) {
                sb.append('&').append(entity).append(';');
            } else {
                sb.append("&#x").append(Integer.toHexString(ch).toUpperCase(Locale.ENGLISH)).append(';');
            }
        }

        @Override
        @NotNull
        protected PsiElement getSubstitution(@NotNull PsiElementFactory factory, @NotNull PsiElement element, @NotNull String newText) {
            if (factory == null) {
                DocCommentHandler.$$$reportNull$$$0(4);
            }
            if (element == null) {
                DocCommentHandler.$$$reportNull$$$0(5);
            }
            if (newText == null) {
                DocCommentHandler.$$$reportNull$$$0(6);
            }
            PsiComment psiComment = factory.createCommentFromText(newText, element.getParent());
            if (psiComment == null) {
                DocCommentHandler.$$$reportNull$$$0(7);
            }
            return psiComment;
        }

        private static void loadEntities(@NotNull Project project) {
            XmlFile file;
            if (project == null) {
                DocCommentHandler.$$$reportNull$$$0(8);
            }
            if (ourEntities != null) {
                return;
            }
            try {
                String url = ExternalResourceManager.getInstance().getResourceLocation("http://www.w3.org/TR/html4/loose.dtd", project);
                if (url == null) {
                    Logger.getInstance(ConvertToBasicLatinInspection.class).error("Namespace not found: http://www.w3.org/TR/html4/loose.dtd");
                    return;
                }
                VirtualFile vFile = VfsUtil.findFileByURL((URL)new URL(url));
                if (vFile == null) {
                    Logger.getInstance(ConvertToBasicLatinInspection.class).error("Resource not found: " + url);
                    return;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(vFile);
                if (!(psiFile instanceof XmlFile)) {
                    Logger.getInstance(ConvertToBasicLatinInspection.class).error("Unexpected resource: " + psiFile);
                    return;
                }
                file = (XmlFile)psiFile;
            }
            catch (MalformedURLException e) {
                Logger.getInstance(ConvertToBasicLatinInspection.class).error((Throwable)e);
                return;
            }
            Int2ObjectOpenHashMap entities = new Int2ObjectOpenHashMap();
            Pattern pattern = Pattern.compile("&#(\\d+);");
            XmlUtil.processXmlElements((XmlElement)file, arg_0 -> DocCommentHandler.lambda$loadEntities$0(pattern, (Int2ObjectMap)entities, arg_0), (boolean)true);
            ourEntities = entities;
        }

        private static /* synthetic */ boolean lambda$loadEntities$0(Pattern pattern, Int2ObjectMap entities, PsiElement element) {
            char i;
            XmlEntityDecl entity;
            Matcher m;
            if (element instanceof XmlEntityDecl && (m = pattern.matcher((entity = (XmlEntityDecl)element).getValueElement().getValue())).matches() && !DocCommentHandler.isBasicLatin(i = (char)Integer.parseInt(m.group(1)))) {
                entities.put((int)i, (Object)entity.getName());
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/i18n/ConvertToBasicLatinInspection$DocCommentHandler";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/i18n/ConvertToBasicLatinInspection$DocCommentHandler";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubstitution";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSubstitution";
                    break;
                }
                case 2: 
                case 7: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "convert";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "loadEntities";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LiteralHandler
    extends Handler {
        private LiteralHandler() {
        }

        @Override
        @NotNull
        protected PsiElement getSubstitution(@NotNull PsiElementFactory factory, @NotNull PsiElement element, @NotNull String newText) {
            if (factory == null) {
                LiteralHandler.$$$reportNull$$$0(0);
            }
            if (element == null) {
                LiteralHandler.$$$reportNull$$$0(1);
            }
            if (newText == null) {
                LiteralHandler.$$$reportNull$$$0(2);
            }
            PsiExpression psiExpression = factory.createExpressionFromText(newText, element.getParent());
            if (psiExpression == null) {
                LiteralHandler.$$$reportNull$$$0(3);
            }
            return psiExpression;
        }

        @Override
        protected void convert(@NotNull StringBuilder sb, char ch) {
            if (sb == null) {
                LiteralHandler.$$$reportNull$$$0(4);
            }
            sb.append(String.format("\\u%04X", ch));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newText";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/i18n/ConvertToBasicLatinInspection$LiteralHandler";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/i18n/ConvertToBasicLatinInspection$LiteralHandler";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubstitution";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSubstitution";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "convert";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class Handler {
        private Handler() {
        }

        @NotNull
        PsiElement getSubstitution(@NotNull Project project, @NotNull PsiElement element) {
            if (project == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (element == null) {
                Handler.$$$reportNull$$$0(1);
            }
            String text = element.getText();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (Handler.isBasicLatin(ch)) {
                    sb.append(ch);
                    continue;
                }
                this.convert(sb, ch);
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiElement psiElement = this.getSubstitution(factory, element, sb.toString());
            if (psiElement == null) {
                Handler.$$$reportNull$$$0(2);
            }
            return psiElement;
        }

        protected static boolean isBasicLatin(char ch) {
            return Character.UnicodeBlock.of(ch) == Character.UnicodeBlock.BASIC_LATIN;
        }

        protected abstract void convert(@NotNull StringBuilder var1, char var2);

        @NotNull
        protected abstract PsiElement getSubstitution(@NotNull PsiElementFactory var1, @NotNull PsiElement var2, @NotNull String var3);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/i18n/ConvertToBasicLatinInspection$Handler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/i18n/ConvertToBasicLatinInspection$Handler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubstitution";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSubstitution";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

