/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.model.converters;

import com.intellij.hibernate.model.enums.LazyType;
import com.intellij.hibernate.model.xml.mapping.HbmAny;
import com.intellij.hibernate.model.xml.mapping.HbmBag;
import com.intellij.hibernate.model.xml.mapping.HbmClass;
import com.intellij.hibernate.model.xml.mapping.HbmComponent;
import com.intellij.hibernate.model.xml.mapping.HbmIdbag;
import com.intellij.hibernate.model.xml.mapping.HbmJoinedSubclass;
import com.intellij.hibernate.model.xml.mapping.HbmKeyManyToOne;
import com.intellij.hibernate.model.xml.mapping.HbmList;
import com.intellij.hibernate.model.xml.mapping.HbmManyToMany;
import com.intellij.hibernate.model.xml.mapping.HbmManyToOne;
import com.intellij.hibernate.model.xml.mapping.HbmMap;
import com.intellij.hibernate.model.xml.mapping.HbmOneToOne;
import com.intellij.hibernate.model.xml.mapping.HbmProperty;
import com.intellij.hibernate.model.xml.mapping.HbmSet;
import com.intellij.hibernate.model.xml.mapping.HbmSubclass;
import com.intellij.hibernate.model.xml.mapping.HbmUnionSubclass;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LazyTypeConverter
extends ResolvingConverter<LazyType> {
    public static final Map<Class<?>, Collection<LazyType>> ourMapping = new HashMap();

    @NotNull
    public Collection<LazyType> getVariants(ConvertContext context) {
        DomElement parent = context.getInvocationElement().getParent();
        Class<?> parentClass = parent == null ? null : parent.getClass().getInterfaces()[0];
        Collection<LazyType> types = parentClass == null ? null : ourMapping.get(parentClass);
        Collection<Object> collection = types == null ? Collections.emptyList() : types;
        if (collection == null) {
            LazyTypeConverter.$$$reportNull$$$0(0);
        }
        return collection;
    }

    public LazyType fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        LazyType lazyType = LazyTypeConverter.getLazyType(s);
        if (lazyType == null || !this.getVariants(context).contains((Object)lazyType)) {
            return null;
        }
        return lazyType;
    }

    public String toString(@Nullable LazyType lazyType, ConvertContext context) {
        return lazyType == null ? null : lazyType.getValue();
    }

    @Nullable
    private static LazyType getLazyType(String s) {
        for (LazyType type : LazyType.values()) {
            if (!type.getValue().equals(s)) continue;
            return type;
        }
        return null;
    }

    static {
        List<LazyType> trueFalse = Arrays.asList(LazyType.TRUE, LazyType.FALSE);
        List<LazyType> trueFalseExtra = Arrays.asList(LazyType.TRUE, LazyType.FALSE, LazyType.EXTRA);
        List<LazyType> falseProxyNoproxy = Arrays.asList(LazyType.FALSE, LazyType.PROXY, LazyType.NO_PROXY);
        List<LazyType> falseProxy = Arrays.asList(LazyType.FALSE, LazyType.PROXY);
        ourMapping.put(HbmAny.class, trueFalse);
        ourMapping.put(HbmBag.class, trueFalseExtra);
        ourMapping.put(HbmClass.class, trueFalse);
        ourMapping.put(HbmComponent.class, trueFalse);
        ourMapping.put(HbmIdbag.class, trueFalseExtra);
        ourMapping.put(HbmJoinedSubclass.class, trueFalse);
        ourMapping.put(HbmKeyManyToOne.class, falseProxy);
        ourMapping.put(HbmList.class, trueFalseExtra);
        ourMapping.put(HbmManyToMany.class, falseProxy);
        ourMapping.put(HbmManyToOne.class, falseProxyNoproxy);
        ourMapping.put(HbmMap.class, trueFalseExtra);
        ourMapping.put(HbmOneToOne.class, falseProxyNoproxy);
        ourMapping.put(HbmProperty.class, trueFalse);
        ourMapping.put(HbmSet.class, trueFalseExtra);
        ourMapping.put(HbmSubclass.class, trueFalse);
        ourMapping.put(HbmUnionSubclass.class, trueFalse);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/model/converters/LazyTypeConverter", "getVariants"));
    }
}

