/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.engine;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.DataBus;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.hibernate.HibernateBundle;
import com.intellij.hibernate.engine.HibernateConnectionManager;
import com.intellij.hibernate.facet.HibernateVersion;
import com.intellij.hibernate.model.HibernateDescriptorsConstants;
import com.intellij.hibernate.model.xml.config.HibernateConfiguration;
import com.intellij.hibernate.model.xml.config.SessionFactory;
import com.intellij.hibernate.remote.HibernateFacade;
import com.intellij.hibernate.remote.RemoteConfiguration;
import com.intellij.hibernate.remote.RemoteSession;
import com.intellij.hibernate.remote.RemoteSessionFactory;
import com.intellij.hibernate.util.HibernateUtil;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.jam.JamElement;
import com.intellij.jam.JavaLibraryUtils;
import com.intellij.jpa.engine.JpaEngine;
import com.intellij.jpa.engine.JpaEngineBase;
import com.intellij.jpa.engine.JpaTemplateDescriptor;
import com.intellij.jpa.remote.RemoteQuery;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.helpers.PersistenceUnitModelHelper;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileUtil;
import com.intellij.util.descriptors.ConfigFileVersion;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ModelMergerUtil;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class HibernateEngine
extends JpaEngineBase {
    private File myTemporaryHibernateConfig;
    private RemoteSession mySession;
    private HibernateFacade myFacade;
    private RemoteConfiguration myHibernateConfiguration;
    private RemoteSessionFactory mySessionFactory;

    public static boolean isAvailable(Module module) {
        return JavaLibraryUtils.hasLibraryClass((Module)module, (String)"org.hibernate.cfg.Configuration");
    }

    public HibernateEngine(DataBus.Producing messageBus, PersistencePackagePointer unitFile, ConsoleRunConfiguration configuration) {
        super(messageBus, unitFile, configuration);
    }

    protected void releaseConnection() {
        this.myFacade = null;
        HibernateConnectionManager.getInstance(this.getProject()).releaseConnection(this.myUnitFile, this.myConfiguration);
        this.removeTemporaryFiles();
    }

    private void ensureInitialized() throws Exception {
        try {
            if (this.myFacade.isClosed()) {
                throw new IllegalStateException();
            }
        }
        catch (Exception e) {
            this.removeTemporaryFiles();
            this.createConnection();
        }
    }

    private void createConnection() throws Exception {
        Project project = this.getProject();
        LocalDataSource dataSource = HibernateEngine.findDataSource((Project)project, (PersistencePackagePointer)this.myUnitFile);
        Trinity<File, Boolean, String> info = this.getHibernateConfig(dataSource);
        if (info == null) {
            return;
        }
        this.setRunConfigurationOptionsForDataSource(dataSource);
        HibernateFacade facade = HibernateConnectionManager.getInstance(project).getConnection(this.myUnitFile, this.myConfiguration);
        RemoteConfiguration configuration = facade.createConfiguration(((Boolean)info.second).booleanValue());
        configuration.configure(((File)info.first).getCanonicalPath());
        if (StringUtil.isNotEmpty((String)((String)info.third))) {
            configuration.setNamingStrategy((String)info.third);
        }
        RemoteSessionFactory sessionFactory = configuration.buildSessionFactory();
        RemoteSession session = sessionFactory.openSession();
        this.myFacade = facade;
        this.myHibernateConfiguration = configuration;
        this.mySessionFactory = sessionFactory;
        this.mySession = session;
    }

    private void removeTemporaryFiles() {
        File file = this.myTemporaryHibernateConfig;
        this.myTemporaryHibernateConfig = null;
        if (file != null) {
            FileUtil.delete((File)file);
        }
    }

    protected RemoteQuery createQuery(String query) throws Exception {
        this.ensureInitialized();
        return this.mySession.createQuery(query);
    }

    protected String getGeneratedDdlInner() throws Exception {
        this.ensureInitialized();
        String ddl1 = this.myHibernateConfiguration.generateSchemaCreationScript();
        String ddl2 = this.myHibernateConfiguration.generateDropSchemaScript();
        return "-- " + HibernateBundle.message("generate.ddl.create.comment", new Object[0]) + "\n" + ddl1 + "\n-- " + HibernateBundle.message("generate.ddl.drop.comment", new Object[0]) + "\n" + ddl2;
    }

    protected String getGenerateSqlInner(String hqlQuery) throws Exception {
        this.ensureInitialized();
        return this.mySessionFactory.generateSql(hqlQuery);
    }

    private boolean isAnnoConfiguration() {
        PersistenceFacet facet = this.myUnitFile.getPersistenceFacet();
        PersistencePackage unit = this.myUnitFile.findElement();
        if (facet == null || unit == null) {
            return false;
        }
        if (JavaPsiFacade.getInstance((Project)this.getProject()).findClass("org.hibernate.cfg.AnnotationConfiguration", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)facet.getModule())) == null) {
            return false;
        }
        PersistenceUnitModelHelper helper = unit.getModelHelper();
        if (!helper.getPackages().isEmpty() || !helper.getClasses().isEmpty()) {
            return true;
        }
        PersistenceMappings mappings = facet.getEntityMappings(unit);
        for (PersistentEntity o : mappings.getModelHelper().getPersistentEntities()) {
            if (ModelMergerUtil.getImplementation((Object)o, JamElement.class) == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private Trinity<File, Boolean, String> getHibernateConfig(@Nullable LocalDataSource dataSource) {
        Credentials credentials = dataSource == null ? null : DatabaseCredentials.getInstance().getCredentials((DasDataSource)dataSource);
        return (Trinity)DumbService.getInstance((Project)this.getProject()).runReadActionInSmartMode(() -> {
            PersistencePackage unit = this.myUnitFile.findElement();
            PersistenceFacet facet = this.myUnitFile.getPersistenceFacet();
            if (unit == null || facet == null || facet.getModule().isDisposed()) {
                return null;
            }
            this.myTemporaryHibernateConfig = this.createTemporaryHibernateConfig(new JpaEngineBase.GenerationInfo(this.getProject(), facet, unit, dataSource, credentials));
            String namingStrategy = HibernateEngine.getNamingStrategy(unit, facet);
            return Trinity.create((Object)this.myTemporaryHibernateConfig, (Object)this.isAnnoConfiguration(), (Object)namingStrategy);
        });
    }

    @Nullable
    private static String getNamingStrategy(@NotNull PersistencePackage unit, @NotNull PersistenceFacet facet) {
        String namingStrategy;
        if (unit == null) {
            HibernateEngine.$$$reportNull$$$0(0);
        }
        if (facet == null) {
            HibernateEngine.$$$reportNull$$$0(1);
        }
        return StringUtil.isEmptyOrSpaces((String)(namingStrategy = facet.getNamingStrategy(unit))) ? unit.getModelHelper().getNamingStrategy() : namingStrategy;
    }

    @TestOnly
    public static String createHibernateConfigXml(@NotNull PersistenceFacet facet, @NotNull PersistencePackage unit) {
        Project project;
        DbDataSource dbElement;
        if (facet == null) {
            HibernateEngine.$$$reportNull$$$0(2);
        }
        if (unit == null) {
            HibernateEngine.$$$reportNull$$$0(3);
        }
        DatabaseSystem delegate = (dbElement = DbPsiFacade.getInstance((Project)(project = facet.getModule().getProject())).findDataSource(facet.getDataSourceId(unit))) != null ? dbElement.getDelegate() : null;
        LocalDataSource dataSource = delegate instanceof LocalDataSource ? (LocalDataSource)delegate : null;
        Credentials credentials = dataSource == null ? null : DatabaseCredentials.getInstance().getCredentials((DasDataSource)dataSource);
        return HibernateEngine.createHibernateConfigXml(new JpaEngineBase.GenerationInfo(project, facet, unit, dataSource, credentials));
    }

    private static String createHibernateConfigXml(@NotNull JpaEngineBase.GenerationInfo info) {
        if (info == null) {
            HibernateEngine.$$$reportNull$$$0(4);
        }
        HibernateVersion hibernateVersion = HibernateUtil.getHibernateVersion(info.facet.getModule());
        ConfigFileVersion configVersion = ConfigFileUtil.getVersionByName((ConfigFileMetaData)HibernateDescriptorsConstants.HIBERNATE_CONFIGURATION_META_DATA, (String)hibernateVersion.getName());
        configVersion = (ConfigFileVersion)ObjectUtils.chooseNotNull((Object)configVersion, (Object)HibernateDescriptorsConstants.HIBERNATE_CONFIGURATION_META_DATA.getDefaultVersion());
        FileTemplate template = FileTemplateManager.getInstance((Project)info.project).getJ2eeTemplate(configVersion.getTemplateName());
        XmlFile xmlFile = (XmlFile)PsiFileFactory.getInstance((Project)info.project).createFileFromText("a.hbm.xml", (FileType)StdFileTypes.XML, (CharSequence)template.getText());
        DomFileElement fileElement = DomManager.getDomManager((Project)info.project).getFileElement(xmlFile, HibernateConfiguration.class);
        assert (fileElement != null);
        SessionFactory sf = ((HibernateConfiguration)fileElement.getRootElement()).getSessionFactory();
        for (Object value : info.unit.getModelHelper().getPackages()) {
            sf.addMapping().getPackage().setStringValue(value.getStringValue());
        }
        for (Object value : info.unit.getModelHelper().getJarFiles()) {
            sf.addMapping().getJar().setStringValue(value.getStringValue());
        }
        List classes = info.unit.getModelHelper().getClasses();
        for (String name : JpaEngine.getMappedClasses((List)classes, (PersistencePackage)info.unit, (PersistenceFacet)info.facet)) {
            sf.addMapping().getClazz().setStringValue(name);
        }
        for (String resource : HibernateEngine.getResourceMappings(info)) {
            sf.addMapping().getResource().setStringValue(resource);
        }
        JpaTemplateDescriptor jpaTemplateDescriptor = JpaEngine.loadJpaTemplate((String)HibernateEngine.getJpaVersion(hibernateVersion));
        Properties properties = info.unit.getModelHelper().getPersistenceUnitProperties();
        for (Object object : properties.keySet()) {
            String name = (String)object;
            String fullPropertyName = HibernateUtil.getFullPropertyName(name);
            if (jpaTemplateDescriptor.getIgnored().contains(fullPropertyName) || jpaTemplateDescriptor.getPredefined().containsKey(fullPropertyName)) continue;
            HibernateUtil.setSessionFactoryProperty(sf, name, properties.getProperty(name));
        }
        for (Map.Entry entry : jpaTemplateDescriptor.getPredefined().entrySet()) {
            HibernateUtil.setSessionFactoryProperty(sf, (String)entry.getKey(), (String)entry.getValue());
        }
        if (info.dataSource != null) {
            LinkedHashMap<Object, String> props = new LinkedHashMap<Object, String>();
            DatabaseConnectionInterceptor.ProtoConnection protoConnection = DataSourceUtil.getProtoConnection((Project)info.project, (LocalDataSource)info.dataSource);
            String dsUrl = protoConnection == null ? info.dataSource.getUrl() : protoConnection.getUrl();
            Map dsProperties = protoConnection == null ? info.dataSource.getDriverProperties() : protoConnection.getConnectionProperties();
            props.put("connection.driver_class", info.dataSource.getDriverClass());
            props.put("connection.url", dsUrl);
            Credentials credentials = info.credentials;
            if (credentials != null) {
                props.put("connection.username", credentials.getUserName());
                props.put("connection.password", credentials.getPasswordAsString());
            }
            for (Map.Entry entry : dsProperties.entrySet()) {
                props.put("connection." + (String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : props.entrySet()) {
                String fullPropertyName = HibernateUtil.getFullPropertyName((String)entry.getKey());
                HibernateUtil.setSessionFactoryProperty(sf, fullPropertyName, (String)entry.getValue());
            }
        }
        return xmlFile.getText();
    }

    @NotNull
    private static Set<String> getResourceMappings(@NotNull JpaEngineBase.GenerationInfo info) {
        if (info == null) {
            HibernateEngine.$$$reportNull$$$0(5);
        }
        HashSet<String> resourceMappings = new HashSet<String>();
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)info.project).getFileIndex();
        for (GenericValue value : info.unit.getModelHelper().getMappingFiles(PersistenceMappings.class)) {
            Object relativePath;
            PersistenceMappings mappings = (PersistenceMappings)value.getValue();
            if (mappings == null) continue;
            PsiFile containingFile = mappings.getContainingFile();
            assert (containingFile != null);
            VirtualFile virtualFile = containingFile.getVirtualFile();
            VirtualFile sourceRoot = index.getSourceRootForFile(virtualFile);
            if (sourceRoot != null) {
                String pkgName = DirectoryIndex.getInstance((Project)info.project).getPackageName(sourceRoot);
                relativePath = (String)(StringUtil.isEmpty((String)pkgName) ? "" : pkgName.replace('.', '/') + "/") + VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)sourceRoot, (char)'/');
                ContainerUtil.addIfNotNull(resourceMappings, (Object)relativePath);
                continue;
            }
            if (virtualFile.getFileSystem() instanceof JarFileSystem) {
                String path = virtualFile.getPath();
                relativePath = path.substring(path.indexOf("!/") + "!/".length());
                ContainerUtil.addIfNotNull(resourceMappings, (Object)relativePath);
                continue;
            }
            ContainerUtil.addIfNotNull(resourceMappings, (Object)VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile).getAbsolutePath());
        }
        HashSet<String> hashSet = resourceMappings;
        if (hashSet == null) {
            HibernateEngine.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    @NotNull
    private static String getJpaVersion(HibernateVersion hibernateVersion) {
        return hibernateVersion == HibernateVersion.Hibernate_3_X ? "2.0" : "2.1";
    }

    private File createTemporaryHibernateConfig(@NotNull JpaEngineBase.GenerationInfo info) {
        if (info == null) {
            HibernateEngine.$$$reportNull$$$0(7);
        }
        @NonNls String fileName = info.facet.getModule().getName().replace(' ', '_') + "-hibernate-" + System.currentTimeMillis() + ".cfg.xml";
        String text = HibernateEngine.createHibernateConfigXml(info);
        File path = HibernateEngine.getTempDirectory((Project)info.project);
        File file = new File(path, fileName);
        this.writeTemporaryConfigText(file, text, info);
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/hibernate/engine/HibernateEngine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/hibernate/engine/HibernateEngine";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNamingStrategy";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createHibernateConfigXml";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getResourceMappings";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTemporaryHibernateConfig";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

