/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.util.DasUtil;
import com.intellij.hibernate.HibernateCustomJdbcTypeMapper;
import com.intellij.hibernate.model.xml.types.DbTypeMapping;
import com.intellij.hibernate.model.xml.types.HibernateReverseEngineering;
import com.intellij.hibernate.model.xml.types.TableFilter;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.CustomJdbcTypeMapper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J&\u0010\u0010\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u000bH\u0002J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/hibernate/HibernateCustomJdbcTypeMapper;", "Lcom/intellij/persistence/CustomJdbcTypeMapper;", "()V", "getMappedJavaTypeFor", "", "", "column", "Lcom/intellij/database/model/DasColumn;", "project", "Lcom/intellij/openapi/project/Project;", "locationAllowed", "", "filter", "Lcom/intellij/hibernate/model/xml/types/TableFilter;", "locationMatches", "actualColumn", "matchesConditions", "actual", "", "required", "isRegexp", "typeMatches", "actualType", "Lcom/intellij/database/model/DataType;", "mapping", "Lcom/intellij/hibernate/model/xml/types/DbTypeMapping;", "Companion", "intellij.hibernate"})
public final class HibernateCustomJdbcTypeMapper
implements CustomJdbcTypeMapper {
    private static final Pattern myDefaultPattern;
    private static final Map<String, Pattern> myCompiledPatterns;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<String> getMappedJavaTypeFor(@NotNull DasColumn column, @NotNull Project project) {
        Collection collection;
        boolean isExcluded;
        Iterable $this$any$iv;
        Object mappings;
        block8: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)column, (String)"column");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            List list = DomService.getInstance().getFileElements(HibernateReverseEngineering.class, project, GlobalSearchScope.projectScope((Project)project));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"DomService.getInstance()\u2026pe.projectScope(project))");
            Object object = (DomFileElement)CollectionsKt.firstOrNull((List)list);
            if (object == null || (object = (HibernateReverseEngineering)object.getRootElement()) == null) {
                List list2 = ContainerUtil.emptyList();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ContainerUtil.emptyList()");
                return list2;
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"DomService.getInstance()\u2026ContainerUtil.emptyList()");
            mappings = object;
            $this$any$iv = mappings.getTableFilters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TableFilter it = (TableFilter)element$iv;
                    boolean bl2 = false;
                    if (!(this.locationMatches(column, it) && !this.locationAllowed(it))) continue;
                    bl = true;
                    break block8;
                }
                bl = isExcluded = false;
            }
        }
        if (isExcluded) {
            List list = ContainerUtil.emptyList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ContainerUtil.emptyList()");
            return list;
        }
        List<DbTypeMapping> list = mappings.getTypeConversionMap().get(column.getDataType().typeName);
        if (list != null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            $this$any$iv = list;
            boolean $i$f$mapNotNull = false;
            Iterator iterator = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String string;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                DbTypeMapping it = (DbTypeMapping)element$iv$iv;
                boolean bl3 = false;
                DataType dataType = column.getDataType();
                Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"column.dataType");
                if ((this.typeMatches(dataType, it) && HibernateCustomJdbcTypeMapper.matchesConditions$default(this, column.isNotNull(), it.isNotNull(), false, 4, null) ? it.getJavaTypeName() : null) == null) continue;
                string = string;
                boolean bl4 = false;
                boolean bl5 = false;
                String it$iv$iv = string;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else {
            List list3 = ContainerUtil.emptyList();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"ContainerUtil.emptyList()");
            collection = list3;
        }
        return collection;
    }

    private final boolean typeMatches(DataType actualType, DbTypeMapping mapping) {
        if (!HibernateCustomJdbcTypeMapper.matchesConditions$default(this, actualType.typeName, mapping.getDbTypeName(), false, 4, null)) {
            return false;
        }
        if (!HibernateCustomJdbcTypeMapper.matchesConditions$default(this, actualType.getLength(), mapping.getSize(), false, 4, null)) {
            return false;
        }
        if (!HibernateCustomJdbcTypeMapper.matchesConditions$default(this, actualType.scale, mapping.getScale(), false, 4, null)) {
            return false;
        }
        return HibernateCustomJdbcTypeMapper.matchesConditions$default(this, actualType.getPrecision(), mapping.getPrecision(), false, 4, null);
    }

    private final boolean locationMatches(DasColumn actualColumn, TableFilter filter) {
        DasTable dasTable = actualColumn.getTable();
        String string = dasTable != null ? dasTable.getName() : null;
        GenericAttributeValue<String> genericAttributeValue = filter.getMatchName();
        Intrinsics.checkNotNullExpressionValue(genericAttributeValue, (String)"filter.matchName");
        if (!this.matchesConditions(string, genericAttributeValue.getValue(), true)) {
            return false;
        }
        String string2 = DasUtil.getSchema((DasObject)((DasObject)actualColumn));
        GenericAttributeValue<String> genericAttributeValue2 = filter.getMatchSchema();
        Intrinsics.checkNotNullExpressionValue(genericAttributeValue2, (String)"filter.matchSchema");
        if (!this.matchesConditions(string2, genericAttributeValue2.getValue(), true)) {
            return false;
        }
        String string3 = DasUtil.getCatalog((DasObject)((DasObject)actualColumn));
        GenericAttributeValue<String> genericAttributeValue3 = filter.getMatchCatalog();
        Intrinsics.checkNotNullExpressionValue(genericAttributeValue3, (String)"filter.matchCatalog");
        return this.matchesConditions(string3, genericAttributeValue3.getValue(), true);
    }

    private final boolean locationAllowed(TableFilter filter) {
        GenericAttributeValue<Boolean> genericAttributeValue = filter.getExclude();
        Intrinsics.checkNotNullExpressionValue(genericAttributeValue, (String)"filter.exclude");
        return Intrinsics.areEqual((Object)((Boolean)genericAttributeValue.getValue()), (Object)true) ^ true;
    }

    private final boolean matchesConditions(Object actual, Object required, boolean isRegexp) {
        Object object;
        if (required == null) {
            return true;
        }
        if (actual == null) {
            return false;
        }
        return isRegexp && required instanceof String && actual instanceof String ? ((object = myCompiledPatterns.get(required)) != null && (object = ((Pattern)object).matcher((CharSequence)actual)) != null ? ((Matcher)object).matches() : true) : Intrinsics.areEqual((Object)required, (Object)actual);
    }

    static /* synthetic */ boolean matchesConditions$default(HibernateCustomJdbcTypeMapper hibernateCustomJdbcTypeMapper, Object object, Object object2, boolean bl, int n, Object object3) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return hibernateCustomJdbcTypeMapper.matchesConditions(object, object2, bl);
    }

    static {
        Companion = new Companion(null);
        Pattern pattern = Pattern.compile(".*");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"Pattern.compile(\".*\")");
        myDefaultPattern = pattern;
        Map map = FactoryMap.create((Function)Companion.myCompiledPatterns.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"FactoryMap.create { getCachedOrCompile(it) }");
        myCompiledPatterns = map;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/hibernate/HibernateCustomJdbcTypeMapper$Companion;", "", "()V", "myCompiledPatterns", "", "", "Ljava/util/regex/Pattern;", "myDefaultPattern", "getCachedOrCompile", "value", "intellij.hibernate"})
    public static final class Companion {
        private final Pattern getCachedOrCompile(Object value) {
            Pattern pattern;
            if (!(value instanceof String)) {
                return myDefaultPattern;
            }
            try {
                Pattern pattern2 = Pattern.compile((String)value);
                Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"Pattern.compile(value)");
                pattern = pattern2;
            }
            catch (PatternSyntaxException ex) {
                pattern = myDefaultPattern;
            }
            return pattern;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ Pattern access$getCachedOrCompile(Companion $this, Object value) {
            return $this.getCachedOrCompile(value);
        }
    }
}

