/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util.projectStructure;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000`\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00010\u00010\u000f*\u00020\u0011\u001a \u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00012\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00160\u0015\u001a \u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00172\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00160\u0015\u001a\u0019\u0010\u0004\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u0002*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0011\u001a\n\u0010\u001a\u001a\u00020\u001b*\u00020\u0001\u001a\u001a\u0010\u001c\u001a\u00020\u001d*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 \"\u001c\u0010\u0000\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u0002*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0017\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0017\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\""}, d2={"module", "Lcom/intellij/openapi/module/Module;", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/psi/PsiElement;", "getModule", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/openapi/module/Module;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getSdk", "(Lcom/intellij/openapi/module/Module;)Lcom/intellij/openapi/projectRoots/Sdk;", "version", "Lcom/intellij/openapi/projectRoots/JavaSdkVersion;", "getVersion", "(Lcom/intellij/openapi/projectRoots/Sdk;)Lcom/intellij/openapi/projectRoots/JavaSdkVersion;", "allModules", "", "kotlin.jvm.PlatformType", "Lcom/intellij/openapi/project/Project;", "findLibrary", "Lcom/intellij/openapi/roots/libraries/Library;", "predicate", "Lkotlin/Function1;", "", "Lcom/intellij/openapi/roots/OrderEnumerator;", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "getModuleDir", "", "replaceFileRoot", "", "Lcom/intellij/openapi/roots/libraries/Library$ModifiableModel;", "oldFile", "Ljava/io/File;", "newFile", "kotlin.idea"})
public final class ProjectStructureUtilKt {
    @NotNull
    public static final List<Module> allModules(@NotNull Project $this$allModules) {
        Intrinsics.checkNotNullParameter((Object)$this$allModules, (String)"$this$allModules");
        ModuleManager moduleManager = ModuleManager.getInstance((Project)$this$allModules);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(this)");
        Object[] objectArray = moduleManager.getModules();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ModuleManager.getInstance(this).modules");
        return ArraysKt.toList((Object[])objectArray);
    }

    @Nullable
    public static final Library findLibrary(@NotNull Module $this$findLibrary, @NotNull Function1<? super Library, Boolean> predicate2) {
        Intrinsics.checkNotNullParameter((Object)$this$findLibrary, (String)"$this$findLibrary");
        Intrinsics.checkNotNullParameter(predicate2, (String)"predicate");
        OrderEnumerator orderEnumerator = OrderEnumerator.orderEntries((Module)$this$findLibrary);
        Intrinsics.checkNotNullExpressionValue((Object)orderEnumerator, (String)"OrderEnumerator.orderEntries(this)");
        return ProjectStructureUtilKt.findLibrary(orderEnumerator, predicate2);
    }

    @Nullable
    public static final Sdk getSdk(@NotNull Module $this$sdk) {
        Intrinsics.checkNotNullParameter((Object)$this$sdk, (String)"$this$sdk");
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)$this$sdk);
        Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(this)");
        return moduleRootManager.getSdk();
    }

    @Nullable
    public static final JavaSdkVersion getVersion(@NotNull Sdk $this$version) {
        Intrinsics.checkNotNullParameter((Object)$this$version, (String)"$this$version");
        return JavaSdk.getInstance().getVersion($this$version);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Library findLibrary(@NotNull OrderEnumerator $this$findLibrary, @NotNull Function1<? super Library, Boolean> predicate2) {
        void lib;
        Intrinsics.checkNotNullParameter((Object)$this$findLibrary, (String)"$this$findLibrary");
        Intrinsics.checkNotNullParameter(predicate2, (String)"predicate");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        $this$findLibrary.forEachLibrary(new Processor(predicate2, (Ref.ObjectRef)lib){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $lib;

            public final boolean process(Library library) {
                boolean bl;
                Library library2 = library;
                Intrinsics.checkNotNull((Object)library2);
                if (((Boolean)this.$predicate.invoke((Object)library2)).booleanValue()) {
                    this.$lib.element = library;
                    bl = false;
                } else {
                    bl = true;
                }
                return bl;
            }
            {
                this.$predicate = function1;
                this.$lib = objectRef;
            }
        });
        return (Library)lib.element;
    }

    @NotNull
    public static final String getModuleDir(@NotNull Module $this$getModuleDir) {
        Intrinsics.checkNotNullParameter((Object)$this$getModuleDir, (String)"$this$getModuleDir");
        String string = new File($this$getModuleDir.getModuleFilePath()).getParent();
        Intrinsics.checkNotNull((Object)string);
        return StringsKt.replace$default((String)string, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }

    public static final void replaceFileRoot(@NotNull Library.ModifiableModel $this$replaceFileRoot, @NotNull File oldFile, @NotNull File newFile) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceFileRoot, (String)"$this$replaceFileRoot");
        Intrinsics.checkNotNullParameter((Object)oldFile, (String)"oldFile");
        Intrinsics.checkNotNullParameter((Object)newFile, (String)"newFile");
        String string = VfsUtil.getUrlForLibraryRoot((File)oldFile);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VfsUtil.getUrlForLibraryRoot(oldFile)");
        String oldRoot = string;
        String string2 = VfsUtil.getUrlForLibraryRoot((File)newFile);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"VfsUtil.getUrlForLibraryRoot(newFile)");
        String newRoot = string2;
        Function1<OrderRootType, Unit> $fun$replaceInRootType$1 = new Function1<OrderRootType, Unit>($this$replaceFileRoot, oldRoot, newRoot){
            final /* synthetic */ Library.ModifiableModel $this_replaceFileRoot;
            final /* synthetic */ String $oldRoot;
            final /* synthetic */ String $newRoot;

            public final void invoke(@NotNull OrderRootType rootType) {
                Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
                for (String url : this.$this_replaceFileRoot.getUrls(rootType)) {
                    if (!Intrinsics.areEqual((Object)this.$oldRoot, (Object)url)) continue;
                    this.$this_replaceFileRoot.removeRoot(url, rootType);
                    this.$this_replaceFileRoot.addRoot(this.$newRoot, rootType);
                }
            }
            {
                this.$this_replaceFileRoot = modifiableModel;
                this.$oldRoot = string;
                this.$newRoot = string2;
                super(1);
            }
        };
        OrderRootType orderRootType = OrderRootType.CLASSES;
        Intrinsics.checkNotNullExpressionValue((Object)orderRootType, (String)"OrderRootType.CLASSES");
        $fun$replaceInRootType$1.invoke(orderRootType);
        OrderRootType orderRootType2 = OrderRootType.SOURCES;
        Intrinsics.checkNotNullExpressionValue((Object)orderRootType2, (String)"OrderRootType.SOURCES");
        $fun$replaceInRootType$1.invoke(orderRootType2);
    }

    @Nullable
    public static final Module getModule(@NotNull VirtualFile $this$getModule, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)$this$getModule, (String)"$this$getModule");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return ModuleUtilCore.findModuleForFile((VirtualFile)$this$getModule, (Project)project2);
    }

    @Nullable
    public static final Module getModule(@NotNull PsiElement $this$module) {
        Intrinsics.checkNotNullParameter((Object)$this$module, (String)"$this$module");
        return ModuleUtilCore.findModuleForPsiElement((PsiElement)$this$module);
    }
}

