/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.formatter.KotlinPackageEntry;
import org.jetbrains.kotlin.idea.core.formatter.KotlinPackageEntryTable;
import org.jetbrains.kotlin.idea.util.ImportPathComparator;
import org.jetbrains.kotlin.idea.util.ImportPathComparatorKt;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/util/ImportPathComparator;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "Lkotlin/Comparator;", "packageTable", "Lorg/jetbrains/kotlin/idea/core/formatter/KotlinPackageEntryTable;", "(Lorg/jetbrains/kotlin/idea/core/formatter/KotlinPackageEntryTable;)V", "bestEntryMatchIndex", "", "path", "ignoreAlias", "", "compare", "import1", "import2", "kotlin.idea"})
public final class ImportPathComparator
implements Comparator<ImportPath> {
    private final KotlinPackageEntryTable packageTable;

    @Override
    public int compare(@NotNull ImportPath import1, @NotNull ImportPath import2) {
        Intrinsics.checkNotNullParameter((Object)import1, (String)"import1");
        Intrinsics.checkNotNullParameter((Object)import2, (String)"import2");
        boolean ignoreAlias = import1.hasAlias() && import2.hasAlias();
        return ComparisonsKt.compareValuesBy((Object)import1, (Object)import2, (Function1[])new Function1[]{new Function1<ImportPath, Comparable<?>>(this, ignoreAlias){
            final /* synthetic */ ImportPathComparator this$0;
            final /* synthetic */ boolean $ignoreAlias;

            @Nullable
            public final Comparable<?> invoke(@NotNull ImportPath importPath) {
                Intrinsics.checkNotNullParameter((Object)importPath, (String)"import");
                return ImportPathComparator.access$bestEntryMatchIndex(this.this$0, importPath, this.$ignoreAlias);
            }
            {
                this.this$0 = importPathComparator;
                this.$ignoreAlias = bl;
                super(1);
            }
        }, compare.2.INSTANCE});
    }

    /*
     * WARNING - void declaration
     */
    private final int bestEntryMatchIndex(ImportPath path, boolean ignoreAlias) {
        KotlinPackageEntry bestEntryMatch = null;
        int bestIndex = -1;
        KotlinPackageEntry[] kotlinPackageEntryArray = this.packageTable.getEntries();
        int n = kotlinPackageEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            void index;
            KotlinPackageEntry entry = kotlinPackageEntryArray[n2];
            if (ImportPathComparatorKt.access$isBetterMatchForPackageThan(entry, bestEntryMatch, path, ignoreAlias)) {
                bestEntryMatch = entry;
                bestIndex = index;
            }
            ++index;
        }
        return bestIndex;
    }

    public ImportPathComparator(@NotNull KotlinPackageEntryTable packageTable) {
        Intrinsics.checkNotNullParameter((Object)packageTable, (String)"packageTable");
        this.packageTable = packageTable;
    }

    public static final /* synthetic */ int access$bestEntryMatchIndex(ImportPathComparator $this, ImportPath path, boolean ignoreAlias) {
        return $this.bestEntryMatchIndex(path, ignoreAlias);
    }
}

