/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.roots;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.service.project.manage.SourceFolderManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootProperties;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.kotlin.config.KotlinResourceRootTypeKt;
import org.jetbrains.kotlin.config.KotlinSourceRootType;
import org.jetbrains.kotlin.config.KotlinSourceRootTypeKt;
import org.jetbrains.kotlin.config.ResourceKotlinRootType;
import org.jetbrains.kotlin.config.SourceKotlinRootType;
import org.jetbrains.kotlin.config.TestResourceKotlinRootType;
import org.jetbrains.kotlin.config.TestSourceKotlinRootType;
import org.jetbrains.kotlin.idea.framework.KotlinSdkType;
import org.jetbrains.kotlin.idea.roots.ProjectRootUtilsKt;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000~\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001c\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u001a\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\r\u001a\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u0010\u0010\u001a\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u001a\"\u0010\u001d\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0010\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001\u001a\u000e\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!\u001a\u001c\u0010\"\u001a\u00020\u000b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\f\u001a\u00020\r\u001a\u0010\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012*\u00020\r\u001a\u001e\u0010'\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0\u0002\u0012\u0004\u0012\u00020)\u0018\u00010(*\u00020*\u001a\u0014\u0010+\u001a\n ,*\u0004\u0018\u00010)0)*\u00020*H\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001d\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006-"}, d2={"KOTLIN_AWARE_SOURCE_ROOT_TYPES", "", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "Lorg/jetbrains/jps/model/java/JavaSourceRootProperties;", "pathAsUrl", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/externalSystem/model/project/ContentRootData$SourceRoot;", "getPathAsUrl", "(Lcom/intellij/openapi/externalSystem/model/project/ContentRootData$SourceRoot;)Ljava/lang/String;", "collectSuitableDestinationSourceRoots", "", "module", "Lcom/intellij/openapi/module/Module;", "result", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getKotlinAwareDestinationSourceRoots", "", "project", "Lcom/intellij/openapi/project/Project;", "getSuitableDestinationSourceRoots", "isForGeneratedSources", "", "sourceFolder", "Lcom/intellij/openapi/roots/SourceFolder;", "isOutsideKotlinAwareSourceRoot", "psiFile", "Lcom/intellij/psi/PsiFile;", "isOutsideSourceRootSet", "sourceRootTypes", "migrateNonJvmSourceFolders", "modifiableRootModel", "Lcom/intellij/openapi/roots/ModifiableRootModel;", "populateNonJvmSourceRootTypes", "sourceSetNode", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lorg/jetbrains/plugins/gradle/model/data/GradleSourceSetData;", "collectKotlinAwareDestinationSourceRoots", "getMigratedSourceRootTypeWithProperties", "Lkotlin/Pair;", "Lorg/jetbrains/jps/model/JpsElement;", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRoot;", "getOrCreateProperties", "kotlin.jvm.PlatformType", "kotlin.idea"})
public final class ProjectRootUtilsKt {
    private static final Set<JpsModuleSourceRootType<JavaSourceRootProperties>> KOTLIN_AWARE_SOURCE_ROOT_TYPES;

    private static final JpsElement getOrCreateProperties(JpsModuleSourceRoot $this$getOrCreateProperties) {
        JpsElement jpsElement;
        block6: {
            block5: {
                jpsElement = $this$getOrCreateProperties.getProperties($this$getOrCreateProperties.getRootType());
                if (jpsElement == null) break block5;
                JpsElement jpsElement2 = jpsElement;
                boolean bl = false;
                boolean bl2 = false;
                JpsElement it = jpsElement2;
                boolean bl3 = false;
                JpsElement jpsElement3 = it;
                if (!(jpsElement3 instanceof JpsElementBase)) {
                    jpsElement3 = null;
                }
                JpsElementBase jpsElementBase = (JpsElementBase)jpsElement3;
                if (jpsElementBase != null) {
                    jpsElementBase.setParent(null);
                }
                if ((jpsElement = jpsElement2) != null) break block6;
            }
            jpsElement = (JpsElement)$this$getOrCreateProperties.getRootType().createDefaultProperties();
        }
        return jpsElement;
    }

    @Nullable
    public static final Pair<JpsModuleSourceRootType<JpsElement>, JpsElement> getMigratedSourceRootTypeWithProperties(@NotNull JpsModuleSourceRoot $this$getMigratedSourceRootTypeWithProperties) {
        JpsModuleSourceRootType jpsModuleSourceRootType;
        JpsModuleSourceRootType currentRootType;
        Intrinsics.checkNotNullParameter((Object)$this$getMigratedSourceRootTypeWithProperties, (String)"$this$getMigratedSourceRootTypeWithProperties");
        JpsModuleSourceRootType jpsModuleSourceRootType2 = $this$getMigratedSourceRootTypeWithProperties.getRootType();
        Intrinsics.checkNotNullExpressionValue((Object)jpsModuleSourceRootType2, (String)"rootType");
        JpsModuleSourceRootType jpsModuleSourceRootType3 = currentRootType = jpsModuleSourceRootType2;
        if (Intrinsics.areEqual((Object)jpsModuleSourceRootType3, (Object)JavaSourceRootType.SOURCE)) {
            SourceKotlinRootType sourceKotlinRootType = SourceKotlinRootType.INSTANCE;
            if (sourceKotlinRootType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.jps.model.module.JpsModuleSourceRootType<org.jetbrains.jps.model.JpsElement>");
            }
            jpsModuleSourceRootType = (JpsModuleSourceRootType)sourceKotlinRootType;
        } else if (Intrinsics.areEqual((Object)jpsModuleSourceRootType3, (Object)JavaSourceRootType.TEST_SOURCE)) {
            jpsModuleSourceRootType = (JpsModuleSourceRootType)TestSourceKotlinRootType.INSTANCE;
        } else if (Intrinsics.areEqual((Object)jpsModuleSourceRootType3, (Object)JavaResourceRootType.RESOURCE)) {
            jpsModuleSourceRootType = (JpsModuleSourceRootType)ResourceKotlinRootType.INSTANCE;
        } else if (Intrinsics.areEqual((Object)jpsModuleSourceRootType3, (Object)JavaResourceRootType.TEST_RESOURCE)) {
            jpsModuleSourceRootType = (JpsModuleSourceRootType)TestResourceKotlinRootType.INSTANCE;
        } else {
            return null;
        }
        if (jpsModuleSourceRootType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.jps.model.module.JpsModuleSourceRootType<org.jetbrains.jps.model.JpsElement>");
        }
        JpsModuleSourceRootType newSourceRootType = jpsModuleSourceRootType;
        return TuplesKt.to((Object)newSourceRootType, (Object)ProjectRootUtilsKt.getOrCreateProperties($this$getMigratedSourceRootTypeWithProperties));
    }

    /*
     * WARNING - void declaration
     */
    public static final void migrateNonJvmSourceFolders(@NotNull ModifiableRootModel modifiableRootModel) {
        Intrinsics.checkNotNullParameter((Object)modifiableRootModel, (String)"modifiableRootModel");
        ContentEntry[] contentEntryArray = modifiableRootModel.getContentEntries();
        int n = contentEntryArray.length;
        for (int i = 0; i < n; ++i) {
            ContentEntry contentEntry;
            ContentEntry contentEntry2 = contentEntry = contentEntryArray[i];
            Intrinsics.checkNotNullExpressionValue((Object)contentEntry2, (String)"contentEntry");
            SourceFolder[] sourceFolderArray = contentEntry2.getSourceFolders();
            int n2 = sourceFolderArray.length;
            for (int j = 0; j < n2; ++j) {
                void newSourceRootType;
                String url;
                Pair<JpsModuleSourceRootType<JpsElement>, JpsElement> pair;
                SourceFolder sourceFolder;
                SourceFolder sourceFolder2 = sourceFolder = sourceFolderArray[j];
                Intrinsics.checkNotNullExpressionValue((Object)sourceFolder2, (String)"sourceFolder");
                JpsModuleSourceRoot jpsModuleSourceRoot = sourceFolder2.getJpsElement();
                Intrinsics.checkNotNullExpressionValue((Object)jpsModuleSourceRoot, (String)"sourceFolder.jpsElement");
                if (ProjectRootUtilsKt.getMigratedSourceRootTypeWithProperties(jpsModuleSourceRoot) == null) {
                    continue;
                }
                JpsModuleSourceRootType jpsModuleSourceRootType = (JpsModuleSourceRootType)pair.component1();
                JpsElement properties2 = (JpsElement)pair.component2();
                Intrinsics.checkNotNullExpressionValue((Object)sourceFolder.getUrl(), (String)"sourceFolder.url");
                contentEntry.removeSourceFolder(sourceFolder);
                contentEntry.addSourceFolder(url, (JpsModuleSourceRootType)newSourceRootType, properties2);
            }
        }
        KotlinSdkType.Companion.setUpIfNeeded$default((KotlinSdkType.Companion)KotlinSdkType.Companion, null, null, (int)3, null);
    }

    private static final String getPathAsUrl(ContentRootData.SourceRoot $this$pathAsUrl) {
        String string = VirtualFileManager.constructUrl((String)"file", (String)FileUtil.toSystemIndependentName((String)$this$pathAsUrl.getPath()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VirtualFileManager.const\u2026temIndependentName(path))");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static final void populateNonJvmSourceRootTypes(@NotNull DataNode<GradleSourceSetData> sourceSetNode, @NotNull Module module) {
        Map externalToKotlinSourceTypes;
        DataNode it;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(sourceSetNode, (String)"sourceSetNode");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        SourceFolderManager sourceFolderManager = SourceFolderManager.getInstance((Project)module.getProject());
        Collection collection = ExternalSystemApiUtil.findAll(sourceSetNode, (Key)ProjectKeys.CONTENT_ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"ExternalSystemApiUtil.fi\u2026ProjectKeys.CONTENT_ROOT)");
        Collection contentRootDataNodes = collection;
        Iterable $this$mapNotNull$iv = contentRootDataNodes;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
            ContentRootData contentRootData;
            element$iv$iv = element$iv$iv$iv;
            boolean bl7 = false;
            it = (DataNode)element$iv$iv;
            boolean bl2 = false;
            DataNode dataNode = it;
            Intrinsics.checkNotNullExpressionValue((Object)dataNode, (String)"it");
            if ((ContentRootData)dataNode.getData() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            ContentRootData it$iv$iv = contentRootData;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List contentRootDataList = (List)destination$iv$iv;
        if (contentRootDataList.isEmpty()) {
            return;
        }
        Map $this$forEach$iv = externalToKotlinSourceTypes = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)ExternalSystemSourceType.SOURCE, (Object)SourceKotlinRootType.INSTANCE), TuplesKt.to((Object)ExternalSystemSourceType.TEST, (Object)TestSourceKotlinRootType.INSTANCE)});
        boolean $i$f$forEach2 = false;
        Map map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$flatMapTo$iv$iv;
            Map.Entry element$iv;
            Map.Entry $dstr$externalType$kotlinType = element$iv = iterator.next();
            boolean bl6 = false;
            element$iv$iv = $dstr$externalType$kotlinType;
            boolean bl7 = false;
            it = (ExternalSystemSourceType)element$iv$iv.getKey();
            element$iv$iv = $dstr$externalType$kotlinType;
            bl7 = false;
            KotlinSourceRootType kotlinType = (KotlinSourceRootType)element$iv$iv.getValue();
            Iterable $this$flatMap$iv = contentRootDataList;
            boolean $i$f$flatMap = false;
            Iterable iterable2 = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
                void externalType;
                ContentRootData it2 = (ContentRootData)element$iv$iv2;
                boolean bl8 = false;
                Iterable list$iv$iv = it2.getPaths((ExternalSystemSourceType)externalType);
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List sourcesRoots = (List)destination$iv$iv2;
            Iterable $this$forEach$iv2 = sourcesRoots;
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ContentRootData.SourceRoot it3 = (ContentRootData.SourceRoot)element$iv2;
                boolean bl9 = false;
                ContentRootData.SourceRoot sourceRoot = it3;
                Intrinsics.checkNotNullExpressionValue((Object)sourceRoot, (String)"it");
                if (FileUtil.exists((String)sourceRoot.getPath())) continue;
                sourceFolderManager.addSourceFolder(module, ProjectRootUtilsKt.getPathAsUrl(it3), (JpsModuleSourceRootType)kotlinType);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<VirtualFile> getKotlinAwareDestinationSourceRoots(@NotNull Project project2) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Module[] moduleArray = moduleManager.getModules();
        Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
        Module[] $this$flatMap$iv = moduleArray;
        boolean $i$f$flatMap = false;
        Module[] moduleArray2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        void var6_6 = $this$flatMapTo$iv$iv;
        int n = ((void)var6_6).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var6_6[i];
            boolean bl = false;
            void v2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
            Iterable list$iv$iv = ProjectRootUtilsKt.collectKotlinAwareDestinationSourceRoots((Module)v2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final List<VirtualFile> collectKotlinAwareDestinationSourceRoots(@NotNull Module $this$collectKotlinAwareDestinationSourceRoots) {
        Intrinsics.checkNotNullParameter((Object)$this$collectKotlinAwareDestinationSourceRoots, (String)"$this$collectKotlinAwareDestinationSourceRoots");
        Object[] objectArray = ProjectUtil.getRootManager((Module)$this$collectKotlinAwareDestinationSourceRoots).getContentEntries();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"rootManager\n        .contentEntries");
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)collectKotlinAwareDestinationSourceRoots.1.INSTANCE), (Function1)collectKotlinAwareDestinationSourceRoots.2.INSTANCE), (Function1)collectKotlinAwareDestinationSourceRoots.3.INSTANCE));
    }

    public static final boolean isOutsideSourceRootSet(@Nullable PsiFile psiFile, @NotNull Set<? extends JpsModuleSourceRootType<?>> sourceRootTypes) {
        Intrinsics.checkNotNullParameter(sourceRootTypes, (String)"sourceRootTypes");
        if (psiFile == null || psiFile instanceof PsiCodeFragment) {
            return false;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile file2 = virtualFile;
        if (file2.getFileSystem() instanceof NonPhysicalFileSystem) {
            return false;
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)psiFile.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(psiFile.project)");
        ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectRootManager.getIn\u2026siFile.project).fileIndex");
        ProjectFileIndex projectFileIndex2 = projectFileIndex;
        return !projectFileIndex2.isUnderSourceRootOfType(file2, sourceRootTypes) && !projectFileIndex2.isInLibrary(file2);
    }

    public static final boolean isOutsideKotlinAwareSourceRoot(@Nullable PsiFile psiFile) {
        return ProjectRootUtilsKt.isOutsideSourceRootSet(psiFile, KOTLIN_AWARE_SOURCE_ROOT_TYPES);
    }

    @NotNull
    public static final List<VirtualFile> getSuitableDestinationSourceRoots(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ArrayList roots2 = new ArrayList();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Module[] moduleArray = moduleManager.getModules();
        int n = moduleArray.length;
        for (int i = 0; i < n; ++i) {
            Module module;
            Module module2 = module = moduleArray[i];
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module");
            ProjectRootUtilsKt.collectSuitableDestinationSourceRoots(module2, roots2);
        }
        return roots2;
    }

    @NotNull
    public static final List<VirtualFile> getSuitableDestinationSourceRoots(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        ArrayList roots2 = new ArrayList();
        ProjectRootUtilsKt.collectSuitableDestinationSourceRoots(module, roots2);
        return roots2;
    }

    public static final void collectSuitableDestinationSourceRoots(@NotNull Module module, @NotNull List<VirtualFile> result2) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
        for (ContentEntry entry : moduleRootManager.getContentEntries()) {
            Iterator iterator = entry.getSourceFolders(KOTLIN_AWARE_SOURCE_ROOT_TYPES).iterator();
            while (iterator.hasNext()) {
                SourceFolder sourceFolder;
                SourceFolder sourceFolder2 = sourceFolder = (SourceFolder)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)sourceFolder2, (String)"sourceFolder");
                if (ProjectRootUtilsKt.isForGeneratedSources(sourceFolder2)) continue;
                ContainerUtil.addIfNotNull((Collection)result2, (Object)sourceFolder.getFile());
            }
        }
    }

    public static final boolean isForGeneratedSources(@NotNull SourceFolder sourceFolder) {
        Intrinsics.checkNotNullParameter((Object)sourceFolder, (String)"sourceFolder");
        JavaSourceRootProperties properties2 = (JavaSourceRootProperties)sourceFolder.getJpsElement().getProperties(KOTLIN_AWARE_SOURCE_ROOT_TYPES);
        JavaResourceRootProperties javaResourceProperties = (JavaResourceRootProperties)sourceFolder.getJpsElement().getProperties(JavaModuleSourceRootTypes.RESOURCES);
        JavaResourceRootProperties kotlinResourceProperties = (JavaResourceRootProperties)sourceFolder.getJpsElement().getProperties(KotlinResourceRootTypeKt.getALL_KOTLIN_RESOURCE_ROOT_TYPES());
        return properties2 != null && properties2.isForGeneratedSources() || javaResourceProperties != null && javaResourceProperties.isForGeneratedSources() || kotlinResourceProperties != null && kotlinResourceProperties.isForGeneratedSources();
    }

    static {
        Set set = JavaModuleSourceRootTypes.SOURCES;
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"JavaModuleSourceRootTypes.SOURCES");
        KOTLIN_AWARE_SOURCE_ROOT_TYPES = SetsKt.plus((Set)set, (Iterable)KotlinSourceRootTypeKt.getALL_KOTLIN_SOURCE_ROOT_TYPES());
    }

    public static final /* synthetic */ Set access$getKOTLIN_AWARE_SOURCE_ROOT_TYPES$p() {
        return KOTLIN_AWARE_SOURCE_ROOT_TYPES;
    }
}

