/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInliner.CodeToInline;
import org.jetbrains.kotlin.idea.codeInliner.CodeToInlineBuilder;
import org.jetbrains.kotlin.idea.intentions.ConvertReferenceToLambdaIntention;
import org.jetbrains.kotlin.idea.refactoring.inline.InlineUtilsKt;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtReturnExpression;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0007H\u0000\u001a\u0015\u0010\u000b\u001a\t\u0018\u00010\f\u00a2\u0006\u0002\b\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\t\u00a8\u0006\u0012"}, d2={"buildCodeToInline", "Lorg/jetbrains/kotlin/idea/codeInliner/CodeToInline;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "bodyOrInitializer", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isBlockBody", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "fallbackToSuperCall", "findCallableConflictForUsage", "", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "usage", "Lcom/intellij/psi/PsiElement;", "findSimpleNameReference", "Lcom/intellij/psi/PsiReference;", "kotlin.idea"})
public final class InlineUtilsKt {
    @Nullable
    public static final CodeToInline buildCodeToInline(@NotNull KtDeclaration declaration2, @NotNull KtExpression bodyOrInitializer, boolean isBlockBody, @Nullable Editor editor2, boolean fallbackToSuperCall) {
        DeclarationDescriptor descriptor2;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)bodyOrInitializer, (String)"bodyOrInitializer");
        DeclarationDescriptor declarationDescriptor = descriptor2 = ResolutionUtils.unsafeResolveToDescriptor$default((KtDeclaration)declaration2, null, (int)1, null);
        if (declarationDescriptor == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableDescriptor");
        }
        CodeToInlineBuilder builder = new CodeToInlineBuilder((CallableDescriptor)declarationDescriptor, ResolutionUtils.getResolutionFacade((KtElement)((KtElement)declaration2)), declaration2, fallbackToSuperCall);
        Function1 expressionMapper2 = isBlockBody ? (Function1)new Function1<KtExpression, Pair<? extends KtExpression, ? extends List<? extends KtExpression>>>(declaration2, editor2){
            final /* synthetic */ KtDeclaration $declaration;
            final /* synthetic */ Editor $editor;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Pair<KtExpression, List<KtExpression>> invoke(@NotNull KtExpression bodyOrInitializer) {
                boolean bl;
                KtReturnExpression lastReturn;
                List returnStatements2;
                List statements;
                block5: {
                    void $this$forEachDescendantOfType$iv$iv$iv$iv;
                    void $this$collectDescendantsOfTypeTo$iv$iv$iv;
                    void $this$collectDescendantsOfType$iv;
                    Intrinsics.checkNotNullParameter((Object)bodyOrInitializer, (String)"bodyOrInitializer");
                    KtBlockExpression cfr_ignored_0 = (KtBlockExpression)bodyOrInitializer;
                    List list = ((KtBlockExpression)bodyOrInitializer).getStatements();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"bodyOrInitializer.statements");
                    statements = list;
                    PsiElement psiElement2 = (PsiElement)bodyOrInitializer;
                    Function1 predicate$iv = (Function1)new Function1<KtReturnExpression, Boolean>(this){
                        final /* synthetic */ buildCodeToInline.expressionMapper.1 this$0;

                        public final boolean invoke(@NotNull KtReturnExpression it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            PsiElement $this$getStrictParentOfType$iv = (PsiElement)it;
                            boolean $i$f$getStrictParentOfType = false;
                            KtFunction function2 = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtFunction.class, (boolean)true);
                            if (function2 != null && Intrinsics.areEqual((Object)function2, (Object)this.this$0.$declaration) ^ true) {
                                return false;
                            }
                            String string = it.getLabelName();
                            boolean bl = false;
                            boolean bl2 = false;
                            String label2 = string;
                            boolean bl3 = false;
                            return label2 == null || Intrinsics.areEqual((Object)label2, (Object)this.this$0.$declaration.getName());
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    };
                    boolean $i$f$collectDescendantsOfType = false;
                    void $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType$iv;
                    boolean $i$f$collectDescendantsOfType2 = false;
                    void var9_9 = $this$collectDescendantsOfType$iv$iv;
                    Collection to$iv$iv$iv = new ArrayList<E>();
                    boolean $i$f$collectDescendantsOfTypeTo = false;
                    void var12_13 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
                    Function1 action$iv$iv$iv$iv = (Function1)new Function1<KtReturnExpression, Unit>(predicate$iv, to$iv$iv$iv){
                        final /* synthetic */ Function1 $predicate;
                        final /* synthetic */ Collection $to;
                        {
                            this.$predicate = $predicate;
                            this.$to = $to;
                            super(1);
                        }

                        /*
                         * Ignored method signature, as it can't be verified against descriptor
                         */
                        public final void invoke(@NotNull PsiElement it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                                this.$to.add(it);
                            }
                        }
                    };
                    boolean $i$f$forEachDescendantOfType = false;
                    $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
                        final /* synthetic */ Function1 $action;
                        {
                            this.$action = $action;
                        }

                        public void visitElement(@NotNull PsiElement element3) {
                            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                            PsiElement it = element3;
                            boolean bl = false;
                            super.visitElement(element3);
                            if (element3 instanceof KtReturnExpression) {
                                this.$action.invoke((Object)element3);
                            }
                        }
                    });
                    returnStatements2 = (List)to$iv$iv$iv;
                    Object object = CollectionsKt.lastOrNull((List)statements);
                    if (!(object instanceof KtReturnExpression)) {
                        object = null;
                    }
                    lastReturn = (KtReturnExpression)object;
                    Iterable $this$any$iv = returnStatements2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            KtReturnExpression it = (KtReturnExpression)element$iv;
                            boolean bl2 = false;
                            if (!(Intrinsics.areEqual((Object)it, (Object)lastReturn) ^ true)) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    String message2 = RefactoringBundle.getCannotRefactorMessage((String)(returnStatements2.size() > 1 ? KotlinBundle.message("error.text.inline.function.is.not.supported.for.functions.with.multiple.return.statements", new Object[0]) : KotlinBundle.message("error.text.inline.function.is.not.supported.for.functions.with.return.statements.not.at.the.end.of.the.body", new Object[0])));
                    CommonRefactoringUtil.showErrorHint((Project)this.$declaration.getProject(), (Editor)this.$editor, (String)message2, (String)KotlinBundle.message("title.inline.function", new Object[0]), null);
                    return null;
                }
                KtReturnExpression ktReturnExpression = lastReturn;
                return TuplesKt.to((Object)(ktReturnExpression != null ? ktReturnExpression.getReturnedExpression() : null), (Object)CollectionsKt.dropLast((List)statements, (int)returnStatements2.size()));
            }
            {
                this.$declaration = ktDeclaration;
                this.$editor = editor2;
                super(1);
            }
        } : (Function1)buildCodeToInline.expressionMapper.2.INSTANCE;
        return builder.prepareCodeToInlineWithAdvancedResolution(bodyOrInitializer, (Function1<? super KtExpression, ? extends Pair<? extends KtExpression, ? extends List<? extends KtExpression>>>)expressionMapper2);
    }

    @Nullable
    public static final PsiReference findSimpleNameReference(@NotNull Editor $this$findSimpleNameReference) {
        PsiReference psiReference;
        block8: {
            Intrinsics.checkNotNullParameter((Object)$this$findSimpleNameReference, (String)"$this$findSimpleNameReference");
            CaretModel caretModel = $this$findSimpleNameReference.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"caretModel");
            PsiReference psiReference2 = TargetElementUtil.findReference((Editor)$this$findSimpleNameReference, (int)caretModel.getOffset());
            if (psiReference2 == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiReference2, (String)"TargetElementUtil.findRe\u2026el.offset) ?: return null");
            PsiReference reference2 = psiReference2;
            PsiElement psiElement2 = reference2.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"reference.element");
            if (Intrinsics.areEqual((Object)psiElement2.getLanguage(), (Object)KotlinLanguage.INSTANCE) ^ true) {
                psiReference = reference2;
            } else if (reference2 instanceof KtSimpleNameReference) {
                psiReference = reference2;
            } else if (reference2 instanceof PsiMultiReference) {
                PsiReference[] psiReferenceArray = ((PsiMultiReference)reference2).getReferences();
                Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"reference.references");
                PsiReference[] $this$firstIsInstanceOrNull$iv = psiReferenceArray;
                boolean $i$f$firstIsInstanceOrNull = false;
                for (PsiReference element$iv : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv instanceof KtSimpleNameReference)) continue;
                    psiReference = element$iv;
                    break block8;
                }
                psiReference = null;
            } else {
                psiReference = null;
            }
        }
        return psiReference;
    }

    @Nullable
    public static final String findCallableConflictForUsage(@NotNull PsiElement usage) {
        Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
        PsiElement psiElement2 = usage.getParent();
        if (!(psiElement2 instanceof KtCallableReferenceExpression)) {
            psiElement2 = null;
        }
        KtCallableReferenceExpression ktCallableReferenceExpression = (KtCallableReferenceExpression)psiElement2;
        if (ktCallableReferenceExpression == null) {
            return null;
        }
        KtCallableReferenceExpression usageParent = ktCallableReferenceExpression;
        if (Intrinsics.areEqual((Object)usageParent.getCallableReference(), (Object)usage) ^ true) {
            return null;
        }
        if (ConvertReferenceToLambdaIntention.Companion.isApplicableTo$default(ConvertReferenceToLambdaIntention.Companion, usageParent, null, 2, null)) {
            return null;
        }
        return KotlinBundle.message("text.reference.cannot.be.converted.to.a.lambda", new Object[0]);
    }
}

