/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix.expectactual;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorNonRoot;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.shorten.DelayedRequestsWaitingSetKt;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.core.overrideImplement.MemberGenerateMode;
import org.jetbrains.kotlin.idea.core.overrideImplement.OverrideMemberChooserObject;
import org.jetbrains.kotlin.idea.core.overrideImplement.OverrideMemberChooserObjectKt;
import org.jetbrains.kotlin.idea.inspections.IntentionBasedInspectionKt;
import org.jetbrains.kotlin.idea.quickfix.TypeAccessibilityChecker;
import org.jetbrains.kotlin.idea.quickfix.expectactual.EscapeXMLKt;
import org.jetbrains.kotlin.idea.quickfix.expectactual.ExpectActualUtilsKt;
import org.jetbrains.kotlin.idea.quickfix.expectactual.KotlinTypeInaccessibleException;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.fqName.FqNameUtilKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.IntroduceUtilKt;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.idea.util.ExpressionExtKt;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.ExpectedActualDeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u00ce\u0001\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\u001a \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u001a<\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a \u0010!\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\"2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a \u0010!\u001a\u00020\b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a \u0010'\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020)H\u0002\u001a\"\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\n\b\u0002\u0010/\u001a\u0004\u0018\u000100\u001a\"\u00101\u001a\u00020\u001a*\u00020\u000e2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u0002032\u0006\u00104\u001a\u00020\u001aH\u0002\u001a\u0014\u00105\u001a\u00020\b*\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0012\u00106\u001a\u00020 *\u0002072\u0006\u00108\u001a\u00020 \u001a(\u00109\u001a\u0012\u0012\u0004\u0012\u00020.0:j\b\u0012\u0004\u0012\u00020.`;*\u00020\f2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001403\u001a,\u0010=\u001a\u00020 *\u0002072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010>\u001a\u00020\u001a2\u0006\u00108\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\f\u0010?\u001a\u00020.*\u0004\u0018\u00010\u0014\u001a\n\u0010@\u001a\u00020\u001a*\u00020\u0014\u001a\u001c\u0010A\u001a\u00020\u001a*\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u00104\u001a\u00020\u001a\u001a\u0014\u0010B\u001a\u00020\u001a*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a&\u0010C\u001a\u00020\b*\u00020\u00162\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u001d\u001a\u00020D2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u001c\u0010E\u001a\u00020\b*\u00020\u00162\u0006\u0010\u001d\u001a\u00020D2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a:\u0010F\u001a\b\u0012\u0004\u0012\u00020.03*\u0002072\u0006\u0010G\u001a\u00020 2\u0006\u0010H\u001a\u00020 2\u0006\u0010>\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010I\u001a\u00020JH\u0002\u001a$\u0010K\u001a\u00020.*\u00020L2\u000e\u0010M\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u0006032\b\b\u0002\u0010N\u001a\u00020O\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"INACCESSIBLE_MODIFIERS", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "kotlin.jvm.PlatformType", "forbiddenAnnotationFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "checkAndAdd", "", "annotationDescriptor", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "checker", "Lorg/jetbrains/kotlin/idea/quickfix/TypeAccessibilityChecker;", "target", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "createFileForDeclaration", "Lorg/jetbrains/kotlin/psi/KtFile;", "module", "Lcom/intellij/openapi/module/Module;", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "generateCallable", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "project", "Lcom/intellij/openapi/project/Project;", "generateExpect", "", "originalDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "generatedClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "repairAnnotationEntries", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorNonRoot;", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "repairAnnotations", "annotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "showInaccessibleDeclarationError", "element", "Lcom/intellij/psi/PsiElement;", "message", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "anyInaccessibleModifier", "modifiers", "", "showErrorHint", "checkAccessibility", "createClassHeaderCopyByText", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "originalClass", "findAndApplyExistingClasses", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "elements", "generateClassOrObject", "generateExpectClass", "getTypeDescription", "isAlwaysActual", "isCorrectAndHaveAccessibleModifiers", "isValidInModule", "repair", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "repairOverride", "repairSuperTypeList", "generated", "original", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "typesToString", "Lorg/jetbrains/kotlin/idea/quickfix/TypeAccessibilityChecker$Companion;", "types", "separator", "", "kotlin.idea"})
public final class ExpectActualUtilsKt {
    private static final Set<FqName> forbiddenAnnotationFqNames = SetsKt.setOf((Object[])new FqName[]{ExpectedActualDeclarationChecker.Companion.getOPTIONAL_EXPECTATION_FQ_NAME(), new FqName("kotlin.ExperimentalMultiplatform"), ExperimentalUsageChecker.Companion.getOPT_IN_FQ_NAME(), ExperimentalUsageChecker.Companion.getOLD_USE_EXPERIMENTAL_FQ_NAME()});
    private static final List<KtModifierKeywordToken> INACCESSIBLE_MODIFIERS = CollectionsKt.listOf((Object[])new KtModifierKeywordToken[]{KtTokens.PRIVATE_KEYWORD, KtTokens.CONST_KEYWORD, KtTokens.LATEINIT_KEYWORD});

    @Nullable
    public static final KtFile createFileForDeclaration(@NotNull Module module, @NotNull KtNamedDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        String string = declaration2.getName();
        if (string == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"declaration.name ?: return null");
        String fileName = string;
        PsiFile psiFile = declaration2.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"declaration.containingFile");
        PsiDirectory originalDir = psiFile.getContainingDirectory();
        PsiPackage containerPackage = JavaDirectoryService.getInstance().getPackage(originalDir);
        KtPackageDirective packageDirective = declaration2.getContainingKtFile().getPackageDirective();
        Object object = containerPackage;
        if (object == null || (object = object.getQualifiedName()) == null) {
            object = "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"containerPackage?.qualifiedName ?: \"\"");
        PsiDirectory psiDirectory = PackageUtilsKt.findOrCreateDirectoryForPackage((Module)module, (String)object);
        if (psiDirectory == null) {
            return null;
        }
        PsiDirectory directory = psiDirectory;
        return (KtFile)ApplicationUtilsKt.runWriteAction((Function0)((Function0)new Function0<KtFile>(fileName, directory, packageDirective){
            final /* synthetic */ String $fileName;
            final /* synthetic */ PsiDirectory $directory;
            final /* synthetic */ KtPackageDirective $packageDirective;

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final KtFile invoke() {
                KtFile ktFile;
                String packageName;
                String string;
                String fileNameWithExtension = this.$fileName + ".kt";
                PsiFile existingFile = this.$directory.findFile(fileNameWithExtension);
                KtPackageDirective ktPackageDirective = this.$packageDirective;
                if ((ktPackageDirective != null ? ktPackageDirective.getPackageNameExpression() : null) == null) {
                    FqName fqName = PackageUtilsKt.getFqNameWithImplicitPrefix((PsiDirectory)this.$directory);
                    string = fqName != null ? fqName.asString() : null;
                } else {
                    string = packageName = this.$packageDirective.getFqName().asString();
                }
                if (!(existingFile instanceof KtFile)) {
                    ktFile = KotlinRefactoringUtilKt.createKotlinFile(fileNameWithExtension, this.$directory, packageName);
                    return ktFile;
                }
                KtPackageDirective existingPackageDirective = ((KtFile)existingFile).getPackageDirective();
                Collection collection = ((KtFile)existingFile).getDeclarations();
                boolean bl = false;
                if (!collection.isEmpty()) {
                    KtPackageDirective ktPackageDirective2 = existingPackageDirective;
                    KtPackageDirective ktPackageDirective3 = this.$packageDirective;
                    if (Intrinsics.areEqual((Object)(ktPackageDirective2 != null ? ktPackageDirective2.getFqName() : null), (Object)(ktPackageDirective3 != null ? ktPackageDirective3.getFqName() : null)) ^ true) {
                        String newName2 = KotlinNameSuggester.INSTANCE.suggestNameByName(this.$fileName, (Function1)new Function1<String, Boolean>(this){
                            final /* synthetic */ createFileForDeclaration.1 this$0;

                            public final boolean invoke(@NotNull String it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return this.this$0.$directory.findFile(it + ".kt") == null;
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }) + ".kt";
                        ktFile = KotlinRefactoringUtilKt.createKotlinFile(newName2, this.$directory, packageName);
                        return ktFile;
                    }
                }
                ktFile = (KtFile)existingFile;
                return ktFile;
            }
            {
                this.$fileName = string;
                this.$directory = psiDirectory;
                this.$packageDirective = ktPackageDirective;
                super(0);
            }
        }));
    }

    @NotNull
    public static final KtClassOrObject createClassHeaderCopyByText(@NotNull KtPsiFactory $this$createClassHeaderCopyByText, @NotNull KtClassOrObject originalClass) {
        KtClassOrObject ktClassOrObject;
        block7: {
            KtClassOrObject ktClassOrObject2;
            Intrinsics.checkNotNullParameter((Object)$this$createClassHeaderCopyByText, (String)"$this$createClassHeaderCopyByText");
            Intrinsics.checkNotNullParameter((Object)originalClass, (String)"originalClass");
            String text2 = originalClass.getText();
            ktClassOrObject = originalClass;
            if (ktClassOrObject instanceof KtObjectDeclaration) {
                KtObjectDeclaration ktObjectDeclaration;
                if (((KtObjectDeclaration)originalClass).isCompanion()) {
                    String string = text2;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                    ktObjectDeclaration = $this$createClassHeaderCopyByText.createCompanionObject(string);
                } else {
                    String string = text2;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                    ktObjectDeclaration = $this$createClassHeaderCopyByText.createObject(string);
                }
                ktClassOrObject2 = (KtClassOrObject)ktObjectDeclaration;
            } else if (ktClassOrObject instanceof KtEnumEntry) {
                String string = text2;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                ktClassOrObject2 = (KtClassOrObject)$this$createClassHeaderCopyByText.createEnumEntry(string);
            } else {
                String string = text2;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                ktClassOrObject2 = (KtClassOrObject)$this$createClassHeaderCopyByText.createClass(string);
            }
            ktClassOrObject = ktClassOrObject2;
            boolean bl = false;
            boolean bl2 = false;
            KtClassOrObject $this$apply = ktClassOrObject;
            boolean bl3 = false;
            Iterable $this$forEach$iv = $this$apply.getDeclarations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtDeclaration p1 = (KtDeclaration)element$iv;
                boolean bl4 = false;
                p1.delete();
            }
            KtPrimaryConstructor ktPrimaryConstructor = $this$apply.getPrimaryConstructor();
            if (ktPrimaryConstructor == null) break block7;
            ktPrimaryConstructor.delete();
        }
        return ktClassOrObject;
    }

    @NotNull
    public static final String getTypeDescription(@Nullable KtNamedDeclaration $this$getTypeDescription) {
        KtNamedDeclaration ktNamedDeclaration = $this$getTypeDescription;
        return ktNamedDeclaration instanceof KtObjectDeclaration ? KotlinBundle.message("text.object", new Object[0]) : (ktNamedDeclaration instanceof KtClass ? (((KtClass)$this$getTypeDescription).isInterface() ? KotlinBundle.message("text.interface", new Object[0]) : (((KtClass)$this$getTypeDescription).isEnum() ? KotlinBundle.message("text.enum.class", new Object[0]) : (((KtClass)$this$getTypeDescription).isAnnotation() ? KotlinBundle.message("text.annotation.class", new Object[0]) : KotlinBundle.message("text.class", new Object[0])))) : (ktNamedDeclaration instanceof KtProperty || ktNamedDeclaration instanceof KtParameter ? KotlinBundle.message("text.property", new Object[0]) : (ktNamedDeclaration instanceof KtFunction ? KotlinBundle.message("text.function", new Object[0]) : KotlinBundle.message("text.declaration", new Object[0]))));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KtClassOrObject generateClassOrObject(@NotNull KtPsiFactory $this$generateClassOrObject, @NotNull Project project2, boolean generateExpectClass, @NotNull KtClassOrObject originalClass, @NotNull TypeAccessibilityChecker checker) {
        DeclarationDescriptor descriptor2;
        DeclarationDescriptor descriptor3;
        Intrinsics.checkNotNullParameter((Object)$this$generateClassOrObject, (String)"$this$generateClassOrObject");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)originalClass, (String)"originalClass");
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        KtClassOrObject generatedClass2 = ExpectActualUtilsKt.createClassHeaderCopyByText($this$generateClassOrObject, originalClass);
        BindingContext context2 = ResolutionUtils.analyzeWithContent((KtDeclaration)((KtDeclaration)originalClass));
        Collection<String> superNames = ExpectActualUtilsKt.repairSuperTypeList($this$generateClassOrObject, generatedClass2, originalClass, generateExpectClass, checker, context2);
        List list = generatedClass2.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"generatedClass.annotationEntries");
        Iterable iterable = list;
        List list2 = originalClass.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"originalClass.annotationEntries");
        Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)iterable, (Iterable)list2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void generatedEntry;
            AnnotationDescriptor annotationDescriptor;
            Pair $dstr$generatedEntry$originalEntry = (Pair)element$iv;
            boolean bl = false;
            KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)$dstr$generatedEntry$originalEntry.component1();
            KtAnnotationEntry originalEntry = (KtAnnotationEntry)$dstr$generatedEntry$originalEntry.component2();
            AnnotationDescriptor annotationDescriptor2 = annotationDescriptor = (AnnotationDescriptor)context2.get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)originalEntry);
            if (annotationDescriptor2 != null && ExpectActualUtilsKt.isValidInModule(annotationDescriptor2, checker)) continue;
            generatedEntry.delete();
        }
        if (generateExpectClass) {
            if (originalClass.isTopLevel()) {
                generatedClass2.addModifier(KtTokens.EXPECT_KEYWORD);
            } else {
                OverrideMemberChooserObjectKt.makeNotActual((KtModifierListOwner)((KtModifierListOwner)generatedClass2));
            }
            generatedClass2.removeModifier(KtTokens.DATA_KEYWORD);
        } else if (!(generatedClass2 instanceof KtEnumEntry)) {
            generatedClass2.addModifier(KtTokens.ACTUAL_KEYWORD);
        }
        Set existingFqNamesWithSuperTypes = CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)checker.getExistingTypeNames(), (Iterable)superNames));
        for (KtDeclaration originalDeclaration : originalClass.getDeclarations()) {
            PsiElement psiElement2;
            KtDeclaration ktDeclaration;
            if (PsiModificationUtilsKt.toDescriptor((KtDeclaration)originalDeclaration) == null) {
                continue;
            }
            if (generateExpectClass && !ExpectActualUtilKt.isEffectivelyActual((KtDeclaration)originalDeclaration, (boolean)false)) continue;
            KtDeclaration bl = originalDeclaration;
            if (bl instanceof KtClassOrObject) {
                ktDeclaration = (KtDeclaration)ExpectActualUtilsKt.generateClassOrObject($this$generateClassOrObject, project2, generateExpectClass, (KtClassOrObject)originalDeclaration, checker);
            } else {
                if (!(bl instanceof KtFunction) && !(bl instanceof KtProperty)) continue;
                ktDeclaration = (KtDeclaration)checker.runInContext((Collection)existingFqNamesWithSuperTypes, (Function1)new Function1<TypeAccessibilityChecker, KtCallableDeclaration>(project2, generateExpectClass, originalDeclaration, descriptor3, generatedClass2){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ boolean $generateExpectClass;
                    final /* synthetic */ KtDeclaration $originalDeclaration;
                    final /* synthetic */ DeclarationDescriptor $descriptor;
                    final /* synthetic */ KtClassOrObject $generatedClass;

                    @NotNull
                    public final KtCallableDeclaration invoke(@NotNull TypeAccessibilityChecker $this$runInContext) {
                        Intrinsics.checkNotNullParameter((Object)$this$runInContext, (String)"$receiver");
                        KtDeclaration ktDeclaration = this.$originalDeclaration;
                        if (ktDeclaration == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallableDeclaration");
                        }
                        DeclarationDescriptor declarationDescriptor = this.$descriptor;
                        if (declarationDescriptor == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableMemberDescriptor");
                        }
                        return ExpectActualUtilsKt.generateCallable(this.$project, this.$generateExpectClass, (KtDeclaration)((KtCallableDeclaration)ktDeclaration), (CallableMemberDescriptor)declarationDescriptor, this.$generatedClass, $this$runInContext);
                    }
                    {
                        this.$project = project2;
                        this.$generateExpectClass = bl;
                        this.$originalDeclaration = ktDeclaration;
                        this.$descriptor = declarationDescriptor;
                        this.$generatedClass = ktClassOrObject;
                        super(1);
                    }
                });
            }
            KtDeclaration generatedDeclaration2 = ktDeclaration;
            KtClassOrObject this_$iv = generatedClass2;
            boolean $i$f$addDeclaration = false;
            KtClassBody body$iv = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv);
            PsiElement psiElement3 = body$iv.getRBrace();
            if (psiElement3 == null) {
                PsiElement psiElement4 = body$iv.getLastChild();
                Intrinsics.checkNotNull((Object)psiElement4);
                psiElement2 = psiElement4;
            } else {
                psiElement2 = psiElement3;
            }
            psiElement3 = new PsiElement[]{PsiWhiteSpace.class};
            PsiElement anchor$iv = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement2, (Class[])psiElement3);
            PsiElement psiElement5 = body$iv.addAfter((PsiElement)generatedDeclaration2, anchor$iv);
            if (psiElement5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDeclaration");
            }
            KtDeclaration cfr_ignored_0 = (KtDeclaration)psiElement5;
        }
        if (!originalClass.isAnnotation() && !ExpressionExtKt.hasInlineModifier((KtModifierListOwner)originalClass)) {
            for (KtParameter originalProperty : originalClass.getPrimaryConstructorParameters()) {
                if (!originalProperty.hasValOrVar() || !PsiUtilsKt.hasActualModifier((KtModifierListOwner)((KtModifierListOwner)originalProperty))) continue;
                DeclarationDescriptor declarationDescriptor = PsiModificationUtilsKt.toDescriptor((KtDeclaration)((KtDeclaration)originalProperty));
                if (!(declarationDescriptor instanceof PropertyDescriptor)) {
                    declarationDescriptor = null;
                }
                if ((PropertyDescriptor)declarationDescriptor == null) {
                    continue;
                }
                checker.runInContext((Collection)existingFqNamesWithSuperTypes, (Function1)new Function1<TypeAccessibilityChecker, KtCallableDeclaration>(project2, generateExpectClass, originalProperty, (PropertyDescriptor)descriptor3, generatedClass2){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ boolean $generateExpectClass;
                    final /* synthetic */ KtParameter $originalProperty;
                    final /* synthetic */ PropertyDescriptor $descriptor;
                    final /* synthetic */ KtClassOrObject $generatedClass;

                    @NotNull
                    public final KtCallableDeclaration invoke(@NotNull TypeAccessibilityChecker $this$runInContext) {
                        PsiElement psiElement2;
                        Intrinsics.checkNotNullParameter((Object)$this$runInContext, (String)"$receiver");
                        KtCallableDeclaration generatedProperty = ExpectActualUtilsKt.generateCallable(this.$project, this.$generateExpectClass, (KtDeclaration)this.$originalProperty, (CallableMemberDescriptor)this.$descriptor, this.$generatedClass, $this$runInContext);
                        KtClassOrObject this_$iv = this.$generatedClass;
                        boolean $i$f$addDeclaration = false;
                        KtClassBody body$iv = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv);
                        PsiElement psiElement3 = body$iv.getRBrace();
                        if (psiElement3 == null) {
                            PsiElement psiElement4 = body$iv.getLastChild();
                            Intrinsics.checkNotNull((Object)psiElement4);
                            psiElement2 = psiElement4;
                        } else {
                            psiElement2 = psiElement3;
                        }
                        psiElement3 = new PsiElement[]{PsiWhiteSpace.class};
                        PsiElement anchor$iv = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement2, (Class[])psiElement3);
                        PsiElement psiElement5 = body$iv.addAfter((PsiElement)((KtDeclaration)generatedProperty), anchor$iv);
                        if (psiElement5 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallableDeclaration");
                        }
                        return (KtCallableDeclaration)((KtDeclaration)((KtCallableDeclaration)psiElement5));
                    }
                    {
                        this.$project = project2;
                        this.$generateExpectClass = bl;
                        this.$originalProperty = ktParameter;
                        this.$descriptor = propertyDescriptor;
                        this.$generatedClass = ktClassOrObject;
                        super(1);
                    }
                });
            }
        }
        KtPrimaryConstructor originalPrimaryConstructor = originalClass.getPrimaryConstructor();
        if (generatedClass2 instanceof KtClass && originalPrimaryConstructor != null && (!generateExpectClass || PsiUtilsKt.hasActualModifier((KtModifierListOwner)((KtModifierListOwner)originalPrimaryConstructor))) && (descriptor2 = PsiModificationUtilsKt.toDescriptor((KtDeclaration)((KtDeclaration)originalPrimaryConstructor))) instanceof FunctionDescriptor) {
            checker.runInContext((Collection)existingFqNamesWithSuperTypes, (Function1)new Function1<TypeAccessibilityChecker, PsiElement>(project2, generateExpectClass, originalPrimaryConstructor, descriptor2, generatedClass2){
                final /* synthetic */ Project $project;
                final /* synthetic */ boolean $generateExpectClass;
                final /* synthetic */ KtPrimaryConstructor $originalPrimaryConstructor;
                final /* synthetic */ DeclarationDescriptor $descriptor;
                final /* synthetic */ KtClassOrObject $generatedClass;

                public final PsiElement invoke(@NotNull TypeAccessibilityChecker $this$runInContext) {
                    Intrinsics.checkNotNullParameter((Object)$this$runInContext, (String)"$receiver");
                    KtCallableDeclaration expectedPrimaryConstructor = ExpectActualUtilsKt.generateCallable(this.$project, this.$generateExpectClass, (KtDeclaration)this.$originalPrimaryConstructor, (CallableMemberDescriptor)this.$descriptor, this.$generatedClass, $this$runInContext);
                    return KtClassKt.createPrimaryConstructorIfAbsent((KtClass)((KtClass)this.$generatedClass)).replace((PsiElement)expectedPrimaryConstructor);
                }
                {
                    this.$project = project2;
                    this.$generateExpectClass = bl;
                    this.$originalPrimaryConstructor = ktPrimaryConstructor;
                    this.$descriptor = declarationDescriptor;
                    this.$generatedClass = ktClassOrObject;
                    super(1);
                }
            });
        }
        return generatedClass2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final Collection<String> repairSuperTypeList(KtPsiFactory $this$repairSuperTypeList, KtClassOrObject generated, KtClassOrObject original, boolean generateExpectClass, TypeAccessibilityChecker checker, BindingContext context2) {
        List list;
        DeclarationDescriptor declarationDescriptor;
        LinkedHashSet superNames;
        block5: {
            Iterator iterator;
            Collection destination$iv$iv;
            block4: {
                block3: {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    Iterable $this$safeAs$iv;
                    boolean bl = false;
                    superNames = new LinkedHashSet();
                    Object object = (DeclarationDescriptor)context2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)original);
                    if (object == null) break block3;
                    declarationDescriptor = object;
                    boolean $i$f$safeAs = false;
                    Iterable iterable = $this$safeAs$iv;
                    if (!(iterable instanceof ClassDescriptor)) {
                        iterable = null;
                    }
                    if ((object = (ClassDescriptor)iterable) == null || (object = object.getDeclaredTypeParameters()) == null) break block3;
                    $this$safeAs$iv = (Iterable)object;
                    boolean $i$f$mapNotNull = false;
                    void var10_11 = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    iterator = $this$forEach$iv$iv$iv.iterator();
                    break block4;
                }
                list = null;
                break block5;
            }
            while (iterator.hasNext()) {
                String string;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv$iv;
                boolean bl2 = false;
                TypeParameterDescriptor typeParameterDescriptor = it;
                Intrinsics.checkNotNullExpressionValue((Object)typeParameterDescriptor, (String)"it");
                FqName fqName = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)typeParameterDescriptor));
                if ((fqName != null ? fqName.asString() : null) == null) continue;
                string = string;
                boolean bl3 = false;
                boolean bl4 = false;
                String it$iv$iv = string;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        declarationDescriptor = list;
        boolean bl = false;
        Object object = declarationDescriptor;
        if (object == null) {
            object = CollectionsKt.emptyList();
        }
        DeclarationDescriptor typeParametersFqName = object;
        checker.runInContext((Collection)CollectionsKt.plus((Collection)checker.getExistingTypeNames(), (Iterable)((Iterable)typeParametersFqName)), (Function1)new Function1<TypeAccessibilityChecker, Unit>($this$repairSuperTypeList, generated, original, context2, generateExpectClass, checker, superNames){
            final /* synthetic */ KtPsiFactory $this_repairSuperTypeList;
            final /* synthetic */ KtClassOrObject $generated;
            final /* synthetic */ KtClassOrObject $original;
            final /* synthetic */ BindingContext $context;
            final /* synthetic */ boolean $generateExpectClass;
            final /* synthetic */ TypeAccessibilityChecker $checker;
            final /* synthetic */ LinkedHashSet $superNames;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull TypeAccessibilityChecker $this$runInContext) {
                Intrinsics.checkNotNullParameter((Object)$this$runInContext, (String)"$receiver");
                Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)this.$generated.getSuperTypeListEntries(), (Iterable)this.$original.getSuperTypeListEntries());
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ClassDescriptor superClassDescriptor;
                    void generatedEntry;
                    ClassifierDescriptor classifierDescriptor;
                    Pair $dstr$generatedEntry$originalEntry = (Pair)element$iv;
                    boolean bl = false;
                    KtSuperTypeListEntry ktSuperTypeListEntry = (KtSuperTypeListEntry)$dstr$generatedEntry$originalEntry.component1();
                    KtSuperTypeListEntry originalEntry = (KtSuperTypeListEntry)$dstr$generatedEntry$originalEntry.component2();
                    KotlinType superType = (KotlinType)this.$context.get((ReadOnlySlice)BindingContext.TYPE, (Object)originalEntry.getTypeReference());
                    KotlinType kotlinType = superType;
                    if (!((kotlinType != null && (kotlinType = kotlinType.getConstructor()) != null ? kotlinType.getDeclarationDescriptor() : (classifierDescriptor = null)) instanceof ClassDescriptor)) {
                        classifierDescriptor = null;
                    }
                    if ((ClassDescriptor)classifierDescriptor == null) {
                        continue;
                    }
                    if (this.$generateExpectClass && !this.$checker.checkAccessibility(superType)) {
                        generatedEntry.delete();
                        continue;
                    }
                    Object object = FqNameUtilKt.getFqName((KotlinType)superType);
                    if (object != null && (object = object.shortName()) != null && (object = object.asString()) != null) {
                        Object object2 = object;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        Object it = object2;
                        boolean bl4 = false;
                        Collection collection = this.$superNames;
                        boolean bl5 = false;
                        collection.add(it);
                    }
                    if (!this.$generateExpectClass ? !(generatedEntry instanceof KtSuperTypeEntry) : !(generatedEntry instanceof KtSuperTypeCallEntry)) continue;
                    if (superClassDescriptor.getKind() != ClassKind.CLASS && superClassDescriptor.getKind() != ClassKind.ENUM_CLASS) continue;
                    String entryText = IdeDescriptorRenderers.SOURCE_CODE.renderType(superType);
                    KtSuperTypeListEntry newGeneratedEntry = this.$generateExpectClass ? (KtSuperTypeListEntry)this.$this_repairSuperTypeList.createSuperTypeEntry(entryText) : (KtSuperTypeListEntry)this.$this_repairSuperTypeList.createSuperTypeCallEntry(entryText + "()");
                    PsiElement $this$safeAs$iv = generatedEntry.replace((PsiElement)newGeneratedEntry);
                    boolean $i$f$safeAs = false;
                    PsiElement psiElement2 = $this$safeAs$iv;
                    if (!(psiElement2 instanceof KtElement)) {
                        psiElement2 = null;
                    }
                    KtElement ktElement = (KtElement)psiElement2;
                    if (ktElement == null) continue;
                    DelayedRequestsWaitingSetKt.addToBeShortenedDescendantsToWaitingSet((KtElement)ktElement);
                }
            }
            {
                this.$this_repairSuperTypeList = ktPsiFactory;
                this.$generated = ktClassOrObject;
                this.$original = ktClassOrObject2;
                this.$context = bindingContext2;
                this.$generateExpectClass = bl;
                this.$checker = typeAccessibilityChecker;
                this.$superNames = linkedHashSet;
                super(1);
            }
        });
        if (!generated.getSuperTypeListEntries().isEmpty()) return superNames;
        KtSuperTypeList ktSuperTypeList = generated.getSuperTypeList();
        if (ktSuperTypeList == null) return superNames;
        ktSuperTypeList.delete();
        return superNames;
    }

    @NotNull
    public static final KtCallableDeclaration generateCallable(@NotNull Project project2, boolean generateExpect, @NotNull KtDeclaration originalDeclaration, @NotNull CallableMemberDescriptor descriptor2, @Nullable KtClassOrObject generatedClass2, @NotNull TypeAccessibilityChecker checker) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)originalDeclaration, (String)"originalDeclaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        ExpectActualUtilsKt.checkAccessibility(descriptor2, checker);
        OverrideMemberChooserObject memberChooserObject = OverrideMemberChooserObject.Companion.create$default((OverrideMemberChooserObject.Companion)OverrideMemberChooserObject.Companion, (PsiElement)((PsiElement)originalDeclaration), (CallableMemberDescriptor)descriptor2, (CallableMemberDescriptor)descriptor2, (OverrideMemberChooserObject.BodyType)(generateExpect || descriptor2.getModality() == Modality.ABSTRACT ? (OverrideMemberChooserObject.BodyType)OverrideMemberChooserObject.BodyType.NO_BODY.INSTANCE : (OverrideMemberChooserObject.BodyType)OverrideMemberChooserObject.BodyType.EMPTY_OR_TEMPLATE.INSTANCE), (boolean)false, (int)16, null);
        KtCallableDeclaration ktCallableDeclaration = OverrideMemberChooserObjectKt.generateMember((OverrideMemberChooserObject)memberChooserObject, (KtClassOrObject)generatedClass2, (boolean)true, (Project)project2, (MemberGenerateMode)(generateExpect ? MemberGenerateMode.EXPECT : MemberGenerateMode.ACTUAL));
        boolean bl = false;
        boolean bl2 = false;
        KtCallableDeclaration $this$apply = ktCallableDeclaration;
        boolean bl3 = false;
        ExpectActualUtilsKt.repair($this$apply, generatedClass2, (CallableDescriptor)descriptor2, checker);
        return ktCallableDeclaration;
    }

    public static /* synthetic */ KtCallableDeclaration generateCallable$default(Project project2, boolean bl, KtDeclaration ktDeclaration, CallableMemberDescriptor callableMemberDescriptor, KtClassOrObject ktClassOrObject, TypeAccessibilityChecker typeAccessibilityChecker, int n, Object object) {
        if ((n & 0x10) != 0) {
            ktClassOrObject = null;
        }
        return ExpectActualUtilsKt.generateCallable(project2, bl, ktDeclaration, callableMemberDescriptor, ktClassOrObject, typeAccessibilityChecker);
    }

    private static final void checkAccessibility(CallableMemberDescriptor $this$checkAccessibility, TypeAccessibilityChecker checker) {
        Collection collection = checker.incorrectTypes((DeclarationDescriptor)$this$checkAccessibility);
        boolean bl = false;
        if (collection.isEmpty()) {
            boolean bl2 = false;
            return;
        }
        Collection errors = collection;
        throw (Throwable)new KotlinTypeInaccessibleException(CollectionsKt.toSet((Iterable)errors));
    }

    private static final void repair(KtCallableDeclaration $this$repair, KtClassOrObject generatedClass2, CallableDescriptor descriptor2, TypeAccessibilityChecker checker) {
        if (generatedClass2 != null) {
            ExpectActualUtilsKt.repairOverride($this$repair, descriptor2, checker);
        }
        ExpectActualUtilsKt.repairAnnotationEntries((KtModifierListOwner)$this$repair, (DeclarationDescriptorNonRoot)descriptor2, checker);
    }

    private static final void repairOverride(KtCallableDeclaration $this$repairOverride, CallableDescriptor descriptor2, TypeAccessibilityChecker checker) {
        DeclarationDescriptor declarationDescriptor;
        if (!$this$repairOverride.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            return;
        }
        Collection collection = descriptor2.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"descriptor.overriddenDescriptors");
        CallableDescriptor callableDescriptor = (CallableDescriptor)CollectionsKt.firstOrNull((Iterable)collection);
        DeclarationDescriptor superDescriptor = callableDescriptor != null ? callableDescriptor.getContainingDeclaration() : null;
        if (!CollectionsKt.contains((Iterable)checker.getExistingTypeNames(), (declarationDescriptor = superDescriptor) != null && (declarationDescriptor = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)declarationDescriptor)) != null && (declarationDescriptor = declarationDescriptor.shortName()) != null ? declarationDescriptor.asString() : null)) {
            $this$repairOverride.removeModifier(KtTokens.OVERRIDE_KEYWORD);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void repairAnnotationEntries(KtModifierListOwner target2, DeclarationDescriptorNonRoot descriptor2, TypeAccessibilityChecker checker) {
        block12: {
            KtParameter typeParameter;
            KtTypeReference receiver;
            DeclarationDescriptorNonRoot declarationDescriptorNonRoot;
            block13: {
                block11: {
                    ExpectActualUtilsKt.repairAnnotations(checker, target2, descriptor2.getAnnotations());
                    declarationDescriptorNonRoot = descriptor2;
                    if (!(declarationDescriptorNonRoot instanceof ValueParameterDescriptor)) break block11;
                    if (!(target2 instanceof KtParameter)) {
                        return;
                    }
                    KtTypeReference ktTypeReference = ((KtParameter)target2).getTypeReference();
                    if (ktTypeReference == null) {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference, (String)"target.typeReference ?: return");
                    KtTypeReference typeReference = ktTypeReference;
                    KotlinType kotlinType = ((ValueParameterDescriptor)descriptor2).getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"descriptor.type");
                    ExpectActualUtilsKt.repairAnnotationEntries(typeReference, kotlinType, checker);
                    break block12;
                }
                if (!(declarationDescriptorNonRoot instanceof TypeParameterDescriptor)) break block13;
                if (!(target2 instanceof KtTypeParameter)) {
                    return;
                }
                KtTypeReference ktTypeReference = ((KtTypeParameter)target2).getExtendsBound();
                if (ktTypeReference == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference, (String)"target.extendsBound ?: return");
                KtTypeReference extendsBound = ktTypeReference;
                Iterator iterator = ((TypeParameterDescriptor)descriptor2).getUpperBounds().iterator();
                while (iterator.hasNext()) {
                    KotlinType upperBound;
                    KotlinType kotlinType = upperBound = (KotlinType)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"upperBound");
                    ExpectActualUtilsKt.repairAnnotationEntries(extendsBound, kotlinType, checker);
                }
                break block12;
            }
            if (!(declarationDescriptorNonRoot instanceof CallableDescriptor)) break block12;
            ReceiverParameterDescriptor extension = ((CallableDescriptor)descriptor2).getExtensionReceiverParameter();
            KtModifierListOwner $this$safeAs$iv = target2;
            boolean $i$f$safeAs = false;
            KtModifierListOwner ktModifierListOwner = $this$safeAs$iv;
            if (!(ktModifierListOwner instanceof KtCallableDeclaration)) {
                ktModifierListOwner = null;
            }
            KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)ktModifierListOwner;
            Object object = receiver = ktCallableDeclaration != null ? ktCallableDeclaration.getReceiverTypeReference() : null;
            if (extension != null && receiver != null) {
                ExpectActualUtilsKt.repairAnnotationEntries((KtModifierListOwner)receiver, (DeclarationDescriptorNonRoot)extension, checker);
            }
            KtModifierListOwner $this$safeAs$iv2 = target2;
            boolean $i$f$safeAs2 = false;
            KtModifierListOwner ktModifierListOwner2 = $this$safeAs$iv2;
            if (!(ktModifierListOwner2 instanceof KtCallableDeclaration)) {
                ktModifierListOwner2 = null;
            }
            KtCallableDeclaration ktCallableDeclaration2 = (KtCallableDeclaration)ktModifierListOwner2;
            if (ktCallableDeclaration2 == null) {
                return;
            }
            KtCallableDeclaration callableDeclaration = ktCallableDeclaration2;
            List list = callableDeclaration.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"callableDeclaration.typeParameters");
            Iterable iterable = list;
            List list2 = ((CallableDescriptor)descriptor2).getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"descriptor.typeParameters");
            Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)iterable, (Iterable)list2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair $dstr$typeParameter$typeParameterDescriptor = (Pair)element$iv;
                boolean bl = false;
                KtTypeParameter ktTypeParameter = (KtTypeParameter)$dstr$typeParameter$typeParameterDescriptor.component1();
                TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)$dstr$typeParameter$typeParameterDescriptor.component2();
                void v12 = typeParameter;
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"typeParameter");
                KtModifierListOwner ktModifierListOwner3 = (KtModifierListOwner)v12;
                TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
                Intrinsics.checkNotNullExpressionValue((Object)typeParameterDescriptor2, (String)"typeParameterDescriptor");
                ExpectActualUtilsKt.repairAnnotationEntries(ktModifierListOwner3, (DeclarationDescriptorNonRoot)typeParameterDescriptor2, checker);
            }
            List list3 = callableDeclaration.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"callableDeclaration.valueParameters");
            Iterable iterable2 = list3;
            List list4 = ((CallableDescriptor)descriptor2).getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"descriptor.valueParameters");
            $this$forEach$iv = CollectionsKt.zip((Iterable)iterable2, (Iterable)list4);
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void valueParameter;
                Pair $dstr$valueParameter$valueParameterDescriptor = (Pair)element$iv;
                boolean bl = false;
                typeParameter = (KtParameter)$dstr$valueParameter$valueParameterDescriptor.component1();
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)$dstr$valueParameter$valueParameterDescriptor.component2();
                void v18 = valueParameter;
                Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"valueParameter");
                KtModifierListOwner ktModifierListOwner4 = (KtModifierListOwner)v18;
                ValueParameterDescriptor valueParameterDescriptor2 = valueParameterDescriptor;
                Intrinsics.checkNotNullExpressionValue((Object)valueParameterDescriptor2, (String)"valueParameterDescriptor");
                ExpectActualUtilsKt.repairAnnotationEntries(ktModifierListOwner4, (DeclarationDescriptorNonRoot)valueParameterDescriptor2, checker);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void repairAnnotationEntries(KtTypeReference typeReference, KotlinType type2, TypeAccessibilityChecker checker) {
        ExpectActualUtilsKt.repairAnnotations(checker, (KtModifierListOwner)typeReference, type2.getAnnotations());
        Object object = typeReference.getTypeElement();
        if (object != null && (object = object.getTypeArgumentsAsTypes()) != null && (object = CollectionsKt.zip((Iterable)((Iterable)object), (Iterable)type2.getArguments())) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void reference2;
                Pair $dstr$reference$projection = (Pair)element$iv;
                boolean bl = false;
                KtTypeReference ktTypeReference = (KtTypeReference)$dstr$reference$projection.component1();
                TypeProjection projection = (TypeProjection)$dstr$reference$projection.component2();
                void v1 = reference2;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"reference");
                KotlinType kotlinType = projection.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"projection.type");
                ExpectActualUtilsKt.repairAnnotationEntries((KtTypeReference)v1, kotlinType, checker);
            }
        }
    }

    private static final void repairAnnotations(TypeAccessibilityChecker checker, KtModifierListOwner target2, Annotations annotations2) {
        for (AnnotationDescriptor annotation : annotations2) {
            if (!ExpectActualUtilsKt.isValidInModule(annotation, checker)) continue;
            ExpectActualUtilsKt.checkAndAdd(annotation, checker, target2);
        }
    }

    private static final void checkAndAdd(AnnotationDescriptor annotationDescriptor, TypeAccessibilityChecker checker, KtModifierListOwner target2) {
        if (ExpectActualUtilsKt.isValidInModule(annotationDescriptor, checker)) {
            SourceElement $this$safeAs$iv = annotationDescriptor.getSource();
            boolean $i$f$safeAs = false;
            SourceElement sourceElement = $this$safeAs$iv;
            if (!(sourceElement instanceof KotlinSourceElement)) {
                sourceElement = null;
            }
            KotlinSourceElement kotlinSourceElement = (KotlinSourceElement)sourceElement;
            $this$safeAs$iv = kotlinSourceElement != null ? kotlinSourceElement.getPsi() : null;
            $i$f$safeAs = false;
            SourceElement sourceElement2 = $this$safeAs$iv;
            if (!(sourceElement2 instanceof KtAnnotationEntry)) {
                sourceElement2 = null;
            }
            KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)sourceElement2;
            if (ktAnnotationEntry == null) {
                return;
            }
            KtAnnotationEntry entry = ktAnnotationEntry;
            target2.addAnnotationEntry(entry);
        }
    }

    private static final boolean isValidInModule(AnnotationDescriptor $this$isValidInModule, TypeAccessibilityChecker checker) {
        return !CollectionsKt.contains((Iterable)forbiddenAnnotationFqNames, (Object)$this$isValidInModule.getFqName()) && checker.checkAccessibility($this$isValidInModule.getType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isAlwaysActual(@NotNull KtNamedDeclaration $this$isAlwaysActual) {
        Intrinsics.checkNotNullParameter((Object)$this$isAlwaysActual, (String)"$this$isAlwaysActual");
        KtNamedDeclaration $this$safeAs$iv = $this$isAlwaysActual;
        boolean $i$f$safeAs = false;
        KtNamedDeclaration ktNamedDeclaration = $this$safeAs$iv;
        if (!(ktNamedDeclaration instanceof KtParameter)) {
            ktNamedDeclaration = null;
        }
        KtParameter ktParameter = (KtParameter)ktNamedDeclaration;
        KtParameter ktParameter2 = ktParameter;
        if (ktParameter == null) return false;
        PsiElement psiElement2 = ktParameter2.getParent();
        ktParameter2 = psiElement2;
        if (psiElement2 == null) return false;
        PsiElement psiElement3 = ktParameter2.getParent();
        ktParameter2 = psiElement3;
        if (psiElement3 == null) return false;
        $this$safeAs$iv = ktParameter2;
        $i$f$safeAs = false;
        KtNamedDeclaration ktNamedDeclaration2 = $this$safeAs$iv;
        if (!(ktNamedDeclaration2 instanceof KtPrimaryConstructor)) {
            ktNamedDeclaration2 = null;
        }
        KtPrimaryConstructor ktPrimaryConstructor = (KtPrimaryConstructor)ktNamedDeclaration2;
        ktParameter2 = ktPrimaryConstructor;
        if (ktPrimaryConstructor == null) return false;
        boolean bl = ExpressionExtKt.mustHaveValOrVar((KtPrimaryConstructor)ktParameter2);
        return bl;
    }

    public static final boolean isCorrectAndHaveAccessibleModifiers(@NotNull TypeAccessibilityChecker $this$isCorrectAndHaveAccessibleModifiers, @NotNull KtNamedDeclaration declaration2, boolean showErrorHint) {
        Intrinsics.checkNotNullParameter((Object)$this$isCorrectAndHaveAccessibleModifiers, (String)"$this$isCorrectAndHaveAccessibleModifiers");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (ExpectActualUtilsKt.anyInaccessibleModifier((KtModifierListOwner)declaration2, (Collection<KtModifierKeywordToken>)INACCESSIBLE_MODIFIERS, showErrorHint)) {
            return false;
        }
        if (declaration2 instanceof KtFunction && ((KtFunction)declaration2).hasBody()) {
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration2));
            if (ktClassOrObject != null) {
                if (KotlinRefactoringUtilKt.isInterfaceClass((PsiNamedElement)ktClassOrObject)) {
                    if (showErrorHint) {
                        ExpectActualUtilsKt.showInaccessibleDeclarationError$default((PsiElement)declaration2, KotlinBundle.message("the.function.declaration.shouldn.t.have.a.default.implementation", new Object[0]), null, 4, null);
                    }
                    return false;
                }
            }
        }
        if (!showErrorHint) {
            return $this$isCorrectAndHaveAccessibleModifiers.checkAccessibility(declaration2);
        }
        Collection collection = $this$isCorrectAndHaveAccessibleModifiers.incorrectTypes(declaration2);
        boolean bl = false;
        if (collection.isEmpty()) {
            boolean bl2 = false;
            return true;
        }
        Collection types = collection;
        PsiElement psiElement2 = (PsiElement)declaration2;
        Object[] objectArray = new Object[2];
        String string = $this$isCorrectAndHaveAccessibleModifiers.getTargetModule().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"targetModule.name");
        objectArray[0] = string;
        objectArray[1] = ExpectActualUtilsKt.typesToString$default(TypeAccessibilityChecker.Companion, types, null, 2, null);
        ExpectActualUtilsKt.showInaccessibleDeclarationError$default(psiElement2, KotlinBundle.message("some.types.are.not.accessible.from.0.1", objectArray), null, 4, null);
        return false;
    }

    public static /* synthetic */ boolean isCorrectAndHaveAccessibleModifiers$default(TypeAccessibilityChecker typeAccessibilityChecker, KtNamedDeclaration ktNamedDeclaration, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return ExpectActualUtilsKt.isCorrectAndHaveAccessibleModifiers(typeAccessibilityChecker, ktNamedDeclaration, bl);
    }

    private static final boolean anyInaccessibleModifier(KtModifierListOwner $this$anyInaccessibleModifier, Collection<KtModifierKeywordToken> modifiers2, boolean showErrorHint) {
        for (KtModifierKeywordToken modifier : modifiers2) {
            if (!$this$anyInaccessibleModifier.hasModifier(modifier)) continue;
            if (showErrorHint) {
                ExpectActualUtilsKt.showInaccessibleDeclarationError$default((PsiElement)$this$anyInaccessibleModifier, KotlinBundle.message("the.declaration.has.0.modifier", modifier), null, 4, null);
            }
            return true;
        }
        return false;
    }

    public static final void showInaccessibleDeclarationError(@NotNull PsiElement element3, @NotNull String message2, @Nullable Editor editor2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Editor editor3 = editor2;
            if (editor3 == null) break block0;
            Editor editor4 = editor3;
            boolean bl = false;
            boolean bl2 = false;
            Editor it = editor4;
            boolean bl3 = false;
            Project project2 = element3.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"element.project");
            IntroduceUtilKt.showErrorHint(project2, editor2, EscapeXMLKt.escapeXml(message2), KotlinBundle.message("inaccessible.declaration", new Object[0]));
        }
    }

    public static /* synthetic */ void showInaccessibleDeclarationError$default(PsiElement psiElement2, String string, Editor editor2, int n, Object object) {
        if ((n & 4) != 0) {
            editor2 = IntentionBasedInspectionKt.findExistingEditor((PsiElement)psiElement2);
        }
        ExpectActualUtilsKt.showInaccessibleDeclarationError(psiElement2, string, editor2);
    }

    @NotNull
    public static final String typesToString(@NotNull TypeAccessibilityChecker.Companion $this$typesToString, @NotNull Collection<FqName> types, @NotNull CharSequence separator) {
        Intrinsics.checkNotNullParameter((Object)$this$typesToString, (String)"$this$typesToString");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.toSet((Iterable)types), (CharSequence)separator, null, null, (int)0, null, (Function1)typesToString.1.INSTANCE, (int)30, null);
    }

    public static /* synthetic */ String typesToString$default(TypeAccessibilityChecker.Companion companion, Collection collection, CharSequence charSequence, int n, Object object) {
        if ((n & 2) != 0) {
            charSequence = "\n";
        }
        return ExpectActualUtilsKt.typesToString(companion, collection, charSequence);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final HashSet<String> findAndApplyExistingClasses(@NotNull TypeAccessibilityChecker $this$findAndApplyExistingClasses, @NotNull Collection<? extends KtNamedDeclaration> elements2) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$findAndApplyExistingClasses, (String)"$this$findAndApplyExistingClasses");
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        Iterable $this$filterIsInstance$iv = elements2;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtClassOrObject)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List classes2 = (List)destination$iv$iv;
        while (true) {
            void $this$filterTo$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = classes2;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Iterable<String> destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                KtClassOrObject it = (KtClassOrObject)element$iv$iv;
                boolean bl2 = false;
                FqName fqName = it.getFqName();
                if ((fqName != null ? fqName.asString() : null) == null) continue;
                string = string;
                boolean bl3 = false;
                boolean bl4 = false;
                String it$iv$iv = string;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            HashSet existingNames = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv2));
            $this$findAndApplyExistingClasses.setExistingTypeNames((Collection)existingNames);
            Iterable $this$filter$iv = classes2;
            boolean $i$f$filter = false;
            destination$iv$iv2 = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtClassOrObject it = (KtClassOrObject)element$iv$iv;
                boolean bl = false;
                if (!ExpectActualUtilsKt.isCorrectAndHaveAccessibleModifiers$default($this$findAndApplyExistingClasses, (KtNamedDeclaration)it, false, 2, null)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List newExistingClasses = (List)destination$iv$iv3;
            if (classes2.size() == newExistingClasses.size()) {
                return existingNames;
            }
            classes2 = newExistingClasses;
        }
    }
}

