/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.AddNameToArgumentFix;
import org.jetbrains.kotlin.idea.quickfix.AddNameToArgumentFix$calculatePossibleArgumentNames$;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0002J&\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0002J\u001a\u0010\u0011\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00172\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0002J\b\u0010\u0018\u001a\u00020\u0015H\u0016J#\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0094\u0002J\"\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "argument", "(Lorg/jetbrains/kotlin/psi/KtValueArgument;)V", "addName", "", "project", "Lcom/intellij/openapi/project/Project;", "name", "Lorg/jetbrains/kotlin/name/Name;", "calculatePossibleArgumentNames", "", "chooseNameAndAdd", "editor", "Lcom/intellij/openapi/editor/Editor;", "names", "createArgumentWithName", "reformat", "", "getFamilyName", "", "getNamePopup", "Lcom/intellij/openapi/ui/popup/ListPopupStep;", "getText", "invoke", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "Companion", "kotlin.idea"})
public final class AddNameToArgumentFix
extends KotlinQuickFixAction<KtValueArgument> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    protected boolean isAvailable(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtValueArgument ktValueArgument = (KtValueArgument)this.getElement();
        if (ktValueArgument == null) {
            return false;
        }
        KtValueArgument element3 = ktValueArgument;
        if (element3.getArgumentExpression() == null) {
            return false;
        }
        Collection collection = this.calculatePossibleArgumentNames();
        boolean bl = false;
        return !collection.isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtValueArgument ktValueArgument = (KtValueArgument)this.getElement();
        if (ktValueArgument == null) return;
        KtValueArgument element3 = ktValueArgument;
        List<Name> possibleNames = this.calculatePossibleArgumentNames();
        Collection collection = possibleNames;
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        bl = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl3 = false;
            String string = "isAvailable() should be checked before invoke()";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (possibleNames.size() != 1 && editor2 != null) {
            JComponent jComponent = editor2.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"editor.component");
            if (jComponent.isShowing()) {
                this.chooseNameAndAdd(project2, editor2, possibleNames);
                return;
            }
        }
        this.addName(project2, element3, (Name)CollectionsKt.first(possibleNames));
    }

    @NotNull
    public String getText() {
        Name argumentName = (Name)CollectionsKt.singleOrNull(this.calculatePossibleArgumentNames());
        if (argumentName != null) {
            Object[] objectArray = new Object[1];
            String string = this.createArgumentWithName(argumentName, false).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"createArgumentWithName(a\u2026e, reformat = false).text");
            objectArray[0] = string;
            return KotlinBundle.message("fix.add.argument.name.text", objectArray);
        }
        return KotlinBundle.message("fix.add.argument.name.text.generic", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("fix.add.argument.name.family", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Name> calculatePossibleArgumentNames() {
        void $this$filterIsInstance$iv;
        KotlinType kotlinType;
        void $this$getParentOfType$iv;
        Object t = this.getElement();
        Intrinsics.checkNotNull(t);
        Object t2 = t;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        KtCallElement ktCallElement = (KtCallElement)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtCallElement.class, (boolean)strict$iv);
        if (ktCallElement == null) {
            return CollectionsKt.emptyList();
        }
        KtCallElement callElement2 = ktCallElement;
        Object t3 = this.getElement();
        Intrinsics.checkNotNull(t3);
        BindingContext context2 = ResolutionUtils.analyze((KtElement)((KtElement)t3), (BodyResolveMode)BodyResolveMode.PARTIAL);
        ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)callElement2), (BindingContext)context2);
        if (resolvedCall2 == null) {
            return CollectionsKt.emptyList();
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        Object t4 = this.getElement();
        Intrinsics.checkNotNull(t4);
        KtExpression ktExpression = ((KtValueArgument)t4).getArgumentExpression();
        if (ktExpression != null) {
            KtExpression ktExpression2 = ktExpression;
            boolean bl = false;
            boolean bl2 = false;
            KtExpression it = ktExpression2;
            boolean bl3 = false;
            kotlinType = context2.getType(it);
        } else {
            kotlinType = null;
        }
        KotlinType argumentType = kotlinType;
        Call call = resolvedCall3.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)call, (String)"resolvedCall.call");
        List list = call.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"resolvedCall.call.valueArguments");
        Sequence sequence2 = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<ValueArgument, ArgumentMapping>(resolvedCall3){
            final /* synthetic */ ResolvedCall $resolvedCall;

            @NotNull
            public final ArgumentMapping invoke(ValueArgument it) {
                return this.$resolvedCall.getArgumentMapping(it);
            }
            {
                this.$resolvedCall = resolvedCall2;
                super(1);
            }
        }));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence3 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)calculatePossibleArgumentNames$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        Set usedParameters2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)sequence3, (Function1)((Function1)new Function1<ArgumentMatch, Boolean>(argumentType){
            final /* synthetic */ KotlinType $argumentType;

            public final boolean invoke(@NotNull ArgumentMatch argumentMatch) {
                Intrinsics.checkNotNullParameter((Object)argumentMatch, (String)"argumentMatch");
                return this.$argumentType == null || KotlinTypeKt.isError((KotlinType)this.$argumentType) || !argumentMatch.isError();
            }
            {
                this.$argumentType = kotlinType;
                super(1);
            }
        })), (Function1)calculatePossibleArgumentNames.usedParameters.3.INSTANCE));
        List list2 = resolvedCall3.getResultingDescriptor().getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"resolvedCall.resultingDescriptor.valueParameters");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list2), (Function1)((Function1)new Function1<ValueParameterDescriptor, Boolean>(usedParameters2){
            final /* synthetic */ Set $usedParameters;

            public final boolean invoke(ValueParameterDescriptor it) {
                return !this.$usedParameters.contains(it);
            }
            {
                this.$usedParameters = set;
                super(1);
            }
        })), (Function1)calculatePossibleArgumentNames.2.INSTANCE));
    }

    private final void addName(Project project2, KtValueArgument argument2, Name name2) {
        ApplicationUtilsKt.executeWriteCommand((Project)project2, (String)KotlinBundle.message("fix.add.argument.name.family", new Object[0]), (Function0)((Function0)new Function0<Unit>(this, argument2, name2){
            final /* synthetic */ AddNameToArgumentFix this$0;
            final /* synthetic */ KtValueArgument $argument;
            final /* synthetic */ Name $name;

            public final void invoke() {
                this.$argument.replace((PsiElement)AddNameToArgumentFix.createArgumentWithName$default(this.this$0, this.$name, false, 2, null));
            }
            {
                this.this$0 = addNameToArgumentFix;
                this.$argument = ktValueArgument;
                this.$name = name2;
                super(0);
            }
        }));
    }

    private final KtValueArgument createArgumentWithName(Name name2, boolean reformat) {
        Object t = this.getElement();
        Intrinsics.checkNotNull(t);
        KtExpression ktExpression = ((KtValueArgument)t).getArgumentExpression();
        Intrinsics.checkNotNull((Object)ktExpression);
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"element!!.getArgumentExpression()!!");
        KtExpression argumentExpression = ktExpression;
        Object t2 = this.getElement();
        Intrinsics.checkNotNull(t2);
        KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default(t2, (boolean)false, (int)2, null);
        Object t3 = this.getElement();
        Intrinsics.checkNotNull(t3);
        return ktPsiFactory.createArgument(argumentExpression, name2, ((KtValueArgument)t3).getSpreadElement() != null, reformat);
    }

    static /* synthetic */ KtValueArgument createArgumentWithName$default(AddNameToArgumentFix addNameToArgumentFix, Name name2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return addNameToArgumentFix.createArgumentWithName(name2, bl);
    }

    private final void chooseNameAndAdd(Project project2, Editor editor2, List<Name> names) {
        JBPopupFactory.getInstance().createListPopup(this.getNamePopup(project2, names)).showInBestPositionFor(editor2);
    }

    private final ListPopupStep<Name> getNamePopup(Project project2, List<Name> names) {
        return (ListPopupStep)new BaseListPopupStep<Name>(this, project2, names, KotlinBundle.message("fix.add.argument.name.step.choose.parameter.name", new Object[0]), names){
            final /* synthetic */ AddNameToArgumentFix this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ List $names;

            @Nullable
            public PopupStep<?> onChosen(@NotNull Name selectedValue, boolean finalChoice) {
                Intrinsics.checkNotNullParameter((Object)selectedValue, (String)"selectedValue");
                T t = this.this$0.getElement();
                Intrinsics.checkNotNull(t);
                AddNameToArgumentFix.access$addName(this.this$0, this.$project, (KtValueArgument)t, selectedValue);
                return PopupStep.FINAL_CHOICE;
            }

            public Icon getIconFor(@NotNull Name name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return KotlinIcons.PARAMETER;
            }

            public String getTextFor(@NotNull Name name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return AddNameToArgumentFix.createArgumentWithName$default(this.this$0, name2, false, 2, null).getText();
            }
            {
                this.this$0 = this$0;
                this.$project = $captured_local_variable$1;
                this.$names = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
            }
        };
    }

    public AddNameToArgumentFix(@NotNull KtValueArgument argument2) {
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        super((PsiElement)argument2);
    }

    public static final /* synthetic */ void access$addName(AddNameToArgumentFix $this, Project project2, KtValueArgument argument2, Name name2) {
        $this.addName(project2, argument2, name2);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            void $this$getParentOfType$iv;
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            boolean strict$iv = false;
            boolean $i$f$getParentOfType = false;
            KtValueArgument ktValueArgument = (KtValueArgument)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtValueArgument.class, (boolean)strict$iv);
            if (ktValueArgument == null) {
                return null;
            }
            KtValueArgument argument2 = ktValueArgument;
            return new AddNameToArgumentFix(argument2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

