/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.internal;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.internal.DecompileFailedException;
import org.jetbrains.kotlin.idea.internal.KotlinBytecodeDecompilerTask;
import org.jetbrains.kotlin.idea.internal.KotlinDecompilerAdapterKt;
import org.jetbrains.kotlin.idea.internal.KotlinDecompilerService;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/internal/KotlinBytecodeDecompilerTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;)V", "getFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "kotlin.idea"})
public final class KotlinBytecodeDecompilerTask
extends Task.Backgroundable {
    @NotNull
    private final KtFile file;

    public void run(@NotNull ProgressIndicator indicator) {
        String string;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        KotlinDecompilerService kotlinDecompilerService = KotlinDecompilerService.Companion.getInstance();
        if (kotlinDecompilerService == null) {
            return;
        }
        KotlinDecompilerService decompilerService = kotlinDecompilerService;
        Object[] objectArray = new Object[1];
        String string2 = this.file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.name");
        objectArray[0] = string2;
        indicator.setText(KotlinBundle.message("internal.indicator.text.decompiling", objectArray));
        try {
            string = decompilerService.decompile(this.file);
        }
        catch (DecompileFailedException e) {
            string = null;
        }
        String decompiledText = string;
        ApplicationManager.getApplication().invokeLater(new Runnable(this, decompiledText){
            final /* synthetic */ KotlinBytecodeDecompilerTask this$0;
            final /* synthetic */ String $decompiledText;

            public final void run() {
                ApplicationUtilsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ run.1 this$0;

                    public final void invoke() {
                        block5: {
                            block4: {
                                if (!this.this$0.this$0.getFile().isValid()) break block4;
                                Project project2 = this.this$0.this$0.getFile().getProject();
                                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"file.project");
                                if (!project2.isDisposed()) break block5;
                            }
                            return;
                        }
                        if (this.this$0.$decompiledText == null) {
                            ApplicationManager.getApplication().invokeLater(new Runnable(this){
                                final /* synthetic */ run.1 this$0;

                                public final void run() {
                                    Object[] objectArray = new Object[1];
                                    String string = this.this$0.this$0.this$0.getFile().getName();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                                    objectArray[0] = string;
                                    Messages.showErrorDialog((String)KotlinBundle.message("internal.error.text.cannot.decompile", objectArray), (String)KotlinBundle.message("internal.title.decompiler.error", new Object[0]));
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            });
                            return;
                        }
                        VirtualFile root = KotlinDecompilerAdapterKt.getOrCreateDummyRoot();
                        String decompiledFileName = FileUtil.getNameWithoutExtension((String)this.this$0.this$0.getFile().getName()) + ".decompiled.java";
                        VirtualFile virtualFile = DummyFileSystem.getInstance().createChildFile(null, root, decompiledFileName);
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"DummyFileSystem.getInsta\u2026root, decompiledFileName)");
                        VirtualFile result2 = virtualFile;
                        VfsUtil.saveText((VirtualFile)result2, (String)this.this$0.$decompiledText);
                        KotlinDecompilerAdapterKt.setKotlinDecompiledFile(result2, true);
                        new OpenFileDescriptor(this.this$0.this$0.getFile().getProject(), result2).navigate(true);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
            {
                this.this$0 = kotlinBytecodeDecompilerTask;
                this.$decompiledText = string;
            }
        });
    }

    @NotNull
    public final KtFile getFile() {
        return this.file;
    }

    public KotlinBytecodeDecompilerTask(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        super(file2.getProject(), KotlinBundle.message("internal.action.text.decompile.kotlin.bytecode", new Object[0]));
        this.file = file2;
    }
}

