/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.loopToCallChain.sequence;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.ChainedCallGenerator;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.CommonUtilsKt;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.MatchingState;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.SequenceTransformation;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.TransformationMatch;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.TransformationMatcher;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.UtilsKt;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.sequence.MapTransformation;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.util.FuzzyType;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/sequence/FlatMapTransformation;", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/SequenceTransformation;", "loop", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "inputVariable", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "transform", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Lorg/jetbrains/kotlin/psi/KtForExpression;Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;Lorg/jetbrains/kotlin/psi/KtExpression;)V", "affectsIndex", "", "getAffectsIndex", "()Z", "getInputVariable", "()Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "getLoop", "()Lorg/jetbrains/kotlin/psi/KtForExpression;", "presentation", "", "getPresentation", "()Ljava/lang/String;", "getTransform", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "generateCode", "chainedCallGenerator", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/ChainedCallGenerator;", "Matcher", "kotlin.idea"})
public final class FlatMapTransformation
implements SequenceTransformation {
    @NotNull
    private final KtForExpression loop;
    @NotNull
    private final KtCallableDeclaration inputVariable;
    @NotNull
    private final KtExpression transform;

    @Override
    public boolean getAffectsIndex() {
        return true;
    }

    @Override
    @NotNull
    public String getPresentation() {
        return "flatMap{}";
    }

    @Override
    @NotNull
    public KtExpression generateCode(@NotNull ChainedCallGenerator chainedCallGenerator2) {
        Intrinsics.checkNotNullParameter((Object)chainedCallGenerator2, (String)"chainedCallGenerator");
        KtLambdaExpression lambda2 = UtilsKt.generateLambda(this.inputVariable, this.transform, chainedCallGenerator2.getReformat());
        return ChainedCallGenerator.DefaultImpls.generate$default(chainedCallGenerator2, "flatMap$0:'{}'", new Object[]{lambda2}, null, false, 12, null);
    }

    @Override
    @NotNull
    public KtForExpression getLoop() {
        return this.loop;
    }

    @NotNull
    public final KtCallableDeclaration getInputVariable() {
        return this.inputVariable;
    }

    @NotNull
    public final KtExpression getTransform() {
        return this.transform;
    }

    public FlatMapTransformation(@NotNull KtForExpression loop, @NotNull KtCallableDeclaration inputVariable, @NotNull KtExpression transform) {
        Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
        Intrinsics.checkNotNullParameter((Object)inputVariable, (String)"inputVariable");
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        this.loop = loop;
        this.inputVariable = inputVariable;
        this.transform = transform;
    }

    @Override
    @Nullable
    public SequenceTransformation mergeWithPrevious(@NotNull SequenceTransformation previousTransformation, boolean reformat) {
        Intrinsics.checkNotNullParameter((Object)previousTransformation, (String)"previousTransformation");
        return SequenceTransformation.DefaultImpls.mergeWithPrevious(this, previousTransformation, reformat);
    }

    @Override
    @NotNull
    public String buildPresentation(@Nullable String prevTransformationsPresentation) {
        return SequenceTransformation.DefaultImpls.buildPresentation(this, prevTransformationsPresentation);
    }

    @Override
    public int getChainCallCount() {
        return SequenceTransformation.DefaultImpls.getChainCallCount(this);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u000b\u001a\u00020\f*\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/sequence/FlatMapTransformation$Matcher;", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/TransformationMatcher;", "()V", "indexVariableAllowed", "", "getIndexVariableAllowed", "()Z", "match", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/TransformationMatch$Sequence;", "state", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/MatchingState;", "asSequence", "Lorg/jetbrains/kotlin/psi/KtExpression;", "reformat", "kotlin.idea"})
    public static final class Matcher
    implements TransformationMatcher {
        @NotNull
        public static final Matcher INSTANCE;

        @Override
        public boolean getIndexVariableAllowed() {
            return true;
        }

        @Override
        @Nullable
        public TransformationMatch.Sequence match(@NotNull MatchingState state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Object object = CollectionsKt.singleOrNull(state.getStatements());
            if (!(object instanceof KtForExpression)) {
                object = null;
            }
            KtForExpression ktForExpression = (KtForExpression)object;
            if (ktForExpression == null) {
                return null;
            }
            KtForExpression nestedLoop = ktForExpression;
            KtExpression ktExpression = nestedLoop.getLoopRange();
            if (ktExpression == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"nestedLoop.loopRange ?: return null");
            KtExpression transform = ktExpression;
            KotlinType kotlinType = ResolutionUtils.analyze((KtElement)((KtElement)transform), (BodyResolveMode)BodyResolveMode.PARTIAL).getType(transform);
            if (kotlinType == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"transform.analyze(BodyRe\u2026transform) ?: return null");
            KotlinType nestedSequenceType = kotlinType;
            KotlinBuiltIns builtIns = PlatformKt.getBuiltIns((KtElement)((KtElement)transform));
            KotlinType kotlinType2 = builtIns.getIterableType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"builtIns.iterableType");
            ClassDescriptor classDescriptor = builtIns.getIterable();
            Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"builtIns.iterable");
            List list = classDescriptor.getDeclaredTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"builtIns.iterable.declaredTypeParameters");
            FuzzyType iterableType = new FuzzyType(kotlinType2, (Collection)list);
            if (iterableType.checkIsSuperTypeOf(nestedSequenceType) == null) {
                return null;
            }
            KtExpression ktExpression2 = nestedLoop.getBody();
            if (ktExpression2 == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"nestedLoop.body ?: return null");
            KtExpression nestedLoopBody = ktExpression2;
            KtParameter ktParameter = nestedLoop.getLoopParameter();
            if (ktParameter == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktParameter, (String)"nestedLoop.loopParameter ?: return null");
            KtParameter newInputVariable = ktParameter;
            if (state.getIndexVariable() != null && CommonUtilsKt.hasUsages(state.getIndexVariable(), (KtElement)transform)) {
                MapTransformation mapIndexedTransformation = new MapTransformation(state.getOuterLoop(), state.getInputVariable(), state.getIndexVariable(), transform, false);
                KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)nestedLoop), (boolean)false, (int)2, null);
                Object[] objectArray = new Object[1];
                Name name2 = state.getInputVariable().getNameAsSafeName();
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"state.inputVariable.nameAsSafeName");
                objectArray[0] = name2;
                KtExpression inputVarExpression = CreateByPatternKt.createExpressionByPattern((KtPsiFactory)ktPsiFactory, (String)"$0", (Object[])objectArray, (boolean)state.getReformat());
                KtExpression transformToUse = state.getLazySequence() ? this.asSequence(inputVarExpression, state.getReformat()) : inputVarExpression;
                FlatMapTransformation flatMapTransformation = new FlatMapTransformation(state.getOuterLoop(), state.getInputVariable(), transformToUse);
                MatchingState newState = MatchingState.copy$default(state, null, nestedLoop, CollectionsKt.listOf((Object)nestedLoopBody), (KtCallableDeclaration)newInputVariable, null, false, null, false, null, null, null, 2033, null);
                return new TransformationMatch.Sequence((List<? extends SequenceTransformation>)CollectionsKt.listOf((Object[])new SequenceTransformation[]{mapIndexedTransformation, flatMapTransformation}), newState);
            }
            KtExpression transformToUse = state.getLazySequence() ? this.asSequence(transform, state.getReformat()) : transform;
            FlatMapTransformation transformation = new FlatMapTransformation(state.getOuterLoop(), state.getInputVariable(), transformToUse);
            MatchingState newState = MatchingState.copy$default(state, null, nestedLoop, CollectionsKt.listOf((Object)nestedLoopBody), (KtCallableDeclaration)newInputVariable, null, false, null, false, null, null, null, 2033, null);
            return new TransformationMatch.Sequence(transformation, newState);
        }

        private final KtExpression asSequence(KtExpression $this$asSequence, boolean reformat) {
            return CreateByPatternKt.createExpressionByPattern((KtPsiFactory)KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)$this$asSequence), (boolean)false, (int)2, null), (String)"$0.asSequence()", (Object[])new Object[]{$this$asSequence}, (boolean)reformat);
        }

        private Matcher() {
        }

        static {
            Matcher matcher2;
            INSTANCE = matcher2 = new Matcher();
        }

        @Override
        public boolean getShouldUseInputVariables() {
            return TransformationMatcher.DefaultImpls.getShouldUseInputVariables(this);
        }

        @Override
        public boolean getEmbeddedBreakOrContinuePossible() {
            return TransformationMatcher.DefaultImpls.getEmbeddedBreakOrContinuePossible(this);
        }
    }
}

