/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.inspections.collections.FunctionUtilsKt;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtElementUtilsKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.ArrayFqNames;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorChecks;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u00d2\u0001\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!H\u0002\u001a\u0010\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%\u001a \u0010&\u001a\u00020'*\b\u0012\u0004\u0012\u00020\f0(2\u0006\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u0005\u001a\u0012\u0010+\u001a\u00020'*\u00020,2\u0006\u0010-\u001a\u00020.\u001a\n\u0010/\u001a\u00020\u0019*\u00020\u0011\u001a\u0012\u0010/\u001a\u00020\u0019*\n\u0012\u0006\b\u0001\u0012\u00020\u001a00\u001a\n\u00101\u001a\u00020\f*\u000202\u001a\f\u00103\u001a\u0004\u0018\u00010\u0005*\u000204\u001a\u000e\u00105\u001a\u0004\u0018\u00010\u001a*\u00020\fH\u0000\u001a\n\u00106\u001a\u00020\f*\u000202\u001a\f\u00107\u001a\u0004\u0018\u00010\u0005*\u000208\u001a\f\u00109\u001a\u00020\u0019*\u0004\u0018\u00010\f\u001a\u0014\u0010:\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0004*\u00020\fH\u0002\u001a\n\u0010;\u001a\u00020\u0019*\u00020\u0011\u001a\n\u0010<\u001a\u00020\u0019*\u00020\f\u001a \u0010=\u001a\u00020\u0019*\u00020\f2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020\u00190?H\u0002\u001a\u0016\u0010A\u001a\u00020\u0019*\u00020B2\n\b\u0002\u0010C\u001a\u0004\u0018\u00010D\u001a\f\u0010E\u001a\u00020\u0019*\u00020@H\u0000\u001a\u0012\u0010F\u001a\u00020\u0019*\u00020\u00112\u0006\u0010G\u001a\u00020\u0005\u001a\f\u0010H\u001a\u00020\u0019*\u0004\u0018\u00010I\u001a\n\u0010J\u001a\u00020\u0019*\u00020\u0012\u001a\n\u0010K\u001a\u00020\u0019*\u00020I\u001a\f\u0010L\u001a\u00020\u0019*\u0004\u0018\u00010I\u001a\n\u0010M\u001a\u00020\u0019*\u000202\u001a\f\u0010N\u001a\u00020\u0019*\u0004\u0018\u00010I\u001a\u001c\u0010O\u001a\u0004\u0018\u00010.*\b\u0012\u0004\u0012\u00020.0P2\u0006\u0010Q\u001a\u00020\fH\u0000\u001a\u0014\u0010R\u001a\u00020\f*\u00020\f2\b\b\u0002\u0010S\u001a\u00020\u0019\u001a\f\u0010T\u001a\u0004\u0018\u00010@*\u00020\u001a\u001a\n\u0010U\u001a\u00020@*\u00020@\u001a$\u0010V\u001a\u00020\f*\u0002022\u0006\u0010W\u001a\u00020,2\u0006\u0010X\u001a\u00020\f2\b\b\u0002\u0010Y\u001a\u00020\u0019\u001a\u0012\u0010Z\u001a\u00020\u0019*\n\u0012\u0006\b\u0001\u0012\u00020\u001a00\u001a\u0010\u0010[\u001a\b\u0012\u0004\u0012\u00020\\0\u0004*\u00020\f\u001a\f\u0010]\u001a\u0004\u0018\u00010^*\u00020\u0011\u001a\u0016\u0010_\u001a\u0004\u0018\u00010\f*\u00020\f2\u0006\u0010S\u001a\u00020\u0019H\u0002\u001a\u001c\u0010`\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u001a\u0018\u000100*\u00020\u00122\u0006\u0010a\u001a\u00020b\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001d\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0004*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\"\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u0005*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\"\u0015\u0010\u0018\u001a\u00020\u0019*\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001b\"\u0015\u0010\u001c\u001a\u00020\u0019*\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001e\u00a8\u0006c"}, d2={"ARRAY_OF_METHODS", "", "Lorg/jetbrains/kotlin/name/Name;", "ENUM_STATIC_METHODS", "", "", "KOTLIN_BUILTIN_ENUM_FUNCTIONS", "Lorg/jetbrains/kotlin/name/FqName;", "NEGATABLE_OPERATORS", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "kotlin.jvm.PlatformType", "branches", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "getBranches", "(Lorg/jetbrains/kotlin/psi/KtIfExpression;)Ljava/util/List;", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "getCallExpression", "(Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;)Lorg/jetbrains/kotlin/psi/KtCallExpression;", "calleeName", "getCalleeName", "(Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;)Ljava/lang/String;", "isInvokeOperator", "", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)Z", "isOperatorOrCompatible", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Z", "getNegatedOperatorText", "token", "Lcom/intellij/psi/tree/IElementType;", "splitPropertyDeclaration", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "appendCallOrQualifiedExpression", "", "Lorg/jetbrains/kotlin/psi/BuilderByPattern;", "call", "newFunctionName", "appendSemicolonBeforeLambdaContainingElement", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "element", "Lcom/intellij/psi/PsiElement;", "canBeReplacedWithInvokeCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "deleteFirstReceiver", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "description", "Lorg/jetbrains/kotlin/psi/KtContainerNode;", "getCallableDescriptor", "getLeftMostReceiverExpression", "getParentLambdaLabelName", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "hasResultingIfWithoutElse", "ifBranchesOrThis", "isArrayOfMethod", "isExitStatement", "isExpressionOfTypeOrSubtype", "predicate", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/types/KotlinType;", "isFinalizeMethod", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "isFlexibleRecursive", "isMethodCall", "fqMethodName", "isOne", "Lorg/jetbrains/kotlin/psi/KtElement;", "isReceiverExpressionWithValue", "isReferenceToBuiltInEnumFunction", "isSizeOrLength", "isToString", "isZero", "lastWithPersistedElementOrNull", "Lkotlin/sequences/Sequence;", "elementShouldPersist", "negate", "reformat", "receiverType", "reflectToRegularFunctionType", "replaceFirstReceiver", "factory", "newReceiver", "safeAccess", "resolvedToArrayType", "resultingWhens", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "singleLambdaArgumentExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "specialNegation", "toResolvedCall", "bodyResolveMode", "Lorg/jetbrains/kotlin/resolve/lazy/BodyResolveMode;", "kotlin.idea"})
public final class UtilsKt {
    private static final Set<KtSingleValueToken> NEGATABLE_OPERATORS = SetsKt.setOf((Object[])new KtSingleValueToken[]{KtTokens.EQEQ, KtTokens.EXCLEQ, KtTokens.EQEQEQ, KtTokens.EXCLEQEQEQ, (KtSingleValueToken)KtTokens.IS_KEYWORD, (KtSingleValueToken)KtTokens.NOT_IS, (KtSingleValueToken)KtTokens.IN_KEYWORD, (KtSingleValueToken)KtTokens.NOT_IN, KtTokens.LT, KtTokens.LTEQ, KtTokens.GT, KtTokens.GTEQ});
    private static final Set<Name> ARRAY_OF_METHODS;
    private static final List<FqName> KOTLIN_BUILTIN_ENUM_FUNCTIONS;
    private static final List<String> ENUM_STATIC_METHODS;

    @Nullable
    public static final String description(@NotNull KtContainerNode $this$description) {
        Intrinsics.checkNotNullParameter((Object)$this$description, (String)"$this$description");
        ASTNode aSTNode = $this$description.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node");
        IElementType iElementType = aSTNode.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.THEN)) {
            return "if";
        }
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.ELSE)) {
            return "else";
        }
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.BODY)) {
            PsiElement psiElement2 = $this$description.getParent();
            if (psiElement2 instanceof KtWhileExpression) {
                return "while";
            }
            if (psiElement2 instanceof KtDoWhileExpression) {
                return "do...while";
            }
            if (psiElement2 instanceof KtForExpression) {
                return "for";
            }
        }
        return null;
    }

    public static final boolean isMethodCall(@NotNull KtCallExpression $this$isMethodCall, @NotNull String fqMethodName) {
        Intrinsics.checkNotNullParameter((Object)$this$isMethodCall, (String)"$this$isMethodCall");
        Intrinsics.checkNotNullParameter((Object)fqMethodName, (String)"fqMethodName");
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)((KtElement)$this$isMethodCall), null, (int)1, null);
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        return Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)resolvedCall3.getResultingDescriptor())).asString(), (Object)fqMethodName);
    }

    @Nullable
    public static final KtBinaryExpression splitPropertyDeclaration(@NotNull KtProperty property2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        PsiElement parent2 = property2.getParent();
        KtExpression ktExpression = property2.getInitializer();
        if (ktExpression == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"property.initializer ?: return null");
        KtExpression initializer2 = ktExpression;
        KotlinType explicitTypeToSet = property2.getTypeReference() != null ? null : ResolutionUtils.analyze$default((KtElement)((KtElement)initializer2), null, (int)1, null).getType(initializer2);
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)property2), (boolean)false, (int)2, null);
        Object[] objectArray = new Object[2];
        Name name2 = property2.getNameAsName();
        Intrinsics.checkNotNull((Object)name2);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"property.nameAsName!!");
        objectArray[0] = name2;
        objectArray[1] = initializer2;
        KtExpression assignment = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"$0 = $1", (Object[])objectArray, (boolean)false, (int)4, null);
        PsiElement psiElement2 = parent2.addAfter((PsiElement)assignment, (PsiElement)property2);
        if (psiElement2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
        }
        assignment = (KtExpression)((KtBinaryExpression)psiElement2);
        parent2.addAfter(psiFactory.createNewLine(), (PsiElement)property2);
        property2.setInitializer((KtExpression)null);
        if (explicitTypeToSet != null) {
            PsiModificationUtilsKt.setType$default((KtCallableDeclaration)((KtCallableDeclaration)property2), (KotlinType)explicitTypeToSet, (boolean)false, (int)2, null);
        }
        return (KtBinaryExpression)assignment;
    }

    @Nullable
    public static final KtCallExpression getCallExpression(@NotNull KtQualifiedExpression $this$callExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$callExpression, (String)"$this$callExpression");
        KtExpression ktExpression = $this$callExpression.getSelectorExpression();
        if (!(ktExpression instanceof KtCallExpression)) {
            ktExpression = null;
        }
        return (KtCallExpression)ktExpression;
    }

    @Nullable
    public static final String getCalleeName(@NotNull KtQualifiedExpression $this$calleeName) {
        Intrinsics.checkNotNullParameter((Object)$this$calleeName, (String)"$this$calleeName");
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression($this$calleeName);
        Object object = ktCallExpression != null ? ktCallExpression.getCalleeExpression() : null;
        if (!(object instanceof KtNameReferenceExpression)) {
            object = null;
        }
        KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)object;
        return ktNameReferenceExpression != null ? ktNameReferenceExpression.getText() : null;
    }

    @Nullable
    public static final ResolvedCall<? extends CallableDescriptor> toResolvedCall(@NotNull KtQualifiedExpression $this$toResolvedCall, @NotNull BodyResolveMode bodyResolveMode) {
        Intrinsics.checkNotNullParameter((Object)$this$toResolvedCall, (String)"$this$toResolvedCall");
        Intrinsics.checkNotNullParameter((Object)bodyResolveMode, (String)"bodyResolveMode");
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression($this$toResolvedCall);
        if (ktCallExpression == null) {
            return null;
        }
        KtCallExpression callExpression2 = ktCallExpression;
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall((KtElement)((KtElement)callExpression2), (BodyResolveMode)bodyResolveMode);
        if (resolvedCall2 == null) {
            return null;
        }
        return resolvedCall2;
    }

    public static final boolean isExitStatement(@NotNull KtExpression $this$isExitStatement) {
        Intrinsics.checkNotNullParameter((Object)$this$isExitStatement, (String)"$this$isExitStatement");
        KtExpression ktExpression = $this$isExitStatement;
        return ktExpression instanceof KtContinueExpression || ktExpression instanceof KtBreakExpression || ktExpression instanceof KtThrowExpression || ktExpression instanceof KtReturnExpression;
    }

    public static final boolean isReceiverExpressionWithValue(@NotNull KtQualifiedExpression $this$isReceiverExpressionWithValue) {
        Intrinsics.checkNotNullParameter((Object)$this$isReceiverExpressionWithValue, (String)"$this$isReceiverExpressionWithValue");
        KtExpression receiver = $this$isReceiverExpressionWithValue.getReceiverExpression();
        if (receiver instanceof KtSuperExpression) {
            return false;
        }
        return ResolutionUtils.analyze$default((KtElement)((KtElement)$this$isReceiverExpressionWithValue), null, (int)1, null).getType(receiver) != null;
    }

    @NotNull
    public static final KtExpression negate(@NotNull KtExpression $this$negate, boolean reformat) {
        Intrinsics.checkNotNullParameter((Object)$this$negate, (String)"$this$negate");
        KtExpression specialNegation = UtilsKt.specialNegation($this$negate, reformat);
        if (specialNegation != null) {
            return specialNegation;
        }
        return CreateByPatternKt.createExpressionByPattern((KtPsiFactory)KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)$this$negate), (boolean)false, (int)2, null), (String)"!$0", (Object[])new Object[]{$this$negate}, (boolean)reformat);
    }

    public static /* synthetic */ KtExpression negate$default(KtExpression ktExpression, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return UtilsKt.negate(ktExpression, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KtWhenExpression> resultingWhens(@NotNull KtExpression $this$resultingWhens) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$resultingWhens, (String)"$this$resultingWhens");
        KtExpression ktExpression = $this$resultingWhens;
        if (ktExpression instanceof KtWhenExpression) {
            Collection<KtExpression> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Collection collection2 = CollectionsKt.listOf((Object)$this$resultingWhens);
            List list = ((KtWhenExpression)$this$resultingWhens).getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"entries");
            Iterable iterable = list;
            Collection collection3 = collection2;
            boolean $i$f$map = false;
            void var4_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KtWhenEntry ktWhenEntry = (KtWhenEntry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                void v2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
                Object object2 = v2.getExpression();
                if (object2 == null || (object2 = UtilsKt.resultingWhens(object2)) == null) {
                    boolean bl2 = false;
                    object2 = CollectionsKt.emptyList();
                }
                Object object3 = object2;
                collection.add((KtExpression)object3);
            }
            collection = (List)destination$iv$iv;
            object = CollectionsKt.plus((Collection)collection3, (Iterable)CollectionsKt.flatten((Iterable)collection));
        } else if (ktExpression instanceof KtIfExpression) {
            Iterable iterable;
            boolean bl;
            Object object4 = ((KtIfExpression)$this$resultingWhens).getThen();
            if (object4 == null || (object4 = UtilsKt.resultingWhens(object4)) == null) {
                bl = false;
                object4 = CollectionsKt.emptyList();
            }
            Collection collection = (Collection)object4;
            Object object5 = ((KtIfExpression)$this$resultingWhens).getElse();
            if (object5 != null && (object5 = UtilsKt.resultingWhens(object5)) != null) {
                iterable = (Iterable)object5;
            } else {
                bl = false;
                iterable = CollectionsKt.emptyList();
            }
            object = CollectionsKt.plus((Collection)collection, (Iterable)iterable);
        } else if (ktExpression instanceof KtBinaryExpression) {
            Iterable iterable;
            boolean bl;
            Object object6 = ((KtBinaryExpression)$this$resultingWhens).getLeft();
            if (object6 == null || (object6 = UtilsKt.resultingWhens(object6)) == null) {
                bl = false;
                object6 = CollectionsKt.emptyList();
            }
            Collection collection = (Collection)object6;
            Object object7 = ((KtBinaryExpression)$this$resultingWhens).getRight();
            if (object7 != null && (object7 = UtilsKt.resultingWhens(object7)) != null) {
                iterable = (Iterable)object7;
            } else {
                bl = false;
                iterable = CollectionsKt.emptyList();
            }
            object = CollectionsKt.plus((Collection)collection, (Iterable)iterable);
        } else if (ktExpression instanceof KtUnaryExpression) {
            object = ((KtUnaryExpression)$this$resultingWhens).getBaseExpression();
            if (object == null || (object = UtilsKt.resultingWhens(object)) == null) {
                boolean bl = false;
                object = CollectionsKt.emptyList();
            }
        } else if (ktExpression instanceof KtBlockExpression) {
            List list = ((KtBlockExpression)$this$resultingWhens).getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"statements");
            object = (KtExpression)CollectionsKt.lastOrNull((List)list);
            if (object == null || (object = UtilsKt.resultingWhens(object)) == null) {
                boolean bl = false;
                object = CollectionsKt.emptyList();
            }
        } else {
            boolean bl = false;
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public static final boolean hasResultingIfWithoutElse(@Nullable KtExpression $this$hasResultingIfWithoutElse) {
        boolean bl;
        block13: {
            KtExpression ktExpression = $this$hasResultingIfWithoutElse;
            if (ktExpression instanceof KtIfExpression) {
                bl = ((KtIfExpression)$this$hasResultingIfWithoutElse).getElse() == null || UtilsKt.hasResultingIfWithoutElse(((KtIfExpression)$this$hasResultingIfWithoutElse).getThen()) || UtilsKt.hasResultingIfWithoutElse(((KtIfExpression)$this$hasResultingIfWithoutElse).getElse());
            } else if (ktExpression instanceof KtWhenExpression) {
                List list = ((KtWhenExpression)$this$hasResultingIfWithoutElse).getEntries();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"entries");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtWhenEntry it = (KtWhenEntry)element$iv;
                        boolean bl2 = false;
                        KtWhenEntry ktWhenEntry = it;
                        Intrinsics.checkNotNullExpressionValue((Object)ktWhenEntry, (String)"it");
                        if (!UtilsKt.hasResultingIfWithoutElse(ktWhenEntry.getExpression())) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            } else if (ktExpression instanceof KtBinaryExpression) {
                bl = UtilsKt.hasResultingIfWithoutElse(((KtBinaryExpression)$this$hasResultingIfWithoutElse).getLeft()) || UtilsKt.hasResultingIfWithoutElse(((KtBinaryExpression)$this$hasResultingIfWithoutElse).getRight());
            } else if (ktExpression instanceof KtUnaryExpression) {
                bl = UtilsKt.hasResultingIfWithoutElse(((KtUnaryExpression)$this$hasResultingIfWithoutElse).getBaseExpression());
            } else if (ktExpression instanceof KtBlockExpression) {
                List list = ((KtBlockExpression)$this$hasResultingIfWithoutElse).getStatements();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"statements");
                bl = UtilsKt.hasResultingIfWithoutElse((KtExpression)CollectionsKt.lastOrNull((List)list));
            } else {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final KtExpression specialNegation(KtExpression $this$specialNegation, boolean reformat) {
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)$this$specialNegation), (boolean)false, (int)2, null);
        KtExpression ktExpression = $this$specialNegation;
        if (ktExpression instanceof KtPrefixExpression) {
            if (!Intrinsics.areEqual((Object)((KtPrefixExpression)$this$specialNegation).getOperationReference().getReferencedName(), (Object)"!")) return null;
            KtExpression baseExpression = ((KtPrefixExpression)$this$specialNegation).getBaseExpression();
            if (baseExpression == null) return null;
            BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)((KtElement)baseExpression), (BodyResolveMode)BodyResolveMode.PARTIAL);
            KotlinType type2 = bindingContext2.getType(baseExpression);
            if (type2 == null) return null;
            if (!KotlinBuiltIns.isBoolean((KotlinType)type2)) return null;
            return KtPsiUtil.safeDeparenthesize((KtExpression)baseExpression);
        }
        if (ktExpression instanceof KtBinaryExpression) {
            IElementType iElementType = ((KtBinaryExpression)$this$specialNegation).getOperationToken();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"operationToken");
            IElementType operator = iElementType;
            if (!CollectionsKt.contains((Iterable)NEGATABLE_OPERATORS, (Object)operator)) {
                return null;
            }
            KtExpression ktExpression2 = ((KtBinaryExpression)$this$specialNegation).getLeft();
            if (ktExpression2 == null) return null;
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"left ?: return null");
            KtExpression left = ktExpression2;
            KtExpression ktExpression3 = ((KtBinaryExpression)$this$specialNegation).getRight();
            if (ktExpression3 == null) return null;
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression3, (String)"right ?: return null");
            KtExpression right = ktExpression3;
            return CreateByPatternKt.createExpressionByPattern((KtPsiFactory)factory2, (String)"$0 $1 $2", (Object[])new Object[]{left, UtilsKt.getNegatedOperatorText(operator), right}, (boolean)reformat);
        }
        if (ktExpression instanceof KtIsExpression) {
            Object[] objectArray = new Object[3];
            KtExpression ktExpression4 = ((KtIsExpression)$this$specialNegation).getLeftHandSide();
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression4, (String)"leftHandSide");
            objectArray[0] = ktExpression4;
            objectArray[1] = ((KtIsExpression)$this$specialNegation).isNegated() ? "is" : "!is";
            KtTypeReference ktTypeReference = ((KtIsExpression)$this$specialNegation).getTypeReference();
            if (ktTypeReference == null) return null;
            Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference, (String)"typeReference ?: return null");
            objectArray[2] = ktTypeReference;
            return CreateByPatternKt.createExpressionByPattern((KtPsiFactory)factory2, (String)"$0 $1 $2", (Object[])objectArray, (boolean)reformat);
        }
        if (!(ktExpression instanceof KtConstantExpression)) return null;
        String string = ((KtConstantExpression)$this$specialNegation).getText();
        if (string == null) return null;
        switch (string) {
            case "true": {
                KtExpression ktExpression5 = factory2.createExpression("false");
                return ktExpression5;
            }
            case "false": {
                KtExpression ktExpression5 = factory2.createExpression("true");
                return ktExpression5;
            }
            default: {
                return null;
            }
        }
    }

    private static final String getNegatedOperatorText(IElementType token) {
        String string;
        IElementType iElementType = token;
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ)) {
            KtSingleValueToken ktSingleValueToken = KtTokens.EXCLEQ;
            Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"KtTokens.EXCLEQ");
            String string2 = ktSingleValueToken.getValue();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"KtTokens.EXCLEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ)) {
            KtSingleValueToken ktSingleValueToken = KtTokens.EQEQ;
            Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"KtTokens.EQEQ");
            String string3 = ktSingleValueToken.getValue();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"KtTokens.EQEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQEQ)) {
            KtSingleValueToken ktSingleValueToken = KtTokens.EXCLEQEQEQ;
            Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"KtTokens.EXCLEQEQEQ");
            String string4 = ktSingleValueToken.getValue();
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"KtTokens.EXCLEQEQEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQEQEQ)) {
            KtSingleValueToken ktSingleValueToken = KtTokens.EQEQEQ;
            Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"KtTokens.EQEQEQ");
            String string5 = ktSingleValueToken.getValue();
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"KtTokens.EQEQEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.IS_KEYWORD)) {
            KtKeywordToken ktKeywordToken = KtTokens.NOT_IS;
            Intrinsics.checkNotNullExpressionValue((Object)ktKeywordToken, (String)"KtTokens.NOT_IS");
            String string6 = ktKeywordToken.getValue();
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"KtTokens.NOT_IS.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.NOT_IS)) {
            KtKeywordToken ktKeywordToken = KtTokens.IS_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktKeywordToken, (String)"KtTokens.IS_KEYWORD");
            String string7 = ktKeywordToken.getValue();
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"KtTokens.IS_KEYWORD.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.IN_KEYWORD)) {
            KtKeywordToken ktKeywordToken = KtTokens.NOT_IN;
            Intrinsics.checkNotNullExpressionValue((Object)ktKeywordToken, (String)"KtTokens.NOT_IN");
            String string8 = ktKeywordToken.getValue();
            string = string8;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"KtTokens.NOT_IN.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.NOT_IN)) {
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.IN_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"KtTokens.IN_KEYWORD");
            String string9 = ktModifierKeywordToken.getValue();
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"KtTokens.IN_KEYWORD.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LT)) {
            KtSingleValueToken ktSingleValueToken = KtTokens.GTEQ;
            Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"KtTokens.GTEQ");
            String string10 = ktSingleValueToken.getValue();
            string = string10;
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"KtTokens.GTEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LTEQ)) {
            KtSingleValueToken ktSingleValueToken = KtTokens.GT;
            Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"KtTokens.GT");
            String string11 = ktSingleValueToken.getValue();
            string = string11;
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"KtTokens.GT.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GT)) {
            KtSingleValueToken ktSingleValueToken = KtTokens.LTEQ;
            Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"KtTokens.LTEQ");
            String string12 = ktSingleValueToken.getValue();
            string = string12;
            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"KtTokens.LTEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GTEQ)) {
            KtSingleValueToken ktSingleValueToken = KtTokens.LT;
            Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"KtTokens.LT");
            String string13 = ktSingleValueToken.getValue();
            string = string13;
            Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"KtTokens.LT.value");
        } else {
            throw (Throwable)new IllegalArgumentException("The token " + token + " does not have a negated equivalent.");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isFlexibleRecursive(@NotNull KotlinType $this$isFlexibleRecursive) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isFlexibleRecursive, (String)"$this$isFlexibleRecursive");
        if (FlexibleTypesKt.isFlexible((KotlinType)$this$isFlexibleRecursive)) {
            return true;
        }
        Iterable $this$any$iv = $this$isFlexibleRecursive.getArguments();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            TypeProjection it = (TypeProjection)element$iv;
            boolean bl2 = false;
            if (!it.isStarProjection()) {
                KotlinType kotlinType = it.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"it.type");
                if (UtilsKt.isFlexibleRecursive(kotlinType)) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @NotNull
    public static final List<KtExpression> getBranches(@NotNull KtIfExpression $this$branches) {
        Intrinsics.checkNotNullParameter((Object)$this$branches, (String)"$this$branches");
        return UtilsKt.ifBranchesOrThis((KtExpression)$this$branches);
    }

    private static final List<KtExpression> ifBranchesOrThis(KtExpression $this$ifBranchesOrThis) {
        if (!($this$ifBranchesOrThis instanceof KtIfExpression)) {
            return CollectionsKt.listOf((Object)$this$ifBranchesOrThis);
        }
        Collection collection = CollectionsKt.listOf((Object)((KtIfExpression)$this$ifBranchesOrThis).getThen());
        KtExpression ktExpression = ((KtIfExpression)$this$ifBranchesOrThis).getElse();
        List list = ktExpression != null ? UtilsKt.ifBranchesOrThis(ktExpression) : null;
        boolean bl = false;
        List list2 = list;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)list2);
    }

    public static final boolean resolvedToArrayType(@NotNull ResolvedCall<? extends CallableDescriptor> $this$resolvedToArrayType) {
        Intrinsics.checkNotNullParameter($this$resolvedToArrayType, (String)"$this$resolvedToArrayType");
        KotlinType kotlinType = $this$resolvedToArrayType.getResultingDescriptor().getReturnType();
        boolean bl = false;
        boolean bl2 = false;
        KotlinType type2 = kotlinType;
        boolean bl3 = false;
        return type2 != null && (KotlinBuiltIns.isArray((KotlinType)type2) || KotlinBuiltIns.isPrimitiveArray((KotlinType)type2));
    }

    public static final boolean isZero(@Nullable KtElement $this$isZero) {
        KtElement ktElement = $this$isZero;
        return Intrinsics.areEqual((Object)(ktElement != null ? ktElement.getText() : null), (Object)"0");
    }

    public static final boolean isOne(@Nullable KtElement $this$isOne) {
        KtElement ktElement = $this$isOne;
        return Intrinsics.areEqual((Object)(ktElement != null ? ktElement.getText() : null), (Object)"1");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isExpressionOfTypeOrSubtype(KtExpression $this$isExpressionOfTypeOrSubtype, Function1<? super KotlinType, Boolean> predicate2) {
        Object element$iv;
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)((KtElement)$this$isExpressionOfTypeOrSubtype), null, (int)1, null);
        ResolvedCall resolvedCall3 = resolvedCall2;
        if (resolvedCall2 == null) return false;
        CallableDescriptor callableDescriptor = resolvedCall3.getResultingDescriptor();
        resolvedCall3 = callableDescriptor;
        if (callableDescriptor == null) return false;
        KotlinType kotlinType = resolvedCall3.getReturnType();
        KotlinType returnType2 = kotlinType;
        if (returnType2 == null) return false;
        Collection collection = returnType2.getConstructor().getSupertypes();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"returnType.constructor.supertypes");
        Iterable $this$any$iv = CollectionsKt.plus((Collection)collection, (Object)returnType2);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
        } while (!((Boolean)predicate2.invoke(element$iv = iterator.next())).booleanValue());
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSizeOrLength(@Nullable KtElement $this$isSizeOrLength) {
        if (!($this$isSizeOrLength instanceof KtDotQualifiedExpression)) {
            return false;
        }
        KtExpression ktExpression = ((KtDotQualifiedExpression)$this$isSizeOrLength).getSelectorExpression();
        if (ktExpression == null) return false;
        String string = ktExpression.getText();
        if (string == null) return false;
        switch (string) {
            case "size": {
                boolean bl = UtilsKt.isExpressionOfTypeOrSubtype(((KtDotQualifiedExpression)$this$isSizeOrLength).getReceiverExpression(), (Function1<? super KotlinType, Boolean>)((Function1)isSizeOrLength.1.INSTANCE));
                return bl;
            }
            case "length": {
                boolean bl = UtilsKt.isExpressionOfTypeOrSubtype(((KtDotQualifiedExpression)$this$isSizeOrLength).getReceiverExpression(), (Function1<? super KotlinType, Boolean>)((Function1)isSizeOrLength.2.INSTANCE));
                return bl;
            }
            default: {
                return false;
            }
        }
    }

    @NotNull
    public static final KtExpression getLeftMostReceiverExpression(@NotNull KtDotQualifiedExpression $this$getLeftMostReceiverExpression) {
        KtDotQualifiedExpression ktDotQualifiedExpression;
        Intrinsics.checkNotNullParameter((Object)$this$getLeftMostReceiverExpression, (String)"$this$getLeftMostReceiverExpression");
        KtExpression ktExpression = $this$getLeftMostReceiverExpression.getReceiverExpression();
        if (!(ktExpression instanceof KtDotQualifiedExpression)) {
            ktExpression = null;
        }
        if ((ktDotQualifiedExpression = (KtDotQualifiedExpression)ktExpression) == null || (ktDotQualifiedExpression = UtilsKt.getLeftMostReceiverExpression(ktDotQualifiedExpression)) == null) {
            ktDotQualifiedExpression = $this$getLeftMostReceiverExpression.getReceiverExpression();
        }
        return ktDotQualifiedExpression;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KtExpression replaceFirstReceiver(@NotNull KtDotQualifiedExpression $this$replaceFirstReceiver, @NotNull KtPsiFactory factory2, @NotNull KtExpression newReceiver, boolean safeAccess) {
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter((Object)$this$replaceFirstReceiver, (String)"$this$replaceFirstReceiver");
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)newReceiver, (String)"newReceiver");
        if (safeAccess) {
            PsiElement psiElement2;
            void $this$replaced$iv;
            PsiElement psiElement3 = (PsiElement)$this$replaceFirstReceiver;
            Object[] objectArray = new Object[2];
            objectArray[0] = $this$replaceFirstReceiver.getReceiverExpression();
            KtExpression ktExpression2 = $this$replaceFirstReceiver.getSelectorExpression();
            Intrinsics.checkNotNull((Object)ktExpression2);
            objectArray[1] = ktExpression2;
            PsiElement newElement$iv = (PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)"$0?.$1", (Object[])objectArray, (boolean)false, (int)4, null);
            boolean $i$f$replaced = false;
            PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
            PsiElement psiElement4 = result$iv;
            if (!(psiElement4 instanceof KtExpression)) {
                psiElement4 = null;
            }
            if ((psiElement2 = (PsiElement)((KtExpression)psiElement4)) == null) {
                PsiElement psiElement5 = result$iv;
                if (psiElement5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                }
                KtExpression ktExpression3 = ((KtParenthesizedExpression)psiElement5).getExpression();
                if (ktExpression3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                psiElement2 = (PsiElement)ktExpression3;
            }
            ktExpression = (KtExpression)psiElement2;
        } else {
            ktExpression = (KtExpression)$this$replaceFirstReceiver;
        }
        if (ktExpression == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtQualifiedExpression");
        }
        KtQualifiedExpression replaced2 = (KtQualifiedExpression)ktExpression;
        KtExpression receiver = replaced2.getReceiverExpression();
        KtExpression ktExpression4 = receiver;
        if (ktExpression4 instanceof KtDotQualifiedExpression) {
            ((KtDotQualifiedExpression)receiver).replace((PsiElement)UtilsKt.replaceFirstReceiver((KtDotQualifiedExpression)receiver, factory2, newReceiver, safeAccess));
        } else {
            receiver.replace((PsiElement)newReceiver);
        }
        return (KtExpression)replaced2;
    }

    public static /* synthetic */ KtExpression replaceFirstReceiver$default(KtDotQualifiedExpression ktDotQualifiedExpression, KtPsiFactory ktPsiFactory, KtExpression ktExpression, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return UtilsKt.replaceFirstReceiver(ktDotQualifiedExpression, ktPsiFactory, ktExpression, bl);
    }

    @NotNull
    public static final KtExpression deleteFirstReceiver(@NotNull KtDotQualifiedExpression $this$deleteFirstReceiver) {
        KtExpression receiver;
        Intrinsics.checkNotNullParameter((Object)$this$deleteFirstReceiver, (String)"$this$deleteFirstReceiver");
        KtExpression ktExpression = receiver = $this$deleteFirstReceiver.getReceiverExpression();
        if (ktExpression instanceof KtDotQualifiedExpression) {
            UtilsKt.deleteFirstReceiver((KtDotQualifiedExpression)receiver);
        } else {
            KtExpression ktExpression2 = $this$deleteFirstReceiver.getSelectorExpression();
            if (ktExpression2 != null) {
                KtExpression ktExpression3 = ktExpression2;
                boolean bl = false;
                boolean bl2 = false;
                KtExpression it = ktExpression3;
                boolean bl3 = false;
                PsiElement psiElement2 = $this$deleteFirstReceiver.replace((PsiElement)it);
                if (psiElement2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                return (KtExpression)psiElement2;
            }
        }
        return (KtExpression)$this$deleteFirstReceiver;
    }

    public static final boolean isArrayOfMethod(@NotNull KtCallExpression $this$isArrayOfMethod) {
        Intrinsics.checkNotNullParameter((Object)$this$isArrayOfMethod, (String)"$this$isArrayOfMethod");
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)((KtElement)$this$isArrayOfMethod), null, (int)1, null);
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        CallableDescriptor descriptor2 = resolvedCall3.getCandidateDescriptor();
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        if (!(declarationDescriptor instanceof PackageFragmentDescriptor)) {
            declarationDescriptor = null;
        }
        PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)declarationDescriptor;
        return Intrinsics.areEqual((Object)(packageFragmentDescriptor != null ? packageFragmentDescriptor.getFqName() : null), (Object)StandardNames.BUILT_INS_PACKAGE_FQ_NAME) && ARRAY_OF_METHODS.contains(descriptor2.getName());
    }

    @Nullable
    public static final String getParentLambdaLabelName(@NotNull KtBlockExpression $this$getParentLambdaLabelName) {
        Object v4;
        KtCallExpression callExpression2;
        block6: {
            Intrinsics.checkNotNullParameter((Object)$this$getParentLambdaLabelName, (String)"$this$getParentLambdaLabelName");
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$getParentLambdaLabelName;
            boolean $i$f$getStrictParentOfType = false;
            KtLambdaExpression ktLambdaExpression = (KtLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtLambdaExpression.class, (boolean)true);
            if (ktLambdaExpression == null) {
                return null;
            }
            KtLambdaExpression lambdaExpression2 = ktLambdaExpression;
            PsiElement $this$getStrictParentOfType$iv2 = (PsiElement)lambdaExpression2;
            boolean $i$f$getStrictParentOfType22 = false;
            KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv2, KtCallExpression.class, (boolean)true);
            if (ktCallExpression == null) {
                return null;
            }
            callExpression2 = ktCallExpression;
            List list = callExpression2.getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"callExpression.valueArguments");
            Iterable $i$f$getStrictParentOfType22 = list;
            boolean bl = false;
            Iterable iterable = $i$f$getStrictParentOfType22;
            boolean bl2 = false;
            for (Object t : iterable) {
                KtValueArgument it = (KtValueArgument)t;
                boolean bl3 = false;
                KtExpression ktExpression = it.getArgumentExpression();
                if (!((ktExpression != null ? KtElementUtilsKt.unpackFunctionLiteral((KtExpression)ktExpression, (boolean)false) : null) == lambdaExpression2)) continue;
                v4 = t;
                break block6;
            }
            v4 = null;
        }
        KtValueArgument ktValueArgument = v4;
        if (ktValueArgument == null) {
            return null;
        }
        KtValueArgument valueArgument = ktValueArgument;
        KtExpression ktExpression = valueArgument.getArgumentExpression();
        if (!(ktExpression instanceof KtLabeledExpression)) {
            ktExpression = null;
        }
        KtLabeledExpression ktLabeledExpression = (KtLabeledExpression)ktExpression;
        String lambdaLabelName = ktLabeledExpression != null ? ktLabeledExpression.getLabelName() : null;
        String string = lambdaLabelName;
        if (string == null) {
            KtSimpleNameExpression ktSimpleNameExpression = KtPsiUtilKt.getCallNameExpression((KtCallElement)((KtCallElement)callExpression2));
            string = ktSimpleNameExpression != null ? ktSimpleNameExpression.getText() : null;
        }
        return string;
    }

    @Nullable
    public static final CallableDescriptor getCallableDescriptor(@NotNull KtExpression $this$getCallableDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$getCallableDescriptor, (String)"$this$getCallableDescriptor");
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)((KtElement)$this$getCallableDescriptor), null, (int)1, null);
        return resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isFinalizeMethod(@NotNull KtDeclaration $this$isFinalizeMethod, @Nullable DeclarationDescriptor descriptor2) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$isFinalizeMethod, (String)"$this$isFinalizeMethod");
        if (KtPsiUtilKt.containingClass((KtElement)((KtElement)$this$isFinalizeMethod)) == null) {
            return false;
        }
        KtDeclaration ktDeclaration = $this$isFinalizeMethod;
        if (!(ktDeclaration instanceof KtNamedFunction)) {
            ktDeclaration = null;
        }
        KtNamedFunction ktNamedFunction = (KtNamedFunction)ktDeclaration;
        if (ktNamedFunction == null) return false;
        KtNamedFunction function2 = ktNamedFunction;
        if (!Intrinsics.areEqual((Object)function2.getName(), (Object)"finalize")) return false;
        if (!function2.getValueParameters().isEmpty()) return false;
        DeclarationDescriptor declarationDescriptor2 = descriptor2;
        if (declarationDescriptor2 == null) {
            declarationDescriptor2 = declarationDescriptor = SearchHelpersKt.getDescriptor((KtDeclaration)((KtDeclaration)function2));
        }
        if (!(declarationDescriptor2 instanceof FunctionDescriptor)) {
            declarationDescriptor = null;
        }
        FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)declarationDescriptor;
        FunctionDescriptor functionDescriptor3 = functionDescriptor2;
        if (functionDescriptor2 == null) return false;
        KotlinType kotlinType = functionDescriptor3.getReturnType();
        functionDescriptor3 = kotlinType;
        if (kotlinType == null) return false;
        if (!TypeUtilsKt.isUnit((KotlinType)functionDescriptor3)) return false;
        return true;
    }

    public static /* synthetic */ boolean isFinalizeMethod$default(KtDeclaration ktDeclaration, DeclarationDescriptor declarationDescriptor, int n, Object object) {
        if ((n & 1) != 0) {
            declarationDescriptor = null;
        }
        return UtilsKt.isFinalizeMethod(ktDeclaration, declarationDescriptor);
    }

    public static final boolean isToString(@NotNull KtDotQualifiedExpression $this$isToString) {
        boolean bl;
        block11: {
            Intrinsics.checkNotNullParameter((Object)$this$isToString, (String)"$this$isToString");
            KtExpression ktExpression = $this$isToString.getSelectorExpression();
            if (!(ktExpression instanceof KtCallExpression)) {
                ktExpression = null;
            }
            KtCallExpression ktCallExpression = (KtCallExpression)ktExpression;
            if (ktCallExpression == null) {
                return false;
            }
            KtCallExpression callExpression2 = ktCallExpression;
            KtExpression ktExpression2 = callExpression2.getCalleeExpression();
            if (!(ktExpression2 instanceof KtNameReferenceExpression)) {
                ktExpression2 = null;
            }
            KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression2;
            if (ktNameReferenceExpression == null) {
                return false;
            }
            KtNameReferenceExpression referenceExpression = ktNameReferenceExpression;
            if (Intrinsics.areEqual((Object)referenceExpression.getReferencedName(), (Object)"toString") ^ true) {
                return false;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = UtilsKt.toResolvedCall((KtQualifiedExpression)$this$isToString, BodyResolveMode.PARTIAL);
            if (resolvedCall2 == null) {
                return false;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
            CallableDescriptor callableDescriptor = resolvedCall3.getResultingDescriptor();
            if (!(callableDescriptor instanceof CallableMemberDescriptor)) {
                callableDescriptor = null;
            }
            CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)callableDescriptor;
            if (callableMemberDescriptor == null) {
                return false;
            }
            CallableMemberDescriptor callableDescriptor2 = callableMemberDescriptor;
            Iterable $this$any$iv = org.jetbrains.kotlin.idea.core.DescriptorUtilsKt.getDeepestSuperDeclarations$default((CallableMemberDescriptor)callableDescriptor2, (boolean)false, (int)1, null);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)it)).asString(), (Object)"kotlin.Any.toString")) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isOperatorOrCompatible(@NotNull FunctionDescriptor $this$isOperatorOrCompatible) {
        Intrinsics.checkNotNullParameter((Object)$this$isOperatorOrCompatible, (String)"$this$isOperatorOrCompatible");
        if ($this$isOperatorOrCompatible instanceof JavaMethodDescriptor) {
            return OperatorChecks.INSTANCE.check($this$isOperatorOrCompatible).isSuccess();
        }
        return $this$isOperatorOrCompatible.isOperator();
    }

    public static final void appendSemicolonBeforeLambdaContainingElement(@NotNull KtPsiFactory $this$appendSemicolonBeforeLambdaContainingElement, @NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)$this$appendSemicolonBeforeLambdaContainingElement, (String)"$this$appendSemicolonBeforeLambdaContainingElement");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiElement previousElement2 = KtPsiUtil.skipSiblingsBackwardByPredicate((PsiElement)element3, (Predicate)appendSemicolonBeforeLambdaContainingElement.previousElement.1.INSTANCE);
        if (previousElement2 != null && previousElement2 instanceof KtExpression) {
            ((KtExpression)previousElement2).getParent().addAfter($this$appendSemicolonBeforeLambdaContainingElement.createSemicolon(), previousElement2);
        }
    }

    @Nullable
    public static final PsiElement lastWithPersistedElementOrNull(@NotNull Sequence<? extends PsiElement> $this$lastWithPersistedElementOrNull, @NotNull KtExpression elementShouldPersist) {
        Intrinsics.checkNotNullParameter($this$lastWithPersistedElementOrNull, (String)"$this$lastWithPersistedElementOrNull");
        Intrinsics.checkNotNullParameter((Object)elementShouldPersist, (String)"elementShouldPersist");
        PsiElement lastElement = null;
        boolean checked = false;
        for (PsiElement element3 : $this$lastWithPersistedElementOrNull) {
            checked = checked || element3 == elementShouldPersist;
            lastElement = element3;
        }
        return checked ? lastElement : null;
    }

    @NotNull
    public static final KotlinType reflectToRegularFunctionType(@NotNull KotlinType $this$reflectToRegularFunctionType) {
        Intrinsics.checkNotNullParameter((Object)$this$reflectToRegularFunctionType, (String)"$this$reflectToRegularFunctionType");
        boolean isTypeAnnotatedWithExtensionFunctionType = $this$reflectToRegularFunctionType.getAnnotations().findAnnotation(StandardNames.FqNames.extensionFunctionType) != null;
        int parameterCount = isTypeAnnotatedWithExtensionFunctionType ? $this$reflectToRegularFunctionType.getArguments().size() - 2 : $this$reflectToRegularFunctionType.getArguments().size() - 1;
        ClassDescriptor classDescriptor = FunctionTypesKt.isKSuspendFunctionType((KotlinType)$this$reflectToRegularFunctionType) ? TypeUtilsKt.getBuiltIns((KotlinType)$this$reflectToRegularFunctionType).getSuspendFunction(parameterCount) : TypeUtilsKt.getBuiltIns((KotlinType)$this$reflectToRegularFunctionType).getFunction(parameterCount);
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"if (isKSuspendFunctionTy\u2026tFunction(parameterCount)");
        ClassDescriptor classDescriptor2 = classDescriptor;
        return (KotlinType)KotlinTypeFactory.simpleNotNullType((Annotations)$this$reflectToRegularFunctionType.getAnnotations(), (ClassDescriptor)classDescriptor2, (List)$this$reflectToRegularFunctionType.getArguments());
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isReferenceToBuiltInEnumFunction(@NotNull KtElement $this$isReferenceToBuiltInEnumFunction) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isReferenceToBuiltInEnumFunction, (String)"$this$isReferenceToBuiltInEnumFunction");
        KtElement ktElement = $this$isReferenceToBuiltInEnumFunction;
        if (ktElement instanceof KtTypeReference) {
            KtExpression target2;
            PsiElement psiElement2 = ((KtTypeReference)$this$isReferenceToBuiltInEnumFunction).getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"parent");
            PsiElement $this$getStrictParentOfType$iv = psiElement2;
            boolean $i$f$getStrictParentOfType2 = false;
            KtTypeArgumentList ktTypeArgumentList = (KtTypeArgumentList)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtTypeArgumentList.class, (boolean)true);
            KtExpression ktExpression = target2 = (KtExpression)PsiUtilsKt.getParentOfTypes((PsiElement)((PsiElement)(ktTypeArgumentList != null ? (KtElementImplStub)ktTypeArgumentList : (KtElementImplStub)$this$isReferenceToBuiltInEnumFunction)), (boolean)true, (Class[])new Class[]{KtCallExpression.class, KtCallableDeclaration.class});
            if (ktExpression instanceof KtCallExpression) {
                bl = FunctionUtilsKt.isCalling$default((KtCallExpression)target2, KOTLIN_BUILTIN_ENUM_FUNCTIONS, null, 2, null);
            } else if (ktExpression instanceof KtCallableDeclaration) {
                void $this$anyDescendantOfType$iv;
                PsiElement $i$f$getStrictParentOfType2 = (PsiElement)target2;
                Function1 predicate$iv = isReferenceToBuiltInEnumFunction.1.INSTANCE;
                boolean $i$f$anyDescendantOfType = false;
                void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
                boolean $i$f$findDescendantOfType = false;
                void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
                boolean $i$f$findDescendantOfType2 = false;
                Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
                $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
                    final /* synthetic */ Function1 $predicate;
                    final /* synthetic */ Ref.ObjectRef $result;
                    {
                        this.$predicate = $predicate;
                        this.$result = $result;
                    }

                    public void visitElement(@NotNull PsiElement element3) {
                        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                        if (element3 instanceof KtCallExpression && ((Boolean)this.$predicate.invoke((Object)element3)).booleanValue()) {
                            this.$result.element = element3;
                            this.stopWalking();
                            return;
                        }
                        PsiElement it = element3;
                        boolean bl = false;
                        super.visitElement(element3);
                    }
                });
                bl = (PsiElement)result$iv$iv$iv.element != null;
            } else {
                bl = false;
            }
        } else if (ktElement instanceof KtQualifiedExpression) {
            KtCallExpression ktCallExpression = UtilsKt.getCallExpression((KtQualifiedExpression)$this$isReferenceToBuiltInEnumFunction);
            bl = CollectionsKt.contains((Iterable)ENUM_STATIC_METHODS, ktCallExpression != null && (ktCallExpression = ktCallExpression.getCalleeExpression()) != null ? ktCallExpression.getText() : null);
        } else if (ktElement instanceof KtCallExpression) {
            KtExpression ktExpression = ((KtCallExpression)$this$isReferenceToBuiltInEnumFunction).getCalleeExpression();
            bl = CollectionsKt.contains((Iterable)ENUM_STATIC_METHODS, (Object)(ktExpression != null ? ktExpression.getText() : null));
        } else if (ktElement instanceof KtCallableReferenceExpression) {
            KtSimpleNameExpression ktSimpleNameExpression = ((KtCallableReferenceExpression)$this$isReferenceToBuiltInEnumFunction).getCallableReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"this.callableReference");
            bl = ENUM_STATIC_METHODS.contains(ktSimpleNameExpression.getText());
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isInvokeOperator(@NotNull CallableDescriptor $this$isInvokeOperator) {
        Intrinsics.checkNotNullParameter((Object)$this$isInvokeOperator, (String)"$this$isInvokeOperator");
        return $this$isInvokeOperator instanceof FunctionDescriptor && !($this$isInvokeOperator instanceof FunctionInvokeDescriptor) && ((FunctionDescriptor)$this$isInvokeOperator).isOperator() && Intrinsics.areEqual((Object)((FunctionDescriptor)$this$isInvokeOperator).getName(), (Object)OperatorNameConventions.INVOKE);
    }

    public static final boolean canBeReplacedWithInvokeCall(@NotNull KtCallExpression $this$canBeReplacedWithInvokeCall) {
        Intrinsics.checkNotNullParameter((Object)$this$canBeReplacedWithInvokeCall, (String)"$this$canBeReplacedWithInvokeCall");
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)((KtElement)$this$canBeReplacedWithInvokeCall), null, (int)1, null);
        return resolvedCall2 != null && UtilsKt.canBeReplacedWithInvokeCall((ResolvedCall<? extends CallableDescriptor>)resolvedCall2);
    }

    public static final boolean canBeReplacedWithInvokeCall(@NotNull ResolvedCall<? extends CallableDescriptor> $this$canBeReplacedWithInvokeCall) {
        Intrinsics.checkNotNullParameter($this$canBeReplacedWithInvokeCall, (String)"$this$canBeReplacedWithInvokeCall");
        CallableDescriptor callableDescriptor = $this$canBeReplacedWithInvokeCall.getResultingDescriptor();
        if (!(callableDescriptor instanceof SimpleFunctionDescriptor)) {
            callableDescriptor = null;
        }
        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)callableDescriptor;
        if (simpleFunctionDescriptor == null) {
            return false;
        }
        SimpleFunctionDescriptor descriptor2 = simpleFunctionDescriptor;
        return (descriptor2 instanceof FunctionInvokeDescriptor || UtilsKt.isInvokeOperator((CallableDescriptor)descriptor2)) && !DescriptorUtilsKt.isExtension((DeclarationDescriptor)((DeclarationDescriptor)descriptor2));
    }

    @Nullable
    public static final KotlinType receiverType(@NotNull CallableDescriptor $this$receiverType) {
        Intrinsics.checkNotNullParameter((Object)$this$receiverType, (String)"$this$receiverType");
        ReceiverParameterDescriptor receiverParameterDescriptor = $this$receiverType.getDispatchReceiverParameter();
        if (receiverParameterDescriptor == null) {
            receiverParameterDescriptor = $this$receiverType.getExtensionReceiverParameter();
        }
        return receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
    }

    public static final void appendCallOrQualifiedExpression(@NotNull BuilderByPattern<KtExpression> $this$appendCallOrQualifiedExpression, @NotNull KtCallExpression call, @NotNull String newFunctionName) {
        block2: {
            KtValueArgumentList it;
            boolean bl;
            boolean bl2;
            KtValueArgumentList ktValueArgumentList;
            KtExpression callOrQualified;
            Intrinsics.checkNotNullParameter($this$appendCallOrQualifiedExpression, (String)"$this$appendCallOrQualifiedExpression");
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)newFunctionName, (String)"newFunctionName");
            KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)call));
            KtExpression ktExpression = callOrQualified = ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : (KtExpression)call;
            if (callOrQualified instanceof KtQualifiedExpression) {
                $this$appendCallOrQualifiedExpression.appendExpression(((KtQualifiedExpression)callOrQualified).getReceiverExpression());
                $this$appendCallOrQualifiedExpression.appendFixedText(".");
            }
            $this$appendCallOrQualifiedExpression.appendFixedText(newFunctionName);
            KtValueArgumentList ktValueArgumentList2 = call.getValueArgumentList();
            if (ktValueArgumentList2 != null) {
                ktValueArgumentList = ktValueArgumentList2;
                bl2 = false;
                bl = false;
                it = ktValueArgumentList;
                boolean bl3 = false;
                KtValueArgumentList ktValueArgumentList3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)ktValueArgumentList3, (String)"it");
                String string = ktValueArgumentList3.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
                $this$appendCallOrQualifiedExpression.appendFixedText(string);
            }
            List list = call.getLambdaArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"call.lambdaArguments");
            KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.firstOrNull((List)list);
            if (ktLambdaArgument == null) break block2;
            ktValueArgumentList = ktLambdaArgument;
            bl2 = false;
            bl = false;
            it = ktValueArgumentList;
            boolean bl4 = false;
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
            $this$appendCallOrQualifiedExpression.appendFixedText(string);
        }
    }

    @Nullable
    public static final KtLambdaExpression singleLambdaArgumentExpression(@NotNull KtCallExpression $this$singleLambdaArgumentExpression) {
        KtLambdaExpression ktLambdaExpression;
        Intrinsics.checkNotNullParameter((Object)$this$singleLambdaArgumentExpression, (String)"$this$singleLambdaArgumentExpression");
        List list = $this$singleLambdaArgumentExpression.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"lambdaArguments");
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.singleOrNull((List)list);
        KtExpression $this$safeAs$iv = ktLambdaArgument != null ? ktLambdaArgument.getArgumentExpression() : null;
        boolean $i$f$safeAs = false;
        KtExpression ktExpression = $this$safeAs$iv;
        if (!(ktExpression instanceof KtLambdaExpression)) {
            ktExpression = null;
        }
        if ((ktLambdaExpression = (KtLambdaExpression)ktExpression) == null) {
            ktLambdaExpression = PsiModificationUtilsKt.getLastLambdaExpression((KtCallExpression)$this$singleLambdaArgumentExpression);
        }
        return ktLambdaExpression;
    }

    static {
        Set set = SetsKt.plus((Set)SetsKt.setOf((Object)ArrayFqNames.INSTANCE.getARRAY_OF_FUNCTION()), (Iterable)CollectionsKt.toSet((Iterable)ArrayFqNames.INSTANCE.getPRIMITIVE_TYPE_TO_ARRAY().values()));
        Name name2 = Name.identifier((String)"emptyArray");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"Name.identifier(\"emptyArray\")");
        ARRAY_OF_METHODS = SetsKt.plus((Set)set, (Object)name2);
        KOTLIN_BUILTIN_ENUM_FUNCTIONS = CollectionsKt.listOf((Object[])new FqName[]{new FqName("kotlin.enumValues"), new FqName("kotlin.enumValueOf")});
        ENUM_STATIC_METHODS = CollectionsKt.listOf((Object[])new String[]{"values", "valueOf"});
    }

    public static final /* synthetic */ List access$getKOTLIN_BUILTIN_ENUM_FUNCTIONS$p() {
        return KOTLIN_BUILTIN_ENUM_FUNCTIONS;
    }
}

