/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.intentions.ConvertFunctionToPropertyIntention;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.callableBuilder.CallableBuilderKt;
import org.jetbrains.kotlin.idea.refactoring.CallableRefactoring;
import org.jetbrains.kotlin.idea.refactoring.CallableRefactoringKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionToPropertyIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "startInWriteAction", "Converter", "kotlin.idea"})
public final class ConvertFunctionToPropertyIntention
extends SelfTargetingIntention<KtNamedFunction>
implements LowPriorityAction {
    public boolean startInWriteAction() {
        return false;
    }

    public boolean isApplicableTo(@NotNull KtNamedFunction element3, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiElement psiElement2 = element3.getFunKeyword();
        if (psiElement2 == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.funKeyword ?: return false");
        PsiElement funKeyword = psiElement2;
        PsiElement psiElement3 = element3.getNameIdentifier();
        if (psiElement3 == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"element.nameIdentifier ?: return false");
        PsiElement identifier = psiElement3;
        if (!new TextRange(PsiUtilsKt.getStartOffset((PsiElement)funKeyword), PsiUtilsKt.getEndOffset((PsiElement)identifier)).containsOffset(caretOffset)) {
            return false;
        }
        List list = element3.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"element.valueParameters");
        Collection collection = list;
        boolean bl = false;
        if (!collection.isEmpty() || element3.isLocal()) {
            return false;
        }
        String string = element3.getName();
        Intrinsics.checkNotNull((Object)string);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.name!!");
        String name2 = string;
        if (Intrinsics.areEqual((Object)name2, (Object)"invoke") || Intrinsics.areEqual((Object)name2, (Object)"iterator") || ((ImmutableSet)OperatorConventions.UNARY_OPERATION_NAMES.inverse().keySet()).contains((Object)Name.identifier((String)name2))) {
            return false;
        }
        FunctionDescriptor functionDescriptor2 = ResolutionUtils.resolveToDescriptorIfAny$default((KtNamedFunction)element3, null, (int)1, null);
        if (functionDescriptor2 == null) {
            return false;
        }
        FunctionDescriptor descriptor2 = functionDescriptor2;
        KotlinType kotlinType = descriptor2.getReturnType();
        if (kotlinType == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"descriptor.returnType ?: return false");
        KotlinType returnType2 = kotlinType;
        return !KotlinBuiltIns.isUnit((KotlinType)returnType2) && !KotlinBuiltIns.isNothing((KotlinType)returnType2);
    }

    public void applyTo(@NotNull KtNamedFunction element3, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.unsafeResolveToDescriptor((KtDeclaration)((KtDeclaration)element3), (BodyResolveMode)BodyResolveMode.PARTIAL);
        if (declarationDescriptor == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
        }
        FunctionDescriptor descriptor2 = (FunctionDescriptor)declarationDescriptor;
        Project project2 = element3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"element.project");
        KtFile ktFile = element3.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"element.containingKtFile");
        new Converter(project2, ktFile, editor2, descriptor2).run();
    }

    public ConvertFunctionToPropertyIntention() {
        super(KtNamedFunction.class, KotlinBundle.lazyMessage("convert.function.to.property", new Object[0]), null, 4, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\nJ \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 H\u0002J\u0016\u0010!\u001a\u00020\u00162\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0 H\u0014R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionToPropertyIntention$Converter;", "Lorg/jetbrains/kotlin/idea/refactoring/CallableRefactoring;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "descriptor", "(Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionToPropertyIntention;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)V", "elementsToShorten", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lkotlin/collections/ArrayList;", "newName", "", "getNewName", "()Ljava/lang/String;", "newName$delegate", "Lkotlin/Lazy;", "convertFunction", "", "originalFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "psiFactory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "moveCaret", "", "findMainElement", "Lcom/intellij/psi/PsiElement;", "callables", "", "performRefactoring", "descriptorsForChange", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "kotlin.idea"})
    private final class Converter
    extends CallableRefactoring<FunctionDescriptor> {
        private final ArrayList<KtElement> elementsToShorten;
        private final Lazy newName$delegate;
        private final KtFile file;

        private final String getNewName() {
            Lazy lazy = this.newName$delegate;
            Converter converter = this;
            Object var3_3 = null;
            boolean bl = false;
            return (String)lazy.getValue();
        }

        /*
         * WARNING - void declaration
         */
        private final void convertFunction(KtNamedFunction originalFunction, KtPsiFactory psiFactory, boolean moveCaret) {
            PsiElement psiElement2;
            void $this$replaced$iv;
            KtTypeReference it;
            String string;
            KtTypeConstraint it2;
            Collection<String> collection;
            void $this$mapTo$iv$iv2;
            Object $this$map$iv;
            KtPsiFactory.CallableBuilder callableBuilder = new KtPsiFactory.CallableBuilder(KtPsiFactory.CallableBuilder.Target.READ_ONLY_PROPERTY);
            boolean bl = false;
            boolean bl2 = false;
            KtPsiFactory.CallableBuilder $this$apply = callableBuilder;
            boolean bl3 = false;
            String string2 = originalFunction.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"originalFunction.text");
            Object object = string2;
            int n = 0;
            PsiElement psiElement3 = originalFunction.getFunKeyword();
            Intrinsics.checkNotNull((Object)psiElement3);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"originalFunction.funKeyword!!");
            int n2 = PsiUtilsKt.getStartOffsetIn((PsiElement)psiElement3, (PsiElement)((PsiElement)originalFunction));
            boolean bl4 = false;
            String string3 = object;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            $this$apply.modifier(string4);
            List list = originalFunction.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"originalFunction.typeParameters");
            object = list;
            KtPsiFactory.CallableBuilder callableBuilder2 = $this$apply;
            boolean $i$f$map = false;
            void var12_16 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                KtTypeParameter ktTypeParameter = (KtTypeParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl5 = false;
                void v5 = it2;
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"it");
                string = v5.getText();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            callableBuilder2.typeParams((Collection)collection);
            KtTypeReference ktTypeReference = originalFunction.getReceiverTypeReference();
            if (ktTypeReference != null) {
                $this$map$iv = ktTypeReference;
                $i$f$map = false;
                boolean $this$mapTo$iv$iv2 = false;
                it = $this$map$iv;
                boolean bl6 = false;
                KtTypeReference ktTypeReference2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference2, (String)"it");
                String string5 = ktTypeReference2.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"it.text");
                $this$apply.receiver(string5);
            }
            $this$apply.name(this.getNewName());
            KtTypeReference ktTypeReference3 = CallableBuilderKt.getReturnTypeReference((KtNamedDeclaration)originalFunction);
            if (ktTypeReference3 != null) {
                $this$map$iv = ktTypeReference3;
                $i$f$map = false;
                boolean $this$mapTo$iv$iv2 = false;
                it = $this$map$iv;
                boolean bl7 = false;
                String string6 = it.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"it.text");
                $this$apply.returnType(string6);
            }
            List list2 = originalFunction.getTypeConstraints();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"originalFunction.typeConstraints");
            $this$map$iv = list2;
            callableBuilder2 = $this$apply;
            $i$f$map = false;
            Object $this$mapTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv2.iterator();
            while (iterator.hasNext()) {
                Object item$iv$iv;
                item$iv$iv = iterator.next();
                it2 = (KtTypeConstraint)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl8 = false;
                KtTypeConstraint ktTypeConstraint = it2;
                Intrinsics.checkNotNullExpressionValue((Object)ktTypeConstraint, (String)"it");
                string = ktTypeConstraint.getText();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            callableBuilder2.typeConstraints(collection);
            if (originalFunction.getEqualsToken() != null) {
                KtExpression ktExpression = originalFunction.getBodyExpression();
                Intrinsics.checkNotNull((Object)ktExpression);
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"originalFunction.bodyExpression!!");
                String string7 = ktExpression.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"originalFunction.bodyExpression!!.text");
                $this$apply.getterExpression(string7, originalFunction.getTypeReference() != null);
            } else {
                KtBlockExpression ktBlockExpression = originalFunction.getBodyBlockExpression();
                if (ktBlockExpression != null) {
                    object = ktBlockExpression;
                    n = 0;
                    boolean bl9 = false;
                    Object body2 = object;
                    boolean bl10 = false;
                    $this$apply.transform((Function1)new Function1<StringBuilder, Unit>((KtBlockExpression)body2){
                        final /* synthetic */ KtBlockExpression $body;

                        public final void invoke(@NotNull StringBuilder $this$transform) {
                            Intrinsics.checkNotNullParameter((Object)$this$transform, (String)"$receiver");
                            $this$transform.append("\nget() ");
                            KtBlockExpression ktBlockExpression = this.$body;
                            Intrinsics.checkNotNullExpressionValue((Object)ktBlockExpression, (String)"body");
                            $this$transform.append(ktBlockExpression.getText());
                        }
                        {
                            this.$body = ktBlockExpression;
                            super(1);
                        }
                    });
                }
            }
            String propertyString2 = callableBuilder.asString();
            PsiElement psiElement4 = (PsiElement)originalFunction;
            PsiElement newElement$iv = (PsiElement)psiFactory.createDeclaration(propertyString2);
            boolean $i$f$replaced = false;
            PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
            PsiElement psiElement5 = result$iv;
            if (!(psiElement5 instanceof KtProperty)) {
                psiElement5 = null;
            }
            if ((psiElement2 = (PsiElement)((KtProperty)psiElement5)) == null) {
                PsiElement psiElement6 = result$iv;
                if (psiElement6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                }
                KtExpression ktExpression = ((KtParenthesizedExpression)psiElement6).getExpression();
                if (ktExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
                }
                psiElement2 = (PsiElement)((KtProperty)ktExpression);
            }
            KtProperty replaced2 = (KtProperty)psiElement2;
            if (this.getEditor() != null && moveCaret) {
                CaretModel caretModel = this.getEditor().getCaretModel();
                PsiElement psiElement7 = replaced2.getNameIdentifier();
                Intrinsics.checkNotNull((Object)psiElement7);
                Intrinsics.checkNotNullExpressionValue((Object)psiElement7, (String)"replaced.nameIdentifier!!");
                caretModel.moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)psiElement7));
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void performRefactoring(@NotNull Collection<? extends CallableDescriptor> descriptorsForChange) {
            Intrinsics.checkNotNullParameter(descriptorsForChange, (String)"descriptorsForChange");
            MultiMap conflicts2 = new MultiMap();
            String string = ((FunctionDescriptor)this.getCallableDescriptor()).getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"callableDescriptor.name.asString()");
            String getterName = JvmAbi.getterName((String)string);
            Collection<PsiElement> callables = CallableRefactoringKt.getAffectedCallables(this.getProject(), descriptorsForChange);
            PsiElement mainElement = this.findMainElement(callables);
            ArrayList<KtCallElement> kotlinCalls = new ArrayList<KtCallElement>();
            ArrayList<PsiReference> kotlinRefsToRename = new ArrayList<PsiReference>();
            ArrayList<PsiReference> foreignRefs = new ArrayList<PsiReference>();
            for (PsiElement callable2 : callables) {
                Query usages2;
                Object object;
                if (!(callable2 instanceof PsiNamedElement)) continue;
                if (!this.checkModifiable(callable2)) {
                    KotlinRefactoringUtilKt.reportDeclarationConflict((MultiMap<PsiElement, String>)conflicts2, callable2, (Function1<? super String, String>)((Function1)performRefactoring.1.INSTANCE));
                }
                if (callable2 instanceof KtNamedFunction && (object = CallableRefactoringKt.getContainingScope((DeclarationDescriptor)this.getCallableDescriptor())) != null) {
                    HierarchicalScope hierarchicalScope = (HierarchicalScope)object;
                    Name name2 = ((FunctionDescriptor)this.getCallableDescriptor()).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"callableDescriptor.name");
                    object = ScopeUtilsKt.findVariable$default((HierarchicalScope)hierarchicalScope, (Name)name2, (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE), null, (int)4, null);
                    if (object != null) {
                        LexicalScope lexicalScope = object;
                        boolean bl = false;
                        boolean bl2 = false;
                        LexicalScope it = lexicalScope;
                        boolean bl3 = false;
                        object = Intrinsics.areEqual((Object)UtilsKt.receiverType((CallableDescriptor)it), (Object)UtilsKt.receiverType(this.getCallableDescriptor())) ? lexicalScope : null;
                        if (object != null) {
                            lexicalScope = object;
                            bl = false;
                            bl2 = false;
                            it = lexicalScope;
                            boolean bl4 = false;
                            object = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(this.getProject(), (DeclarationDescriptor)it);
                            if (object != null) {
                                lexicalScope = object;
                                bl = false;
                                bl2 = false;
                                it = lexicalScope;
                                boolean bl5 = false;
                                KotlinRefactoringUtilKt.reportDeclarationConflict((MultiMap<PsiElement, String>)conflicts2, (PsiElement)it, (Function1<? super String, String>)((Function1)performRefactoring.4.1.INSTANCE));
                            }
                        }
                    }
                }
                if (callable2 instanceof PsiMethod) {
                    KotlinRefactoringUtilKt.checkDeclarationConflict((PsiMethod)callable2, getterName, (MultiMap<PsiElement, String>)conflicts2, callables);
                }
                Intrinsics.checkNotNullExpressionValue((Object)ReferencesSearch.search((PsiElement)callable2), (String)"ReferencesSearch.search(callable)");
                for (PsiReference usage : usages2) {
                    if (usage instanceof KtSimpleNameReference) {
                        void $this$getParentOfTypeAndBranch_u24default$iv;
                        KtSimpleNameExpression expression2 = (KtSimpleNameExpression)((KtSimpleNameReference)usage).getExpression();
                        Object object2 = (PsiElement)expression2;
                        Function1 branch$iv = performRefactoring.callElement.1.INSTANCE;
                        boolean strict$iv = false;
                        boolean $i$f$getParentOfTypeAndBranch = false;
                        void $this$getParentOfType$iv$iv = $this$getParentOfTypeAndBranch_u24default$iv;
                        boolean $i$f$getParentOfType = false;
                        PsiElement psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv$iv, KtCallElement.class, (boolean)strict$iv);
                        KtCallElement callElement2 = (KtCallElement)(psiElement2 == null ? null : PsiUtilsKt.getIfChildIsInBranch((PsiElement)psiElement2, (PsiElement)$this$getParentOfTypeAndBranch_u24default$iv, (Function1)branch$iv));
                        if (callElement2 != null) {
                            PsiElement $this$getStrictParentOfType$iv = (PsiElement)expression2;
                            boolean $i$f$getStrictParentOfType = false;
                            if (PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallableReferenceExpression.class, (boolean)true) == null) {
                                List list = callElement2.getTypeArguments();
                                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"callElement.typeArguments");
                                object2 = list;
                                boolean bl = false;
                                if (!object2.isEmpty()) {
                                    Object[] objectArray = new Object[1];
                                    String string2 = StringUtil.htmlEmphasize((String)callElement2.getText());
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringUtil.htmlEmphasize(callElement.text)");
                                    objectArray[0] = string2;
                                    conflicts2.putValue((Object)callElement2, (Object)KotlinBundle.message("type.arguments.will.be.lost.after.conversion.0", objectArray));
                                }
                                List list2 = callElement2.getValueArguments();
                                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"callElement.valueArguments");
                                object2 = list2;
                                bl = false;
                                if (!object2.isEmpty()) {
                                    Object[] objectArray = new Object[1];
                                    String string3 = StringUtil.htmlEmphasize((String)callElement2.getText());
                                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringUtil.htmlEmphasize(callElement.text)");
                                    objectArray[0] = string3;
                                    conflicts2.putValue((Object)callElement2, (Object)KotlinBundle.message("call.with.arguments.will.be.skipped.0", objectArray));
                                    continue;
                                }
                                kotlinCalls.add(callElement2);
                                continue;
                            }
                        }
                        kotlinRefsToRename.add(usage);
                        continue;
                    }
                    foreignRefs.add(usage);
                }
            }
            KotlinRefactoringUtilKt.checkConflictsInteractively$default(this.getProject(), conflicts2, null, (Function0)new Function0<Unit>(this, kotlinCalls, kotlinRefsToRename, foreignRefs, callables, mainElement){
                final /* synthetic */ Converter this$0;
                final /* synthetic */ ArrayList $kotlinCalls;
                final /* synthetic */ ArrayList $kotlinRefsToRename;
                final /* synthetic */ ArrayList $foreignRefs;
                final /* synthetic */ Collection $callables;
                final /* synthetic */ PsiElement $mainElement;

                public final void invoke() {
                    ApplicationUtilsKt.executeWriteCommand((Project)this.this$0.getProject(), (String)this.this$0.ConvertFunctionToPropertyIntention.this.getText(), (Function0)((Function0)new Function0<Unit>(this){
                        final /* synthetic */ performRefactoring.5 this$0;

                        public final void invoke() {
                            KtCallElement it;
                            KtPsiFactory psiFactory = new KtPsiFactory(this.this$0.this$0.getProject(), false, 2, null);
                            String newGetterName = JvmAbi.getterName((String)Converter.access$getNewName$p(this.this$0.this$0));
                            KtExpression newRefExpr = psiFactory.createExpression(Converter.access$getNewName$p(this.this$0.this$0));
                            Iterable $this$forEach$iv = this.this$0.$kotlinCalls;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                it = (KtCallElement)element$iv;
                                boolean bl = false;
                                it.replace((PsiElement)newRefExpr);
                            }
                            $this$forEach$iv = this.this$0.$kotlinRefsToRename;
                            $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                it = (PsiReference)element$iv;
                                boolean bl = false;
                                it.handleElementRename(Converter.access$getNewName$p(this.this$0.this$0));
                            }
                            $this$forEach$iv = this.this$0.$foreignRefs;
                            $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                it = (PsiReference)element$iv;
                                boolean bl = false;
                                it.handleElementRename(newGetterName);
                            }
                            $this$forEach$iv = this.this$0.$callables;
                            $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                it = (PsiElement)element$iv;
                                boolean bl = false;
                                KtCallElement ktCallElement = it;
                                if (ktCallElement instanceof KtNamedFunction) {
                                    Converter.access$convertFunction(this.this$0.this$0, (KtNamedFunction)it, psiFactory, Intrinsics.areEqual((Object)it, (Object)this.this$0.$mainElement));
                                    continue;
                                }
                                if (!(ktCallElement instanceof PsiMethod)) continue;
                                ((PsiMethod)it).setName(newGetterName);
                            }
                            ShortenReferences.process$default((ShortenReferences)ShortenReferences.DEFAULT, (Iterable)Converter.access$getElementsToShorten$p(this.this$0.this$0), null, null, (int)6, null);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                }
                {
                    this.this$0 = converter;
                    this.$kotlinCalls = arrayList;
                    this.$kotlinRefsToRename = arrayList2;
                    this.$foreignRefs = arrayList3;
                    this.$callables = collection;
                    this.$mainElement = psiElement2;
                    super(0);
                }
            }, 2, null);
        }

        private final PsiElement findMainElement(Collection<? extends PsiElement> callables) {
            Object v1;
            block2: {
                if (this.getEditor() == null) {
                    return null;
                }
                CaretModel caretModel = this.getEditor().getCaretModel();
                Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
                int offset = caretModel.getOffset();
                Iterable iterable = callables;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    PsiElement it = (PsiElement)t;
                    boolean bl3 = false;
                    if (!(Intrinsics.areEqual((Object)this.file, (Object)it.getContainingFile()) && it.getTextRange().contains(offset))) continue;
                    v1 = t;
                    break block2;
                }
                v1 = null;
            }
            return v1;
        }

        public Converter(@NotNull Project project2, @Nullable KtFile file2, @NotNull Editor editor2, FunctionDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            super(project2, editor2, (CallableDescriptor)descriptor2, ConvertFunctionToPropertyIntention.this.getText());
            this.file = file2;
            this.elementsToShorten = new ArrayList();
            this.newName$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ Converter this$0;

                @NotNull
                public final String invoke() {
                    Name name2 = ((FunctionDescriptor)this.this$0.getCallableDescriptor()).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"callableDescriptor.name");
                    Name name3 = name2;
                    Name name4 = SyntheticJavaPropertyDescriptor.Companion.propertyNameByGetMethodName(name3);
                    if (name4 == null) {
                        name4 = name3;
                    }
                    String string = name4.asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(SyntheticJavaPropertyDe\u2026name) ?: name).asString()");
                    return string;
                }
                {
                    this.this$0 = converter;
                    super(0);
                }
            }));
        }

        public static final /* synthetic */ String access$getNewName$p(Converter $this) {
            return $this.getNewName();
        }

        public static final /* synthetic */ void access$convertFunction(Converter $this, KtNamedFunction originalFunction, KtPsiFactory psiFactory, boolean moveCaret) {
            $this.convertFunction(originalFunction, psiFactory, moveCaret);
        }

        public static final /* synthetic */ ArrayList access$getElementsToShorten$p(Converter $this) {
            return $this.elementsToShorten;
        }
    }
}

