/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.migration;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteCodeFix;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteCodeProblemReporter;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteExperimentalCoroutinesInspectionKt;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteImportsUsageReporter;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0005H$J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH$R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteImportsUsageReporter;", "Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteCodeProblemReporter;", "()V", "importsToRemove", "", "", "getImportsToRemove", "()Ljava/util/Set;", "packageBindings", "", "getPackageBindings", "()Ljava/util/Map;", "textMarker", "getTextMarker", "()Ljava/lang/String;", "wholeProjectFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "getWholeProjectFix", "()Lcom/intellij/codeInspection/LocalQuickFix;", "findBinding", "Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteImportsUsageReporter$Binding;", "simpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "problemMessage", "report", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "wrapFix", "fix", "Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteCodeFix;", "Binding", "ObsoleteImportFix", "kotlin.idea"})
public abstract class ObsoleteImportsUsageReporter
implements ObsoleteCodeProblemReporter {
    @NotNull
    private final Set<String> importsToRemove = SetsKt.emptySet();

    @NotNull
    protected abstract String getTextMarker();

    @NotNull
    protected abstract Map<String, String> getPackageBindings();

    @NotNull
    protected Set<String> getImportsToRemove() {
        return this.importsToRemove;
    }

    @NotNull
    protected abstract LocalQuickFix getWholeProjectFix();

    @NotNull
    protected abstract String problemMessage();

    @NotNull
    protected abstract LocalQuickFix wrapFix(@NotNull ObsoleteCodeFix var1);

    @Override
    public final boolean report(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull KtSimpleNameExpression simpleNameExpression) {
        KtExpression reportExpression;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)simpleNameExpression, (String)"simpleNameExpression");
        if (Intrinsics.areEqual((Object)simpleNameExpression.getText(), (Object)this.getTextMarker()) ^ true) {
            return false;
        }
        PsiElement psiElement2 = simpleNameExpression.getParent();
        if (!(psiElement2 instanceof KtExpression)) {
            psiElement2 = null;
        }
        KtExpression ktExpression = (KtExpression)psiElement2;
        if (ktExpression == null) {
            return false;
        }
        KtExpression parent2 = ktExpression;
        KtExpression ktExpression2 = parent2;
        if (!(ktExpression2 instanceof KtDotQualifiedExpression)) {
            ktExpression2 = null;
        }
        KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)ktExpression2;
        KtExpression ktExpression3 = reportExpression = ktDotQualifiedExpression != null ? (KtExpression)ktDotQualifiedExpression : (KtExpression)simpleNameExpression;
        if (this.findBinding(simpleNameExpression) == null) {
            return false;
        }
        LocalQuickFix[] localQuickFixArray = ObsoleteExperimentalCoroutinesInspectionKt.fixesWithWholeProject(isOnTheFly, this.wrapFix(new ObsoleteImportFix()), this.getWholeProjectFix());
        holder.registerProblem((PsiElement)reportExpression, this.problemMessage(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
        return true;
    }

    private final Binding findBinding(KtSimpleNameExpression simpleNameExpression) {
        Object v3;
        Object fqNameStr;
        KtImportDirective importDirective2;
        block6: {
            if (Intrinsics.areEqual((Object)simpleNameExpression.getText(), (Object)this.getTextMarker()) ^ true) {
                return null;
            }
            Object object = SequencesKt.lastOrNull((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.getParents((PsiElement)((PsiElement)simpleNameExpression)), (Function1)findBinding.importDirective.1.INSTANCE));
            if (!(object instanceof KtImportDirective)) {
                object = null;
            }
            KtImportDirective ktImportDirective = (KtImportDirective)object;
            if (ktImportDirective == null) {
                return null;
            }
            importDirective2 = ktImportDirective;
            Object object2 = importDirective2.getImportedFqName();
            if (object2 == null || (object2 = object2.asString()) == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"importDirective.imported\u2026asString() ?: return null");
            fqNameStr = object2;
            Iterable iterable = this.getPackageBindings().entrySet();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                Map.Entry $dstr$affectedImportPrefix$_u24__u24 = (Map.Entry)t;
                boolean bl3 = false;
                Map.Entry entry = $dstr$affectedImportPrefix$_u24__u24;
                boolean bl4 = false;
                String affectedImportPrefix = (String)entry.getKey();
                if (!StringsKt.startsWith$default((String)fqNameStr, (String)affectedImportPrefix, (boolean)false, (int)2, null)) continue;
                v3 = t;
                break block6;
            }
            v3 = null;
        }
        Map.Entry entry = v3;
        if (entry == null) {
            return null;
        }
        Map.Entry bindEntry = entry;
        return new Binding(new FqName((String)bindEntry.getValue()), this.getImportsToRemove().contains(fqNameStr), importDirective2);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteImportsUsageReporter$ObsoleteImportFix;", "Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteCodeFix;", "(Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteImportsUsageReporter;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.idea"})
    private final class ObsoleteImportFix
    implements ObsoleteCodeFix {
        @Override
        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            KtSimpleNameExpression ktSimpleNameExpression;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement element3 = descriptor2.getPsiElement();
            if (element3 instanceof KtSimpleNameExpression) {
                ktSimpleNameExpression = (KtSimpleNameExpression)element3;
            } else if (element3 instanceof KtDotQualifiedExpression) {
                KtExpression ktExpression = ((KtDotQualifiedExpression)element3).getSelectorExpression();
                if (!(ktExpression instanceof KtSimpleNameExpression)) {
                    ktExpression = null;
                }
                ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression;
            } else {
                ktSimpleNameExpression = null;
            }
            if (ktSimpleNameExpression == null) {
                return;
            }
            KtSimpleNameExpression simpleNameExpression = ktSimpleNameExpression;
            Binding binding = ObsoleteImportsUsageReporter.this.findBinding(simpleNameExpression);
            if (binding == null) {
                return;
            }
            Binding binding2 = binding;
            if (binding2.getShouldRemove()) {
                binding2.getImportDirective().delete();
            } else {
                KtSimpleNameReference.bindToFqName$default((KtSimpleNameReference)ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)simpleNameExpression), (FqName)binding2.getBindTo(), (KtSimpleNameReference.ShorteningMode)KtSimpleNameReference.ShorteningMode.NO_SHORTENING, null, (int)4, null);
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteImportsUsageReporter$Binding;", "", "bindTo", "Lorg/jetbrains/kotlin/name/FqName;", "shouldRemove", "", "importDirective", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "(Lorg/jetbrains/kotlin/name/FqName;ZLorg/jetbrains/kotlin/psi/KtImportDirective;)V", "getBindTo", "()Lorg/jetbrains/kotlin/name/FqName;", "getImportDirective", "()Lorg/jetbrains/kotlin/psi/KtImportDirective;", "getShouldRemove", "()Z", "kotlin.idea"})
    private static final class Binding {
        @NotNull
        private final FqName bindTo;
        private final boolean shouldRemove;
        @NotNull
        private final KtImportDirective importDirective;

        @NotNull
        public final FqName getBindTo() {
            return this.bindTo;
        }

        public final boolean getShouldRemove() {
            return this.shouldRemove;
        }

        @NotNull
        public final KtImportDirective getImportDirective() {
            return this.importDirective;
        }

        public Binding(@NotNull FqName bindTo, boolean shouldRemove, @NotNull KtImportDirective importDirective2) {
            Intrinsics.checkNotNullParameter((Object)bindTo, (String)"bindTo");
            Intrinsics.checkNotNullParameter((Object)importDirective2, (String)"importDirective");
            this.bindTo = bindTo;
            this.shouldRemove = shouldRemove;
            this.importDirective = importDirective2;
        }
    }
}

