/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.migration;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.LegacyDescriptorUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteCodeFix;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteCodeProblemReporter;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteExperimentalCoroutinesInspectionKt;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteKotlinBrowserUsageFix;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteKotlinJsPackagesUsagesInWholeProjectFix;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/KotlinBrowserFullyQualifiedUsageReporter;", "Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteCodeProblemReporter;", "()V", "report", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "simpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "resolvesToKotlinBrowserPackage", "KotlinBrowserFullyQualifiedUsageFix", "kotlin.idea"})
final class KotlinBrowserFullyQualifiedUsageReporter
implements ObsoleteCodeProblemReporter {
    @NotNull
    public static final KotlinBrowserFullyQualifiedUsageReporter INSTANCE;

    @Override
    public boolean report(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull KtSimpleNameExpression simpleNameExpression) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)simpleNameExpression, (String)"simpleNameExpression");
        PsiElement psiElement2 = simpleNameExpression.getParent();
        if (!(psiElement2 instanceof KtDotQualifiedExpression)) {
            psiElement2 = null;
        }
        KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)psiElement2;
        if (ktDotQualifiedExpression == null) {
            return false;
        }
        KtDotQualifiedExpression fullyQualifiedExpression = ktDotQualifiedExpression;
        KtExpression ktExpression = fullyQualifiedExpression.getReceiverExpression();
        if (!(ktExpression instanceof KtDotQualifiedExpression)) {
            ktExpression = null;
        }
        KtDotQualifiedExpression ktDotQualifiedExpression2 = (KtDotQualifiedExpression)ktExpression;
        if (ktDotQualifiedExpression2 == null) {
            return false;
        }
        KtDotQualifiedExpression kotlinBrowserQualifier = ktDotQualifiedExpression2;
        if (Intrinsics.areEqual((Object)kotlinBrowserQualifier.getText(), (Object)"kotlin.browser") ^ true) {
            return false;
        }
        if (!this.resolvesToKotlinBrowserPackage(simpleNameExpression)) {
            return false;
        }
        LocalQuickFix[] localQuickFixArray = ObsoleteExperimentalCoroutinesInspectionKt.fixesWithWholeProject(isOnTheFly, new ObsoleteKotlinBrowserUsageFix(KotlinBrowserFullyQualifiedUsageFix.INSTANCE), ObsoleteKotlinJsPackagesUsagesInWholeProjectFix.INSTANCE);
        holder.registerProblem((PsiElement)kotlinBrowserQualifier, KotlinBundle.message("package.usages.are.obsolete.since.1.4", "kotlin.dom"), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
        return true;
    }

    private final boolean resolvesToKotlinBrowserPackage(KtSimpleNameExpression simpleNameExpression) {
        Object object = CollectionsKt.singleOrNull((Iterable)ReferenceUtilKt.resolveMainReferenceToDescriptors((KtElement)((KtElement)simpleNameExpression)));
        if (!(object instanceof CallableDescriptor)) {
            object = null;
        }
        CallableDescriptor callableDescriptor = (CallableDescriptor)object;
        if (callableDescriptor == null) {
            return false;
        }
        CallableDescriptor referencedDescriptor = callableDescriptor;
        return Intrinsics.areEqual((Object)LegacyDescriptorUtilsKt.findPackage((DeclarationDescriptor)((DeclarationDescriptor)referencedDescriptor)).getFqName().asString(), (Object)"kotlin.browser");
    }

    private KotlinBrowserFullyQualifiedUsageReporter() {
    }

    static {
        KotlinBrowserFullyQualifiedUsageReporter kotlinBrowserFullyQualifiedUsageReporter;
        INSTANCE = kotlinBrowserFullyQualifiedUsageReporter = new KotlinBrowserFullyQualifiedUsageReporter();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/KotlinBrowserFullyQualifiedUsageReporter$KotlinBrowserFullyQualifiedUsageFix;", "Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteCodeFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.idea"})
    public static final class KotlinBrowserFullyQualifiedUsageFix
    implements ObsoleteCodeFix {
        @NotNull
        public static final KotlinBrowserFullyQualifiedUsageFix INSTANCE;

        @Override
        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (!(psiElement2 instanceof KtDotQualifiedExpression)) {
                psiElement2 = null;
            }
            KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)psiElement2;
            if (ktDotQualifiedExpression == null) {
                return;
            }
            KtDotQualifiedExpression oldQualifier = ktDotQualifiedExpression;
            KtExpression newQualifier = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)oldQualifier), (boolean)false, (int)2, null).createExpression("kotlinx.browser");
            oldQualifier.replace((PsiElement)newQualifier);
        }

        private KotlinBrowserFullyQualifiedUsageFix() {
        }

        static {
            KotlinBrowserFullyQualifiedUsageFix kotlinBrowserFullyQualifiedUsageFix;
            INSTANCE = kotlinBrowserFullyQualifiedUsageFix = new KotlinBrowserFullyQualifiedUsageFix();
        }
    }
}

