/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.dfa;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeBinOp;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfBooleanConstantType;
import com.intellij.codeInspection.dataFlow.types.DfBooleanType;
import com.intellij.codeInspection.dataFlow.types.DfDoubleConstantType;
import com.intellij.codeInspection.dataFlow.types.DfDoubleType;
import com.intellij.codeInspection.dataFlow.types.DfFloatConstantType;
import com.intellij.codeInspection.dataFlow.types.DfFloatType;
import com.intellij.codeInspection.dataFlow.types.DfIntConstantType;
import com.intellij.codeInspection.dataFlow.types.DfIntType;
import com.intellij.codeInspection.dataFlow.types.DfLongConstantType;
import com.intellij.codeInspection.dataFlow.types.DfLongType;
import com.intellij.codeInspection.dataFlow.types.DfNullConstantType;
import com.intellij.codeInspection.dataFlow.types.DfPrimitiveType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0000\u001a\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u000f*\u00020\u0011H\u0000\u001a\u0016\u0010\u0012\u001a\u00020\u0001*\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u0014\u0010\u0015\u001a\u00020\u0001*\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a8\u0006\u0018"}, d2={"getConstant", "Lcom/intellij/codeInspection/dataFlow/types/DfType;", "expr", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "mathOpFromAssignmentToken", "Lcom/intellij/codeInspection/dataFlow/rangeSet/LongRangeBinOp;", "token", "Lcom/intellij/psi/tree/IElementType;", "mathOpFromToken", "ref", "Lorg/jetbrains/kotlin/psi/KtOperationReferenceExpression;", "relationFromToken", "Lcom/intellij/codeInspection/dataFlow/value/RelationType;", "canBeNull", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "getKotlinType", "Lorg/jetbrains/kotlin/psi/KtExpression;", "toDfType", "context", "Lcom/intellij/psi/PsiElement;", "toDfTypeNotNull", "toPsiType", "Lcom/intellij/psi/PsiType;", "kotlin.idea"})
public final class KtDfaHelpersKt {
    @NotNull
    public static final DfType toDfType(@Nullable KotlinType $this$toDfType, @NotNull PsiElement context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if ($this$toDfType == null) {
            DfType dfType = DfType.TOP;
            Intrinsics.checkNotNullExpressionValue((Object)dfType, (String)"DfType.TOP");
            return dfType;
        }
        if (KtDfaHelpersKt.canBeNull($this$toDfType)) {
            DfType dfType;
            DfType notNullableType = KtDfaHelpersKt.toDfTypeNotNull(TypeUtilsKt.makeNotNullable((KotlinType)$this$toDfType), context2);
            if (notNullableType instanceof DfPrimitiveType) {
                DfType dfType2 = SpecialField.UNBOX.asDfType(notNullableType).meet(DfTypes.typedObject((PsiType)KtDfaHelpersKt.toPsiType($this$toDfType, context2), (Nullability)Nullability.UNKNOWN));
                Intrinsics.checkNotNullExpressionValue((Object)dfType2, (String)"SpecialField.UNBOX.asDfT\u2026t), Nullability.UNKNOWN))");
                notNullableType = dfType2;
            }
            if (notNullableType instanceof DfReferenceType) {
                DfType dfType3 = ((DfReferenceType)notNullableType).dropNullability().meet((DfType)DfaNullability.NULLABLE.asDfType());
                dfType = dfType3;
                Intrinsics.checkNotNullExpressionValue((Object)dfType3, (String)"notNullableType.dropNull\u2026lity.NULLABLE.asDfType())");
            } else {
                dfType = notNullableType;
            }
            return dfType;
        }
        return KtDfaHelpersKt.toDfTypeNotNull($this$toDfType, context2);
    }

    private static final DfType toDfTypeNotNull(KotlinType $this$toDfTypeNotNull, PsiElement context2) {
        DfType dfType;
        if (TypeUtilsKt.isBoolean((KotlinType)$this$toDfTypeNotNull)) {
            DfBooleanType dfBooleanType = DfTypes.BOOLEAN;
            Intrinsics.checkNotNullExpressionValue((Object)dfBooleanType, (String)"DfTypes.BOOLEAN");
            dfType = (DfType)dfBooleanType;
        } else if (TypeUtilsKt.isByte((KotlinType)$this$toDfTypeNotNull)) {
            DfType dfType2 = DfTypes.intRange((LongRangeSet)LongRangeSet.range((long)-128, (long)127));
            dfType = dfType2;
            Intrinsics.checkNotNullExpressionValue((Object)dfType2, (String)"DfTypes.intRange(LongRan\u2026Byte.MAX_VALUE.toLong()))");
        } else if (TypeUtilsKt.isChar((KotlinType)$this$toDfTypeNotNull)) {
            DfType dfType3 = DfTypes.intRange((LongRangeSet)LongRangeSet.range((long)0L, (long)65535));
            dfType = dfType3;
            Intrinsics.checkNotNullExpressionValue((Object)dfType3, (String)"DfTypes.intRange(LongRan\u2026cter.MAX_VALUE.toLong()))");
        } else if (TypeUtilsKt.isShort((KotlinType)$this$toDfTypeNotNull)) {
            DfType dfType4 = DfTypes.intRange((LongRangeSet)LongRangeSet.range((long)Short.MIN_VALUE, (long)Short.MAX_VALUE));
            dfType = dfType4;
            Intrinsics.checkNotNullExpressionValue((Object)dfType4, (String)"DfTypes.intRange(LongRan\u2026hort.MAX_VALUE.toLong()))");
        } else if (TypeUtilsKt.isInt((KotlinType)$this$toDfTypeNotNull)) {
            DfIntType dfIntType = DfTypes.INT;
            Intrinsics.checkNotNullExpressionValue((Object)dfIntType, (String)"DfTypes.INT");
            dfType = (DfType)dfIntType;
        } else if (TypeUtilsKt.isLong((KotlinType)$this$toDfTypeNotNull)) {
            DfLongType dfLongType = DfTypes.LONG;
            Intrinsics.checkNotNullExpressionValue((Object)dfLongType, (String)"DfTypes.LONG");
            dfType = (DfType)dfLongType;
        } else if (TypeUtilsKt.isFloat((KotlinType)$this$toDfTypeNotNull)) {
            DfFloatType dfFloatType = DfTypes.FLOAT;
            Intrinsics.checkNotNullExpressionValue((Object)dfFloatType, (String)"DfTypes.FLOAT");
            dfType = (DfType)dfFloatType;
        } else if (TypeUtilsKt.isDouble((KotlinType)$this$toDfTypeNotNull)) {
            DfDoubleType dfDoubleType = DfTypes.DOUBLE;
            Intrinsics.checkNotNullExpressionValue((Object)dfDoubleType, (String)"DfTypes.DOUBLE");
            dfType = (DfType)dfDoubleType;
        } else {
            DfType dfType5 = DfTypes.typedObject((PsiType)KtDfaHelpersKt.toPsiType($this$toDfTypeNotNull, context2), (Nullability)Nullability.NOT_NULL);
            dfType = dfType5;
            Intrinsics.checkNotNullExpressionValue((Object)dfType5, (String)"DfTypes.typedObject(toPs\u2026t), Nullability.NOT_NULL)");
        }
        return dfType;
    }

    public static final boolean canBeNull(@NotNull KotlinType $this$canBeNull) {
        Intrinsics.checkNotNullParameter((Object)$this$canBeNull, (String)"$this$canBeNull");
        return $this$canBeNull.isMarkedNullable() || FlexibleTypesKt.isNullabilityFlexible((KotlinType)$this$canBeNull);
    }

    @NotNull
    public static final DfType getConstant(@NotNull KtConstantExpression expr) {
        DfType dfType;
        ConstantValue constant;
        Object object;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)((KtElement)expr), (BodyResolveMode)BodyResolveMode.PARTIAL);
        KotlinType type2 = bindingContext2.getType((KtExpression)expr);
        if (type2 == null) {
            object = null;
        } else {
            CompileTimeConstant compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant((KtExpression)expr, bindingContext2);
            object = compileTimeConstant != null ? compileTimeConstant.toConstantValue(type2) : null;
        }
        ConstantValue constantValue = constant = object;
        if (constantValue instanceof NullValue) {
            DfNullConstantType dfNullConstantType = DfTypes.NULL;
            Intrinsics.checkNotNullExpressionValue((Object)dfNullConstantType, (String)"DfTypes.NULL");
            dfType = (DfType)dfNullConstantType;
        } else if (constantValue instanceof BooleanValue) {
            DfBooleanConstantType dfBooleanConstantType = DfTypes.booleanValue((boolean)((Boolean)((BooleanValue)constant).getValue()));
            Intrinsics.checkNotNullExpressionValue((Object)dfBooleanConstantType, (String)"DfTypes.booleanValue(constant.value)");
            dfType = (DfType)dfBooleanConstantType;
        } else if (constantValue instanceof ByteValue) {
            DfIntConstantType dfIntConstantType = DfTypes.intValue((int)((Number)((ByteValue)constant).getValue()).byteValue());
            Intrinsics.checkNotNullExpressionValue((Object)dfIntConstantType, (String)"DfTypes.intValue(constant.value.toInt())");
            dfType = (DfType)dfIntConstantType;
        } else if (constantValue instanceof ShortValue) {
            DfIntConstantType dfIntConstantType = DfTypes.intValue((int)((Number)((ShortValue)constant).getValue()).shortValue());
            Intrinsics.checkNotNullExpressionValue((Object)dfIntConstantType, (String)"DfTypes.intValue(constant.value.toInt())");
            dfType = (DfType)dfIntConstantType;
        } else if (constantValue instanceof CharValue) {
            DfIntConstantType dfIntConstantType = DfTypes.intValue((int)((Character)((CharValue)constant).getValue()).charValue());
            Intrinsics.checkNotNullExpressionValue((Object)dfIntConstantType, (String)"DfTypes.intValue(constant.value.toInt())");
            dfType = (DfType)dfIntConstantType;
        } else if (constantValue instanceof IntValue) {
            DfIntConstantType dfIntConstantType = DfTypes.intValue((int)((Number)((IntValue)constant).getValue()).intValue());
            Intrinsics.checkNotNullExpressionValue((Object)dfIntConstantType, (String)"DfTypes.intValue(constant.value)");
            dfType = (DfType)dfIntConstantType;
        } else if (constantValue instanceof LongValue) {
            DfLongConstantType dfLongConstantType = DfTypes.longValue((long)((Number)((LongValue)constant).getValue()).longValue());
            Intrinsics.checkNotNullExpressionValue((Object)dfLongConstantType, (String)"DfTypes.longValue(constant.value)");
            dfType = (DfType)dfLongConstantType;
        } else if (constantValue instanceof FloatValue) {
            DfFloatConstantType dfFloatConstantType = DfTypes.floatValue((float)((Number)((FloatValue)constant).getValue()).floatValue());
            Intrinsics.checkNotNullExpressionValue((Object)dfFloatConstantType, (String)"DfTypes.floatValue(constant.value)");
            dfType = (DfType)dfFloatConstantType;
        } else if (constantValue instanceof DoubleValue) {
            DfDoubleConstantType dfDoubleConstantType = DfTypes.doubleValue((double)((Number)((DoubleValue)constant).getValue()).doubleValue());
            Intrinsics.checkNotNullExpressionValue((Object)dfDoubleConstantType, (String)"DfTypes.doubleValue(constant.value)");
            dfType = (DfType)dfDoubleConstantType;
        } else {
            DfType dfType2 = DfType.TOP;
            dfType = dfType2;
            Intrinsics.checkNotNullExpressionValue((Object)dfType2, (String)"DfType.TOP");
        }
        return dfType;
    }

    @Nullable
    public static final KotlinType getKotlinType(@NotNull KtExpression $this$getKotlinType) {
        Intrinsics.checkNotNullParameter((Object)$this$getKotlinType, (String)"$this$getKotlinType");
        return ResolutionUtils.analyze((KtElement)((KtElement)$this$getKotlinType), (BodyResolveMode)BodyResolveMode.PARTIAL).getType($this$getKotlinType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final PsiType toPsiType(@NotNull KotlinType $this$toPsiType, @NotNull PsiElement context2) {
        Intrinsics.checkNotNullParameter((Object)$this$toPsiType, (String)"$this$toPsiType");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ClassifierDescriptor classifierDescriptor = $this$toPsiType.getConstructor().getDeclarationDescriptor();
        String typeFqName = classifierDescriptor != null && (classifierDescriptor = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptor))) != null ? classifierDescriptor.asString() : null;
        boolean boxed = $this$toPsiType.isMarkedNullable();
        Function1<PsiPrimitiveType, PsiType> $fun$orBoxed$1 = new Function1<PsiPrimitiveType, PsiType>(boxed, context2){
            final /* synthetic */ boolean $boxed;
            final /* synthetic */ PsiElement $context;

            @Nullable
            public final PsiType invoke(@NotNull PsiPrimitiveType $this$orBoxed) {
                Intrinsics.checkNotNullParameter((Object)$this$orBoxed, (String)"$this$orBoxed");
                return this.$boxed ? (PsiType)$this$orBoxed.getBoxedType(this.$context) : (PsiType)$this$orBoxed;
            }
            {
                this.$boxed = bl;
                this.$context = psiElement2;
                super(1);
            }
        };
        String string = typeFqName;
        if (string == null) return null;
        switch (string) {
            case "kotlin.Int": {
                PsiPrimitiveType psiPrimitiveType = PsiType.INT;
                Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType, (String)"PsiType.INT");
                PsiType psiType = $fun$orBoxed$1.invoke(psiPrimitiveType);
                return psiType;
            }
            case "kotlin.Long": {
                PsiPrimitiveType psiPrimitiveType = PsiType.LONG;
                Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType, (String)"PsiType.LONG");
                PsiType psiType = $fun$orBoxed$1.invoke(psiPrimitiveType);
                return psiType;
            }
            case "kotlin.Short": {
                PsiPrimitiveType psiPrimitiveType = PsiType.SHORT;
                Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType, (String)"PsiType.SHORT");
                PsiType psiType = $fun$orBoxed$1.invoke(psiPrimitiveType);
                return psiType;
            }
            case "kotlin.Boolean": {
                PsiPrimitiveType psiPrimitiveType = PsiType.BOOLEAN;
                Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType, (String)"PsiType.BOOLEAN");
                PsiType psiType = $fun$orBoxed$1.invoke(psiPrimitiveType);
                return psiType;
            }
            case "kotlin.Byte": {
                PsiPrimitiveType psiPrimitiveType = PsiType.BYTE;
                Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType, (String)"PsiType.BYTE");
                PsiType psiType = $fun$orBoxed$1.invoke(psiPrimitiveType);
                return psiType;
            }
            case "kotlin.Char": {
                PsiPrimitiveType psiPrimitiveType = PsiType.CHAR;
                Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType, (String)"PsiType.CHAR");
                PsiType psiType = $fun$orBoxed$1.invoke(psiPrimitiveType);
                return psiType;
            }
            case "kotlin.Double": {
                PsiPrimitiveType psiPrimitiveType = PsiType.DOUBLE;
                Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType, (String)"PsiType.DOUBLE");
                PsiType psiType = $fun$orBoxed$1.invoke(psiPrimitiveType);
                return psiType;
            }
            case "kotlin.Float": {
                PsiPrimitiveType psiPrimitiveType = PsiType.FLOAT;
                Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType, (String)"PsiType.FLOAT");
                PsiType psiType = $fun$orBoxed$1.invoke(psiPrimitiveType);
                return psiType;
            }
            case "kotlin.Unit": {
                PsiPrimitiveType psiPrimitiveType = PsiType.VOID;
                Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType, (String)"PsiType.VOID");
                PsiType psiType = $fun$orBoxed$1.invoke(psiPrimitiveType);
                return psiType;
            }
            case "kotlin.String": {
                PsiType psiType = (PsiType)PsiType.getJavaLangString((PsiManager)context2.getManager(), (GlobalSearchScope)context2.getResolveScope());
                return psiType;
            }
            default: {
                return null;
            }
        }
    }

    @Nullable
    public static final RelationType relationFromToken(@NotNull IElementType token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        IElementType iElementType = token;
        return Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LT) ? RelationType.LT : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GT) ? RelationType.GT : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LTEQ) ? RelationType.LE : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GTEQ) ? RelationType.GE : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ) ? RelationType.EQ : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ) ? RelationType.NE : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQEQ) ? RelationType.EQ : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQEQEQ) ? RelationType.NE : null)))))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final LongRangeBinOp mathOpFromToken(@NotNull KtOperationReferenceExpression ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        String string = ref.getText();
        if (string == null) return null;
        switch (string) {
            case "+": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.PLUS;
                return longRangeBinOp;
            }
            case "-": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.MINUS;
                return longRangeBinOp;
            }
            case "*": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.MUL;
                return longRangeBinOp;
            }
            case "/": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.DIV;
                return longRangeBinOp;
            }
            case "%": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.MOD;
                return longRangeBinOp;
            }
            case "and": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.AND;
                return longRangeBinOp;
            }
            case "or": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.OR;
                return longRangeBinOp;
            }
            case "xor": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.XOR;
                return longRangeBinOp;
            }
            case "shl": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.SHL;
                return longRangeBinOp;
            }
            case "shr": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.SHR;
                return longRangeBinOp;
            }
            case "ushr": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.USHR;
                return longRangeBinOp;
            }
            default: {
                return null;
            }
        }
    }

    @Nullable
    public static final LongRangeBinOp mathOpFromAssignmentToken(@NotNull IElementType token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        IElementType iElementType = token;
        return Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUSEQ) ? LongRangeBinOp.PLUS : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUSEQ) ? LongRangeBinOp.MINUS : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MULTEQ) ? LongRangeBinOp.MUL : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.DIVEQ) ? LongRangeBinOp.DIV : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PERCEQ) ? LongRangeBinOp.MOD : null))));
    }
}

