/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.dfa;

import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.interpreter.DataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.java.inst.BooleanBinaryInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.JvmPushInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.NotInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.NumericBinaryInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.PrimitiveConversionInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.StringConcatInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.ThrowInstruction;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.jvm.transfer.ExceptionTransfer;
import com.intellij.codeInspection.dataFlow.jvm.transfer.InstructionTransfer;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.ir.ClosureInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlTransferInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.lang.ir.DupInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.EnsureInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.EvalUnknownInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.FinishElementInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.FlushFieldsInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.FlushVariableInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.GotoInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.lang.ir.PopInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.PushValueInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.ResultOfInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.SimpleAssignmentInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.SwapInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.UnwrapDerivedVariableInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.WrapDerivedVariableInstruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeBinOp;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfBooleanType;
import com.intellij.codeInspection.dataFlow.types.DfIntConstantType;
import com.intellij.codeInspection.dataFlow.types.DfIntegralType;
import com.intellij.codeInspection.dataFlow.types.DfLongConstantType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DerivedVariableDescriptor;
import com.intellij.codeInspection.dataFlow.value.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.FList;
import com.intellij.util.containers.FactoryMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinExpressionAnchor;
import org.jetbrains.kotlin.idea.inspections.dfa.KtDfaHelpersKt;
import org.jetbrains.kotlin.idea.inspections.dfa.KtLocalVariableDescriptor;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.CommonUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveMethod.MoveKotlinMethodProcessorKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a6\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 q2\u00020\u0001:\u0001qB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00052\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J&\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00052\b\u0010 \u001a\u0004\u0018\u00010\u001f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#H\u0002J\u001e\u0010$\u001a\u0004\u0018\u00010\u001f2\b\u0010%\u001a\u0004\u0018\u00010\u001f2\b\u0010&\u001a\u0004\u0018\u00010\u001fH\u0002J\b\u0010'\u001a\u0004\u0018\u00010\u0015J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\rH\u0002J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0002J\u0010\u0010*\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020\rJ\u0012\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u000204H\u0002J\u0016\u00105\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u00106\u001a\u00020-H\u0002J\u0010\u00107\u001a\u00020\u001c2\u0006\u00103\u001a\u000208H\u0002J\u0010\u00109\u001a\u00020\u001c2\u0006\u00103\u001a\u000208H\u0002J \u0010:\u001a\u00020\u001c2\u0006\u00103\u001a\u0002082\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\bH\u0002J\u0010\u0010>\u001a\u00020\u001c2\u0006\u00103\u001a\u00020?H\u0002J\u0010\u0010@\u001a\u00020\u001c2\u0006\u00103\u001a\u00020AH\u0002J\u0010\u0010B\u001a\u00020\u001c2\u0006\u00103\u001a\u00020CH\u0002J\u0010\u0010D\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020FH\u0002J\u0010\u0010G\u001a\u00020\u001c2\u0006\u00103\u001a\u00020HH\u0002J\u0012\u0010I\u001a\u00020\u001c2\b\u00103\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010J\u001a\u00020\u001c2\u0006\u00103\u001a\u00020KH\u0002J\u0010\u0010L\u001a\u00020\u001c2\u0006\u0010M\u001a\u00020NH\u0002J\u0010\u0010O\u001a\u00020\u001c2\u0006\u00103\u001a\u00020PH\u0002J\u0010\u0010Q\u001a\u00020\u001c2\u0006\u00103\u001a\u00020RH\u0002J\u0018\u0010S\u001a\u00020\u001c2\u0006\u00103\u001a\u0002082\u0006\u0010T\u001a\u00020UH\u0002J\u0010\u0010V\u001a\u00020\u001c2\u0006\u00103\u001a\u000208H\u0002J\u0010\u0010W\u001a\u00020\u001c2\u0006\u00103\u001a\u00020XH\u0002J\u0010\u0010Y\u001a\u00020\u001c2\u0006\u00103\u001a\u00020ZH\u0002J\u0010\u0010[\u001a\u00020\u001c2\u0006\u00103\u001a\u000204H\u0002J\u0010\u0010\\\u001a\u00020\u001c2\u0006\u00103\u001a\u00020]H\u0002J\u0010\u0010^\u001a\u00020\u001c2\u0006\u00103\u001a\u00020_H\u0002J\u0018\u0010`\u001a\u00020\u001c2\u0006\u00103\u001a\u0002082\u0006\u0010a\u001a\u00020\bH\u0002J\u0010\u0010b\u001a\u00020\u001c2\u0006\u00103\u001a\u00020cH\u0002J\u0010\u0010d\u001a\u00020\u001c2\u0006\u00103\u001a\u00020eH\u0002J\u0018\u0010f\u001a\u00020\u001c2\u0006\u00103\u001a\u00020g2\u0006\u0010h\u001a\u00020iH\u0002J\u0010\u0010j\u001a\u00020\u001c2\u0006\u00103\u001a\u00020gH\u0002J\u0010\u0010k\u001a\u00020\u001c2\u0006\u00103\u001a\u00020lH\u0002J\b\u0010m\u001a\u00020\u001cH\u0002J\u0010\u0010n\u001a\u00020\u001c2\u0006\u0010o\u001a\u00020pH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nRV\u0010\u000b\u001aJ\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u000f0\u000f \u000e*#\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u000f0\u000f0\u0011\u00a2\u0006\u0002\b\u00100\f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/dfa/KtControlFlowBuilder;", "", "factory", "Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;", "context", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;Lorg/jetbrains/kotlin/psi/KtExpression;)V", "broken", "", "getContext", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "exceptionCache", "", "", "kotlin.jvm.PlatformType", "Lcom/intellij/codeInspection/dataFlow/jvm/transfer/ExceptionTransfer;", "Lorg/jetbrains/annotations/NotNull;", "", "getFactory", "()Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;", "flow", "Lcom/intellij/codeInspection/dataFlow/lang/ir/ControlFlow;", "stringType", "Lcom/intellij/psi/PsiClassType;", "traps", "Lcom/intellij/util/containers/FList;", "Lcom/intellij/codeInspection/dataFlow/value/DfaControlTransferValue$Trap;", "addImplicitConversion", "", "expression", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "actualType", "addInstruction", "inst", "Lcom/intellij/codeInspection/dataFlow/lang/ir/Instruction;", "balanceType", "left", "right", "buildFlow", "createClassType", "fqn", "createTransfer", "Lcom/intellij/codeInspection/dataFlow/jvm/transfer/InstructionTransfer;", "exitedStatement", "Lcom/intellij/psi/PsiElement;", "blockToFlush", "Lcom/intellij/codeInspection/dataFlow/value/DfaControlTransferValue;", "exception", "findSpecialField", "Lcom/intellij/codeInspection/dataFlow/jvm/SpecialField;", "expr", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "getTrapsInsideElement", "element", "processAssignmentExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "processBinaryExpression", "processBinaryRelationExpression", "relation", "Lcom/intellij/codeInspection/dataFlow/value/RelationType;", "forceEqualityByContent", "processBlock", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "processCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "processConstantExpression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "processDeclaration", "variable", "Lorg/jetbrains/kotlin/psi/KtProperty;", "processDoWhileExpression", "Lorg/jetbrains/kotlin/psi/KtDoWhileExpression;", "processExpression", "processForExpression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "processIfExpression", "ifExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "processLabeledJumpExpression", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "processLambda", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "processMathExpression", "mathOp", "Lcom/intellij/codeInspection/dataFlow/rangeSet/LongRangeBinOp;", "processNullSafeOperator", "processPostfixExpression", "Lorg/jetbrains/kotlin/psi/KtPostfixExpression;", "processPrefixExpression", "Lorg/jetbrains/kotlin/psi/KtPrefixExpression;", "processQualifiedReferenceExpression", "processReferenceExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "processReturnExpression", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "processShortCircuitExpression", "and", "processStringTemplate", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "processThrowExpression", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "processWhenCondition", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "condition", "Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "processWhenExpression", "processWhileExpression", "Lorg/jetbrains/kotlin/psi/KtWhileExpression;", "pushUnknown", "setOffset", "offset", "Lcom/intellij/codeInspection/dataFlow/lang/ir/ControlFlow$DeferredOffset;", "Companion", "kotlin.idea"})
public final class KtControlFlowBuilder {
    private final FList<DfaControlTransferValue.Trap> traps;
    private final ControlFlow flow;
    private boolean broken;
    private final Map<String, ExceptionTransfer> exceptionCache;
    private final PsiClassType stringType;
    @NotNull
    private final DfaValueFactory factory;
    @NotNull
    private final KtExpression context;
    private static final Logger LOG;
    private static final TokenSet ASSIGNMENT_TOKENS;
    private static final AtomicInteger totalCount;
    private static final AtomicInteger successCount;
    @NotNull
    public static final Companion Companion;

    private final PsiClassType createClassType(String fqn) {
        PsiClassType psiClassType;
        Project project2 = this.factory.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"factory.project");
        Project project3 = project2;
        GlobalSearchScope globalSearchScope = this.context.getResolveScope();
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"context.resolveScope");
        GlobalSearchScope scope2 = globalSearchScope;
        PsiClass aClass = JavaPsiFacade.getInstance((Project)project3).findClass(fqn, scope2);
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project3);
        if (aClass != null) {
            PsiClassType psiClassType2 = elementFactory.createType(aClass);
            psiClassType = psiClassType2;
            Intrinsics.checkNotNullExpressionValue((Object)psiClassType2, (String)"elementFactory.createType(aClass)");
        } else {
            PsiClassType psiClassType3 = elementFactory.createTypeByFQClassName(fqn, scope2);
            psiClassType = psiClassType3;
            Intrinsics.checkNotNullExpressionValue((Object)psiClassType3, (String)"elementFactory.createTypeByFQClassName(fqn, scope)");
        }
        return psiClassType;
    }

    @Nullable
    public final ControlFlow buildFlow() {
        this.processExpression(this.context);
        if (LOG.isDebugEnabled()) {
            int success;
            int total = totalCount.incrementAndGet();
            int n = success = !this.broken ? successCount.incrementAndGet() : successCount.get();
            if (total % 100 == 0) {
                LOG.info("Analyzed: " + success + " of " + total + " (" + success * 100 / total + "%)");
            }
        }
        if (this.broken) {
            return null;
        }
        this.addInstruction((Instruction)new PopInstruction());
        this.flow.finish();
        return this.flow;
    }

    private final void processExpression(KtExpression expr) {
        KtExpression ktExpression = expr;
        if (ktExpression == null) {
            this.pushUnknown();
        } else if (ktExpression instanceof KtBlockExpression) {
            this.processBlock((KtBlockExpression)expr);
        } else if (ktExpression instanceof KtParenthesizedExpression) {
            this.processExpression(((KtParenthesizedExpression)expr).getExpression());
        } else if (ktExpression instanceof KtBinaryExpression) {
            this.processBinaryExpression((KtBinaryExpression)expr);
        } else if (ktExpression instanceof KtPrefixExpression) {
            this.processPrefixExpression((KtPrefixExpression)expr);
        } else if (ktExpression instanceof KtPostfixExpression) {
            this.processPostfixExpression((KtPostfixExpression)expr);
        } else if (ktExpression instanceof KtCallExpression) {
            this.processCallExpression((KtCallExpression)expr);
        } else if (ktExpression instanceof KtConstantExpression) {
            this.processConstantExpression((KtConstantExpression)expr);
        } else if (ktExpression instanceof KtSimpleNameExpression) {
            this.processReferenceExpression((KtSimpleNameExpression)expr);
        } else if (ktExpression instanceof KtDotQualifiedExpression) {
            this.processQualifiedReferenceExpression((KtQualifiedExpression)expr);
        } else if (ktExpression instanceof KtSafeQualifiedExpression) {
            this.processQualifiedReferenceExpression((KtQualifiedExpression)expr);
        } else if (ktExpression instanceof KtReturnExpression) {
            this.processReturnExpression((KtReturnExpression)expr);
        } else if (ktExpression instanceof KtContinueExpression) {
            this.processLabeledJumpExpression((KtExpressionWithLabel)expr);
        } else if (ktExpression instanceof KtBreakExpression) {
            this.processLabeledJumpExpression((KtExpressionWithLabel)expr);
        } else if (ktExpression instanceof KtThrowExpression) {
            this.processThrowExpression((KtThrowExpression)expr);
        } else if (ktExpression instanceof KtIfExpression) {
            this.processIfExpression((KtIfExpression)expr);
        } else if (ktExpression instanceof KtWhenExpression) {
            this.processWhenExpression((KtWhenExpression)expr);
        } else if (ktExpression instanceof KtWhileExpression) {
            this.processWhileExpression((KtWhileExpression)expr);
        } else if (ktExpression instanceof KtDoWhileExpression) {
            this.processDoWhileExpression((KtDoWhileExpression)expr);
        } else if (ktExpression instanceof KtForExpression) {
            this.processForExpression((KtForExpression)expr);
        } else if (ktExpression instanceof KtProperty) {
            this.processDeclaration((KtProperty)expr);
        } else if (ktExpression instanceof KtLambdaExpression) {
            this.processLambda((KtLambdaExpression)expr);
        } else if (ktExpression instanceof KtStringTemplateExpression) {
            this.processStringTemplate((KtStringTemplateExpression)expr);
        } else {
            this.broken = true;
        }
        this.flow.finishElement((PsiElement)expr);
    }

    private final void processStringTemplate(KtStringTemplateExpression expr) {
        Object[] entries;
        boolean first = true;
        Object[] objectArray = expr.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"expr.entries");
        Object[] objectArray2 = entries = objectArray;
        boolean bl = false;
        if (objectArray2.length == 0) {
            this.addInstruction((Instruction)new PushValueInstruction((DfType)DfTypes.constant((Object)"", (PsiType)((PsiType)this.stringType))));
            return;
        }
        KtStringTemplateEntry lastEntry = (KtStringTemplateEntry)ArraysKt.last((Object[])entries);
        for (Object entry : entries) {
            Object object = entry;
            if (object instanceof KtEscapeStringTemplateEntry) {
                this.addInstruction((Instruction)new PushValueInstruction((DfType)DfTypes.constant((Object)((KtEscapeStringTemplateEntry)entry).getUnescapedValue(), (PsiType)((PsiType)this.stringType))));
            } else if (object instanceof KtLiteralStringTemplateEntry) {
                this.addInstruction((Instruction)new PushValueInstruction((DfType)DfTypes.constant((Object)((KtLiteralStringTemplateEntry)entry).getText(), (PsiType)((PsiType)this.stringType))));
            } else if (object instanceof KtStringTemplateEntryWithExpression) {
                this.processExpression(((KtStringTemplateEntryWithExpression)entry).getExpression());
            } else {
                this.pushUnknown();
            }
            if (!first) {
                KotlinExpressionAnchor anchor = Intrinsics.areEqual((Object)entry, (Object)lastEntry) ? new KotlinExpressionAnchor((KtExpression)expr) : null;
                this.addInstruction((Instruction)new StringConcatInstruction((DfaAnchor)anchor, (PsiType)this.stringType));
            }
            first = false;
        }
    }

    private final void processLambda(KtLambdaExpression expr) {
        this.addInstruction((Instruction)new ClosureInstruction(CollectionsKt.listOf((Object)expr)));
        this.pushUnknown();
    }

    private final void processCallExpression(KtCallExpression expr) {
        List args;
        KtValueArgumentList ktValueArgumentList = expr.getValueArgumentList();
        List list = args = ktValueArgumentList != null ? ktValueArgumentList.getArguments() : null;
        if (args != null) {
            for (KtValueArgument arg : args) {
                KtExpression argExpr = arg.getArgumentExpression();
                if (argExpr == null) continue;
                this.processExpression(argExpr);
                this.addInstruction((Instruction)new PopInstruction());
            }
        }
        for (KtLambdaArgument lambdaArg : expr.getLambdaArguments()) {
            this.processExpression((KtExpression)lambdaArg.getLambdaExpression());
            this.addInstruction((Instruction)new PopInstruction());
        }
        this.pushUnknown();
        this.addInstruction((Instruction)new FlushFieldsInstruction());
    }

    private final void processQualifiedReferenceExpression(KtQualifiedExpression expr) {
        SpecialField specialField;
        this.processExpression(expr.getReceiverExpression());
        SpecialField specialField2 = specialField = expr instanceof KtDotQualifiedExpression ? this.findSpecialField(expr) : null;
        if (specialField != null) {
            this.addInstruction((Instruction)new UnwrapDerivedVariableInstruction((DerivedVariableDescriptor)specialField));
        } else {
            this.addInstruction((Instruction)new PopInstruction());
            this.processExpression(expr.getSelectorExpression());
            this.addInstruction((Instruction)new PopInstruction());
            this.pushUnknown();
        }
    }

    private final SpecialField findSpecialField(KtQualifiedExpression expr) {
        KtExpression ktExpression = expr.getSelectorExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression selector = ktExpression;
        KtExpression receiver = expr.getReceiverExpression();
        String string = selector.getText();
        if (string != null) {
            switch (string) {
                case "size": {
                    KotlinType kotlinType = KtDfaHelpersKt.getKotlinType(receiver);
                    if (kotlinType == null) {
                        return null;
                    }
                    KotlinType type2 = kotlinType;
                    if (KotlinBuiltIns.isArray((KotlinType)type2) || KotlinBuiltIns.isPrimitiveArray((KotlinType)type2)) {
                        return SpecialField.ARRAY_LENGTH;
                    }
                    if (KotlinBuiltIns.isCollectionOrNullableCollection((KotlinType)type2) || KotlinBuiltIns.isMapOrNullableMap((KotlinType)type2)) {
                        return SpecialField.COLLECTION_SIZE;
                    }
                    return null;
                }
                case "length": {
                    KotlinType kotlinType = KtDfaHelpersKt.getKotlinType(receiver);
                    if (kotlinType == null) {
                        return null;
                    }
                    KotlinType type3 = kotlinType;
                    return KotlinBuiltIns.isStringOrNullableString((KotlinType)type3) ? SpecialField.STRING_LENGTH : null;
                }
            }
        }
        return null;
    }

    private final void processPrefixExpression(KtPrefixExpression expr) {
        KtExpression operand = expr.getBaseExpression();
        this.processExpression(operand);
        KotlinExpressionAnchor anchor = new KotlinExpressionAnchor((KtExpression)expr);
        if (operand != null) {
            DfType dfType = KtDfaHelpersKt.toDfType(KtDfaHelpersKt.getKotlinType(operand), (PsiElement)expr);
            KtLocalVariableDescriptor descriptor2 = KtLocalVariableDescriptor.Companion.create(operand);
            KtSimpleNameExpression ktSimpleNameExpression = expr.getOperationReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"expr.operationReference");
            String ref = ktSimpleNameExpression.getText();
            if (dfType instanceof DfIntegralType) {
                String string = ref;
                if (string != null) {
                    switch (string) {
                        case "++": 
                        case "--": {
                            if (descriptor2 == null) break;
                            this.addInstruction((Instruction)new PushValueInstruction(((DfIntegralType)dfType).meetRange(LongRangeSet.point((long)1L))));
                            this.addInstruction((Instruction)new NumericBinaryInstruction(Intrinsics.areEqual((Object)ref, (Object)"++") ? LongRangeBinOp.PLUS : LongRangeBinOp.MINUS, null));
                            this.addInstruction((Instruction)new SimpleAssignmentInstruction((DfaAnchor)anchor, this.factory.getVarFactory().createVariableValue((VariableDescriptor)descriptor2)));
                            return;
                        }
                        case "+": {
                            return;
                        }
                        case "-": {
                            this.addInstruction((Instruction)new PushValueInstruction(((DfIntegralType)dfType).meetRange(LongRangeSet.point((long)0L))));
                            this.addInstruction((Instruction)new SwapInstruction());
                            this.addInstruction((Instruction)new NumericBinaryInstruction(LongRangeBinOp.MINUS, (DfaAnchor)anchor));
                            return;
                        }
                    }
                }
            }
            if (dfType instanceof DfBooleanType && Intrinsics.areEqual((Object)ref, (Object)"!")) {
                this.addInstruction((Instruction)new NotInstruction((DfaAnchor)anchor));
                return;
            }
            if (descriptor2 != null && (Intrinsics.areEqual((Object)ref, (Object)"++") || Intrinsics.areEqual((Object)ref, (Object)"--"))) {
                this.addInstruction((Instruction)new FlushVariableInstruction(this.factory.getVarFactory().createVariableValue((VariableDescriptor)descriptor2)));
            }
        }
        this.addInstruction((Instruction)new EvalUnknownInstruction((DfaAnchor)anchor, 1));
    }

    private final void processPostfixExpression(KtPostfixExpression expr) {
        KtExpression operand = expr.getBaseExpression();
        this.processExpression(operand);
        KotlinExpressionAnchor anchor = new KotlinExpressionAnchor((KtExpression)expr);
        KtSimpleNameExpression ktSimpleNameExpression = expr.getOperationReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"expr.operationReference");
        String ref = ktSimpleNameExpression.getText();
        if (Intrinsics.areEqual((Object)ref, (Object)"++") || Intrinsics.areEqual((Object)ref, (Object)"--")) {
            if (operand != null) {
                DfType dfType = KtDfaHelpersKt.toDfType(KtDfaHelpersKt.getKotlinType(operand), (PsiElement)expr);
                KtLocalVariableDescriptor descriptor2 = KtLocalVariableDescriptor.Companion.create(operand);
                if (descriptor2 != null) {
                    if (dfType instanceof DfIntegralType) {
                        this.addInstruction((Instruction)new DupInstruction());
                        this.addInstruction((Instruction)new PushValueInstruction(((DfIntegralType)dfType).meetRange(LongRangeSet.point((long)1L))));
                        this.addInstruction((Instruction)new NumericBinaryInstruction(Intrinsics.areEqual((Object)ref, (Object)"++") ? LongRangeBinOp.PLUS : LongRangeBinOp.MINUS, null));
                        this.addInstruction((Instruction)new SimpleAssignmentInstruction((DfaAnchor)anchor, this.factory.getVarFactory().createVariableValue((VariableDescriptor)descriptor2)));
                        this.addInstruction((Instruction)new PopInstruction());
                    } else {
                        this.addInstruction((Instruction)new FlushVariableInstruction(this.factory.getVarFactory().createVariableValue((VariableDescriptor)descriptor2)));
                    }
                }
            }
        } else {
            this.addInstruction((Instruction)new EvalUnknownInstruction((DfaAnchor)anchor, 1));
        }
    }

    private final void processDoWhileExpression(KtDoWhileExpression expr) {
        ControlFlow.FixedOffset offset = new ControlFlow.FixedOffset(this.flow.getInstructionCount());
        this.processExpression(expr.getBody());
        this.addInstruction((Instruction)new PopInstruction());
        this.processExpression(expr.getCondition());
        this.addInstruction((Instruction)new ConditionalGotoInstruction((ControlFlow.ControlFlowOffset)offset, (DfType)DfTypes.TRUE));
        this.flow.finishElement((PsiElement)expr);
        this.pushUnknown();
        this.addInstruction((Instruction)new FinishElementInstruction((PsiElement)expr));
    }

    private final void processWhileExpression(KtWhileExpression expr) {
        ControlFlow.FixedOffset startOffset = new ControlFlow.FixedOffset(this.flow.getInstructionCount());
        KtExpression condition2 = expr.getCondition();
        this.processExpression(condition2);
        ControlFlow.DeferredOffset endOffset2 = new ControlFlow.DeferredOffset();
        this.addInstruction((Instruction)new ConditionalGotoInstruction((ControlFlow.ControlFlowOffset)endOffset2, (DfType)DfTypes.FALSE, (PsiElement)condition2));
        this.processExpression(expr.getBody());
        this.addInstruction((Instruction)new PopInstruction());
        this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)startOffset));
        this.setOffset(endOffset2);
        this.flow.finishElement((PsiElement)expr);
        this.pushUnknown();
        this.addInstruction((Instruction)new FinishElementInstruction((PsiElement)expr));
    }

    private final void processForExpression(KtForExpression expr) {
        KtExpression range = expr.getLoopRange();
        this.processExpression(range);
        this.addInstruction((Instruction)new PopInstruction());
        ControlFlow.FixedOffset startOffset = new ControlFlow.FixedOffset(this.flow.getInstructionCount());
        ControlFlow.DeferredOffset endOffset2 = new ControlFlow.DeferredOffset();
        this.pushUnknown();
        this.addInstruction((Instruction)new ConditionalGotoInstruction((ControlFlow.ControlFlowOffset)endOffset2, (DfType)DfTypes.FALSE));
        KtParameter parameter = expr.getLoopParameter();
        if (parameter == null) {
            this.broken = true;
            return;
        }
        KtLocalVariableDescriptor descriptor2 = new KtLocalVariableDescriptor((KtCallableDeclaration)parameter);
        this.addInstruction((Instruction)new FlushVariableInstruction(this.factory.getVarFactory().createVariableValue((VariableDescriptor)descriptor2)));
        this.processExpression(expr.getBody());
        this.addInstruction((Instruction)new PopInstruction());
        this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)startOffset));
        this.setOffset(endOffset2);
        this.flow.finishElement((PsiElement)expr);
        this.pushUnknown();
        this.addInstruction((Instruction)new FinishElementInstruction((PsiElement)expr));
    }

    private final void processBlock(KtBlockExpression expr) {
        List list = expr.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"expr.statements");
        List statements = list;
        if (statements.isEmpty()) {
            this.pushUnknown();
        } else {
            for (KtExpression child : statements) {
                this.processExpression(child);
                if (Intrinsics.areEqual((Object)child, (Object)((KtExpression)CollectionsKt.last((List)statements))) ^ true) {
                    this.addInstruction((Instruction)new PopInstruction());
                }
                if (!this.broken) continue;
                return;
            }
            this.addInstruction((Instruction)new FinishElementInstruction((PsiElement)expr));
        }
    }

    private final void processDeclaration(KtProperty variable2) {
        KtExpression initializer2 = variable2.getInitializer();
        if (initializer2 == null) {
            this.pushUnknown();
            return;
        }
        DfaVariableValue dfaVariableValue = this.factory.getVarFactory().createVariableValue((VariableDescriptor)new KtLocalVariableDescriptor((KtCallableDeclaration)variable2));
        Intrinsics.checkNotNullExpressionValue((Object)dfaVariableValue, (String)"factory.varFactory.creat\u2026ableDescriptor(variable))");
        DfaVariableValue dfaVariable = dfaVariableValue;
        this.processExpression(initializer2);
        this.addImplicitConversion(initializer2, MoveKotlinMethodProcessorKt.type((KtNamedDeclaration)variable2));
        this.addInstruction((Instruction)new SimpleAssignmentInstruction((DfaAnchor)new KotlinExpressionAnchor((KtExpression)variable2), dfaVariable));
    }

    private final void processReturnExpression(KtReturnExpression expr) {
        if (expr.getLabeledExpression() != null) {
            this.broken = true;
            return;
        }
        this.processExpression(expr.getReturnedExpression());
        this.addInstruction((Instruction)new ReturnInstruction(this.factory, this.traps, (PsiElement)expr));
        this.pushUnknown();
    }

    /*
     * WARNING - void declaration
     */
    private final FList<DfaControlTransferValue.Trap> getTrapsInsideElement(PsiElement element3) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = (Iterable)this.traps;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DfaControlTransferValue.Trap trap = (DfaControlTransferValue.Trap)element$iv$iv;
            boolean bl = false;
            DfaControlTransferValue.Trap trap2 = trap;
            Intrinsics.checkNotNullExpressionValue((Object)trap2, (String)"trap");
            if (!PsiTreeUtil.isAncestor((PsiElement)element3, (PsiElement)trap2.getAnchor(), (boolean)true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        FList fList = FList.createFromReversed((Iterable)CollectionsKt.asReversed((List)((List)destination$iv$iv)));
        Intrinsics.checkNotNullExpressionValue((Object)fList, (String)"FList.createFromReversed\u2026or, true) }.asReversed())");
        return fList;
    }

    /*
     * WARNING - void declaration
     */
    private final InstructionTransfer createTransfer(PsiElement exitedStatement, PsiElement blockToFlush) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)blockToFlush, KtProperty.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"PsiTreeUtil.findChildren\u2026rty::class.java\n        )");
        Iterable iterable = collection;
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void property2;
            KtProperty ktProperty = (KtProperty)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            void v1 = property2;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"property");
            KtLocalVariableDescriptor ktLocalVariableDescriptor = new KtLocalVariableDescriptor((KtCallableDeclaration)v1);
            collection2.add(ktLocalVariableDescriptor);
        }
        List varsToFlush = (List)destination$iv$iv;
        return new InstructionTransfer(this, exitedStatement, varsToFlush, this.flow.getEndOffset(exitedStatement), varsToFlush){
            final /* synthetic */ KtControlFlowBuilder this$0;
            final /* synthetic */ PsiElement $exitedStatement;
            final /* synthetic */ List $varsToFlush;

            @NotNull
            public List<DfaInstructionState> dispatch(@NotNull DfaMemoryState state, @NotNull DataFlowInterpreter interpreter) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
                state.push((DfaValue)this.this$0.getFactory().getUnknown());
                List list = super.dispatch(state, interpreter);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"super.dispatch(state, interpreter)");
                return list;
            }
            {
                this.this$0 = this$0;
                this.$exitedStatement = $captured_local_variable$1;
                this.$varsToFlush = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
            }
        };
    }

    private final void processLabeledJumpExpression(KtExpressionWithLabel expr) {
        KtLoopExpression targetLoop = CommonUtilsKt.targetLoop$default(expr, null, 1, null);
        if (targetLoop == null || !PsiTreeUtil.isAncestor((PsiElement)((PsiElement)this.context), (PsiElement)((PsiElement)targetLoop), (boolean)false)) {
            this.addInstruction((Instruction)new ControlTransferInstruction(this.factory.controlTransfer(DfaControlTransferValue.RETURN_TRANSFER, this.traps)));
        } else {
            KtExpression ktExpression;
            if (expr instanceof KtBreakExpression) {
                ktExpression = (KtExpression)targetLoop;
            } else {
                KtExpression ktExpression2 = targetLoop.getBody();
                ktExpression = ktExpression2;
                Intrinsics.checkNotNull((Object)ktExpression2);
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"if (expr is KtBreakExpre\u2026op else targetLoop.body!!");
            KtExpression body2 = ktExpression;
            this.addInstruction((Instruction)new ControlTransferInstruction(this.factory.controlTransfer((DfaControlTransferValue.TransferTarget)this.createTransfer((PsiElement)body2, (PsiElement)body2), this.getTrapsInsideElement((PsiElement)body2))));
        }
    }

    private final void processThrowExpression(KtThrowExpression expr) {
        KtExpression exception = expr.getThrownExpression();
        this.processExpression(exception);
        this.addInstruction((Instruction)new PopInstruction());
        if (exception != null) {
            PsiType psiType;
            KotlinType kotlinType = KtDfaHelpersKt.getKotlinType(exception);
            PsiType psiType2 = psiType = kotlinType != null ? KtDfaHelpersKt.toPsiType(kotlinType, (PsiElement)expr) : null;
            if (psiType != null) {
                ExceptionTransfer kind = new ExceptionTransfer(TypeConstraints.instanceOf((PsiType)psiType));
                this.addInstruction((Instruction)new ThrowInstruction(this.factory.controlTransfer((DfaControlTransferValue.TransferTarget)kind, this.traps), (PsiElement)expr));
                return;
            }
        }
        this.pushUnknown();
    }

    private final void processReferenceExpression(KtSimpleNameExpression expr) {
        KtLocalVariableDescriptor descriptor2 = KtLocalVariableDescriptor.Companion.create((KtExpression)expr);
        if (descriptor2 != null) {
            this.addInstruction((Instruction)new JvmPushInstruction(descriptor2.createValue(this.factory, null), (DfaAnchor)new KotlinExpressionAnchor((KtExpression)expr)));
            KotlinType exprType = KtDfaHelpersKt.getKotlinType((KtExpression)expr);
            KotlinType declaredType = MoveKotlinMethodProcessorKt.type((KtNamedDeclaration)descriptor2.getVariable());
            this.addImplicitConversion((KtExpression)expr, declaredType, exprType);
            return;
        }
        this.addInstruction((Instruction)new FlushFieldsInstruction());
        this.pushUnknown();
    }

    private final void processConstantExpression(KtConstantExpression expr) {
        this.addInstruction((Instruction)new PushValueInstruction(KtDfaHelpersKt.getConstant(expr), (DfaAnchor)new KotlinExpressionAnchor((KtExpression)expr)));
    }

    private final void pushUnknown() {
        this.addInstruction((Instruction)new PushValueInstruction(DfType.TOP));
    }

    private final void processBinaryExpression(KtBinaryExpression expr) {
        KotlinType leftKtType;
        IElementType token;
        block9: {
            block10: {
                IElementType iElementType = expr.getOperationToken();
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"expr.operationToken");
                token = iElementType;
                RelationType relation = KtDfaHelpersKt.relationFromToken(token);
                if (relation != null) {
                    this.processBinaryRelationExpression(expr, relation, Intrinsics.areEqual((Object)token, (Object)KtTokens.EXCLEQ) || Intrinsics.areEqual((Object)token, (Object)KtTokens.EQEQ));
                    return;
                }
                KtExpression ktExpression = expr.getLeft();
                Object object = leftKtType = ktExpression != null ? KtDfaHelpersKt.getKotlinType(ktExpression) : null;
                if (token != KtTokens.PLUS) break block9;
                if (KotlinBuiltIns.isString((KotlinType)leftKtType)) break block10;
                KtExpression ktExpression2 = expr.getRight();
                if (!KotlinBuiltIns.isString((KotlinType)(ktExpression2 != null ? KtDfaHelpersKt.getKotlinType(ktExpression2) : null))) break block9;
            }
            this.processExpression(expr.getLeft());
            this.processExpression(expr.getRight());
            this.addInstruction((Instruction)new StringConcatInstruction((DfaAnchor)new KotlinExpressionAnchor((KtExpression)expr), (PsiType)this.stringType));
            return;
        }
        KotlinType kotlinType = leftKtType;
        if ((kotlinType != null ? KtDfaHelpersKt.toDfType(kotlinType, (PsiElement)expr) : null) instanceof DfIntegralType) {
            KtOperationReferenceExpression ktOperationReferenceExpression = expr.getOperationReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"expr.operationReference");
            LongRangeBinOp mathOp = KtDfaHelpersKt.mathOpFromToken(ktOperationReferenceExpression);
            if (mathOp != null) {
                this.processMathExpression(expr, mathOp);
                return;
            }
        }
        if (token == KtTokens.ANDAND || token == KtTokens.OROR) {
            this.processShortCircuitExpression(expr, token == KtTokens.ANDAND);
            return;
        }
        if (ASSIGNMENT_TOKENS.contains(token)) {
            this.processAssignmentExpression(expr);
            return;
        }
        if (token == KtTokens.ELVIS) {
            this.processNullSafeOperator(expr);
            return;
        }
        this.processExpression(expr.getLeft());
        this.processExpression(expr.getRight());
        this.addInstruction((Instruction)new EvalUnknownInstruction((DfaAnchor)new KotlinExpressionAnchor((KtExpression)expr), 2));
        this.addInstruction((Instruction)new FlushFieldsInstruction());
    }

    private final void processNullSafeOperator(KtBinaryExpression expr) {
        this.processExpression(expr.getLeft());
        this.addInstruction((Instruction)new DupInstruction());
        ControlFlow.DeferredOffset offset = new ControlFlow.DeferredOffset();
        this.addInstruction((Instruction)new ConditionalGotoInstruction((ControlFlow.ControlFlowOffset)offset, (DfType)DfTypes.NULL));
        ControlFlow.DeferredOffset endOffset2 = new ControlFlow.DeferredOffset();
        this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)endOffset2));
        this.setOffset(offset);
        this.addInstruction((Instruction)new PopInstruction());
        this.processExpression(expr.getRight());
        this.setOffset(endOffset2);
    }

    private final void processAssignmentExpression(KtBinaryExpression expr) {
        KotlinType rightType2;
        KtExpression left = expr.getLeft();
        KtExpression right = expr.getRight();
        KtLocalVariableDescriptor descriptor2 = KtLocalVariableDescriptor.Companion.create(left);
        KtExpression ktExpression = left;
        KotlinType leftType = ktExpression != null ? KtDfaHelpersKt.getKotlinType(ktExpression) : null;
        KtExpression ktExpression2 = right;
        Object object = rightType2 = ktExpression2 != null ? KtDfaHelpersKt.getKotlinType(ktExpression2) : null;
        if (descriptor2 == null) {
            this.processExpression(left);
            this.addInstruction((Instruction)new PopInstruction());
            this.processExpression(right);
            this.addImplicitConversion(right, leftType);
            this.addInstruction((Instruction)new FlushFieldsInstruction());
            return;
        }
        IElementType iElementType = expr.getOperationToken();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"expr.operationToken");
        IElementType token = iElementType;
        LongRangeBinOp mathOp = KtDfaHelpersKt.mathOpFromAssignmentToken(token);
        if (mathOp != null) {
            KotlinType resultType = this.balanceType(leftType, rightType2);
            this.processExpression(left);
            this.addImplicitConversion(left, resultType);
            this.processExpression(right);
            this.addImplicitConversion(right, resultType);
            this.addInstruction((Instruction)new NumericBinaryInstruction(mathOp, (DfaAnchor)new KotlinExpressionAnchor((KtExpression)expr)));
            this.addImplicitConversion(right, resultType, leftType);
        } else {
            this.processExpression(right);
            this.addImplicitConversion(right, leftType);
        }
        this.addInstruction((Instruction)new SimpleAssignmentInstruction((DfaAnchor)new KotlinExpressionAnchor((KtExpression)expr), this.factory.getVarFactory().createVariableValue((VariableDescriptor)descriptor2)));
        this.addInstruction((Instruction)new FinishElementInstruction((PsiElement)expr));
    }

    private final void processShortCircuitExpression(KtBinaryExpression expr, boolean and) {
        KtExpression left = expr.getLeft();
        KtExpression right = expr.getRight();
        ControlFlow.DeferredOffset endOffset2 = new ControlFlow.DeferredOffset();
        this.processExpression(left);
        ControlFlow.DeferredOffset nextOffset = new ControlFlow.DeferredOffset();
        this.addInstruction((Instruction)new ConditionalGotoInstruction((ControlFlow.ControlFlowOffset)nextOffset, (DfType)DfTypes.booleanValue((boolean)and), (PsiElement)left));
        KotlinExpressionAnchor anchor = new KotlinExpressionAnchor((KtExpression)expr);
        this.addInstruction((Instruction)new PushValueInstruction((DfType)DfTypes.booleanValue((!and ? 1 : 0) != 0), (DfaAnchor)anchor));
        this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)endOffset2));
        this.setOffset(nextOffset);
        this.addInstruction((Instruction)new FinishElementInstruction(null));
        this.processExpression(right);
        this.setOffset(endOffset2);
        this.addInstruction((Instruction)new ResultOfInstruction((DfaAnchor)anchor));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void processMathExpression(KtBinaryExpression expr, LongRangeBinOp mathOp) {
        KtExpression left = expr.getLeft();
        KtExpression right = expr.getRight();
        KotlinType resultType = KtDfaHelpersKt.getKotlinType((KtExpression)expr);
        this.processExpression(left);
        this.addImplicitConversion(left, resultType);
        this.processExpression(right);
        if (mathOp == LongRangeBinOp.DIV || mathOp == LongRangeBinOp.MOD) {
            DfType dfType;
            DfaControlTransferValue transfer = this.createTransfer("java.lang.ArithmeticException");
            KotlinType kotlinType = resultType;
            if (kotlinType != null && TypeUtilsKt.isLong((KotlinType)kotlinType)) {
                DfLongConstantType dfLongConstantType = DfTypes.longValue((long)0L);
                Intrinsics.checkNotNullExpressionValue((Object)dfLongConstantType, (String)"DfTypes.longValue(0)");
                dfType = (DfType)dfLongConstantType;
            } else {
                DfIntConstantType dfIntConstantType = DfTypes.intValue((int)0);
                Intrinsics.checkNotNullExpressionValue((Object)dfIntConstantType, (String)"DfTypes.intValue(0)");
                dfType = (DfType)dfIntConstantType;
            }
            DfType zero = dfType;
            this.addInstruction((Instruction)new EnsureInstruction(null, RelationType.NE, zero, transfer, true));
        }
        if (!mathOp.isShift()) {
            this.addImplicitConversion(right, resultType);
        }
        this.addInstruction((Instruction)new NumericBinaryInstruction(mathOp, (DfaAnchor)new KotlinExpressionAnchor((KtExpression)expr)));
    }

    @Nullable
    public final DfaControlTransferValue createTransfer(@NotNull String exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        return !this.traps.isEmpty() ? this.factory.controlTransfer((DfaControlTransferValue.TransferTarget)this.exceptionCache.get(exception), this.traps) : null;
    }

    private final void addImplicitConversion(KtExpression expression2, KotlinType expectedType) {
        KtExpression ktExpression = expression2;
        this.addImplicitConversion(expression2, (KotlinType)(ktExpression != null ? KtDfaHelpersKt.getKotlinType(ktExpression) : null), expectedType);
    }

    private final void addImplicitConversion(KtExpression expression2, KotlinType actualType, KotlinType expectedType) {
        if (expression2 == null) {
            return;
        }
        if (actualType == null) {
            return;
        }
        if (expectedType == null) {
            return;
        }
        if (Intrinsics.areEqual((Object)actualType, (Object)expectedType)) {
            return;
        }
        PsiType actualPsiType = KtDfaHelpersKt.toPsiType(actualType, (PsiElement)expression2);
        PsiType expectedPsiType = KtDfaHelpersKt.toPsiType(expectedType, (PsiElement)expression2);
        if (actualType.isMarkedNullable() && !expectedType.isMarkedNullable() && expectedPsiType instanceof PsiPrimitiveType) {
            this.addInstruction((Instruction)new UnwrapDerivedVariableInstruction((DerivedVariableDescriptor)SpecialField.UNBOX));
        } else if (!actualType.isMarkedNullable() && expectedType.isMarkedNullable() && actualPsiType instanceof PsiPrimitiveType) {
            this.addInstruction((Instruction)new WrapDerivedVariableInstruction(KtDfaHelpersKt.toDfType(expectedType, (PsiElement)expression2).meet((DfType)DfTypes.NOT_NULL_OBJECT), (DerivedVariableDescriptor)SpecialField.UNBOX));
        }
        if (actualPsiType instanceof PsiPrimitiveType && expectedPsiType instanceof PsiPrimitiveType) {
            this.addInstruction((Instruction)new PrimitiveConversionInstruction((PsiPrimitiveType)expectedPsiType, null));
        }
    }

    private final void processBinaryRelationExpression(KtBinaryExpression expr, RelationType relation, boolean forceEqualityByContent) {
        KtExpression left = expr.getLeft();
        KtExpression right = expr.getRight();
        KtExpression ktExpression = left;
        KotlinType leftType = ktExpression != null ? KtDfaHelpersKt.getKotlinType(ktExpression) : null;
        KtExpression ktExpression2 = right;
        KotlinType rightType2 = ktExpression2 != null ? KtDfaHelpersKt.getKotlinType(ktExpression2) : null;
        KotlinType balancedType = null;
        balancedType = forceEqualityByContent && leftType != null && rightType2 != null ? (leftType.isMarkedNullable() && !rightType2.isMarkedNullable() && Intrinsics.areEqual((Object)TypeUtilsKt.makeNotNullable((KotlinType)leftType), (Object)rightType2) ? leftType : (rightType2.isMarkedNullable() && !leftType.isMarkedNullable() && Intrinsics.areEqual((Object)TypeUtilsKt.makeNotNullable((KotlinType)rightType2), (Object)leftType) ? rightType2 : (KotlinType)null)) : this.balanceType(leftType, rightType2);
        this.processExpression(left);
        this.addImplicitConversion(left, balancedType);
        this.processExpression(right);
        this.addImplicitConversion(right, balancedType);
        if (left == null || right == null) {
            this.addInstruction((Instruction)new EvalUnknownInstruction((DfaAnchor)new KotlinExpressionAnchor((KtExpression)expr), 2));
            return;
        }
        this.addInstruction((Instruction)new BooleanBinaryInstruction(relation, forceEqualityByContent, (DfaAnchor)new KotlinExpressionAnchor((KtExpression)expr)));
    }

    private final KotlinType balanceType(KotlinType left, KotlinType right) {
        if (left == null || right == null) {
            return null;
        }
        if (Intrinsics.areEqual((Object)left, (Object)right)) {
            return left;
        }
        if (KtDfaHelpersKt.canBeNull(left) && !KtDfaHelpersKt.canBeNull(right)) {
            return this.balanceType(TypeUtilsKt.makeNotNullable((KotlinType)left), right);
        }
        if (!KtDfaHelpersKt.canBeNull(left) && KtDfaHelpersKt.canBeNull(right)) {
            return this.balanceType(left, TypeUtilsKt.makeNotNullable((KotlinType)right));
        }
        if (TypeUtilsKt.isDouble((KotlinType)left)) {
            return left;
        }
        if (TypeUtilsKt.isDouble((KotlinType)right)) {
            return right;
        }
        if (TypeUtilsKt.isFloat((KotlinType)left)) {
            return left;
        }
        if (TypeUtilsKt.isFloat((KotlinType)right)) {
            return right;
        }
        if (TypeUtilsKt.isLong((KotlinType)left)) {
            return left;
        }
        if (TypeUtilsKt.isLong((KotlinType)right)) {
            return right;
        }
        return null;
    }

    private final void addInstruction(Instruction inst) {
        this.flow.addInstruction(inst);
    }

    private final void setOffset(ControlFlow.DeferredOffset offset) {
        offset.setOffset(this.flow.getInstructionCount());
    }

    private final void processWhenExpression(KtWhenExpression expr) {
        if (expr.getSubjectExpression() != null || expr.getSubjectVariable() != null) {
            this.broken = true;
            return;
        }
        ControlFlow.DeferredOffset endOffset2 = new ControlFlow.DeferredOffset();
        Iterator iterator = expr.getEntries().iterator();
        while (iterator.hasNext()) {
            KtWhenEntry entry;
            KtWhenEntry ktWhenEntry = entry = (KtWhenEntry)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)ktWhenEntry, (String)"entry");
            if (ktWhenEntry.isElse()) {
                this.processExpression(entry.getExpression());
                this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)endOffset2));
                continue;
            }
            ControlFlow.DeferredOffset branchStart = new ControlFlow.DeferredOffset();
            KtWhenCondition[] ktWhenConditionArray = entry.getConditions();
            int n = ktWhenConditionArray.length;
            for (int i = 0; i < n; ++i) {
                KtWhenCondition condition2;
                KtWhenCondition ktWhenCondition = condition2 = ktWhenConditionArray[i];
                Intrinsics.checkNotNullExpressionValue((Object)ktWhenCondition, (String)"condition");
                this.processWhenCondition(expr, ktWhenCondition);
                this.addInstruction((Instruction)new ConditionalGotoInstruction((ControlFlow.ControlFlowOffset)branchStart, (DfType)DfTypes.TRUE));
            }
            ControlFlow.DeferredOffset skipBranch = new ControlFlow.DeferredOffset();
            this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)skipBranch));
            this.setOffset(branchStart);
            this.processExpression(entry.getExpression());
            this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)endOffset2));
            this.setOffset(skipBranch);
        }
        this.pushUnknown();
        this.setOffset(endOffset2);
        this.addInstruction((Instruction)new FinishElementInstruction((PsiElement)expr));
    }

    private final void processWhenCondition(KtWhenExpression expr, KtWhenCondition condition2) {
        KtWhenCondition ktWhenCondition = condition2;
        if (ktWhenCondition instanceof KtWhenConditionWithExpression) {
            this.processExpression(((KtWhenConditionWithExpression)condition2).getExpression());
        } else {
            this.broken = true;
        }
    }

    private final void processIfExpression(KtIfExpression ifExpression2) {
        KtExpression condition2 = ifExpression2.getCondition();
        this.processExpression(condition2);
        ControlFlow.DeferredOffset skipThenOffset = new ControlFlow.DeferredOffset();
        KtExpression thenStatement = ifExpression2.getThen();
        KtExpression elseStatement = ifExpression2.getElse();
        this.addInstruction((Instruction)new ConditionalGotoInstruction((ControlFlow.ControlFlowOffset)skipThenOffset, (DfType)DfTypes.FALSE, (PsiElement)condition2));
        this.addInstruction((Instruction)new FinishElementInstruction(null));
        this.processExpression(thenStatement);
        ControlFlow.DeferredOffset skipElseOffset = new ControlFlow.DeferredOffset();
        this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)skipElseOffset));
        this.setOffset(skipThenOffset);
        this.addInstruction((Instruction)new FinishElementInstruction(null));
        this.processExpression(elseStatement);
        this.setOffset(skipElseOffset);
        this.addInstruction((Instruction)new FinishElementInstruction((PsiElement)ifExpression2));
    }

    @NotNull
    public final DfaValueFactory getFactory() {
        return this.factory;
    }

    @NotNull
    public final KtExpression getContext() {
        return this.context;
    }

    public KtControlFlowBuilder(@NotNull DfaValueFactory factory2, @NotNull KtExpression context2) {
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.factory = factory2;
        this.context = context2;
        FList fList = FList.emptyList();
        Intrinsics.checkNotNullExpressionValue((Object)fList, (String)"FList.emptyList()");
        this.traps = fList;
        this.flow = new ControlFlow(this.factory, (PsiElement)this.context);
        Map map2 = FactoryMap.create((Function)new Function(this){
            final /* synthetic */ KtControlFlowBuilder this$0;

            public final ExceptionTransfer fun(String fqn) {
                String string = fqn;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fqn");
                return new ExceptionTransfer(TypeConstraints.instanceOf((PsiType)((PsiType)KtControlFlowBuilder.access$createClassType(this.this$0, string))));
            }
            {
                this.this$0 = ktControlFlowBuilder;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"FactoryMap.create<String\u2026(createClassType(fqn))) }");
        this.exceptionCache = map2;
        this.stringType = this.createClassType("java.lang.String");
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KtControlFlowBuilder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{(IElementType)KtTokens.EQ, (IElementType)KtTokens.PLUSEQ, (IElementType)KtTokens.MINUSEQ, (IElementType)KtTokens.MULTEQ, (IElementType)KtTokens.DIVEQ, (IElementType)KtTokens.PERCEQ});
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"TokenSet.create(KtTokens\u2026s.DIVEQ, KtTokens.PERCEQ)");
        ASSIGNMENT_TOKENS = tokenSet;
        totalCount = new AtomicInteger();
        successCount = new AtomicInteger();
    }

    public static final /* synthetic */ PsiClassType access$createClassType(KtControlFlowBuilder $this, String fqn) {
        return $this.createClassType(fqn);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/dfa/KtControlFlowBuilder$Companion;", "", "()V", "ASSIGNMENT_TOKENS", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "successCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "totalCount", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

