/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.dfa;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.interpreter.RunnerResult;
import com.intellij.codeInspection.dataFlow.interpreter.StandardDataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.jvm.JvmDfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.DfaListener;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.psi.PsiElement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinExpressionAnchor;
import org.jetbrains.kotlin.idea.inspections.dfa.KtControlFlowBuilder;
import org.jetbrains.kotlin.idea.refactoring.move.moveMethod.MoveKotlinMethodProcessorKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "resultIsUnused", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "shouldSuppress", "ConstantValue", "KotlinDfaListener", "kotlin.idea"})
public final class KotlinConstantConditionsInspection
extends AbstractKotlinInspection {
    private final boolean shouldSuppress(KtExpression expression2) {
        PsiElement target2;
        if (expression2 instanceof KtConstantExpression || expression2 instanceof KtProperty || expression2 instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)expression2).getOperationToken(), (Object)KtTokens.EQ)) {
            return true;
        }
        if (expression2 instanceof KtSimpleNameExpression && (target2 = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)expression2)).resolve()) instanceof KtProperty && !((KtProperty)target2).isVar() && ((KtProperty)target2).getInitializer() instanceof KtConstantExpression) {
            return true;
        }
        return this.resultIsUnused(expression2);
    }

    private final boolean resultIsUnused(KtExpression expression2) {
        boolean bl;
        PsiElement parent2 = expression2.getParent();
        if (parent2 instanceof KtBlockExpression) {
            bl = Intrinsics.areEqual((Object)KtPsiUtilKt.lastBlockStatementOrThis((KtExpression)((KtExpression)parent2)), (Object)expression2) ^ true || this.resultIsUnused((KtExpression)parent2);
        } else if (parent2 instanceof KtLoopExpression) {
            bl = Intrinsics.areEqual((Object)((KtLoopExpression)parent2).getBody(), (Object)expression2);
        } else if (parent2 instanceof KtIfExpression) {
            bl = this.resultIsUnused((KtExpression)parent2);
        } else {
            if (parent2 instanceof KtWhenEntry) {
                KtWhenExpression whenExpression2;
                PsiElement psiElement2 = ((KtWhenEntry)parent2).getParent();
                if (!(psiElement2 instanceof KtWhenExpression)) {
                    psiElement2 = null;
                }
                return (whenExpression2 = (KtWhenExpression)psiElement2) != null && this.resultIsUnused((KtExpression)whenExpression2);
            }
            if (parent2 instanceof KtFunction) {
                KotlinType type2 = MoveKotlinMethodProcessorKt.type((KtNamedDeclaration)parent2);
                return type2 != null && KotlinBuiltIns.isUnit((KotlinType)type2);
            }
            bl = false;
        }
        return bl;
    }

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return VisitorWrappersKt.namedFunctionVisitor((Function1)((Function1)new Function1<KtNamedFunction, Unit>(this, holder){
            final /* synthetic */ KotlinConstantConditionsInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull KtNamedFunction function2) {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                KtExpression ktExpression = function2.getBodyExpression();
                if (ktExpression == null) {
                    ktExpression = (KtExpression)function2.getBodyBlockExpression();
                }
                if (ktExpression == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"function.bodyExpression \u2026BlockExpression ?: return");
                KtExpression body2 = ktExpression;
                DfaValueFactory factory2 = new DfaValueFactory(this.$holder.getProject());
                ControlFlow controlFlow = new KtControlFlowBuilder(factory2, body2).buildFlow();
                if (controlFlow == null) {
                    return;
                }
                ControlFlow flow = controlFlow;
                JvmDfaMemoryStateImpl state = new JvmDfaMemoryStateImpl(factory2);
                KotlinDfaListener listener = new KotlinDfaListener();
                StandardDataFlowInterpreter interpreter = new StandardDataFlowInterpreter(flow, (DfaListener)listener);
                if (interpreter.interpret((DfaMemoryState)state) != RunnerResult.OK) {
                    return;
                }
                Map $this$forEach$iv = listener.getConstantConditions();
                boolean $i$f$forEach = false;
                Map map2 = $this$forEach$iv;
                boolean bl = false;
                Iterator<Map.Entry<K, V>> iterator = map2.entrySet().iterator();
                while (iterator.hasNext()) {
                    void expr;
                    Map.Entry<K, V> element$iv;
                    Map.Entry<K, V> $dstr$expr$cv = element$iv = iterator.next();
                    boolean bl2 = false;
                    Map.Entry<K, V> entry = $dstr$expr$cv;
                    boolean bl3 = false;
                    KtExpression ktExpression2 = (KtExpression)entry.getKey();
                    entry = $dstr$expr$cv;
                    bl3 = false;
                    ConstantValue cv = (ConstantValue)((Object)entry.getValue());
                    if (cv == ConstantValue.UNKNOWN || KotlinConstantConditionsInspection.access$shouldSuppress(this.this$0, (KtExpression)expr)) continue;
                    String key = cv == ConstantValue.TRUE ? "inspection.message.condition.always.true" : "inspection.message.condition.always.false";
                    ProblemHighlightType highlightType = expr instanceof KtSimpleNameExpression || expr instanceof KtQualifiedExpression ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                    this.$holder.registerProblem((PsiElement)expr, KotlinBundle.message(key, new Object[0]), highlightType, new LocalQuickFix[0]);
                }
            }
            {
                this.this$0 = kotlinConstantConditionsInspection;
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    public static final /* synthetic */ boolean access$shouldSuppress(KotlinConstantConditionsInspection $this, KtExpression expression2) {
        return $this.shouldSuppress(expression2);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection$ConstantValue;", "", "(Ljava/lang/String;I)V", "TRUE", "FALSE", "UNKNOWN", "kotlin.idea"})
    private static final class ConstantValue
    extends Enum<ConstantValue> {
        public static final /* enum */ ConstantValue TRUE;
        public static final /* enum */ ConstantValue FALSE;
        public static final /* enum */ ConstantValue UNKNOWN;
        private static final /* synthetic */ ConstantValue[] $VALUES;

        static {
            ConstantValue[] constantValueArray = new ConstantValue[3];
            ConstantValue[] constantValueArray2 = constantValueArray;
            constantValueArray[0] = TRUE = new ConstantValue();
            constantValueArray[1] = FALSE = new ConstantValue();
            constantValueArray[2] = UNKNOWN = new ConstantValue();
            $VALUES = constantValueArray;
        }

        public static ConstantValue[] values() {
            return (ConstantValue[])$VALUES.clone();
        }

        public static ConstantValue valueOf(String string) {
            return Enum.valueOf(ConstantValue.class, string);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J5\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J \u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u000eH\u0002R-\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection$KotlinDfaListener;", "Lcom/intellij/codeInspection/dataFlow/lang/DfaListener;", "()V", "constantConditions", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection$ConstantValue;", "Lkotlin/collections/HashMap;", "getConstantConditions", "()Ljava/util/HashMap;", "beforePush", "", "args", "", "Lcom/intellij/codeInspection/dataFlow/value/DfaValue;", "value", "anchor", "Lcom/intellij/codeInspection/dataFlow/lang/DfaAnchor;", "state", "Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;", "([Lcom/intellij/codeInspection/dataFlow/value/DfaValue;Lcom/intellij/codeInspection/dataFlow/value/DfaValue;Lcom/intellij/codeInspection/dataFlow/lang/DfaAnchor;Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;)V", "recordExpressionValue", "expression", "kotlin.idea"})
    private static final class KotlinDfaListener
    implements DfaListener {
        @NotNull
        private final HashMap<KtExpression, ConstantValue> constantConditions;

        @NotNull
        public final HashMap<KtExpression, ConstantValue> getConstantConditions() {
            return this.constantConditions;
        }

        public void beforePush(@NotNull DfaValue[] args, @NotNull DfaValue value, @NotNull DfaAnchor anchor, @NotNull DfaMemoryState state) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            if (anchor instanceof KotlinExpressionAnchor) {
                this.recordExpressionValue(((KotlinExpressionAnchor)anchor).getExpression(), state, value);
            }
        }

        private final void recordExpressionValue(KtExpression expression2, DfaMemoryState state, DfaValue value) {
            ConstantValue newVal;
            ConstantValue oldVal = this.constantConditions.get(expression2);
            if (oldVal == ConstantValue.UNKNOWN) {
                return;
            }
            DfType dfType = state.getDfType(value);
            ConstantValue constantValue = Intrinsics.areEqual((Object)dfType, (Object)DfTypes.TRUE) ? ConstantValue.TRUE : (newVal = Intrinsics.areEqual((Object)dfType, (Object)DfTypes.FALSE) ? ConstantValue.FALSE : ConstantValue.UNKNOWN);
            if (oldVal != null && oldVal != newVal) {
                newVal = ConstantValue.UNKNOWN;
            }
            ((Map)this.constantConditions).put(expression2, newVal);
        }

        public KotlinDfaListener() {
            boolean bl = false;
            this.constantConditions = new HashMap();
        }
    }
}

