/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.blockingCallsDetection;

import com.intellij.codeInspection.blockingCallsDetection.NonBlockingContextChecker;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.KotlinPsiUtilKt;
import org.jetbrains.kotlin.idea.inspections.blockingCallsDetection.CoroutineNonBlockingContextChecker;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.refactoring.fqName.FqNameUtilKt;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.js.resolve.diagnostics.SourceLocationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e*\u0006\u0012\u0002\b\u00030\u000fH\u0002J\f\u0010\u0010\u001a\u00020\b*\u00020\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\b*\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u000e\u0010\u0012\u001a\u00020\b*\u0004\u0018\u00010\u0013H\u0002J\f\u0010\u0014\u001a\u00020\b*\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\b*\u0004\u0018\u00010\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\b*\u0004\u0018\u00010\u0017H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/blockingCallsDetection/CoroutineNonBlockingContextChecker;", "Lcom/intellij/codeInspection/blockingCallsDetection/NonBlockingContextChecker;", "()V", "getLanguageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "psiElement", "Lcom/intellij/psi/PsiElement;", "isApplicable", "", "file", "Lcom/intellij/psi/PsiFile;", "isContextNonBlockingFor", "element", "getFirstArgument", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "hasBlockFriendlyDispatcher", "hasBlockFriendlyDispatcherParameter", "isBlockFriendlyDispatcher", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "isCoroutineContext", "Lorg/jetbrains/kotlin/types/KotlinType;", "isFlowChainElementWithIODispatcher", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "isInFunctionWithDefaultDispatcher", "Companion", "kotlin.idea"})
public final class CoroutineNonBlockingContextChecker
implements NonBlockingContextChecker {
    private static final String BLOCKING_CONTEXT_ANNOTATION = "org.jetbrains.annotations.BlockingContext";
    private static final String IO_DISPATCHER_FQN = "kotlinx.coroutines.Dispatchers.IO";
    private static final String COROUTINE_SCOPE = "kotlinx.coroutines.CoroutineScope";
    private static final String COROUTINE_CONTEXT = "kotlin.coroutines.CoroutineContext";
    private static final String FLOW_ON_FQN = "kotlinx.coroutines.flow.flowOn";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean isApplicable(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        LanguageVersionSettings languageVersionSettings = this.getLanguageVersionSettings((PsiElement)file2);
        return languageVersionSettings.supportsFeature(LanguageFeature.ReleaseCoroutines);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isContextNonBlockingFor(@NotNull PsiElement element3) {
        KtValueArgument containingArgument;
        KtValueArgument ktValueArgument;
        PsiElement containingLambda;
        Object v0;
        block16: {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            if (!(element3 instanceof KtCallExpression)) {
                return false;
            }
            Sequence $this$firstOrNull$iv = PsiUtilsKt.getParents((PsiElement)element3);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                if (!(it instanceof KtLambdaExpression && ResolutionUtils.analyze$default((KtElement)((KtElement)it), null, (int)1, null).get((ReadOnlySlice)BindingContext.LAMBDA_INVOCATIONS, (Object)it) == null)) continue;
                v0 = element$iv;
                break block16;
            }
            v0 = null;
        }
        PsiElement psiElement2 = containingLambda = (PsiElement)v0;
        if (psiElement2 != null) {
            void strict$iv;
            void $this$getParentOfType$iv;
            PsiElement $i$f$firstOrNull = psiElement2;
            boolean bl = true;
            Class[] stopAt$iv = new Class[]{KtCallableDeclaration.class};
            boolean $i$f$getParentOfType = false;
            Class[] bl2 = new Class[stopAt$iv.length];
            System.arraycopy(stopAt$iv, 0, bl2, 0, stopAt$iv.length);
            ktValueArgument = (KtValueArgument)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtValueArgument.class, (boolean)strict$iv, (Class[])bl2);
        } else {
            ktValueArgument = containingArgument = null;
        }
        if (containingArgument != null) {
            Boolean bl;
            boolean isBlockFriendlyDispatcherUsed;
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)containingArgument;
            boolean $i$f$getStrictParentOfType = false;
            KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallExpression.class, (boolean)true);
            if (ktCallExpression == null) {
                return false;
            }
            KtCallExpression callExpression2 = ktCallExpression;
            ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall((KtElement)((KtElement)callExpression2), (BodyResolveMode)BodyResolveMode.PARTIAL);
            if (resolvedCall2 == null) {
                return false;
            }
            ResolvedCall call = resolvedCall2;
            boolean bl3 = isBlockFriendlyDispatcherUsed = this.hasBlockFriendlyDispatcherParameter(call) || this.isInFunctionWithDefaultDispatcher(callExpression2) || this.isFlowChainElementWithIODispatcher(callExpression2);
            if (isBlockFriendlyDispatcherUsed) {
                return false;
            }
            ValueParameterDescriptor valueParameterDescriptor = CallUtilKt.getParameterForArgument((ResolvedCall)call, (ValueArgument)((ValueArgument)containingArgument));
            if (valueParameterDescriptor == null) {
                return false;
            }
            ValueParameterDescriptor parameterForArgument = valueParameterDescriptor;
            KotlinType kotlinType = parameterForArgument.getReturnType();
            if (kotlinType == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"parameterForArgument.returnType ?: return false");
            KotlinType type2 = kotlinType;
            if (FunctionTypesKt.isBuiltinFunctionalType((KotlinType)type2)) {
                KotlinType kotlinType2 = FunctionTypesKt.getReceiverTypeFromFunctionType((KotlinType)type2);
                bl = kotlinType2 != null ? Boolean.valueOf(CoroutineCallCheckerKt.isRestrictsSuspensionReceiver((KotlinType)kotlinType2, (LanguageVersionSettings)this.getLanguageVersionSettings(element3))) : null;
            } else {
                bl = null;
            }
            Boolean hasRestrictSuspensionAnnotation = bl;
            return Intrinsics.areEqual(hasRestrictSuspensionAnnotation, (Object)true) ^ true && FunctionTypesKt.isSuspendFunctionType((KotlinType)type2);
        }
        if (containingLambda == null) {
            Object v10;
            block17: {
                void $this$firstOrNull$iv;
                PsiElement $this$parentsOfType$iv = element3;
                boolean withSelf$iv = true;
                boolean $i$f$parentsOfType = false;
                $this$parentsOfType$iv = SequencesKt.take((Sequence)PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType$iv, KtNamedFunction.class, (boolean)withSelf$iv), (int)2);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KtNamedFunction function2 = (KtNamedFunction)element$iv;
                    boolean bl = false;
                    if (!(function2.getNameIdentifier() != null)) continue;
                    v10 = element$iv;
                    break block17;
                }
                v10 = null;
            }
            KtNamedFunction ktNamedFunction = v10;
            return ktNamedFunction != null ? ktNamedFunction.hasModifier(KtTokens.SUSPEND_KEYWORD) : false;
        }
        KtCallableDeclaration containingPropertyOrFunction = (KtCallableDeclaration)PsiUtilsKt.getParentOfTypes((PsiElement)containingLambda, (boolean)true, (Class[])new Class[]{KtProperty.class, KtNamedFunction.class});
        KtCallableDeclaration ktCallableDeclaration = containingPropertyOrFunction;
        if (ktCallableDeclaration != null && (ktCallableDeclaration = ktCallableDeclaration.getTypeReference()) != null) {
            if (ktCallableDeclaration.hasModifier(KtTokens.SUSPEND_KEYWORD)) {
                return true;
            }
        }
        KtCallableDeclaration ktCallableDeclaration2 = containingPropertyOrFunction;
        return ktCallableDeclaration2 != null && ktCallableDeclaration2.hasModifier(KtTokens.SUSPEND_KEYWORD);
    }

    private final LanguageVersionSettings getLanguageVersionSettings(PsiElement psiElement2) {
        Module module = ProjectStructureUtilKt.getModule(psiElement2);
        if (module == null || (module = PlatformKt.getLanguageVersionSettings((Module)module)) == null) {
            Project project2 = psiElement2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"psiElement.project");
            module = PlatformKt.getLanguageVersionSettings$default((Project)project2, null, null, (int)3, null);
        }
        return module;
    }

    private final KtExpression getFirstArgument(ResolvedCall<?> $this$getFirstArgument) {
        List list = $this$getFirstArgument.getValueArgumentsByIndex();
        return list != null && (list = (ResolvedValueArgument)CollectionsKt.firstOrNull((List)list)) != null && (list = list.getArguments()) != null && (list = (ValueArgument)CollectionsKt.firstOrNull((List)list)) != null ? list.getArgumentExpression() : null;
    }

    private final boolean isCoroutineContext(KotlinType $this$isCoroutineContext) {
        boolean bl;
        block3: {
            Collection collection = $this$isCoroutineContext.getConstructor().getSupertypes();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"this.constructor.supertypes");
            Iterable $this$any$iv = CollectionsKt.plus((Collection)collection, (Object)$this$isCoroutineContext);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl2 = false;
                    KotlinType kotlinType = it;
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"it");
                    FqName fqName = FqNameUtilKt.getFqName((KotlinType)kotlinType);
                    if (!Intrinsics.areEqual((Object)(fqName != null ? fqName.asString() : null), (Object)COROUTINE_CONTEXT)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean hasBlockFriendlyDispatcherParameter(ResolvedCall<?> $this$hasBlockFriendlyDispatcherParameter) {
        KtExpression ktExpression = this.getFirstArgument($this$hasBlockFriendlyDispatcherParameter);
        CallableDescriptor argumentDescriptor = ktExpression != null && (ktExpression = ResolutionUtils.resolveToCall$default((KtElement)((KtElement)ktExpression), null, (int)1, null)) != null ? ktExpression.getResultingDescriptor() : null;
        return this.isBlockFriendlyDispatcher((DeclarationDescriptor)argumentDescriptor);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final boolean isInFunctionWithDefaultDispatcher(KtCallExpression $this$isInFunctionWithDefaultDispatcher) {
        block14: {
            block13: {
                v0 = $this$isInFunctionWithDefaultDispatcher;
                v1 /* !! */  = v0 != null ? KotlinPsiUtilKt.receiverValue((KtCallExpression)v0) : null;
                if (!(v1 /* !! */  instanceof ImplicitClassReceiver)) {
                    v1 /* !! */  = null;
                }
                if ((v2 = (ImplicitClassReceiver)v1 /* !! */ ) == null || (v2 = v2.getClassDescriptor()) == null) {
                    return false;
                }
                classDescriptor = v2;
                v3 = classDescriptor.getTypeConstructor();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"classDescriptor.typeConstructor");
                v4 = v3.getSupertypes();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"classDescriptor.typeConstructor.supertypes");
                $this$none$iv = v4;
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    v5 = true;
                } else {
                    for (T element$iv : $this$none$iv) {
                        it = (KotlinType)element$iv;
                        $i$a$-none-CoroutineNonBlockingContextChecker$isInFunctionWithDefaultDispatcher$1 = false;
                        v6 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"it");
                        v7 = FqNameUtilKt.getFqName((KotlinType)v6);
                        if (!Intrinsics.areEqual((Object)(v7 != null ? v7.asString() : null), (Object)"kotlinx.coroutines.CoroutineScope")) continue;
                        v5 = false;
                        break block13;
                    }
                    v5 = true;
                }
            }
            if (v5) {
                return false;
            }
            $i$f$none = ResolutionScope.DefaultImpls.getContributedDescriptors$default((ResolutionScope)((ResolutionScope)classDescriptor.getUnsubstitutedMemberScope()), (DescriptorKindFilter)DescriptorKindFilter.VARIABLES, null, (int)2, null);
            $i$f$filterIsInstance = false;
            element$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterIsInstanceTo = false;
            for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PropertyDescriptor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            $i$f$singleOrNull = false;
            single$iv = null;
            found$iv = false;
            for (T element$iv : $this$singleOrNull$iv) {
                it = (PropertyDescriptor)element$iv;
                $i$a$-singleOrNull-CoroutineNonBlockingContextChecker$isInFunctionWithDefaultDispatcher$propertyDescriptor$1 = false;
                if (!ModalityUtilsKt.isOverridableOrOverrides((CallableMemberDescriptor)((CallableMemberDescriptor)it))) ** GOTO lbl-1000
                v8 = it.getType();
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"it.type");
                if (this.isCoroutineContext(v8)) {
                    v9 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v9 = false;
                }
                if (!v9) continue;
                if (found$iv) {
                    v10 = null;
                    break block14;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v10 = found$iv == false ? null : single$iv;
        }
        v11 = v10;
        if (v11 == null) {
            return false;
        }
        propertyDescriptor = v11;
        v12 = SourceLocationUtilsKt.findPsi((DeclarationDescriptor)((DeclarationDescriptor)propertyDescriptor));
        if (!(v12 instanceof KtProperty)) {
            v12 = null;
        }
        v13 = (KtProperty)v12;
        v14 = initializer = v13 != null ? v13.getInitializer() : null;
        return v14 != null ? this.hasBlockFriendlyDispatcher(v14) : false;
    }

    private final boolean isFlowChainElementWithIODispatcher(KtCallExpression $this$isFlowChainElementWithIODispatcher) {
        isFlowChainElementWithIODispatcher.1 $fun$findFlowOnCall$1 = isFlowChainElementWithIODispatcher.1.INSTANCE;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = $this$isFlowChainElementWithIODispatcher;
        if (resolvedCall2 == null || (resolvedCall2 = $fun$findFlowOnCall$1.invoke((KtExpression)resolvedCall2)) == null) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> flowOnCall = resolvedCall2;
        return this.hasBlockFriendlyDispatcherParameter(flowOnCall);
    }

    private final boolean hasBlockFriendlyDispatcher(KtExpression $this$hasBlockFriendlyDispatcher) {
        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"org/jetbrains/kotlin/idea/inspections/blockingCallsDetection/CoroutineNonBlockingContextChecker$hasBlockFriendlyDispatcher$RecursiveExpressionVisitor", "Lcom/intellij/psi/PsiRecursiveElementVisitor;", "(Lorg/jetbrains/kotlin/idea/inspections/blockingCallsDetection/CoroutineNonBlockingContextChecker;)V", "isBlockFriendlyDispatcherFound", "", "()Z", "setBlockFriendlyDispatcherFound", "(Z)V", "visitElement", "", "element", "Lcom/intellij/psi/PsiElement;", "kotlin.idea"})
        public final class RecursiveExpressionVisitor
        extends PsiRecursiveElementVisitor {
            private boolean isBlockFriendlyDispatcherFound;
            final /* synthetic */ CoroutineNonBlockingContextChecker this$0;

            public final boolean isBlockFriendlyDispatcherFound() {
                return this.isBlockFriendlyDispatcherFound;
            }

            public final void setBlockFriendlyDispatcherFound(boolean bl) {
                this.isBlockFriendlyDispatcherFound = bl;
            }

            public void visitElement(@NotNull PsiElement element3) {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                if (element3 instanceof KtExpression) {
                    CallableDescriptor callableDescriptor = UtilsKt.getCallableDescriptor((KtExpression)element3);
                    CallableDescriptor callableDescriptor2 = callableDescriptor;
                    if (!(callableDescriptor2 instanceof DeclarationDescriptor)) {
                        callableDescriptor2 = null;
                    }
                    if (CoroutineNonBlockingContextChecker.access$isBlockFriendlyDispatcher(this.this$0, (DeclarationDescriptor)callableDescriptor2)) {
                        this.isBlockFriendlyDispatcherFound = true;
                        return;
                    }
                }
                super.visitElement(element3);
            }

            public RecursiveExpressionVisitor(CoroutineNonBlockingContextChecker this$0) {
                this.this$0 = this$0;
            }
        }
        RecursiveExpressionVisitor recursiveExpressionVisitor = new RecursiveExpressionVisitor(this);
        boolean bl = false;
        boolean bl2 = false;
        RecursiveExpressionVisitor it = recursiveExpressionVisitor;
        boolean bl3 = false;
        $this$hasBlockFriendlyDispatcher.accept((PsiElementVisitor)it);
        return recursiveExpressionVisitor.isBlockFriendlyDispatcherFound();
    }

    private final boolean isBlockFriendlyDispatcher(DeclarationDescriptor $this$isBlockFriendlyDispatcher) {
        if ($this$isBlockFriendlyDispatcher == null) {
            return false;
        }
        boolean hasBlockingAnnotation = $this$isBlockFriendlyDispatcher.getAnnotations().hasAnnotation(new FqName(BLOCKING_CONTEXT_ANNOTATION));
        if (hasBlockingAnnotation) {
            return true;
        }
        FqName fqName = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)$this$isBlockFriendlyDispatcher);
        return Intrinsics.areEqual((Object)(fqName != null ? fqName.asString() : null), (Object)IO_DISPATCHER_FQN);
    }

    public static final /* synthetic */ boolean access$isBlockFriendlyDispatcher(CoroutineNonBlockingContextChecker $this, DeclarationDescriptor $this$access_u24isBlockFriendlyDispatcher) {
        return $this.isBlockFriendlyDispatcher($this$access_u24isBlockFriendlyDispatcher);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/blockingCallsDetection/CoroutineNonBlockingContextChecker$Companion;", "", "()V", "BLOCKING_CONTEXT_ANNOTATION", "", "COROUTINE_CONTEXT", "COROUTINE_SCOPE", "FLOW_ON_FQN", "IO_DISPATCHER_FQN", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

