/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.GenerateUtilKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SimplifyAssertNotNullInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "extractMessage", "Lorg/jetbrains/kotlin/psi/KtExpression;", "findVariableDeclaration", "Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;", "fixText", "inspectionText", "isApplicable", "", "kotlin.idea"})
public final class SimplifyAssertNotNullInspection
extends AbstractApplicabilityBasedInspection<KtCallExpression> {
    public boolean isApplicable(@NotNull KtCallExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtExpression ktExpression = element3.getCalleeExpression();
        if (!(ktExpression instanceof KtNameReferenceExpression)) {
            ktExpression = null;
        }
        KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression;
        if (Intrinsics.areEqual((Object)(ktNameReferenceExpression != null ? ktNameReferenceExpression.getReferencedName() : null), (Object)"assert") ^ true) {
            return false;
        }
        List list = element3.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"element.valueArguments");
        List arguments = list;
        if (arguments.size() != 1 && arguments.size() != 2) {
            return false;
        }
        KtExpression ktExpression2 = ((KtValueArgument)CollectionsKt.first((List)arguments)).getArgumentExpression();
        if (!(ktExpression2 instanceof KtBinaryExpression)) {
            ktExpression2 = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)ktExpression2;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression condition2 = ktBinaryExpression;
        if (Intrinsics.areEqual((Object)condition2.getOperationToken(), (Object)KtTokens.EXCLEQ) ^ true) {
            return false;
        }
        KtExpression ktExpression3 = IfThenUtilsKt.expressionComparedToNull(condition2);
        if (!(ktExpression3 instanceof KtNameReferenceExpression)) {
            ktExpression3 = null;
        }
        KtNameReferenceExpression ktNameReferenceExpression2 = (KtNameReferenceExpression)ktExpression3;
        if (ktNameReferenceExpression2 == null) {
            return false;
        }
        KtNameReferenceExpression value = ktNameReferenceExpression2;
        KtVariableDeclaration ktVariableDeclaration = this.findVariableDeclaration(element3);
        if (ktVariableDeclaration == null) {
            return false;
        }
        KtVariableDeclaration prevDeclaration = ktVariableDeclaration;
        if (Intrinsics.areEqual((Object)value.getReferencedNameAsName(), (Object)prevDeclaration.getNameAsName()) ^ true) {
            return false;
        }
        if (prevDeclaration.getInitializer() == null) {
            return false;
        }
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)((KtElement)element3), null, (int)1, null);
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        if (!ArgumentMappingKt.isReallySuccess((ResolvedCall)resolvedCall3)) {
            return false;
        }
        CallableDescriptor callableDescriptor = resolvedCall3.getResultingDescriptor();
        if (!(callableDescriptor instanceof FunctionDescriptor)) {
            callableDescriptor = null;
        }
        FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)callableDescriptor;
        if (functionDescriptor2 == null) {
            return false;
        }
        FunctionDescriptor function2 = functionDescriptor2;
        FqName fqName = ImportsUtils.getImportableFqName((DeclarationDescriptor)((DeclarationDescriptor)function2));
        if (Intrinsics.areEqual((Object)(fqName != null ? fqName.asString() : null), (Object)"kotlin.assert") ^ true) {
            return false;
        }
        return arguments.size() == 1 || this.extractMessage(element3) != null;
    }

    @NotNull
    public String inspectionText(@NotNull KtCallExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return KotlinBundle.message("assert.should.be.replaced.with.operator", new Object[0]);
    }

    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message("replace.assert.with.operator", new Object[0]);
    }

    @NotNull
    public String fixText(@NotNull KtCallExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return element3.getValueArguments().size() == 1 ? KotlinBundle.message("replace.with.0.operator", "!!") : KotlinBundle.message("replace.with.error", new Object[0]);
    }

    public void applyTo(@NotNull KtCallExpression element3, @NotNull Project project2, @Nullable Editor editor2) {
        KtExpression newInitializer;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        KtVariableDeclaration ktVariableDeclaration = this.findVariableDeclaration(element3);
        if (ktVariableDeclaration == null) {
            return;
        }
        KtVariableDeclaration declaration2 = ktVariableDeclaration;
        KtExpression ktExpression = declaration2.getInitializer();
        if (ktExpression == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"declaration.initializer ?: return");
        KtExpression initializer2 = ktExpression;
        KtExpression message2 = this.extractMessage(element3);
        CommentSaver commentSaver = new CommentSaver((PsiElement)element3, false, 2, null);
        if (message2 == null) {
            newInitializer = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)element3), (boolean)false, (int)2, null), (String)"$0!!", (Object[])new Object[]{initializer2}, (boolean)false, (int)4, null);
            initializer2.replace((PsiElement)newInitializer);
        } else {
            PsiElement result2;
            newInitializer = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)element3), (boolean)false, (int)2, null), (String)"$0 ?: kotlin.error($1)", (Object[])new Object[]{initializer2, message2}, (boolean)false, (int)4, null);
            PsiElement psiElement2 = result2 = initializer2.replace((PsiElement)newInitializer);
            if (psiElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
            }
            KtExpression ktExpression2 = ((KtBinaryExpression)psiElement2).getRight();
            if (ktExpression2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDotQualifiedExpression");
            }
            KtDotQualifiedExpression qualifiedExpression = (KtDotQualifiedExpression)ktExpression2;
            KtFile ktFile = element3.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"element.containingKtFile");
            int n = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)qualifiedExpression));
            KtExpression ktExpression3 = qualifiedExpression.getSelectorExpression();
            if (ktExpression3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
            }
            KtExpression ktExpression4 = ((KtCallExpression)ktExpression3).getCalleeExpression();
            Intrinsics.checkNotNull((Object)ktExpression4);
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression4, (String)"(qualifiedExpression.sel\u2026ssion).calleeExpression!!");
            ShortenReferences.process$default((ShortenReferences)ShortenReferences.DEFAULT, (KtFile)ktFile, (int)n, (int)PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktExpression4)), null, null, (int)24, null);
        }
        element3.delete();
        CommentSaver.restore$default((CommentSaver)commentSaver, (PsiElement)((PsiElement)declaration2), (boolean)false, (int)2, null);
        if (editor2 != null) {
            int n;
            KtVariableDeclaration ktVariableDeclaration2 = (KtVariableDeclaration)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)((PsiElement)declaration2));
            if (ktVariableDeclaration2 == null || (ktVariableDeclaration2 = ktVariableDeclaration2.getInitializer()) == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktVariableDeclaration2, (String)"CodeInsightUtilCore.forc\u2026n)?.initializer ?: return");
            newInitializer = ktVariableDeclaration2;
            if (message2 == null) {
                n = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)newInitializer));
            } else {
                KtExpression ktExpression5 = newInitializer;
                if (ktExpression5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
                }
                KtOperationReferenceExpression ktOperationReferenceExpression = ((KtBinaryExpression)ktExpression5).getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"(newInitializer as KtBin\u2026ssion).operationReference");
                n = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)ktOperationReferenceExpression));
            }
            int offset = n;
            GenerateUtilKt.moveCaret$default((Editor)editor2, (int)offset, null, (int)2, null);
        }
    }

    private final KtVariableDeclaration findVariableDeclaration(KtCallExpression element3) {
        Object v1;
        Object v0;
        block3: {
            if (!(element3.getParent() instanceof KtBlockExpression)) {
                return null;
            }
            Sequence $this$firstIsInstanceOrNull$iv = PsiUtilsKt.siblings((PsiElement)((PsiElement)element3), (boolean)false, (boolean)false);
            boolean $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof KtExpression)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = v1 = null;
        }
        if (!(v0 instanceof KtVariableDeclaration)) {
            v1 = null;
        }
        return v1;
    }

    private final KtExpression extractMessage(KtCallExpression element3) {
        Object object;
        List list = element3.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"element.valueArguments");
        List arguments = list;
        if (arguments.size() != 2) {
            return null;
        }
        KtExpression ktExpression = ((KtValueArgument)arguments.get(1)).getArgumentExpression();
        if (!(ktExpression instanceof KtLambdaExpression)) {
            ktExpression = null;
        }
        return (object = (KtLambdaExpression)ktExpression) != null && (object = object.getBodyExpression()) != null && (object = object.getStatements()) != null ? (KtExpression)CollectionsKt.singleOrNull((List)object) : null;
    }

    public SimplifyAssertNotNullInspection() {
        super(KtCallExpression.class);
    }
}

