/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Query;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.ReplaceManualRangeWithIndicesCallsInspectionKt;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValueArgument;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceIndexLoopWithCollectionLoopQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "kotlin.idea"})
public final class ReplaceIndexLoopWithCollectionLoopQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        return KotlinBundle.message("replace.index.loop.with.collection.loop.quick.fix.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        Object object;
        KtExpression loopRange;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement2 = descriptor2.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"descriptor.psiElement");
        PsiElement $this$getStrictParentOfType$iv = psiElement2;
        boolean $i$f$getStrictParentOfType = false;
        KtForExpression ktForExpression = (KtForExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtForExpression.class, (boolean)true);
        if (ktForExpression == null) {
            return;
        }
        KtForExpression element3 = ktForExpression;
        KtParameter ktParameter = element3.getLoopParameter();
        if (ktParameter == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktParameter, (String)"element.loopParameter ?: return");
        KtParameter loopParameter = ktParameter;
        KtExpression ktExpression = element3.getLoopRange();
        if (ktExpression == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"element.loopRange ?: return");
        KtExpression ktExpression2 = loopRange = ktExpression;
        if (ktExpression2 instanceof KtDotQualifiedExpression) {
            Object object2;
            PsiElement psiElement3 = ((KtDotQualifiedExpression)loopRange).getParent();
            if (!(psiElement3 instanceof KtCallExpression)) {
                psiElement3 = null;
            }
            object = (object2 = (KtCallExpression)psiElement3) != null && (object2 = object2.getValueArguments()) != null && (object2 = (KtValueArgument)CollectionsKt.firstOrNull((List)object2)) != null ? object2.getArgumentExpression() : null;
        } else {
            object = ktExpression2 instanceof KtBinaryExpression ? ((KtBinaryExpression)loopRange).getRight() : null;
        }
        if (object == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"when (loopRange) {\n     \u2026 null\n        } ?: return");
        KtExpression collectionParent = object;
        KtExpression ktExpression3 = ReplaceManualRangeWithIndicesCallsInspectionKt.receiverIfIsSizeOrLengthCall(collectionParent);
        if (ktExpression3 == null) {
            ktExpression3 = ReplaceManualRangeWithIndicesCallsInspectionKt.receiverIfIsSizeOrLengthMinusOneCall(collectionParent);
        }
        if (ktExpression3 == null) {
            return;
        }
        KtExpression collection = ktExpression3;
        PsiElement psiElement4 = loopParameter.getOriginalElement();
        if (psiElement4 == null) {
            return;
        }
        PsiElement paramElement = psiElement4;
        Query query = ReferencesSearch.search((PsiElement)paramElement);
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"ReferencesSearch.search(paramElement)");
        PsiReference psiReference = (PsiReference)CollectionsKt.singleOrNull((Iterable)((Iterable)query));
        if (psiReference == null || (psiReference = psiReference.getElement()) == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiReference, (String)"ReferencesSearch.search(\u2026Null()?.element ?: return");
        PsiReference usageElement = psiReference;
        PsiElement psiElement5 = usageElement.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement5, (String)"usageElement.parent");
        PsiElement psiElement6 = psiElement5.getParent();
        if (!(psiElement6 instanceof KtArrayAccessExpression)) {
            psiElement6 = null;
        }
        KtArrayAccessExpression ktArrayAccessExpression = (KtArrayAccessExpression)psiElement6;
        if (ktArrayAccessExpression == null) {
            return;
        }
        KtArrayAccessExpression arrayAccessElement = ktArrayAccessExpression;
        KtPsiFactory factory2 = new KtPsiFactory(project2, false, 2, null);
        KtParameter newParameter = factory2.createLoopParameter("element");
        KtExpression newReferenceExpression = factory2.createExpression("element");
        arrayAccessElement.replace((PsiElement)newReferenceExpression);
        loopParameter.replace((PsiElement)newParameter);
        loopRange.replace((PsiElement)collection);
    }
}

