/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.RedundantGetterInspectionKt;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RemoveRedundantGetterFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "Companion", "kotlin.idea"})
public final class RemoveRedundantGetterFix
implements LocalQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getName() {
        return KotlinBundle.message("remove.redundant.getter.fix.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement2 = descriptor2.getPsiElement();
        if (!(psiElement2 instanceof KtPropertyAccessor)) {
            psiElement2 = null;
        }
        KtPropertyAccessor ktPropertyAccessor = (KtPropertyAccessor)psiElement2;
        if (ktPropertyAccessor == null) {
            return;
        }
        KtPropertyAccessor accessor = ktPropertyAccessor;
        Companion.removeRedundantGetter(accessor);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RemoveRedundantGetterFix$Companion;", "", "()V", "removeRedundantGetter", "", "getter", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "kotlin.idea"})
    public static final class Companion {
        public final void removeRedundantGetter(@NotNull KtPropertyAccessor getter) {
            Intrinsics.checkNotNullParameter((Object)getter, (String)"getter");
            KtProperty ktProperty = getter.getProperty();
            Intrinsics.checkNotNullExpressionValue((Object)ktProperty, (String)"getter.property");
            KtProperty property2 = ktProperty;
            KtTypeReference accessorTypeReference = getter.getReturnTypeReference();
            if (accessorTypeReference != null && property2.getTypeReference() == null && property2.getInitializer() == null) {
                property2.setTypeReference(accessorTypeReference);
            }
            if (RedundantGetterInspectionKt.canBeCompletelyDeleted(getter)) {
                getter.delete();
            } else {
                RedundantGetterInspectionKt.deleteBody(getter);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

