/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.RedundantUnitExpressionInspection;
import org.jetbrains.kotlin.idea.inspections.RedundantUnitExpressionInspectionKt;
import org.jetbrains.kotlin.idea.inspections.RemoveRedundantUnitFix;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.CommonUtilsKt;
import org.jetbrains.kotlin.idea.util.ExpressionExtKt;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u00012\u00020\u0002:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantUnitExpressionInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "Companion", "kotlin.idea"})
public final class RedundantUnitExpressionInspection
extends AbstractKotlinInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)VisitorWrappersKt.referenceExpressionVisitor((Function1)((Function1)new Function1<KtReferenceExpression, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtReferenceExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                if (RedundantUnitExpressionInspection.Companion.isRedundantUnit(expression2)) {
                    this.$holder.registerProblem((PsiElement)expression2, KotlinBundle.message("redundant.unit", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new RemoveRedundantUnitFix()});
                }
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantUnitExpressionInspection$Companion;", "", "()V", "isRedundantUnit", "", "referenceExpression", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "kotlin.idea"})
    public static final class Companion {
        public final boolean isRedundantUnit(@NotNull KtReferenceExpression referenceExpression) {
            Intrinsics.checkNotNullParameter((Object)referenceExpression, (String)"referenceExpression");
            if (!ExpressionExtKt.isUnitLiteral((KtExpression)referenceExpression)) {
                return false;
            }
            PsiElement psiElement2 = referenceExpression.getParent();
            if (psiElement2 == null) {
                return false;
            }
            PsiElement parent2 = psiElement2;
            if (parent2 instanceof KtReturnExpression) {
                KotlinType kotlinType = RedundantUnitExpressionInspectionKt.access$expectedReturnType((KtReturnExpression)parent2);
                if (kotlinType == null) {
                    return false;
                }
                KotlinType expectedReturnType = kotlinType;
                return Intrinsics.areEqual((Object)DescriptorUtilsKt.getNameIfStandardType((KotlinType)expectedReturnType), (Object)StandardNames.FqNames.any.shortName()) ^ true && !expectedReturnType.isMarkedNullable();
            }
            if (parent2 instanceof KtBlockExpression) {
                if (Intrinsics.areEqual((Object)referenceExpression, (Object)KtPsiUtilKt.lastBlockStatementOrThis((KtExpression)((KtExpression)parent2)))) {
                    KtExpression ktExpression = CommonUtilsKt.previousStatement((KtExpression)referenceExpression);
                    if (ktExpression == null) {
                        return true;
                    }
                    KtExpression prev2 = ktExpression;
                    if (ExpressionExtKt.isUnitLiteral(prev2)) {
                        return true;
                    }
                    if (prev2 instanceof KtDeclaration && RedundantUnitExpressionInspectionKt.access$isDynamicCall((KtBlockExpression)parent2)) {
                        return false;
                    }
                    BindingContext context2 = ResolutionUtils.analyze((KtElement)((KtElement)prev2), (BodyResolveMode)BodyResolveMode.PARTIAL);
                    KotlinType prevType = context2.getType(prev2);
                    if (prevType != null) {
                        return TypeUtilsKt.isUnit((KotlinType)prevType) && RedundantUnitExpressionInspectionKt.access$canBeUsedAsValue(prev2, context2);
                    }
                    if (!(prev2 instanceof KtDeclaration)) {
                        return false;
                    }
                    if (!(prev2 instanceof KtFunction)) {
                        return true;
                    }
                    return PsiUtilsKt.getParentOfTypesAndPredicate((PsiElement)parent2, (boolean)true, (Class[])new Class[]{KtIfExpression.class, KtWhenExpression.class}, (Function1)isRedundantUnit.1.INSTANCE) == null;
                }
                return true;
            }
            return false;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

