/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.IntentionBasedInspectionKt;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineAnonymousFunctionProcessor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantLambdaOrAnonymousFunctionInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "Companion", "RedundantLambdaOrAnonymousFunctionFix", "kotlin.idea"})
public final class RedundantLambdaOrAnonymousFunctionInspection
extends AbstractKotlinInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public void visitNamedFunction(@NotNull KtNamedFunction function2) {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                this.processExpression((KtFunction)function2);
            }

            public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression2) {
                Intrinsics.checkNotNullParameter((Object)lambdaExpression2, (String)"lambdaExpression");
                KtFunctionLiteral ktFunctionLiteral = lambdaExpression2.getFunctionLiteral();
                Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"lambdaExpression.functionLiteral");
                this.processExpression((KtFunction)ktFunctionLiteral);
            }

            private final void processExpression(KtFunction function2) {
                if (RedundantLambdaOrAnonymousFunctionInspection.Companion.findCallIfApplicableTo(function2) == null) {
                    return;
                }
                String message2 = function2 instanceof KtNamedFunction ? KotlinBundle.message("inspection.redundant.anonymous.function.description", new Object[0]) : KotlinBundle.message("inspection.redundant.lambda.description", new Object[0]);
                this.$holder.registerProblem((PsiElement)function2, message2, new LocalQuickFix[]{new RedundantLambdaOrAnonymousFunctionFix()});
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantLambdaOrAnonymousFunctionInspection$RedundantLambdaOrAnonymousFunctionFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "startInWriteAction", "", "kotlin.idea"})
    private static final class RedundantLambdaOrAnonymousFunctionFix
    implements LocalQuickFix {
        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message("inspection.redundant.lambda.or.anonymous.function.fix", new Object[0]);
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (!(psiElement2 instanceof KtFunction)) {
                psiElement2 = null;
            }
            KtFunction ktFunction = (KtFunction)psiElement2;
            if (ktFunction == null) {
                return;
            }
            KtFunction function2 = ktFunction;
            KtExpression ktExpression = KotlinInlineAnonymousFunctionProcessor.Companion.findCallExpression(function2);
            if (ktExpression == null) {
                return;
            }
            KtExpression call = ktExpression;
            new KotlinInlineAnonymousFunctionProcessor(function2, call, IntentionBasedInspectionKt.findExistingEditor((PsiElement)((PsiElement)function2)), project2).run();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantLambdaOrAnonymousFunctionInspection$Companion;", "", "()V", "findCallIfApplicableTo", "Lorg/jetbrains/kotlin/psi/KtExpression;", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "kotlin.idea"})
    public static final class Companion {
        @Nullable
        public final KtExpression findCallIfApplicableTo(@NotNull KtFunction function2) {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            return function2.hasBody() ? KotlinInlineAnonymousFunctionProcessor.Companion.findCallExpression(function2) : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

