/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinEqualsBetweenInconvertibleTypesInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "Companion", "kotlin.idea"})
public final class KotlinEqualsBetweenInconvertibleTypesInspection
extends AbstractKotlinInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return VisitorWrappersKt.callExpressionVisitor((Function1)((Function1)new Function1<KtCallExpression, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtCallExpression call) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                KtExpression ktExpression = call.getCalleeExpression();
                if (!(ktExpression instanceof KtSimpleNameExpression)) {
                    ktExpression = null;
                }
                KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression;
                if (ktSimpleNameExpression == null) {
                    return;
                }
                KtSimpleNameExpression callee = ktSimpleNameExpression;
                Name identifier = callee.getReferencedNameAsName();
                if (Intrinsics.areEqual((Object)identifier, (Object)OperatorNameConventions.EQUALS) ^ true) {
                    return;
                }
                KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)call));
                if (ktQualifiedExpression == null || (ktQualifiedExpression = ktQualifiedExpression.getReceiverExpression()) == null) {
                    return;
                }
                KtQualifiedExpression receiver = ktQualifiedExpression;
                List list = call.getValueArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"call.valueArguments");
                KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.singleOrNull((List)list);
                if (ktValueArgument == null || (ktValueArgument = ktValueArgument.getArgumentExpression()) == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ktValueArgument, (String)"call.valueArguments.sing\u2026entExpression() ?: return");
                KtValueArgument argument2 = ktValueArgument;
                if (KotlinEqualsBetweenInconvertibleTypesInspection.Companion.isInconvertibleTypes(ResolutionUtils.analyze((KtElement)((KtElement)call), (BodyResolveMode)BodyResolveMode.PARTIAL), (KtExpression)receiver, (KtExpression)argument2)) {
                    this.$holder.registerProblem((PsiElement)callee, KotlinBundle.message("equals.between.objects.of.inconvertible.types", new Object[0]), new LocalQuickFix[0]);
                }
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001e\u0010\b\u001a\u00020\t*\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinEqualsBetweenInconvertibleTypesInspection$Companion;", "", "()V", "getTargetType", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isInconvertibleTypes", "", "expr1", "expr2", "kotlin.idea"})
    public static final class Companion {
        public final boolean isInconvertibleTypes(@NotNull BindingContext $this$isInconvertibleTypes, @Nullable KtExpression expr1, @Nullable KtExpression expr2) {
            Intrinsics.checkNotNullParameter((Object)$this$isInconvertibleTypes, (String)"$this$isInconvertibleTypes");
            KtExpression ktExpression = expr1;
            if (ktExpression == null || (ktExpression = this.getTargetType(ktExpression, $this$isInconvertibleTypes)) == null) {
                return false;
            }
            KtExpression type1 = ktExpression;
            KtExpression ktExpression2 = expr2;
            if (ktExpression2 == null || (ktExpression2 = this.getTargetType(ktExpression2, $this$isInconvertibleTypes)) == null) {
                return false;
            }
            KtExpression type2 = ktExpression2;
            return Intrinsics.areEqual((Object)type1, (Object)type2) ^ true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final KotlinType getTargetType(KtExpression $this$getTargetType, BindingContext context2) {
            KotlinType kotlinType = context2.getType($this$getTargetType);
            KotlinType kotlinType2 = kotlinType;
            if (kotlinType == null) return null;
            KotlinType kotlinType3 = kotlinType2;
            boolean bl = false;
            boolean bl2 = false;
            KotlinType it = kotlinType3;
            boolean bl3 = false;
            if (!KotlinBuiltIns.isPrimitiveTypeOrNullablePrimitiveType((KotlinType)it) && !KotlinBuiltIns.isStringOrNullableString((KotlinType)it)) {
                KotlinType kotlinType4 = it;
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType4, (String)"it");
                if (!TypeUtilsKt.isEnum((KotlinType)kotlinType4)) return null;
            }
            boolean bl4 = true;
            if (!bl4) return null;
            KotlinType kotlinType5 = kotlinType3;
            kotlinType2 = kotlinType5;
            if (kotlinType5 == null) return null;
            KotlinType kotlinType6 = TypeUtilsKt.makeNotNullable((KotlinType)kotlinType2);
            return kotlinType6;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

