/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.JavaCollectionsStaticMethodInspection;
import org.jetbrains.kotlin.idea.inspections.ReplaceWithStdLibFix;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/JavaCollectionsStaticMethodInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "Companion", "kotlin.idea"})
public final class JavaCollectionsStaticMethodInspection
extends AbstractKotlinInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)VisitorWrappersKt.dotQualifiedExpressionVisitor((Function1)((Function1)new Function1<KtDotQualifiedExpression, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull KtDotQualifiedExpression expression2) {
                void methodName;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                Pair pair = org.jetbrains.kotlin.idea.inspections.JavaCollectionsStaticMethodInspection$Companion.access$getTargetMethodOnMutableList(JavaCollectionsStaticMethodInspection.Companion, expression2);
                if (pair == null) {
                    return;
                }
                Pair pair2 = pair;
                String string = (String)pair2.component1();
                KtValueArgument firstArg = (KtValueArgument)pair2.component2();
                PsiElement psiElement2 = (PsiElement)expression2;
                String string2 = KotlinBundle.message("java.collections.static.method.call.should.be.replaced.with.kotlin.stdlib", new Object[0]);
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
                String string3 = firstArg.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"firstArg.text");
                localQuickFixArray[0] = new ReplaceWithStdLibFix((String)methodName, string3);
                this.$holder.registerProblem(psiElement2, string2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, localQuickFixArray);
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J7\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00040\u0012\u00a2\u0006\u0002\b\u0014H\u0002J\u001c\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00102\u0006\u0010\u0005\u001a\u00020\u0006J\u001e\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/JavaCollectionsStaticMethodInspection$Companion;", "", "()V", "canReplaceWithStdLib", "", "expression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "fqName", "", "args", "", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "checkApiVersion", "requiredVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "getTargetMethod", "Lkotlin/Pair;", "isValidFirstArgument", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lkotlin/ExtensionFunctionType;", "getTargetMethodOnImmutableList", "getTargetMethodOnMutableList", "kotlin.idea"})
    public static final class Companion {
        @Nullable
        public final Pair<String, KtValueArgument> getTargetMethodOnImmutableList(@NotNull KtDotQualifiedExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            return this.getTargetMethod(expression2, (Function1<? super KotlinType, Boolean>)((Function1)getTargetMethodOnImmutableList.1.INSTANCE));
        }

        private final Pair<String, KtValueArgument> getTargetMethodOnMutableList(KtDotQualifiedExpression expression2) {
            return this.getTargetMethod(expression2, (Function1<? super KotlinType, Boolean>)((Function1)getTargetMethodOnMutableList.1.INSTANCE));
        }

        private final Pair<String, KtValueArgument> getTargetMethod(KtDotQualifiedExpression expression2, Function1<? super KotlinType, Boolean> isValidFirstArgument) {
            KtCallExpression ktCallExpression = UtilsKt.getCallExpression((KtQualifiedExpression)expression2);
            if (ktCallExpression == null) {
                return null;
            }
            KtCallExpression callExpression2 = ktCallExpression;
            List list = callExpression2.getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"callExpression.valueArguments");
            List args = list;
            KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.firstOrNull((List)args);
            if (ktValueArgument == null) {
                return null;
            }
            KtValueArgument firstArg = ktValueArgument;
            BindingContext context2 = ResolutionUtils.analyze((KtElement)((KtElement)expression2), (BodyResolveMode)BodyResolveMode.PARTIAL);
            KtExpression ktExpression = firstArg.getArgumentExpression();
            if (ktExpression == null || (ktExpression = CallUtilKt.getType((KtExpression)ktExpression, (BindingContext)context2)) == null || !((Boolean)isValidFirstArgument.invoke((Object)ktExpression)).booleanValue()) {
                return null;
            }
            ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression2), (BindingContext)context2);
            Object object = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
            if (!(object instanceof JavaMethodDescriptor)) {
                object = null;
            }
            JavaMethodDescriptor javaMethodDescriptor = (JavaMethodDescriptor)object;
            if (javaMethodDescriptor == null) {
                return null;
            }
            JavaMethodDescriptor descriptor2 = javaMethodDescriptor;
            Object object2 = ImportsUtils.getImportableFqName((DeclarationDescriptor)((DeclarationDescriptor)descriptor2));
            if (object2 == null || (object2 = object2.asString()) == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"descriptor.importableFqN\u2026asString() ?: return null");
            Object fqName = object2;
            if (!this.canReplaceWithStdLib(expression2, (String)fqName, args)) {
                return null;
            }
            String methodName = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)((CharSequence)fqName), (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null));
            return TuplesKt.to((Object)methodName, (Object)firstArg);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean canReplaceWithStdLib(KtDotQualifiedExpression expression2, String fqName, List<? extends KtValueArgument> args) {
            if (!StringsKt.startsWith$default((String)fqName, (String)"java.util.Collections.", (boolean)false, (int)2, null)) {
                return false;
            }
            int size = args.size();
            switch (fqName) {
                case "java.util.Collections.fill": {
                    if (!this.checkApiVersion(ApiVersion.KOTLIN_1_2, expression2)) return false;
                    if (size != 2) return false;
                    return true;
                }
                case "java.util.Collections.reverse": {
                    if (size != 1) return false;
                    return true;
                }
                case "java.util.Collections.shuffle": {
                    if (!this.checkApiVersion(ApiVersion.KOTLIN_1_2, expression2)) return false;
                    if (size == 1) return true;
                    if (size != 2) return false;
                    return true;
                }
                case "java.util.Collections.sort": {
                    if (size == 1) return true;
                    if (size != 2) return false;
                    KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.getOrNull(args, (int)1);
                    if (!((ktValueArgument != null ? ktValueArgument.getArgumentExpression() : null) instanceof KtLambdaExpression)) return false;
                    return true;
                }
                default: {
                    return false;
                }
            }
        }

        private final boolean checkApiVersion(ApiVersion requiredVersion, KtDotQualifiedExpression expression2) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)expression2));
            if (module == null) {
                return true;
            }
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ModuleUtilCore.findModul\u2026xpression) ?: return true");
            Module module2 = module;
            return PlatformKt.getLanguageVersionSettings((Module)module2).getApiVersion().compareTo(requiredVersion) >= 0;
        }

        private Companion() {
        }

        public static final /* synthetic */ Pair access$getTargetMethodOnMutableList(Companion $this, KtDotQualifiedExpression expression2) {
            return $this.getTargetMethodOnMutableList(expression2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

