/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.IncompleteDestructuringInspectionKt;
import org.jetbrains.kotlin.idea.inspections.IncompleteDestructuringQuickfix;
import org.jetbrains.kotlin.idea.util.ExpressionExtKt;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/IncompleteDestructuringInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "kotlin.idea"})
public final class IncompleteDestructuringInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)VisitorWrappersKt.destructuringDeclarationVisitor((Function1)((Function1)new Function1<KtDestructuringDeclaration, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtDestructuringDeclaration destructuringDeclaration) {
                Intrinsics.checkNotNullParameter((Object)destructuringDeclaration, (String)"destructuringDeclaration");
                PsiElement psiElement2 = destructuringDeclaration.getLPar();
                if (psiElement2 == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"destructuringDeclaration.lPar ?: return");
                PsiElement lPar = psiElement2;
                PsiElement psiElement3 = destructuringDeclaration.getRPar();
                if (psiElement3 == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"destructuringDeclaration.rPar ?: return");
                PsiElement rPar = psiElement3;
                List list = IncompleteDestructuringInspectionKt.access$primaryParameters(destructuringDeclaration);
                if (list == null) {
                    return;
                }
                List primaryParameters = list;
                if (destructuringDeclaration.getEntries().size() < primaryParameters.size()) {
                    TextRange highlightRange = new TextRange(ExpressionExtKt.textRangeIn(lPar, (PsiElement)destructuringDeclaration).getStartOffset(), ExpressionExtKt.textRangeIn(rPar, (PsiElement)destructuringDeclaration).getEndOffset());
                    this.$holder.registerProblem((PsiElement)destructuringDeclaration, highlightRange, KotlinBundle.message("incomplete.destructuring.declaration.text", new Object[0]), new LocalQuickFix[]{new IncompleteDestructuringQuickfix()});
                }
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }
}

